/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.multiview.Accessor;
import org.netbeans.core.multiview.TabsComponent;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;

class MultiViewModel {
    private MultiViewDescription currentEditor;
    private Map nestedElements;
    private Map nestedCallbacks;
    private Map nestedPerspectives;
    private MultiViewDescription[] descriptions;
    private ButtonGroup group;
    private Collection shownElements;
    private ArrayList listeners;
    private ActionRequestObserverFactory observerFactory;

    MultiViewModel(MultiViewDescription[] descs, MultiViewDescription defaultDescr, ActionRequestObserverFactory factory) {
        this(descs, defaultDescr, factory, Collections.EMPTY_MAP);
    }

    MultiViewModel(MultiViewDescription[] descs, MultiViewDescription defaultDescr, ActionRequestObserverFactory factory, Map existingElements) {
        this.observerFactory = factory;
        this.nestedElements = new HashMap();
        this.nestedPerspectives = new HashMap();
        this.nestedCallbacks = new HashMap();
        this.shownElements = new HashSet(descs.length + 3);
        this.descriptions = descs;
        this.group = this.group;
        for (int i = 0; i < this.descriptions.length; ++i) {
            MultiViewElement element = (MultiViewElement)existingElements.get(this.descriptions[i]);
            this.nestedElements.put(this.descriptions[i], element);
            this.nestedPerspectives.put(this.descriptions[i], Accessor.DEFAULT.createPerspective(this.descriptions[i]));
            if (element == null) continue;
            MultiViewElementCallback call = factory.createElementCallback(this.descriptions[i]);
            this.nestedCallbacks.put(element, call);
            element.setMultiViewCallback(call);
        }
        this.currentEditor = defaultDescr == null || !this.nestedElements.containsKey(defaultDescr) ? this.descriptions[0] : defaultDescr;
        this.group = new BtnGroup();
    }

    void setActiveDescription(MultiViewDescription description) {
        if (this.currentEditor == description) {
            return;
        }
        MultiViewDescription old = this.currentEditor;
        this.currentEditor = description;
        this.fireSelectionChanged(old, description);
    }

    MultiViewDescription getActiveDescription() {
        return this.currentEditor;
    }

    MultiViewElement getActiveElement() {
        return this.getActiveElement(true);
    }

    MultiViewElement getActiveElement(boolean createIfNotCreatedYet) {
        return this.getElementForDescription(this.currentEditor, createIfNotCreatedYet);
    }

    synchronized Collection getCreatedElements() {
        ArrayList col = new ArrayList(this.nestedElements.size());
        Iterator it = this.nestedElements.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() == null) continue;
            col.add(entry.getValue());
        }
        return col;
    }

    boolean wasShownBefore(MultiViewElement element) {
        return this.shownElements.contains(element);
    }

    void markAsShown(MultiViewElement element) {
        this.shownElements.add(element);
    }

    void markAsHidden(MultiViewElement element) {
        this.shownElements.remove(element);
    }

    MultiViewDescription[] getDescriptions() {
        return this.descriptions;
    }

    MultiViewPerspective[] getPerspectives() {
        MultiViewPerspective[] toReturn = new MultiViewPerspective[this.descriptions.length];
        for (int i = 0; i < this.descriptions.length; ++i) {
            toReturn[i] = (MultiViewPerspective)this.nestedPerspectives.get(this.descriptions[i]);
        }
        return toReturn;
    }

    MultiViewPerspective getSelectedPerspective() {
        return (MultiViewPerspective)this.nestedPerspectives.get(this.getActiveDescription());
    }

    ButtonGroup getButtonGroup() {
        return this.group;
    }

    MultiViewElement getElementForDescription(MultiViewDescription description) {
        return this.getElementForDescription(description, true);
    }

    synchronized MultiViewElement getElementForDescription(MultiViewDescription description, boolean create) {
        MultiViewElement element = (MultiViewElement)this.nestedElements.get(description);
        if (element == null && create) {
            element = description.createElement();
            MultiViewElementCallback call = this.observerFactory.createElementCallback(description);
            this.nestedCallbacks.put(element, call);
            element.setMultiViewCallback(call);
            this.nestedElements.put(description, element);
        }
        return element;
    }

    synchronized MultiViewElementCallback getCallbackForElement(MultiViewElement elem) {
        return (MultiViewElementCallback)this.nestedCallbacks.get(elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addElementSelectionListener(ElementSelectionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeElementSelectionListener(ElementSelectionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSelectionChanged(MultiViewDescription oldOne, MultiViewDescription newOne) {
        if (this.listeners != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                Iterator it = this.listeners.iterator();
                while (it.hasNext()) {
                    ElementSelectionListener list = (ElementSelectionListener)it.next();
                    list.selectionChanged(oldOne, newOne);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireActivateCurrent() {
        if (this.listeners != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                Iterator it = this.listeners.iterator();
                while (it.hasNext()) {
                    ElementSelectionListener list = (ElementSelectionListener)it.next();
                    list.selectionActivatedByButton();
                }
            }
        }
    }

    public String toString() {
        return "current=" + this.currentEditor;
    }

    private class BtnGroup
    extends ButtonGroup {
        private BtnGroup() {
        }

        public void setSelected(ButtonModel m, boolean b) {
            super.setSelected(m, b);
            if (this.getSelection() instanceof TabsComponent.TabsButtonModel) {
                TabsComponent.TabsButtonModel mod = (TabsComponent.TabsButtonModel)m;
                MultiViewDescription desc = mod.getButtonsDescription();
                MultiViewModel.this.setActiveDescription(desc);
            }
        }
    }

    static interface ActionRequestObserverFactory {
        public MultiViewElementCallback createElementCallback(MultiViewDescription var1);
    }

    static interface ElementSelectionListener {
        public void selectionChanged(MultiViewDescription var1, MultiViewDescription var2);

        public void selectionActivatedByButton();
    }
}

