/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.awt.Container;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.JmiException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.FeatureImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMIUtils {
    private JMIUtils() {
    }

    public static JavaClass findClass(String className, ClassPath classPath) {
        JavaClass result = (JavaClass)JMIUtils.resolveType(className, classPath);
        return result instanceof UnresolvedClass ? null : result;
    }

    public static JavaClass findClass(String className, FileObject fo) {
        JavaClass result = (JavaClass)JMIUtils.resolveType(className, fo);
        return result instanceof UnresolvedClass ? null : result;
    }

    public static JavaClass findClass(String className) {
        JavaClass result = (JavaClass)JMIUtils.resolveType(className);
        return result instanceof UnresolvedClass ? null : result;
    }

    public static JavaClass getDeclaringClass(Feature feature) {
        if (feature == null) {
            return null;
        }
        return feature instanceof JavaClass ? (JavaClass)feature : (JavaClass)feature.getDeclaringClass();
    }

    public static boolean isResolvableType(String typeName) {
        if (null == typeName || "".equals(typeName.trim())) {
            return false;
        }
        if (typeName.endsWith("...")) {
            typeName = typeName.substring(0, typeName.length() - 3);
        }
        return !(JMIUtils.resolveType(typeName) instanceof UnresolvedClass);
    }

    public static Type resolveType(String typeName) {
        Type basicType;
        Type type = JavaModel.getDefaultExtent().getType().resolve(typeName);
        if (type instanceof UnresolvedClass && !((basicType = JavaModel.getDefaultExtent().getType().resolve("java.lang." + typeName)) instanceof UnresolvedClass)) {
            return basicType;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type resolveType(String typeName, ClassPath classPath) {
        JMIUtils.beginJmiTransaction();
        try {
            JavaModel.setClassPath((ClassPath)classPath);
            Type type = JMIUtils.resolveType(typeName);
            return type;
        }
        finally {
            JMIUtils.endJmiTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type resolveType(String typeName, FileObject fo) {
        JMIUtils.beginJmiTransaction();
        try {
            JavaModel.setClassPath((FileObject)fo);
            Type type = JMIUtils.resolveType(typeName);
            return type;
        }
        finally {
            JMIUtils.endJmiTransaction();
        }
    }

    public static Method[] getMethods(JavaClass jc) {
        LinkedList result = new LinkedList();
        if (jc != null) {
            List features = jc.getFeatures();
            for (Object o : features) {
                if (!(o instanceof Method)) continue;
                result.add(o);
            }
        }
        return result.toArray(new Method[result.size()]);
    }

    public static List<Field> getFields(JavaClass jc) {
        ArrayList<Field> result = new ArrayList<Field>();
        if (jc != null) {
            List features = jc.getFeatures();
            for (Feature feature : features) {
                if (!(feature instanceof Field)) continue;
                result.add((Field)feature);
            }
        }
        return result;
    }

    public static Field findFieldByType(JavaClass jc, String fqn) {
        if (jc == null || fqn == null) {
            throw new IllegalArgumentException("Tried to pass null argument");
        }
        String simple = fqn.substring(fqn.lastIndexOf(".") + 1);
        List<Field> fields = JMIUtils.getFields(jc);
        for (Field field : fields) {
            String fieldTypeName = field.getTypeName().getName();
            if (!fqn.equals(field.getType().getName()) && !fqn.equals(fieldTypeName) && !simple.equals(fieldTypeName)) continue;
            return field;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaClass getJavaClassFromNode(Node node) {
        JMIUtils.beginJmiTransaction();
        JavaClass jc = null;
        try {
            DataObject dobj = (DataObject)node.getCookie(DataObject.class);
            if (dobj != null) {
                Resource res = JavaModel.getResource((FileObject)dobj.getPrimaryFile());
                if (res != null) {
                    JavaModel.setClassPath((Resource)res);
                    List classes = res.getClassifiers();
                    if (classes.size() == 1) {
                        jc = (JavaClass)classes.get(0);
                    }
                }
            } else {
                Feature feature = (Feature)node.getLookup().lookup(Feature.class);
                if (feature != null) {
                    jc = feature instanceof JavaClass ? (JavaClass)feature : (JavaClass)feature.getDeclaringClass();
                }
            }
            JavaClass javaClass = jc;
            return javaClass;
        }
        finally {
            JMIUtils.endJmiTransaction();
        }
    }

    public static Method getMethodFromNode(Node node) {
        TopComponent activetc;
        EditorCookie ec;
        DataObject dobj = (DataObject)node.getCookie(DataObject.class);
        if (dobj != null && (ec = (EditorCookie)dobj.getCookie(EditorCookie.class)) != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane) {
            JEditorPane pane = ((CloneableEditorSupport.Pane)activetc).getEditorPane();
            int position = pane.getCaretPosition();
            Resource r = JavaModel.getResource((FileObject)dobj.getPrimaryFile());
            Element e = JMIUtils.findElement(r, position);
            if (e instanceof Method) {
                return (Method)e;
            }
        }
        return null;
    }

    public static ClassMember getClassMemberFromNode(Node node) {
        JEditorPane pane;
        TopComponent activetc;
        EditorCookie ec;
        DataObject dobj = (DataObject)node.getCookie(DataObject.class);
        if (dobj != null && (ec = (EditorCookie)dobj.getCookie(EditorCookie.class)) != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane && (pane = ((CloneableEditorSupport.Pane)activetc).getEditorPane()) != null) {
            int position = pane.getCaretPosition();
            Resource r = JavaModel.getResource((FileObject)dobj.getPrimaryFile());
            Element e = JMIUtils.findElement(r, position);
            if (e instanceof ClassMember) {
                return (ClassMember)e;
            }
        }
        return null;
    }

    public static CallableFeature getCallableFeatureFromNode(Node node) {
        TopComponent activetc;
        EditorCookie ec;
        DataObject dobj = (DataObject)node.getCookie(DataObject.class);
        if (dobj != null && (ec = (EditorCookie)dobj.getCookie(EditorCookie.class)) != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane) {
            JEditorPane pane = ((CloneableEditorSupport.Pane)activetc).getEditorPane();
            int position = pane.getCaretPosition();
            Resource r = JavaModel.getResource((FileObject)dobj.getPrimaryFile());
            Element e = JMIUtils.findElement(r, position);
            if (e instanceof CallableFeature) {
                return (CallableFeature)e;
            }
        }
        return null;
    }

    public static Method createMethod(JavaClass javaClass) {
        return JMIUtils.getJavaModelPackage((Feature)javaClass).getMethod().createMethod();
    }

    public static JavaClass createClass(JavaClass javaClass, String name) {
        JavaClass newJavaClass = JMIUtils.getJavaModelPackage((Feature)javaClass).getJavaClass().createJavaClass();
        newJavaClass.setName(name);
        return newJavaClass;
    }

    public static Field createField(JavaClass javaClass, String name, String type) {
        Field field = JMIUtils.getJavaModelPackage((Feature)javaClass).getField().createField();
        field.setName(name);
        field.setType(JMIUtils.resolveType(type));
        return field;
    }

    public static Parameter createParameter(Method method, String name, Type type, boolean isFinal) {
        Parameter parameter = JMIUtils.getJavaModelPackage((Feature)method).getParameter().createParameter();
        parameter.setName(name);
        parameter.setType(type);
        parameter.setFinal(isFinal);
        return parameter;
    }

    public static void beginJmiTransaction(boolean writeAccess) {
        JavaModel.getJavaRepository().beginTrans(writeAccess);
    }

    public static void beginJmiTransaction() {
        JMIUtils.beginJmiTransaction(false);
    }

    public static void endJmiTransaction(boolean rollback) {
        JavaModel.getJavaRepository().endTrans(rollback);
    }

    public static void endJmiTransaction() {
        JMIUtils.endJmiTransaction(false);
    }

    public static void addException(Method method, String exceptionName) {
        method.getExceptionNames().add(JMIUtils.createMultipartId((Feature)method, exceptionName));
    }

    public static void addExceptions(Method method, List exceptionNames) {
        Iterator it = exceptionNames.iterator();
        while (it.hasNext()) {
            JMIUtils.addException(method, (String)it.next());
        }
    }

    public static Node.Cookie getCookie(Feature feature, Class c) {
        if (feature == null) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)JavaModel.getFileObject((Resource)feature.getResource()));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return dataObject == null ? null : dataObject.getCookie(c);
    }

    public static void openInEditor(final Element element) {
        if (element == null || !element.isValid()) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JMIUtils.beginJmiTransaction();
                try {
                    if (!element.isValid() || element.getResource() == null) {
                        return;
                    }
                    PositionBounds bounds = JMManager.getManager().getElementPosition(element);
                    if (bounds == null) {
                        return;
                    }
                    final PositionRef beginPos = bounds.getBegin();
                    int extraOffset = 0;
                    if (element instanceof StatementBlock) {
                        try {
                            String bodyText = bounds.getText().trim();
                            extraOffset = bodyText.indexOf(bodyText.substring(1, bodyText.length() - 1).trim());
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                        catch (BadLocationException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                    final int finalOffset = extraOffset;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CloneableEditorSupport editSupp = beginPos.getCloneableEditorSupport();
                            editSupp.edit();
                            JEditorPane[] panes = editSupp.getOpenedPanes();
                            if (panes != null) {
                                panes[0].setCaretPosition(beginPos.getOffset() + finalOffset);
                                JMIUtils.getTopComponent(panes[0]).requestActive();
                                JMIUtils.getTopComponent(panes[0]).requestFocusInWindow();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                finally {
                    JMIUtils.endJmiTransaction();
                }
            }
        });
    }

    private static final TopComponent getTopComponent(Container temp) {
        while (!(temp instanceof TopComponent)) {
            temp = temp.getParent();
        }
        return (TopComponent)temp;
    }

    public static boolean equalMethods(Method method1, Method method2) {
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        List params1 = method1.getParameters();
        List params2 = method2.getParameters();
        if (params1.size() != params2.size()) {
            return false;
        }
        Iterator it1 = params1.iterator();
        Iterator it2 = params2.iterator();
        for (int i = 0; i < params1.size(); ++i) {
            Parameter param1 = (Parameter)it1.next();
            Parameter param2 = (Parameter)it2.next();
            if (param1.getType().getName().equals(param2.getType().getName())) continue;
            return false;
        }
        return true;
    }

    public static String elementName(NamedElement el) throws JmiException {
        if (el instanceof JavaClass) {
            return ((JavaClass)el).getSimpleName();
        }
        if (el instanceof Constructor) {
            JavaClass jc = (JavaClass)((Constructor)el).getDeclaringClass();
            return jc.getSimpleName();
        }
        return el.getName();
    }

    public static void addInterface(JavaClass javaClass, String interfaceName) {
        List interfaceNames = javaClass.getInterfaceNames();
        Iterator it = interfaceNames.iterator();
        while (it.hasNext()) {
            if (!interfaceName.equals(((MultipartId)it.next()).getElement().getName())) continue;
            return;
        }
        interfaceNames.add(JMIUtils.createMultipartId((Feature)javaClass, interfaceName));
    }

    public static void removeInterface(JavaClass javaClass, String interfaceName) {
        if (javaClass == null) {
            return;
        }
        Iterator it = javaClass.getInterfaceNames().iterator();
        while (it.hasNext()) {
            String name = ((MultipartId)it.next()).getElement().getName();
            if (!interfaceName.equals(name)) continue;
            it.remove();
        }
    }

    public static Type getPrimitiveTypeWrapper(PrimitiveType type) {
        PrimitiveTypeKind kind = type.getKind();
        if (PrimitiveTypeKindEnum.BOOLEAN.equals((Object)kind)) {
            return JMIUtils.resolveType("java.lang.Boolean");
        }
        if (PrimitiveTypeKindEnum.BYTE.equals((Object)kind)) {
            return JMIUtils.resolveType("java.lang.Byte");
        }
        if (PrimitiveTypeKindEnum.CHAR.equals((Object)kind)) {
            return JMIUtils.resolveType("java.lang.Character");
        }
        if (PrimitiveTypeKindEnum.DOUBLE.equals((Object)kind)) {
            return JMIUtils.resolveType("java.lang.Double");
        }
        if (PrimitiveTypeKindEnum.FLOAT.equals((Object)kind)) {
            return JMIUtils.resolveType("java.lang.Float");
        }
        if (PrimitiveTypeKindEnum.INT.equals((Object)kind)) {
            return JMIUtils.resolveType("java.lang.Integer");
        }
        if (PrimitiveTypeKindEnum.LONG.equals((Object)kind)) {
            return JMIUtils.resolveType("java.lang.Long");
        }
        if (PrimitiveTypeKindEnum.SHORT.equals((Object)kind)) {
            return JMIUtils.resolveType("java.lang.Short");
        }
        return null;
    }

    public static Method findInClass(Method me, JavaClass jc) {
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        for (Parameter parameter : me.getParameters()) {
            Type type = JMIUtils.resolveType(parameter.getType().getName());
            if (type instanceof UnresolvedClass) {
                type = parameter.getType();
            }
            parameterTypes.add(type);
        }
        return jc.getMethod(me.getName(), parameterTypes, false);
    }

    public static MultipartId createMultipartId(Feature feature, String name) {
        return JMIUtils.getJavaModelPackage(feature).getMultipartId().createMultipartId(name, null, null);
    }

    public static String printParameters(Method method) {
        if (method == null) {
            return "### null";
        }
        StringBuffer result = new StringBuffer("### " + method.getName() + "(");
        Iterator it = method.getParameters().iterator();
        while (it.hasNext()) {
            Parameter parameter = (Parameter)it.next();
            result.append(parameter.getType().getName());
            if (!it.hasNext()) continue;
            result.append(",");
        }
        result.append(")");
        return result.toString();
    }

    private static Element findElement(Resource r, int offset) {
        if (r == null) {
            return null;
        }
        Iterator cit = r.getClassifiers().iterator();
        Resource el = r;
        while (cit.hasNext()) {
            JavaClass jc = (JavaClass)cit.next();
            PositionBounds bounds = JavaMetamodel.getManager().getElementPosition((Element)jc);
            if (bounds == null || offset < bounds.getBegin().getOffset() || offset > bounds.getEnd().getOffset()) continue;
            el = JMIUtils.findElement(jc, offset);
            break;
        }
        return el;
    }

    private static Element findElement(JavaClass jc, int offset) {
        Iterator classIt = jc.getFeatures().iterator();
        JavaClass el = jc;
        while (classIt.hasNext()) {
            ClassMember cm = (ClassMember)classIt.next();
            PositionBounds bounds = JavaMetamodel.getManager().getElementPosition((Element)cm);
            if (offset < bounds.getBegin().getOffset() || offset >= bounds.getEnd().getOffset()) continue;
            if (cm instanceof JavaClass) {
                el = JMIUtils.findElement((JavaClass)cm, offset);
                break;
            }
            el = cm;
            break;
        }
        return el;
    }

    private static JavaModelPackage getJavaModelPackage(Feature feature) {
        return feature != null ? (JavaModelPackage)feature.refImmediatePackage() : JavaModel.getDefaultExtent();
    }

    public static void replaceParameters(Method method, List newParameters) {
        List parameters = method.getParameters();
        parameters.clear();
        for (Parameter parameter : newParameters) {
            parameters.add(JMIUtils.createParameter(method, parameter.getName(), parameter.getType(), parameter.isFinal()));
        }
    }

    public static Collection getClassesBySimpleName(String simpleName, ClassPath classPath) {
        FileObject[] roots = classPath.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            Collection classes;
            ClassIndex index;
            JavaModelPackage mofPackage = JavaMetamodel.getManager().getJavaExtent(roots[i]);
            if (mofPackage == null || (index = ClassIndex.getIndex((JavaModelPackage)mofPackage)) == null || (classes = index.getClassesBySimpleName(simpleName)) == null) continue;
            return classes;
        }
        return Collections.EMPTY_LIST;
    }

    public static boolean signaturesEqual(Method method1, Method method2) {
        assert (method1 != null && method2 != null);
        if (JMIUtils.isEmptyOrNull(method1.getParameters()) && JMIUtils.isEmptyOrNull(method2.getParameters())) {
            return true;
        }
        return method1.signatureEquals(method2);
    }

    private static boolean isEmptyOrNull(Collection collection) {
        return collection == null ? true : collection.isEmpty();
    }

    public static Method duplicate(Method original) {
        Method result = (Method)original.duplicate();
        result.setType(original.getType());
        return result;
    }

    public static void fixImports(String className) {
        JMIUtils.fixImports(JMIUtils.findClass(className));
    }

    public static void fixImports(JavaClass jc) {
        JavaClassImpl javaClass = (JavaClassImpl)jc;
        if (javaClass != null) {
            javaClass.fixImports((Element)javaClass, (Element)javaClass);
        }
    }

    public static void fixImports(JavaClass scope, Feature feature) {
        ((FeatureImpl)feature).fixImports((Element)scope, (Element)feature);
    }

    public static void saveClass(String className, FileObject fo) {
        JMIUtils.saveClass(JMIUtils.findClass(className, fo));
    }

    public static void saveClass(JavaClass jc) {
        SaveCookie sc;
        DataObject dobj;
        if (jc != null && (dobj = JavaMetamodel.getManager().getDataObject(jc.getResource())) != null && (sc = (SaveCookie)dobj.getCookie(SaveCookie.class)) != null) {
            try {
                sc.save();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private static String convertToJavaIdentifier(String str, String defaultValue) {
        if (str == null) {
            throw new NullPointerException("Passed null str to JMIUtils.convertToJavaIdentifier(String str, String defaultValue)");
        }
        if (str.equals("")) {
            throw new IllegalArgumentException("Passed empty string as str to JMIUtils.convertToJavaIdentifier(String str, String defaultValue)");
        }
        if (defaultValue == null) {
            throw new NullPointerException("Passed null defaultValue to JMIUtils.convertToJavaIdentifier(String str, String defaultValue)");
        }
        if (defaultValue.equals("")) {
            throw new IllegalArgumentException("Passed empty string as defaultValue to JMIUtils.convertToJavaIdentifier(String str, String defaultValue)");
        }
        while (str.length() > 0 && !Character.isJavaIdentifierStart(str.charAt(0))) {
            str = str.substring(1);
        }
        StringBuilder result = new StringBuilder();
        if (str.length() > 0) {
            char firstChar = str.charAt(0);
            firstChar = Character.toLowerCase(firstChar);
            result.append(firstChar);
            for (int i = 1; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) continue;
                result.append(c);
            }
        } else {
            result.append(defaultValue);
        }
        return result.toString();
    }

    public static String uniqueMemberName(JavaClass javaClass, String memberName, String defaultValue) {
        memberName = JMIUtils.convertToJavaIdentifier(memberName, defaultValue);
        List existing = javaClass.getFeatures();
        ArrayList<String> existingMethodNames = new ArrayList<String>();
        for (Feature f : existing) {
            existingMethodNames.add(f.getName());
        }
        int uniquefier = 1;
        String newName = memberName;
        while (existingMethodNames.contains(newName)) {
            newName = memberName + uniquefier++;
        }
        return newName;
    }

    public static String uniqueClassName(String className, FileObject fo) {
        int uniquefier = 1;
        String newName = className;
        while (JMIUtils.findClass(newName, fo) != null) {
            newName = className + uniquefier++;
        }
        return newName;
    }

    public static class ClassPathScanHelper {
        private boolean scanInProgress = JavaMetamodel.getManager().isScanInProgress();

        public ClassPathScanHelper() {
            if (this.scanInProgress) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        JavaMetamodel.getManager().waitScanFinished();
                        ClassPathScanHelper.this.scanInProgress = false;
                        ClassPathScanHelper.this.scanFinished();
                    }
                });
            }
        }

        public void scanFinished() {
        }

        public final boolean isScanInProgress() {
            return this.scanInProgress;
        }
    }
}

