/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.bridge;

import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.sun.bridge.AppServerBridge;

public class DirectoryDeploymentFacility {
    private String host;
    private String user;
    private String passwd;
    private int port;
    private boolean secure;
    private static final String FILEARCHIVEA81 = "com.sun.enterprise.deployment.archivist.FileArchive";
    private static final String FILEARCHIVEA9 = "com.sun.enterprise.deployment.deploy.shared.FileArchive";

    public DirectoryDeploymentFacility(String host, int port, String user, String passwd, boolean secure) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.passwd = passwd;
        this.secure = secure;
    }

    public final ProgressObject incrementalDeploy(TargetModuleID tmid) {
        JESProgressObject progressObject = null;
        File dirLocation = AppServerBridge.getDirLocation(tmid);
        try {
            Archive fa = this.getFileArchive(dirLocation);
            if (fa == null) {
                IllegalStateException ise = new IllegalStateException("cannot find FileArchive class...");
                throw ise;
            }
            DeploymentFacility df = DeploymentFacilityFactory.getDeploymentFacility();
            ServerConnectionIdentifier sci = new ServerConnectionIdentifier();
            sci.setHostName(this.host);
            sci.setHostPort(this.port);
            sci.setUserName(this.user);
            sci.setPassword(this.passwd);
            sci.setSecure(this.secure);
            df.connect(sci);
            Properties deploymentOptions = new Properties();
            deploymentOptions.put("force", "true");
            deploymentOptions.put("name", tmid.getModuleID());
            System.out.println("moduleID=" + tmid.getModuleID());
            deploymentOptions.put("archiveName", dirLocation.getAbsolutePath());
            Target[] targets = new Target[]{(Target)tmid};
            progressObject = df.deploy(targets, fa, null, (Map)deploymentOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
        return progressObject;
    }

    public ProgressObject initialDeploy(Target target, File file, String moduleID) {
        JESProgressObject progressObject = null;
        try {
            Archive fa = this.getFileArchive(file);
            if (fa == null) {
                IllegalStateException ise = new IllegalStateException("cannot find FileArchive class...");
                throw ise;
            }
            DeploymentFacility df = DeploymentFacilityFactory.getDeploymentFacility();
            ServerConnectionIdentifier sci = new ServerConnectionIdentifier();
            sci.setHostName(this.host);
            sci.setHostPort(this.port);
            sci.setUserName(this.user);
            sci.setPassword(this.passwd);
            sci.setSecure(this.secure);
            df.connect(sci);
            Properties deploymentOptions = new Properties();
            deploymentOptions.put("force", "true");
            deploymentOptions.put("name", moduleID);
            System.out.println("moduleID=" + moduleID);
            deploymentOptions.put("archiveName", file.getAbsolutePath());
            Target[] targets = new Target[]{target};
            progressObject = df.deploy(targets, fa, null, (Map)deploymentOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
        return progressObject;
    }

    private Archive getFileArchive(File file) {
        try {
            Class<?> fileArchiveClass;
            try {
                fileArchiveClass = this.getClass().getClassLoader().loadClass(FILEARCHIVEA81);
                Logger.getLogger("javax.enterprise.system.tools.deployment").setLevel(Level.SEVERE);
            }
            catch (ClassNotFoundException ex) {
                try {
                    fileArchiveClass = this.getClass().getClassLoader().loadClass(FILEARCHIVEA9);
                }
                catch (ClassNotFoundException ex2) {
                    ex2.printStackTrace();
                    return null;
                }
            }
            Object fa = fileArchiveClass.newInstance();
            Method method = fileArchiveClass.getMethod("open", String.class);
            method.invoke(fa, file.getAbsolutePath());
            return (Archive)fa;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

