/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.io.IOException;
import java.util.LinkedList;
import javax.swing.Action;
import org.netbeans.editor.AnnotationType;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderInstance;

public class AnnotationTypeActionsFolder
extends FolderInstance {
    private static final String FOLDER = "Editors/AnnotationTypes/";
    private AnnotationType type;

    private AnnotationTypeActionsFolder(AnnotationType type, DataFolder fld) {
        super(fld);
        this.type = type;
        this.recreate();
        this.instanceFinished();
    }

    public static boolean readActions(AnnotationType type, String subFolder) {
        FileObject f = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER + subFolder);
        if (f == null) {
            return false;
        }
        try {
            DataObject d = DataObject.find((FileObject)f);
            DataFolder df = (DataFolder)d.getCookie(DataFolder.class);
            if (df != null) {
                AnnotationTypeActionsFolder folder = new AnnotationTypeActionsFolder(type, df);
                return true;
            }
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
        return false;
    }

    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        LinkedList<Action> annotationActions = new LinkedList<Action>();
        for (int i = 0; i < cookies.length; ++i) {
            Object o = cookies[i].instanceCreate();
            if (!(o instanceof Action)) continue;
            Action action = (Action)o;
            annotationActions.add(action);
        }
        this.type.setActions(annotationActions.toArray(new Action[0]));
        return null;
    }
}

