/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.MIMEOptionFolder;
import org.netbeans.modules.editor.options.MultiPropertyFolder;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OptionUtilities {
    public static final String DEFAULT_FOLDER = "Defaults";
    static /* synthetic */ Class class$org$netbeans$editor$MultiKeyBinding;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$util$actions$SystemAction;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$javax$swing$JSeparator;

    private OptionUtilities() {
    }

    private static String wrap(String s) {
        return s.length() == 1 ? "0" + s : s;
    }

    public static String color2String(Color c) {
        StringBuffer sb = new StringBuffer();
        sb.append("#");
        sb.append(OptionUtilities.wrap(Integer.toHexString(c.getRed()).toUpperCase()));
        sb.append(OptionUtilities.wrap(Integer.toHexString(c.getGreen()).toUpperCase()));
        sb.append(OptionUtilities.wrap(Integer.toHexString(c.getBlue()).toUpperCase()));
        return sb.toString();
    }

    public static Color string2Color(String s) {
        try {
            return Color.decode(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static int string2Int(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static int getFontStyle(String s) {
        s = s.toLowerCase();
        int ret = 0;
        if (s.indexOf("bold") != -1) {
            ret |= 1;
        }
        if (s.indexOf("italic") != -1) {
            ret |= 2;
        }
        return ret;
    }

    public static String style2String(int i) {
        if (1 == i) {
            return "bold";
        }
        if (2 == i) {
            return "italic";
        }
        if (3 == i) {
            return "bold-italic";
        }
        return "plain";
    }

    public static Map getMapDiff(Map oldMap, Map newMap, boolean allowNewKeys) {
        Object value;
        Object key;
        HashMap ret = new HashMap();
        Iterator i = newMap.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            value = newMap.get(key);
            if (!value.equals(oldMap.get(key))) {
                ret.put(key, newMap.get(key));
                continue;
            }
            if (!allowNewKeys || oldMap.containsKey(key)) continue;
            ret.put(key, newMap.get(key));
        }
        i = oldMap.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            value = oldMap.get(key);
            if (newMap.containsKey(key)) continue;
            ret.put(key, "");
        }
        return ret;
    }

    public static String keysToString(KeyStroke[] stroke) {
        if (stroke == null) {
            return "NULL";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stroke.length; ++i) {
            sb.append(Utilities.keyToString((KeyStroke)stroke[i]));
            if (i >= stroke.length - 1) continue;
            sb.append("$");
        }
        return sb.toString();
    }

    public static String keyToString(KeyStroke stroke) {
        if (stroke == null) {
            return "NULL";
        }
        return Utilities.keyToString((KeyStroke)stroke);
    }

    public static KeyStroke stringToKey(String s) {
        if (s.equals("NULL")) {
            return null;
        }
        return Utilities.stringToKey((String)s);
    }

    public static KeyStroke[] stringToKeys(String s) {
        if (s.equals("NULL")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s.toUpperCase(), "$");
        ArrayList<KeyStroke> arr = new ArrayList<KeyStroke>();
        while (st.hasMoreElements()) {
            s = st.nextToken();
            KeyStroke k = OptionUtilities.stringToKey(s);
            if (k == null) {
                return null;
            }
            arr.add(k);
        }
        return arr.toArray(new KeyStroke[arr.size()]);
    }

    public static void printDefaultAbbrevs(Map map) {
        System.out.println("-----------------------------------------------------------");
        System.out.println("<?xml version=\"1.0\"?>");
        System.out.println("<!DOCTYPE catalog PUBLIC \"-//NetBeans//DTD Editor Abbreviations settings 1.0//EN\"");
        System.out.println(" \"http://www.netbeans.org/dtds/EditorAbbreviations-1_0.dtd\">");
        System.out.println("");
        System.out.println("<abbrevs>");
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)map.get(key);
            System.out.println("<abbrev key=\"" + key + "\">" + value + "</" + "abbrev" + ">");
        }
        System.out.println("</abbrevs>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDefaultAbbrevs(Map map, FileObject file) {
        Document doc = XMLUtil.createDocument((String)"abbrevs", null, (String)"-//NetBeans//DTD Editor Abbreviations settings 1.0//EN", (String)"http://www.netbeans.org/dtds/EditorAbbreviations-1_0.dtd");
        Element rootElem = doc.getDocumentElement();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!(map.get(key) instanceof String)) continue;
            String action = (String)map.get(key);
            Element abbrevElem = doc.createElement("abbrev");
            abbrevElem.setAttribute("key", key);
            abbrevElem.appendChild(doc.createTextNode(action));
            rootElem.appendChild(abbrevElem);
        }
        doc.getDocumentElement().normalize();
        try {
            FileLock lock = file.lock();
            try {
                XMLUtil.write((Document)doc, (OutputStream)file.getOutputStream(lock), (String)"UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDefaultMacros(Map map, FileObject file) {
        Document doc = XMLUtil.createDocument((String)"macros", null, (String)"-//NetBeans//DTD Editor Macros settings 1.0//EN", (String)"http://www.netbeans.org/dtds/EditorMacros-1_0.dtd");
        Element rootElem = doc.getDocumentElement();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!(map.get(key) instanceof String)) continue;
            String action = (String)map.get(key);
            Element macroElem = doc.createElement("macro");
            macroElem.setAttribute("name", key);
            macroElem.appendChild(doc.createTextNode(action));
            rootElem.appendChild(macroElem);
        }
        doc.getDocumentElement().normalize();
        try {
            FileLock lock = file.lock();
            try {
                XMLUtil.write((Document)doc, (OutputStream)file.getOutputStream(lock), (String)"UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDefaultKeyBindings(List list, FileObject file) {
        Map map = OptionUtilities.makeKeyBindingsMap(list);
        Document doc = XMLUtil.createDocument((String)"bindings", null, (String)"-//NetBeans//DTD Editor KeyBindings settings 1.0//EN", (String)"http://www.netbeans.org/dtds/EditorKeyBindings-1_0.dtd");
        Element rootElem = doc.getDocumentElement();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            MultiKeyBinding mkb;
            String key = (String)i.next();
            if (!(map.get(key) instanceof MultiKeyBinding) || (mkb = (MultiKeyBinding)map.get(key)) == null) continue;
            Element keybElem = doc.createElement("bind");
            keybElem.setAttribute("key", key);
            keybElem.setAttribute("actionName", mkb.actionName);
            rootElem.appendChild(keybElem);
        }
        doc.getDocumentElement().normalize();
        try {
            FileLock lock = file.lock();
            try {
                XMLUtil.write((Document)doc, (OutputStream)file.getOutputStream(lock), (String)"UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static String insetsToString(Insets ins) {
        StringBuffer sb = new StringBuffer();
        sb.append(ins.top);
        sb.append(',');
        sb.append(ins.left);
        sb.append(',');
        sb.append(ins.bottom);
        sb.append(',');
        sb.append(ins.right);
        return sb.toString();
    }

    public static Insets parseInsets(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        int[] arr = new int[4];
        int i = 0;
        while (st.hasMoreElements()) {
            if (i > 3) {
                return null;
            }
            try {
                arr[i] = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            ++i;
        }
        if (i != 4) {
            return null;
        }
        return new Insets(arr[0], arr[1], arr[2], arr[3]);
    }

    public static String dimensionToString(Dimension dim) {
        StringBuffer sb = new StringBuffer();
        sb.append(dim.width);
        sb.append(',');
        sb.append(dim.height);
        return sb.toString();
    }

    public static Dimension parseDimension(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        int[] arr = new int[2];
        int i = 0;
        while (st.hasMoreElements()) {
            if (i > 1) {
                return null;
            }
            try {
                arr[i] = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            ++i;
        }
        if (i != 2) {
            return null;
        }
        return new Dimension(arr[0], arr[1]);
    }

    public static Map makeKeyBindingsMap(List propList) {
        HashMap<String, MultiKeyBinding> ret = new HashMap<String, MultiKeyBinding>();
        boolean output = true;
        for (int i = 0; i < propList.size(); ++i) {
            String fileName;
            Object obj = propList.get(i);
            if (!(obj instanceof MultiKeyBinding)) {
                if ((class$org$netbeans$editor$MultiKeyBinding == null ? OptionUtilities.class$("org.netbeans.editor.MultiKeyBinding") : class$org$netbeans$editor$MultiKeyBinding).getClassLoader().equals(obj.getClass().getClassLoader()) || !output) continue;
                System.err.println("Different classloaders:");
                System.err.println((class$org$netbeans$editor$MultiKeyBinding == null ? OptionUtilities.class$("org.netbeans.editor.MultiKeyBinding") : class$org$netbeans$editor$MultiKeyBinding).getClassLoader());
                System.err.println(obj.getClass().getClassLoader());
                output = false;
                continue;
            }
            MultiKeyBinding mkb = (MultiKeyBinding)obj;
            String string = fileName = mkb.keys == null ? OptionUtilities.keyToString(mkb.key) : OptionUtilities.keysToString(mkb.keys);
            if (fileName == null) continue;
            ret.put(fileName, mkb);
        }
        return ret;
    }

    public static List getGlobalAttribs(String folderName) {
        MIMEOptionFolder mimeFolder = AllOptionsFolder.getDefault().getMIMEFolder();
        if (mimeFolder == null) {
            return new ArrayList();
        }
        MultiPropertyFolder mpf = mimeFolder.getMPFolder(folderName, false);
        if (mpf != null) {
            ArrayList<String> retList = new ArrayList<String>();
            Enumeration e = mpf.getDataFolder().getPrimaryFile().getAttributes();
            while (e.hasMoreElements()) {
                Object value;
                String name = (String)e.nextElement();
                if (name.indexOf("/") == -1 || !((value = mpf.getDataFolder().getPrimaryFile().getAttribute(name)) instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
                retList.add(name);
            }
            return retList;
        }
        return new ArrayList();
    }

    public static List getGlobalPopupAttribs() {
        return OptionUtilities.getGlobalAttribs("Popup");
    }

    public static List getGlobalPopupMenuItems() {
        return OptionUtilities.getGlobalMenuItems("Popup");
    }

    public static List getGlobalMenuItems(String folderName) {
        MIMEOptionFolder mimeFolder = AllOptionsFolder.getDefault().getMIMEFolder();
        if (mimeFolder == null) {
            return new ArrayList();
        }
        MultiPropertyFolder mpf = mimeFolder.getMPFolder(folderName, false);
        if (mpf != null) {
            return mpf.getProperties();
        }
        return new ArrayList();
    }

    public static List getPopupStrings(List popup) {
        return OptionUtilities.getPopupStrings(popup, false);
    }

    public static List getPopupStrings(List popup, boolean addSeparatorInstance) {
        ArrayList<Object> retList = new ArrayList<Object>();
        for (int i = 0; i < popup.size(); ++i) {
            if (!(popup.get(i) instanceof DataObject)) continue;
            DataObject dob = (DataObject)popup.get(i);
            InstanceCookie ic = (InstanceCookie)dob.getCookie(class$org$openide$cookies$InstanceCookie == null ? OptionUtilities.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
            if (ic != null) {
                try {
                    if ((class$org$openide$util$actions$SystemAction == null ? OptionUtilities.class$("org.openide.util.actions.SystemAction") : class$org$openide$util$actions$SystemAction).isAssignableFrom(ic.instanceClass())) {
                        retList.add(ic.instanceName());
                    } else if ((class$javax$swing$Action == null ? OptionUtilities.class$("javax.swing.Action") : class$javax$swing$Action).isAssignableFrom(ic.instanceClass())) {
                        retList.add(ic.instanceCreate());
                    }
                    if (!(class$javax$swing$JSeparator == null ? OptionUtilities.class$("javax.swing.JSeparator") : class$javax$swing$JSeparator).isAssignableFrom(ic.instanceClass())) continue;
                    retList.add(addSeparatorInstance ? new JSeparator() : null);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                }
                continue;
            }
            if ("org-openide-windows-TopComponent".equals(dob.getName())) {
                retList.add(dob.getName().replace('-', '.'));
                continue;
            }
            retList.add(dob.getName());
        }
        return retList;
    }

    public static List arrangeMergedFolderObjects(Set items, Set attribs) {
        int i;
        ArrayList retList = new ArrayList(items);
        ArrayList<String> nameList = new ArrayList<String>();
        for (i = 0; i < retList.size(); ++i) {
            DataObject dob = (DataObject)retList.get(i);
            nameList.add(dob.getPrimaryFile().getNameExt());
        }
        for (i = 0; i < attribs.size(); ++i) {
            Iterator j = attribs.iterator();
            while (j.hasNext()) {
                int second;
                String attr = (String)j.next();
                String firstItem = attr.substring(0, attr.indexOf(47));
                String secondItem = attr.substring(attr.indexOf(47) + 1);
                int first = nameList.indexOf(firstItem);
                if (first <= (second = nameList.indexOf(secondItem)) || second <= -1) continue;
                nameList.add(second, (String)nameList.remove(first));
                retList.add(second, retList.remove(first));
            }
        }
        return retList;
    }

    public static List arrangeMergedPopup(Set items, Set attribs) {
        List list = OptionUtilities.arrangeMergedFolderObjects(items, attribs);
        return OptionUtilities.getPopupStrings(list);
    }
}

