/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.DataExpression;
import oracle.toplink.essentials.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.ObjectExpression;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;

public class ParameterExpression
extends Expression {
    protected DatabaseField field;
    protected Expression localBase;
    protected Expression baseExpression;
    Object type;

    public ParameterExpression() {
    }

    public ParameterExpression(String fieldName) {
        this(new DatabaseField(fieldName));
    }

    public ParameterExpression(DatabaseField field) {
        this.field = field;
    }

    public ParameterExpression(String fieldName, Expression baseExpression, Object type) {
        this(new DatabaseField(fieldName), baseExpression);
        this.type = type;
    }

    public ParameterExpression(DatabaseField field, Expression baseExpression) {
        this.field = field;
        this.localBase = baseExpression;
    }

    public String basicDescription() {
        return String.valueOf(this.getField());
    }

    public String descriptionOfNodeType() {
        return "Parameter";
    }

    public Expression get(String attributeOrQueryKey) {
        ParameterExpression expression = new ParameterExpression(attributeOrQueryKey);
        expression.setBaseExpression(this);
        return expression;
    }

    public Expression getBaseExpression() {
        return this.baseExpression;
    }

    public ExpressionBuilder getBuilder() {
        if (this.localBase == null) {
            if (this.getBaseExpression() != null) {
                return ((ParameterExpression)this.getBaseExpression()).getBuilder();
            }
            return null;
        }
        return this.localBase.getBuilder();
    }

    public DatabaseField getField() {
        return this.field;
    }

    public Expression getField(DatabaseField field) {
        ParameterExpression expression = new ParameterExpression(field);
        expression.setBaseExpression(this);
        return expression;
    }

    public Expression getLocalBase() {
        return this.localBase;
    }

    public Object getType() {
        return this.type;
    }

    public Object getValue(AbstractRecord translationRow, AbstractSession session) {
        if (this.getField() == null) {
            return null;
        }
        Object value = null;
        if (this.getBaseExpression() != null) {
            value = ((ParameterExpression)this.getBaseExpression()).getValue(translationRow, session);
            if (value == null) {
                return null;
            }
            ClassDescriptor descriptor = session.getDescriptor(value);
            if (descriptor.isAggregateDescriptor() && ((ParameterExpression)this.getBaseExpression()).getLocalBase().isObjectExpression()) {
                descriptor = ((ObjectExpression)((ParameterExpression)this.getBaseExpression()).getLocalBase()).getDescriptor();
            }
            if (descriptor != null) {
                value = descriptor.getObjectBuilder().unwrapObject(value, session);
                translationRow.put(((ParameterExpression)this.getBaseExpression()).getField(), value);
                DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForField(this.getField());
                if (mapping != null) {
                    value = mapping.valueFromObject(value, this.getField(), session);
                } else {
                    mapping = descriptor.getObjectBuilder().getMappingForAttributeName(this.getField().getName());
                    if (mapping != null) {
                        value = mapping.getRealAttributeValueFromObject(value, session);
                    } else {
                        DatabaseField queryKeyField = descriptor.getObjectBuilder().getFieldForQueryKeyName(this.getField().getName());
                        if (queryKeyField != null && (mapping = descriptor.getObjectBuilder().getMappingForField(this.getField())) != null) {
                            value = mapping.valueFromObject(value, this.getField(), session);
                        }
                    }
                }
            }
        } else {
            value = translationRow.getIndicatingNoEntry(this.getField());
            if (value == AbstractRecord.noEntry) {
                throw QueryException.parameterNameMismatch(this.getField().getName());
            }
        }
        if (this.getLocalBase() != null) {
            value = this.getLocalBase().getFieldValue(value);
        }
        return value;
    }

    public boolean isParameterExpression() {
        return true;
    }

    public boolean isValueExpression() {
        return true;
    }

    protected void postCopyIn(Dictionary alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.getLocalBase() != null) {
            this.setLocalBase(this.getLocalBase().copiedVersionFrom(alreadyDone));
        }
        if (this.getBaseExpression() != null) {
            this.setBaseExpression(this.getBaseExpression().copiedVersionFrom(alreadyDone));
        }
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        if (printer.shouldPrintParameterValues()) {
            Object value = this.getValue(printer.getTranslationRow(), printer.getSession());
            if (this.getField() == null) {
                printer.printPrimitive(value);
            } else if (value instanceof Vector) {
                printer.printValuelist((Vector)value);
            } else {
                printer.printParameter(this);
            }
        } else if (this.getField() != null) {
            printer.printParameter(this);
        }
    }

    public void printJava(ExpressionJavaPrinter printer) {
        ((DataExpression)this.getLocalBase()).getBaseExpression().printJava(printer);
        printer.printString(".getParameter(\"" + this.getField().getQualifiedName() + "\")");
    }

    public Expression rebuildOn(Expression newBase) {
        ParameterExpression result = (ParameterExpression)this.clone();
        result.setLocalBase(this.localBase.rebuildOn(newBase));
        return result;
    }

    protected void setBaseExpression(Expression baseExpression) {
        this.baseExpression = baseExpression;
    }

    public void setLocalBase(Expression localBase) {
        this.localBase = localBase;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        return context.getField(this.getField());
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean isObjectUnregistered) {
        if (this.getField() != null) {
            return this.getValue(translationRow, session);
        }
        throw QueryException.cannotConformExpression();
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.basicDescription());
    }

    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.getBaseExpression() != null) {
            this.getBaseExpression().toString(writer, indent);
        }
    }
}

