/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.impl;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.remoting.Processor;

public class MethodBindingProcessor
implements Processor {
    private transient Log log = null;

    public void process(FacesContext context, String resourceId) throws IOException {
        MethodBinding mb = this.mapResourceId(context, resourceId);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Translated resource id '" + resourceId + "' to method binding expression '" + mb.getExpressionString() + "'"));
        }
        mb.invoke(context, new Object[0]);
        context.responseComplete();
    }

    protected MethodBinding mapResourceId(FacesContext context, String resourceId) {
        if (resourceId.startsWith("/")) {
            resourceId = resourceId.substring(1);
        }
        resourceId = resourceId.replace('/', '.');
        resourceId = "#{" + resourceId + "}";
        return context.getApplication().createMethodBinding(resourceId, new Class[0]);
    }

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)MethodBindingProcessor.class);
        }
        return this.log;
    }
}

