/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.util.Iterator;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

public final class AccessibilityQueryImpl
implements AccessibilityQueryImplementation {
    private final NbModuleProject project;

    public AccessibilityQueryImpl(NbModuleProject project) {
        this.project = project;
    }

    public Boolean isPubliclyAccessible(FileObject pkg) {
        String path;
        FileObject srcdir = this.project.getSourceDirectory();
        if (srcdir != null && (path = FileUtil.getRelativePath((FileObject)srcdir, (FileObject)pkg)) != null) {
            String name = path.replace('/', '.');
            Element config = this.project.getHelper().getPrimaryConfigurationData(true);
            Element pubPkgs = Util.findElement(config, "public-packages", "http://www.netbeans.org/ns/nb-module-project/2");
            if (pubPkgs == null) {
                pubPkgs = Util.findElement(config, "friend-packages", "http://www.netbeans.org/ns/nb-module-project/2");
            }
            if (pubPkgs != null) {
                Iterator it = Util.findSubElements(pubPkgs).iterator();
                while (it.hasNext()) {
                    Element pubPkg = (Element)it.next();
                    boolean sub = "subpackages".equals(pubPkg.getLocalName());
                    String pubPkgS = Util.findText(pubPkg);
                    if (!name.equals(pubPkgS) && (!sub || !name.startsWith(pubPkgS + '.'))) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            Util.err.log(16, "Invalid project.xml for " + this.project);
            return null;
        }
        return null;
    }
}

