/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class BrandingSupport {
    private final SuiteProject suiteProject;
    private SuiteProperties suiteProperties;
    private Set brandedModules = null;
    private Set brandedBundleKeys = null;
    private Set brandedFiles = null;
    private NbPlatform platform;
    private final File brandingDir;
    private static final String NAME_OF_BRANDING_FOLDER = "branding";
    private static final String BUNDLE_NAME = "Bundle.properties";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static BrandingSupport getInstance(SuiteProperties suiteProperties) throws IOException {
        return new BrandingSupport(suiteProperties);
    }

    private BrandingSupport(SuiteProperties suiteProperties) throws IOException {
        this.suiteProperties = suiteProperties;
        this.suiteProject = suiteProperties.getProject();
        File suiteDir = FileUtil.toFile((FileObject)this.suiteProject.getProjectDirectory());
        if (!($assertionsDisabled || suiteDir != null && suiteDir.exists())) {
            throw new AssertionError();
        }
        this.brandingDir = new File(suiteDir, NAME_OF_BRANDING_FOLDER);
        this.init();
    }

    public File getProjectDirectory() {
        return FileUtil.toFile((FileObject)this.suiteProject.getProjectDirectory());
    }

    public File getBrandingRoot() {
        return new File(this.getProjectDirectory(), NAME_OF_BRANDING_FOLDER);
    }

    public File getModuleEntryDirectory(ModuleEntry mEntry) {
        String relativePath = PropertyUtils.relativizeFile((File)mEntry.getClusterDirectory(), (File)mEntry.getJarLocation());
        return new File(this.getBrandingRoot(), relativePath);
    }

    public File getLocalizingBundle(ModuleEntry mEntry) {
        String bundlePath;
        ManifestManager mfm = ManifestManager.getInstanceFromJAR(mEntry.getJarLocation());
        File bundle = null;
        if (mfm != null && (bundlePath = mfm.getLocalizingBundle()) != null) {
            bundle = new File(this.getModuleEntryDirectory(mEntry), bundlePath);
        }
        return bundle;
    }

    public boolean isBranded(BundleKey key) {
        boolean retval = this.getBrandedBundleKeys().contains(key);
        return retval;
    }

    public boolean isBranded(BrandedFile bFile) {
        boolean retval = this.getBrandedFiles().contains(bFile);
        return retval;
    }

    public boolean isBranded(ModuleEntry entry) {
        boolean retval = this.getBrandedModules().contains(entry);
        if (!$assertionsDisabled && retval != this.getModuleEntryDirectory(entry).exists()) {
            throw new AssertionError();
        }
        return retval;
    }

    public Set getBrandedModules() {
        return this.brandedModules;
    }

    public Set getBrandedBundleKeys() {
        return this.brandedBundleKeys;
    }

    public Set getBrandedFiles() {
        return this.brandedFiles;
    }

    public Set getLocalizingBundleKeys(String moduleCodeNameBase, Set keys) {
        ModuleEntry foundEntry = this.getModuleEntry(moduleCodeNameBase);
        return foundEntry != null ? this.getLocalizingBundleKeys(foundEntry, keys) : null;
    }

    public Set getLocalizingBundleKeys(ModuleEntry moduleEntry, Set keys) {
        HashSet<BundleKey> retval = new HashSet<BundleKey>();
        Iterator it = this.getBrandedBundleKeys().iterator();
        while (it.hasNext() && retval.size() != keys.size()) {
            BundleKey bKey = (BundleKey)it.next();
            if (!keys.contains(bKey.getKey())) continue;
            retval.add(bKey);
        }
        if (retval.size() != keys.size()) {
            this.loadLocalizedBundlesFromPlatform(moduleEntry, keys, retval);
        }
        return retval.size() != keys.size() ? null : retval;
    }

    public BrandedFile getBrandedFile(String moduleCodeNameBase, String entryPath) {
        ModuleEntry foundEntry = this.getModuleEntry(moduleCodeNameBase);
        return foundEntry != null ? this.getBrandedFile(foundEntry, entryPath) : null;
    }

    public BrandedFile getBrandedFile(ModuleEntry moduleEntry, String entryPath) {
        BrandedFile retval = null;
        try {
            retval = new BrandedFile(moduleEntry, entryPath);
            Iterator it = this.getBrandedFiles().iterator();
            while (it.hasNext()) {
                BrandedFile bFile = (BrandedFile)it.next();
                if (!retval.equals(bFile)) continue;
                retval = bFile;
            }
        }
        catch (MalformedURLException ex) {
            retval = null;
        }
        return retval;
    }

    public BundleKey getBundleKey(String moduleCodeNameBase, String bundleEntry, String key) {
        Set keys = new HashSet<String>();
        keys.add(key);
        keys = this.getBundleKeys(moduleCodeNameBase, bundleEntry, keys);
        return keys == null ? null : (BundleKey)keys.toArray()[0];
    }

    public Set getBundleKeys(String moduleCodeNameBase, String bundleEntry, Set keys) {
        ModuleEntry foundEntry = this.getModuleEntry(moduleCodeNameBase);
        return foundEntry != null ? this.getBundleKeys(foundEntry, bundleEntry, keys) : null;
    }

    public Set getBundleKeys(ModuleEntry moduleEntry, String bundleEntry, Set keys) {
        HashSet<BundleKey> retval = new HashSet<BundleKey>();
        Iterator it = this.getBrandedBundleKeys().iterator();
        while (it.hasNext() && retval.size() != keys.size()) {
            BundleKey bKey = (BundleKey)it.next();
            if (!keys.contains(bKey.getKey())) continue;
            retval.add(bKey);
        }
        if (retval.size() != keys.size()) {
            try {
                this.loadLocalizedBundlesFromPlatform(moduleEntry, bundleEntry, keys, retval);
            }
            catch (IOException ex) {
                throw new IllegalStateException();
            }
        }
        return retval.size() != keys.size() ? null : retval;
    }

    private ModuleEntry getModuleEntry(String moduleCodeNameBase) {
        NbPlatform platform = this.getActivePlatform();
        Iterator<ModuleEntry> it = Arrays.asList(platform.getModules()).iterator();
        while (it.hasNext()) {
            ModuleEntry entry = it.next();
            if (!entry.getCodeNameBase().equals(moduleCodeNameBase)) continue;
            return entry;
        }
        return null;
    }

    private NbPlatform getActivePlatform() {
        NbPlatform retval = this.suiteProperties.getActivePlatform();
        if (retval != null) {
            return retval;
        }
        return NbPlatform.getDefaultPlatform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void brandFile(BrandedFile bFile) throws IOException {
        if (!bFile.isModified()) {
            return;
        }
        File target = bFile.getFileLocation();
        if (!target.exists()) {
            target.getParentFile().mkdirs();
            target.createNewFile();
        }
        if (!$assertionsDisabled && !target.exists()) {
            throw new AssertionError();
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = bFile.getBrandingSource().openStream();
            os = new FileOutputStream(target);
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            this.brandedFiles.add(bFile);
            bFile.modified = false;
        }
    }

    public void brandFile(BrandedFile bFile, Runnable saveTask) throws IOException {
        if (!bFile.isModified()) {
            return;
        }
        saveTask.run();
        this.brandedFiles.add(bFile);
        bFile.modified = false;
    }

    public void brandBundleKey(BundleKey bundleKey) throws IOException {
        if (bundleKey == null) {
            return;
        }
        HashSet<BundleKey> keys = new HashSet<BundleKey>();
        keys.add(bundleKey);
        this.brandBundleKeys(keys);
    }

    public void brandBundleKeys(Set bundleKeys) throws IOException {
        this.init();
        HashMap<File, EditableProperties> mentryToEditProp = new HashMap<File, EditableProperties>();
        Iterator<Object> it = bundleKeys.iterator();
        while (it.hasNext()) {
            BundleKey bKey = (BundleKey)it.next();
            if (!bKey.isModified()) continue;
            EditableProperties ep = (EditableProperties)mentryToEditProp.get(bKey.getBrandingBundle());
            if (ep == null) {
                File bundle = bKey.getBrandingBundle();
                if (!bundle.exists()) {
                    bundle.getParentFile().mkdirs();
                    bundle.createNewFile();
                }
                ep = BrandingSupport.getEditableProperties(bundle);
                mentryToEditProp.put(bKey.getBrandingBundle(), ep);
            }
            ep.setProperty(bKey.getKey(), bKey.getValue());
        }
        it = mentryToEditProp.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            File bundle = (File)entry.getKey();
            if (!$assertionsDisabled && !bundle.exists()) {
                throw new AssertionError();
            }
            BrandingSupport.storeEditableProperties((EditableProperties)entry.getValue(), bundle);
            Iterator it2 = bundleKeys.iterator();
            while (it2.hasNext()) {
                BundleKey bKey = (BundleKey)it2.next();
                File bundle2 = bKey.getBrandingBundle();
                if (!bundle2.equals(bundle)) continue;
                this.brandedBundleKeys.add(bKey);
                bKey.modified = false;
                this.brandedModules.add(bKey.getModuleEntry());
            }
        }
    }

    private void init() throws IOException {
        NbPlatform newPlatform = this.getActivePlatform();
        if (this.brandedModules == null || !newPlatform.equals(this.platform)) {
            this.brandedModules = new HashSet();
            this.brandedBundleKeys = new HashSet();
            this.brandedFiles = new HashSet();
            this.platform = newPlatform;
            if (this.brandingDir.exists()) {
                if (!$assertionsDisabled && !this.brandingDir.isDirectory()) {
                    throw new AssertionError();
                }
                this.scanModulesInBrandingDir(this.brandingDir, this.platform.getModules());
            }
        }
    }

    private void scanModulesInBrandingDir(File srcDir, ModuleEntry[] platformModules) throws IOException {
        if (srcDir.getName().endsWith(".jar")) {
            ModuleEntry foundEntry = null;
            for (int i = 0; i < platformModules.length; ++i) {
                if (!this.isBrandingForModuleEntry(srcDir, platformModules[i])) continue;
                this.scanBrandedFiles(srcDir, platformModules[i]);
                foundEntry = platformModules[i];
                break;
            }
            if (foundEntry != null) {
                this.brandedModules.add(foundEntry);
            }
        } else {
            String[] kids = srcDir.list();
            if (!$assertionsDisabled && kids == null) {
                throw new AssertionError();
            }
            for (int i = 0; i < kids.length; ++i) {
                File kid = new File(srcDir, kids[i]);
                if (!kid.isDirectory()) continue;
                this.scanModulesInBrandingDir(kid, platformModules);
            }
        }
    }

    private void scanBrandedFiles(File srcDir, ModuleEntry mEntry) throws IOException {
        String[] kids = srcDir.list();
        if (!$assertionsDisabled && kids == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < kids.length; ++i) {
            File kid = new File(srcDir, kids[i]);
            if (!kid.isDirectory()) {
                if (kid.getName().endsWith(BUNDLE_NAME)) {
                    this.loadBundleKeys(mEntry, kid);
                    continue;
                }
                this.loadBrandedFiles(mEntry, kid);
                continue;
            }
            this.scanBrandedFiles(kid, mEntry);
        }
    }

    private void loadBundleKeys(ModuleEntry mEntry, File bundle) throws IOException {
        EditableProperties p = BrandingSupport.getEditableProperties(bundle);
        Iterator it = p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            this.brandedBundleKeys.add(new BundleKey(mEntry, bundle, (String)entry.getKey(), (String)entry.getValue()));
        }
    }

    private void loadBrandedFiles(ModuleEntry mEntry, File file) throws IOException {
        String entryPath = PropertyUtils.relativizeFile((File)this.getModuleEntryDirectory(mEntry), (File)file);
        BrandedFile bf = new BrandedFile(mEntry, file.toURI().toURL(), entryPath);
        this.brandedFiles.add(bf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EditableProperties getEditableProperties(File bundle) throws IOException {
        EditableProperties p = new EditableProperties(true);
        FileInputStream is = new FileInputStream(bundle);
        try {
            p.load((InputStream)is);
        }
        finally {
            ((InputStream)is).close();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeEditableProperties(EditableProperties p, File bundle) throws IOException {
        FileOutputStream os = new FileOutputStream(bundle);
        try {
            p.store((OutputStream)os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    private void loadLocalizedBundlesFromPlatform(ModuleEntry moduleEntry, Set keys, Set bundleKeys) {
        EditableProperties p = ModuleList.loadBundleInfo(moduleEntry.getSourceLocation()).toEditableProperties();
        Iterator it = p.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!keys.contains(key)) continue;
            String value = p.getProperty(key);
            bundleKeys.add(new BundleKey(moduleEntry, key, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalizedBundlesFromPlatform(ModuleEntry moduleEntry, String bundleEntry, Set keys, Set bundleKeys) throws IOException {
        Properties p = new Properties();
        JarFile module = new JarFile(moduleEntry.getJarLocation());
        JarEntry je = module.getJarEntry(bundleEntry);
        InputStream is = module.getInputStream(je);
        File bundle = new File(this.getModuleEntryDirectory(moduleEntry), bundleEntry);
        try {
            p.load(is);
        }
        finally {
            is.close();
        }
        Iterator<Object> it = p.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!keys.contains(key)) continue;
            String value = p.getProperty(key);
            bundleKeys.add(new BundleKey(moduleEntry, bundle, key, value));
        }
    }

    private boolean isBrandingForModuleEntry(File srcDir, ModuleEntry mEntry) {
        boolean retval = mEntry.getJarLocation().getName().equals(srcDir.getName());
        if (retval) {
            String relPath1 = PropertyUtils.relativizeFile((File)mEntry.getClusterDirectory(), (File)mEntry.getJarLocation().getParentFile());
            String relPath2 = PropertyUtils.relativizeFile((File)this.brandingDir, (File)srcDir.getParentFile());
            retval = relPath1.equals(relPath2);
        }
        return retval;
    }

    static {
        $assertionsDisabled = !BrandingSupport.class.desiredAssertionStatus();
    }

    public class BrandedFile {
        private final ModuleEntry moduleEntry;
        private final String entryPath;
        private URL brandingSource;
        private boolean modified = false;

        private BrandedFile(ModuleEntry moduleEntry, String entry) throws MalformedURLException {
            this(moduleEntry, null, entry);
        }

        private BrandedFile(ModuleEntry moduleEntry, URL source, String entry) throws MalformedURLException {
            this.moduleEntry = moduleEntry;
            this.entryPath = entry;
            if (source == null) {
                this.brandingSource = moduleEntry.getJarLocation().toURI().toURL();
                this.brandingSource = new URL("jar:" + this.brandingSource + "!/" + this.entryPath);
            } else {
                this.brandingSource = source;
            }
        }

        public ModuleEntry getModuleEntry() {
            return this.moduleEntry;
        }

        public String getEntryPath() {
            return this.entryPath;
        }

        public File getFileLocation() {
            return new File(BrandingSupport.this.getModuleEntryDirectory(this.getModuleEntry()), this.getEntryPath());
        }

        public URL getBrandingSource() {
            return this.brandingSource;
        }

        public void setBrandingSource(URL brandingSource) {
            if (!Utilities.compareObjects((Object)brandingSource, (Object)this.brandingSource)) {
                this.modified = true;
            }
            this.brandingSource = brandingSource;
        }

        public void setBrandingSource(File brandingFile) throws MalformedURLException {
            this.setBrandingSource(brandingFile.toURI().toURL());
        }

        public boolean isModified() {
            return this.modified;
        }

        public boolean equals(Object obj) {
            boolean retval = false;
            if (obj instanceof BrandedFile) {
                BrandedFile bFile = (BrandedFile)obj;
                retval = this.getModuleEntry().equals(bFile.getModuleEntry()) && this.getFileLocation().equals(bFile.getFileLocation());
            }
            return retval;
        }

        public int hashCode() {
            return 0;
        }
    }

    public final class BundleKey {
        private final File brandingBundle;
        private final ModuleEntry moduleEntry;
        private final String key;
        private String value;
        private boolean modified = false;

        private BundleKey(ModuleEntry moduleEntry, File brandingBundle, String key, String value) {
            this.moduleEntry = moduleEntry;
            this.key = key;
            this.value = value;
            this.brandingBundle = brandingBundle;
        }

        private BundleKey(ModuleEntry mEntry, String key, String value) {
            this(mEntry, brandingSupport.getLocalizingBundle(mEntry), key, value);
        }

        public ModuleEntry getModuleEntry() {
            return this.moduleEntry;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            if (!this.value.equals(value)) {
                this.modified = true;
            }
            this.value = value;
        }

        public boolean equals(Object obj) {
            boolean retval = false;
            if (obj instanceof BundleKey) {
                BundleKey bKey = (BundleKey)obj;
                retval = this.getKey().equals(bKey.getKey()) && this.getModuleEntry().equals(bKey.getModuleEntry()) && this.getBrandingBundle().equals(bKey.getBrandingBundle());
            }
            return retval;
        }

        public int hashCode() {
            return 0;
        }

        boolean isModified() {
            return this.modified;
        }

        public File getBrandingBundle() {
            return this.brandingBundle;
        }
    }
}

