/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.AnnotatedNode;
import org.netbeans.modules.apisupport.project.ui.ModuleLogicalView;
import org.netbeans.modules.apisupport.project.ui.SuiteActions;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.NewNbModuleWizardIterator;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public final class SuiteLogicalView
implements LogicalViewProvider {
    private final SuiteProject suite;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView;
    static /* synthetic */ Class class$org$netbeans$spi$project$SubprojectProvider;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$NbModuleProject;
    static /* synthetic */ Class class$org$netbeans$api$project$Project;

    public SuiteLogicalView(SuiteProject suite) {
        this.suite = suite;
    }

    public Node createLogicalView() {
        return new SuiteRootNode(this.suite);
    }

    public Node findPath(Node root, Object target) {
        DataObject file;
        if (root.getLookup().lookup(SuiteProject.class) != this.suite) {
            return null;
        }
        if (target instanceof FileObject) {
            try {
                file = DataObject.find((FileObject)((FileObject)target));
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        } else if (target instanceof DataObject) {
            file = (DataObject)target;
        } else {
            return null;
        }
        Node impFilesNode = root.getChildren().findChild("important.files");
        if (impFilesNode != null) {
            Node[] impFiles = impFilesNode.getChildren().getNodes(true);
            for (int i = 0; i < impFiles.length; ++i) {
                if (impFiles[i].getCookie(class$org$openide$loaders$DataObject == null ? SuiteLogicalView.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject) != file) continue;
                return impFiles[i];
            }
        }
        return null;
    }

    private static Children createRootChildren(SuiteProject suite) {
        ImportantFilesChildren ch = new ImportantFilesChildren(suite);
        Node ifn = ModuleLogicalView.createImportantFilesNode((Children)ch);
        Node[] nodes = new Node[]{new ModulesNode(suite), ifn};
        Children.Array children = new Children.Array();
        children.add(nodes);
        return children;
    }

    private static final class ImportantFilesChildren
    extends Children.Keys {
        private List visibleFiles = new ArrayList();
        private FileChangeListener fcl;
        private static final Map FILES;
        private final SuiteProject project;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ImportantFilesChildren(SuiteProject project) {
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.attachListeners();
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.removeListeners();
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            String loc = (String)key;
            String locEval = this.project.getEvaluator().evaluate(loc);
            FileObject file = this.project.getHelper().resolveFileObject(locEval);
            try {
                Node orig = DataObject.find((FileObject)file).getNodeDelegate();
                return new Node[]{new ModuleLogicalView.SpecialFileNode(orig, (String)FILES.get(loc))};
            }
            catch (DataObjectNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        private void refreshKeys() {
            ArrayList<String> newVisibleFiles = new ArrayList<String>();
            Iterator it = FILES.keySet().iterator();
            HashSet<FileObject> files = new HashSet<FileObject>();
            while (it.hasNext()) {
                FileObject file;
                String loc = (String)it.next();
                String locEval = this.project.getEvaluator().evaluate(loc);
                if (locEval == null || (file = this.project.getHelper().resolveFileObject(locEval)) == null) continue;
                newVisibleFiles.add(loc);
                files.add(file);
            }
            if (!this.isInitialized() || !((Object)newVisibleFiles).equals(this.visibleFiles)) {
                this.visibleFiles = newVisibleFiles;
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        ImportantFilesChildren.this.setKeys(ImportantFilesChildren.this.visibleFiles);
                    }
                });
                ((ModuleLogicalView.ImportantFilesNode)this.getNode()).setFiles(files);
            }
        }

        private void attachListeners() {
            block3: {
                try {
                    if (this.fcl == null) {
                        this.fcl = new FileChangeAdapter(){

                            public void fileDataCreated(FileEvent fe) {
                                ImportantFilesChildren.this.refreshKeys();
                            }

                            public void fileDeleted(FileEvent fe) {
                                ImportantFilesChildren.this.refreshKeys();
                            }
                        };
                        this.project.getProjectDirectory().getFileSystem().addFileChangeListener(this.fcl);
                    }
                }
                catch (FileStateInvalidException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
        }

        private void removeListeners() {
            if (this.fcl != null) {
                block3: {
                    try {
                        this.project.getProjectDirectory().getFileSystem().removeFileChangeListener(this.fcl);
                    }
                    catch (FileStateInvalidException e) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)e);
                    }
                }
                this.fcl = null;
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView).desiredAssertionStatus();
            FILES = new LinkedHashMap();
            FILES.put("master.jnlp", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"LBL_jnlp_master"));
            FILES.put("build.xml", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"LBL_build.xml"));
            FILES.put("nbproject/project.properties", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"LBL_project.properties"));
            FILES.put("nbproject/private/private.properties", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"LBL_private.properties"));
            FILES.put("nbproject/platform.properties", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"LBL_platform.properties"));
            FILES.put("nbproject/private/platform-private.properties", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"LBL_platform-private.properties"));
        }
    }

    private static final class OpenProjectAction
    extends CookieAction {
        private OpenProjectAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            final Project[] projects = new Project[activatedNodes.length];
            for (int i = 0; i < activatedNodes.length; ++i) {
                Project project;
                projects[i] = project = (Project)activatedNodes[i].getLookup().lookup(class$org$netbeans$api$project$Project == null ? SuiteLogicalView.class$("org.netbeans.api.project.Project") : class$org$netbeans$api$project$Project);
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    String previousText = StatusDisplayer.getDefault().getStatusText();
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"MSG_OpeningProjects"));
                    OpenProjects.getDefault().open(projects, false);
                    StatusDisplayer.getDefault().setStatusText(previousText);
                }
            });
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"CTL_OpenProject");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }

        protected int mode() {
            return 4;
        }

        protected Class[] cookieClasses() {
            return new Class[]{class$org$netbeans$api$project$Project == null ? (class$org$netbeans$api$project$Project = SuiteLogicalView.class$("org.netbeans.api.project.Project")) : class$org$netbeans$api$project$Project};
        }
    }

    private static final class RemoveSuiteComponentAction
    extends NodeAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        private RemoveSuiteComponentAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            for (int i = 0; i < activatedNodes.length; ++i) {
                NbModuleProject suiteComponent = (NbModuleProject)activatedNodes[i].getLookup().lookup(class$org$netbeans$modules$apisupport$project$NbModuleProject == null ? SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.NbModuleProject") : class$org$netbeans$modules$apisupport$project$NbModuleProject);
                if (!$assertionsDisabled && suiteComponent == null) {
                    throw new AssertionError((Object)"NbModuleProject in lookup");
                }
                try {
                    NbModuleProject[] modules = SuiteUtils.getDependentModules(suiteComponent);
                    boolean remove = true;
                    if (modules.length > 0) {
                        StringBuffer sb = new StringBuffer("<ul>");
                        for (int j = 0; j < modules.length; ++j) {
                            sb.append("<li>" + ProjectUtils.getInformation((Project)modules[j]).getDisplayName() + "</li>");
                        }
                        sb.append("</ul>");
                        String displayName = ProjectUtils.getInformation((Project)suiteComponent).getDisplayName();
                        String confirmMessage = NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView") : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"MSG_RemovingModuleMessage", (Object)displayName, (Object)sb.toString());
                        NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)confirmMessage, NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView") : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"CTL_RemovingModuleTitle", (Object)displayName), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm);
                        if (confirm.getValue() == NotifyDescriptor.CANCEL_OPTION) {
                            remove = false;
                        }
                    }
                    if (!remove) continue;
                    SuiteUtils.removeModuleFromSuiteWithDependencies(suiteComponent);
                    continue;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"CTL_RemoveModule");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView).desiredAssertionStatus();
        }
    }

    private static final class SuiteComponentNode
    extends AbstractNode {
        private static final Action REMOVE_ACTION = new RemoveSuiteComponentAction();
        private static final Action OPEN_ACTION = new OpenProjectAction();

        public SuiteComponentNode(NbModuleProject suiteComponent) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{suiteComponent}));
            ProjectInformation info = ProjectUtils.getInformation((Project)suiteComponent);
            this.setName(info.getName());
            this.setDisplayName(info.getDisplayName());
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.gif");
            info.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "displayName") {
                        SuiteComponentNode.this.setDisplayName((String)evt.getNewValue());
                    } else if (evt.getPropertyName() == "name") {
                        SuiteComponentNode.this.setName((String)evt.getNewValue());
                    }
                }
            });
        }

        public Action[] getActions(boolean context) {
            return new Action[]{OPEN_ACTION, REMOVE_ACTION};
        }

        public Action getPreferredAction() {
            return OPEN_ACTION;
        }
    }

    static final class AddNewLibraryWrapperAction
    extends AbstractAction {
        private final Project suiteProvider;
        private final NbModuleProject target;
        static final /* synthetic */ boolean $assertionsDisabled;

        public AddNewLibraryWrapperAction(Project suiteProvider, NbModuleProject target) {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"CTL_AddNewLibrary"));
            this.suiteProvider = suiteProvider;
            this.target = target;
        }

        public AddNewLibraryWrapperAction(Project suiteProvider) {
            this(suiteProvider, null);
        }

        public void actionPerformed(ActionEvent evt) {
            block3: {
                NbModuleProject project = UIUtil.runLibraryWrapperWizard(this.suiteProvider);
                if (project != null && this.target != null) {
                    try {
                        Util.addDependency(this.target, project);
                        ProjectManager.getDefault().saveProject((Project)this.target);
                    }
                    catch (IOException e) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)e);
                    }
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView).desiredAssertionStatus();
        }
    }

    private static final class AddNewSuiteComponentAction
    extends AbstractAction {
        private final SuiteProject suite;

        public AddNewSuiteComponentAction(SuiteProject suite) {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"CTL_AddNewModule"));
            this.suite = suite;
        }

        public void actionPerformed(ActionEvent evt) {
            NewNbModuleWizardIterator iterator = NewNbModuleWizardIterator.createSuiteComponentIterator(this.suite);
            UIUtil.runProjectWizard(iterator, "CTL_NewModuleProject");
        }
    }

    private static final class AddSuiteComponentAction
    extends AbstractAction {
        private final SuiteProject suite;

        public AddSuiteComponentAction(SuiteProject suite) {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"CTL_AddModule"));
            this.suite = suite;
        }

        public void actionPerformed(ActionEvent evt) {
            NbModuleProject project = UIUtil.chooseSuiteComponent(WindowManager.getDefault().getMainWindow(), this.suite);
            if (project != null) {
                if (!SuiteUtils.contains(this.suite, project)) {
                    try {
                        SuiteUtils.addModule(this.suite, project);
                        ProjectManager.getDefault().saveProject((Project)this.suite);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"MSG_SuiteAlreadyContainsCNB", (Object)project.getCodeNameBase())));
                }
            }
        }
    }

    static final class ModulesNode
    extends AbstractNode {
        private SuiteProject suite;

        ModulesNode(SuiteProject suite) {
            super((Children)new ModuleChildren(suite));
            this.suite = suite;
            this.setName("modules");
            this.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"CTL_Modules"));
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new AddNewSuiteComponentAction(this.suite), new AddNewLibraryWrapperAction(this.suite), new AddSuiteComponentAction(this.suite)};
        }

        private Image getIcon(boolean opened) {
            Image badge = Utilities.loadImage((String)"org/netbeans/modules/apisupport/project/suite/resources/module-badge.gif", (boolean)true);
            return Utilities.mergeImages((Image)UIUtil.getTreeFolderIcon(opened), (Image)badge, (int)9, (int)9);
        }

        public Image getIcon(int type) {
            return this.getIcon(false);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(true);
        }

        static final class ModuleChildren
        extends Children.Keys
        implements ChangeListener {
            private final SubprojectProvider spp;

            public ModuleChildren(SuiteProject suite) {
                this.spp = (SubprojectProvider)suite.getLookup().lookup(class$org$netbeans$spi$project$SubprojectProvider == null ? (class$org$netbeans$spi$project$SubprojectProvider = SuiteLogicalView.class$("org.netbeans.spi.project.SubprojectProvider")) : class$org$netbeans$spi$project$SubprojectProvider);
                this.spp.addChangeListener((ChangeListener)this);
            }

            protected void addNotify() {
                this.updateKeys();
            }

            private void updateKeys() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        TreeSet subModules = new TreeSet(Util.projectDisplayNameComparator());
                        subModules.addAll(ModuleChildren.this.spp.getSubprojects());
                        ModuleChildren.this.setKeys(subModules);
                    }
                });
            }

            protected void removeNotify() {
                this.spp.removeChangeListener((ChangeListener)this);
                this.setKeys(Collections.EMPTY_SET);
            }

            protected Node[] createNodes(Object key) {
                return new Node[]{new SuiteComponentNode((NbModuleProject)key)};
            }

            public void stateChanged(ChangeEvent ev) {
                this.updateKeys();
            }
        }
    }

    static final class SuiteRootNode
    extends AnnotatedNode
    implements PropertyChangeListener {
        private static final Image ICON = Utilities.loadImage((String)"org/netbeans/modules/apisupport/project/suite/resources/suite.gif", (boolean)true);
        private final SuiteProject suite;
        private final ProjectInformation info;

        SuiteRootNode(SuiteProject suite) {
            super(SuiteLogicalView.createRootChildren(suite), Lookups.fixed((Object[])new Object[]{suite}));
            this.suite = suite;
            this.info = ProjectUtils.getInformation((Project)suite);
            this.info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.info));
            this.setFiles(this.getProjectFiles());
        }

        Set getProjectFiles() {
            HashSet<FileObject> files = new HashSet<FileObject>();
            Enumeration en = this.suite.getProjectDirectory().getChildren(false);
            while (en.hasMoreElements()) {
                FileObject child = (FileObject)en.nextElement();
                if (FileOwnerQuery.getOwner((FileObject)child) != this.suite) continue;
                files.add(child);
            }
            return files;
        }

        public String getName() {
            return this.info.getDisplayName();
        }

        public String getDisplayName() {
            return this.info.getDisplayName();
        }

        public String getShortDescription() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView = SuiteLogicalView.class$("org.netbeans.modules.apisupport.project.ui.SuiteLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$SuiteLogicalView), (String)"HINT_suite_project_root_node", (Object)FileUtil.getFileDisplayName((FileObject)this.suite.getProjectDirectory()));
        }

        public Action[] getActions(boolean context) {
            return SuiteActions.getProjectActions(this.suite);
        }

        public Image getIcon(int type) {
            return this.annotateIcon(ICON, type);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("name")) {
                this.fireNameChange(null, this.getName());
            } else if (evt.getPropertyName().equals("displayName")) {
                this.fireDisplayNameChange(null, this.getDisplayName());
            }
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String name) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.suite, (String)name);
        }
    }
}

