/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.AbstractEntry;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

abstract class AbstractEntryWithSources
extends AbstractEntry {
    private LocalizedBundleInfo bundleInfo;

    AbstractEntryWithSources() {
    }

    protected LocalizedBundleInfo getBundleInfo() {
        if (this.bundleInfo == null) {
            this.bundleInfo = ModuleList.loadBundleInfo(this.getSourceLocation());
        }
        return this.bundleInfo;
    }

    protected Set computePublicClassNamesInMainModule() throws IOException {
        HashSet result = new HashSet();
        File src = new File(this.getSourceLocation(), "src");
        ManifestManager.PackageExport[] pkgs = this.getPublicPackages();
        for (int i = 0; i < pkgs.length; ++i) {
            String pkg = pkgs[i].getPackage();
            this.scanForClasses(result, pkg, new File(src, pkg.replace('.', File.separatorChar)), pkgs[i].isRecursive());
        }
        return result;
    }

    private void scanForClasses(Set result, String pkg, File dir, boolean recurse) throws IOException {
        if (!dir.isDirectory()) {
            return;
        }
        File[] kids = dir.listFiles();
        if (kids == null) {
            throw new IOException(dir.getAbsolutePath());
        }
        for (int i = 0; i < kids.length; ++i) {
            String name = kids[i].getName();
            if (name.endsWith(".java")) {
                String basename = name.substring(0, name.length() - 5);
                result.add(pkg + '.' + basename);
            }
            if (!recurse || !kids[i].isDirectory()) continue;
            this.scanForClasses(result, pkg + '.' + name, kids[i], true);
        }
    }

    public String[] getRunDependencies() {
        NbModuleProject project;
        TreeSet<String> deps = new TreeSet<String>();
        FileObject source = FileUtil.toFileObject((File)this.getSourceLocation());
        if (source == null) {
            return new String[0];
        }
        try {
            project = (NbModuleProject)ProjectManager.getDefault().findProject(source);
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
            return new String[0];
        }
        Element data = project.getHelper().getPrimaryConfigurationData(true);
        Element moduleDependencies = Util.findElement(data, "module-dependencies", "http://www.netbeans.org/ns/nb-module-project/2");
        List depEls = Util.findSubElements(moduleDependencies);
        Iterator it = depEls.iterator();
        StringBuffer cp = new StringBuffer();
        while (it.hasNext()) {
            Element dep = (Element)it.next();
            if (Util.findElement(dep, "run-dependency", "http://www.netbeans.org/ns/nb-module-project/2") == null) continue;
            Element cnbEl = Util.findElement(dep, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/2");
            String cnb = Util.findText(cnbEl);
            deps.add(cnb);
        }
        return deps.toArray(new String[deps.size()]);
    }

    public String getSpecificationVersion() {
        FileObject source = FileUtil.toFileObject((File)this.getSourceLocation());
        if (source != null) {
            try {
                NbModuleProject project = (NbModuleProject)ProjectManager.getDefault().findProject(source);
                if (project != null) {
                    return project.getSpecVersion();
                }
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
        return null;
    }
}

