/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.api;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.websvc.jaxws.JAXWSSupportAccessor;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportImpl;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class JAXWSSupport {
    private JAXWSSupportImpl impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(JAXWSSupportProvider.class));

    private JAXWSSupport(JAXWSSupportImpl impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
    }

    public static JAXWSSupport getJAXWSSupport(FileObject f) {
        if (f == null) {
            throw new NullPointerException("Passed null to WebServicesSupport.getWebServicesSupport(FileObject)");
        }
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            JAXWSSupportProvider supportProvider = (JAXWSSupportProvider)it.next();
            JAXWSSupport wss = supportProvider.findJAXWSSupport(f);
            if (wss == null) continue;
            return wss;
        }
        return null;
    }

    public void addService(String serviceName, String serviceImpl, boolean isJsr109) {
        this.impl.addService(serviceName, serviceImpl, isJsr109);
    }

    public String addService(String name, String serviceImpl, String wsdlUrl, String serviceName, String portName, String packageName, boolean isJsr109) {
        return this.impl.addService(name, serviceImpl, wsdlUrl, serviceName, portName, packageName, isJsr109);
    }

    public List getServices() {
        return this.impl.getServices();
    }

    public void removeService(String serviceName) {
        this.impl.removeService(serviceName);
    }

    public void serviceFromJavaRemoved(String serviceName) {
        this.impl.serviceFromJavaRemoved(serviceName);
    }

    public String getServiceImpl(String serviceName) {
        return this.impl.getServiceImpl(serviceName);
    }

    public boolean isFromWSDL(String serviceName) {
        return this.impl.isFromWSDL(serviceName);
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        return this.impl.getWsdlFolder(create);
    }

    public FileObject getLocalWsdlFolderForService(String serviceName, boolean createFolder) {
        return this.impl.getLocalWsdlFolderForService(serviceName, createFolder);
    }

    public FileObject getBindingsFolderForService(String serviceName, boolean createFolder) {
        return this.impl.getBindingsFolderForService(serviceName, createFolder);
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.impl.getAntProjectHelper();
    }

    public URL getCatalog() {
        return this.impl.getCatalog();
    }

    public String getWsdlLocation(String serviceName) {
        return this.impl.getWsdlLocation(serviceName);
    }

    public void removeNonJsr109Entries(String serviceName) throws IOException {
        this.impl.removeNonJsr109Entries(serviceName);
    }

    public FileObject getDeploymentDescriptorFolder() {
        return this.impl.getDeploymentDescriptorFolder();
    }

    static {
        JAXWSSupportAccessor.DEFAULT = new JAXWSSupportAccessor(){

            public JAXWSSupport createJAXWSSupport(JAXWSSupportImpl spiWebServicesSupport) {
                return new JAXWSSupport(spiWebServicesSupport);
            }

            public JAXWSSupportImpl getJAXWSSupportImpl(JAXWSSupport wss) {
                return wss == null ? null : wss.impl;
            }
        };
    }
}

