/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;

public class Snapshot
implements InvocationHandler {
    private final HashMap results = new HashMap();
    private RefObject wrappedObject;
    private HashSet snapshots;

    private Snapshot(RefObject wrappedObject) {
        this.wrappedObject = wrappedObject;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        if (this.wrappedObject == null) {
            result = this.results.get(method);
            if (result == null && !this.results.containsKey(method)) {
                throw new IllegalStateException("Value for " + method + " not cached.");
            }
        } else {
            result = method.invoke((Object)this.wrappedObject, args);
            result = this.wrap(result);
            this.results.put(method, result);
        }
        return result;
    }

    private void addSnapshot(Object snapshot) {
        if (this.snapshots == null) {
            this.snapshots = new HashSet();
        }
        this.snapshots.add(snapshot);
    }

    private Object wrap(Object obj) {
        if (obj instanceof Collection) {
            return this.wrapCollection((Collection)obj);
        }
        if (obj instanceof RefObject) {
            RefObject result = Snapshot.createSnapshot((RefObject)obj);
            this.addSnapshot(result);
            return result;
        }
        return obj;
    }

    private Object wrapCollection(Collection col) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            result.add(this.wrap(it.next()));
        }
        return result;
    }

    private void freeze() {
        if (this.snapshots != null) {
            Iterator it = this.snapshots.iterator();
            while (it.hasNext()) {
                ((Snapshot)it.next()).freeze();
            }
            this.snapshots = null;
        }
        this.wrappedObject = null;
    }

    public static RefObject createSnapshot(RefObject wrappedObject) {
        Snapshot ss = new Snapshot(wrappedObject);
        Class<?> clz = wrappedObject.getClass();
        return (RefObject)Proxy.newProxyInstance(clz.getClassLoader(), clz.getInterfaces(), (InvocationHandler)ss);
    }

    public static void freeze(RefObject snapshot) {
        ((Snapshot)Proxy.getInvocationHandler(snapshot)).freeze();
    }
}

