/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.openide.util.WeakSet;

public class LightAttrList
implements List {
    private List innerList;
    private int modCount = 0;
    private final MetadataElement parent;
    private final int changeMask;
    private List hardReferences;
    private final WeakSet iterators = new WeakSet();
    private RuntimeException exception = null;

    private void lock(boolean writeLock) {
        JavaMetamodel.getDefaultRepository().beginTrans(writeLock);
    }

    private void unlock() {
        this.unlock(false);
    }

    private void unlock(boolean rollback) {
        JavaMetamodel.getDefaultRepository().endTrans(rollback);
    }

    public LightAttrList(List innerList, MetadataElement parent, int changeMask) {
        this(innerList, parent, changeMask, false);
    }

    public LightAttrList(List innerList, MetadataElement parent, int changeMask, boolean hardReference) {
        this.parent = parent;
        this.changeMask = changeMask;
        this.setInnerList(innerList);
        if (hardReference) {
            this.updateHardReferences(true);
        }
    }

    private void updateHardReferences(boolean parentChanged) {
        Object[] elements = this.innerList.toArray();
        this.hardReferences = new ArrayList(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            Object obj = elements[i];
            if (parentChanged) {
                this.parentChanged(obj);
            }
            this.hardReferences.add(obj);
        }
    }

    public void setInnerList(List innerList) {
        this.setInnerList(innerList, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInnerList(List innerList, boolean parentChanged) {
        block5: {
            this.lock(false);
            try {
                ++this.modCount;
                this.innerList = innerList;
                if (this.hardReferences != null) {
                    this.updateHardReferences(parentChanged);
                }
                if (this.iterators == null) break block5;
                Object[] iters = this.iterators.toArray();
                for (int i = 0; i < iters.length; ++i) {
                    if (((LightAttrListIterator)iters[i]).modCount < 0) continue;
                    this.exception = new RuntimeException();
                    break;
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getInnerList() {
        this.lock(false);
        try {
            List list = this.innerList;
            return list;
        }
        finally {
            this.unlock();
        }
    }

    protected void objectChanged() {
        if (this.parent != null) {
            this.parent.objectChanged(this.changeMask);
        }
    }

    protected void parentChanged(Object obj) {
        if (obj instanceof MetadataElement) {
            ((MetadataElement)((Object)obj)).parentChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object obj) {
        boolean fail = true;
        this.lock(true);
        try {
            this.objectChanged();
            boolean result = this.innerList.remove(obj);
            if (this.hardReferences != null && result) {
                this.hardReferences.remove(obj);
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int param, Object obj) {
        boolean fail = true;
        this.lock(true);
        try {
            this.objectChanged();
            Object result = this.innerList.set(param, obj);
            if (this.hardReferences != null) {
                this.hardReferences.set(param, obj);
            }
            this.parentChanged(obj);
            fail = false;
            Object object = result;
            return object;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int param) {
        boolean fail = true;
        this.lock(true);
        try {
            this.objectChanged();
            Object result = this.innerList.remove(param);
            if (this.hardReferences != null) {
                this.hardReferences.remove(param);
            }
            fail = false;
            Object e = result;
            return e;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int param, Object obj) {
        boolean fail = true;
        this.lock(true);
        try {
            this.objectChanged();
            this.innerList.add(param, obj);
            if (this.hardReferences != null) {
                this.hardReferences.add(param, obj);
            }
            this.parentChanged(obj);
            fail = false;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object obj) {
        boolean fail = true;
        this.lock(true);
        try {
            this.objectChanged();
            boolean result = this.innerList.add(obj);
            if (this.hardReferences != null && result) {
                this.hardReferences.add(obj);
            }
            if (result) {
                this.parentChanged(obj);
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator(int param) {
        this.lock(false);
        try {
            LightAttrListIterator result = new LightAttrListIterator(param);
            if (this.iterators != null) {
                this.iterators.add((Object)result);
            }
            LightAttrListIterator lightAttrListIterator = result;
            return lightAttrListIterator;
        }
        finally {
            this.unlock();
        }
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List subList(int param, int param1) {
        this.lock(false);
        try {
            LightAttrList lightAttrList = new LightAttrList(this.innerList.subList(param, param1), this.parent, this.changeMask);
            return lightAttrList;
        }
        finally {
            this.unlock();
        }
    }

    public boolean contains(Object obj) {
        return this.innerList.contains(obj);
    }

    public boolean containsAll(Collection collection) {
        return this.innerList.containsAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        boolean fail = true;
        this.lock(true);
        try {
            this.objectChanged();
            boolean result = this.innerList.addAll(c);
            if (this.hardReferences != null) {
                this.hardReferences.addAll(c);
            }
            if (result) {
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    this.parentChanged(it.next());
                }
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean fail = true;
        this.lock(true);
        try {
            this.objectChanged();
            this.innerList.clear();
            if (this.hardReferences != null) {
                this.hardReferences.clear();
            }
            fail = false;
        }
        finally {
            this.unlock(fail);
        }
    }

    public boolean isEmpty() {
        return this.innerList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        boolean fail = true;
        this.lock(true);
        try {
            this.objectChanged();
            boolean result = this.innerList.removeAll(c);
            if (this.hardReferences != null) {
                this.hardReferences.removeAll(c);
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        boolean fail = true;
        this.lock(true);
        try {
            this.objectChanged();
            boolean result = this.innerList.retainAll(c);
            if (this.hardReferences != null) {
                this.hardReferences.retainAll(c);
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    public int size() {
        return this.innerList.size();
    }

    public Object[] toArray() {
        return this.innerList.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.innerList.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection c) {
        boolean fail = true;
        this.lock(true);
        try {
            this.objectChanged();
            boolean result = this.innerList.addAll(index, c);
            if (this.hardReferences != null) {
                this.hardReferences.addAll(index, c);
            }
            if (result) {
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    this.parentChanged(it.next());
                }
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    public Object get(int index) {
        return this.innerList.get(index);
    }

    public int indexOf(Object o) {
        return this.innerList.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.innerList.lastIndexOf(o);
    }

    class LightAttrListIterator
    implements ListIterator {
        private ListIterator innerIterator;
        private ListIterator hrIterator;
        private int modCount = -1;
        private final int index;

        LightAttrListIterator(int param) {
            this.index = param;
        }

        private int getParentModCount() {
            return LightAttrList.this.modCount;
        }

        private void testModCount() throws ConcurrentModificationException {
            if (this.modCount == -1) {
                if (LightAttrList.this.hardReferences != null) {
                    if (LightAttrList.this.hardReferences.size() != LightAttrList.this.innerList.size()) {
                        JMManager.getLog().notify(1, (Throwable)new Exception("Inconsistency in LightAttrList: innerList.size() == " + LightAttrList.this.innerList.size() + " while hardReferences.size() == " + LightAttrList.this.hardReferences.size() + ". Fixing..."));
                        LightAttrList.this.updateHardReferences(true);
                    }
                    this.hrIterator = LightAttrList.this.hardReferences.listIterator(this.index);
                }
                this.innerIterator = LightAttrList.this.innerList.listIterator(this.index);
                this.modCount = this.getParentModCount();
            } else if (this.getParentModCount() != this.modCount) {
                JMManager.getLog().notify(1, (Throwable)LightAttrList.this.exception);
                throw new ConcurrentModificationException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            boolean fail = true;
            LightAttrList.this.lock(true);
            try {
                this.testModCount();
                LightAttrList.this.objectChanged();
                this.innerIterator.remove();
                if (this.hrIterator != null) {
                    this.hrIterator.remove();
                }
                fail = false;
            }
            finally {
                LightAttrList.this.unlock(fail);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Object obj) {
            boolean fail = true;
            LightAttrList.this.lock(true);
            try {
                this.testModCount();
                LightAttrList.this.objectChanged();
                this.innerIterator.add(obj);
                if (this.hrIterator != null) {
                    this.hrIterator.add(obj);
                }
                LightAttrList.this.parentChanged(obj);
                fail = false;
            }
            finally {
                LightAttrList.this.unlock(fail);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Object obj) {
            boolean fail = true;
            LightAttrList.this.lock(true);
            try {
                this.testModCount();
                LightAttrList.this.objectChanged();
                this.innerIterator.set(obj);
                if (this.hrIterator != null) {
                    this.hrIterator.set(obj);
                }
                LightAttrList.this.parentChanged(obj);
                fail = false;
            }
            finally {
                LightAttrList.this.unlock(fail);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            LightAttrList.this.lock(false);
            try {
                this.testModCount();
                boolean bl = this.innerIterator.hasNext();
                return bl;
            }
            finally {
                LightAttrList.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPrevious() {
            LightAttrList.this.lock(false);
            try {
                this.testModCount();
                boolean bl = this.innerIterator.hasPrevious();
                return bl;
            }
            finally {
                LightAttrList.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            LightAttrList.this.lock(false);
            try {
                this.testModCount();
                if (this.hrIterator != null) {
                    this.hrIterator.next();
                }
                Object e = this.innerIterator.next();
                return e;
            }
            finally {
                LightAttrList.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int nextIndex() {
            LightAttrList.this.lock(false);
            try {
                this.testModCount();
                int n = this.innerIterator.nextIndex();
                return n;
            }
            finally {
                LightAttrList.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object previous() {
            LightAttrList.this.lock(false);
            try {
                this.testModCount();
                if (this.hrIterator != null) {
                    this.hrIterator.previous();
                }
                Object e = this.innerIterator.previous();
                return e;
            }
            finally {
                LightAttrList.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int previousIndex() {
            LightAttrList.this.lock(false);
            try {
                this.testModCount();
                int n = this.innerIterator.previousIndex();
                return n;
            }
            finally {
                LightAttrList.this.unlock();
            }
        }
    }
}

