/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefObject;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.lib.java.parser.ASTContext;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.lib.java.parser.ErrConsumer;
import org.netbeans.lib.java.parser.Factory;
import org.netbeans.lib.java.parser.JParser;
import org.netbeans.lib.java.parser.ParserTokens;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.parser.ASTRepairer;
import org.netbeans.modules.javacore.parser.Util;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

public class ASTProvider
implements ParserTokens,
ASTreeTypes,
ASTContext {
    FileObject fobj;
    private CloneableEditorSupport editor;
    private ASTree topNode;
    private Token[] tokens;
    private String sourceText;
    private Resource rsc;
    static ASTree[] NULL_TREE;
    boolean documentPositions;
    boolean hasSyntaxErrors;
    private static final Pattern docRegExp;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ASTProvider(Resource r, FileObject obj) {
        this.rsc = r;
        this.fobj = obj;
        if (obj == null) {
            throw new InvalidObjectException((RefObject)r);
        }
    }

    protected ASTProvider(Resource r, FileObject obj, String sourceText, boolean isFromDoc) {
        this(r, obj);
        this.sourceText = sourceText;
        this.documentPositions = isFromDoc;
    }

    private void createASTree() {
        Reader r;
        int status = -1;
        this.hasSyntaxErrors = false;
        try {
            r = this.getReader();
        }
        catch (Exception ex) {
            JMManager.getLog().log(16, "Error opening stream for: " + this.getResource().getName() + "; " + ex.toString());
            ErrorManager.getDefault().notify((Throwable)ex);
            return;
        }
        JParser parser = Factory.getDefault().getParser(this, r, this.fobj.getName());
        try {
            if (JMManager.PERF_DEBUG) {
                System.err.println("Parsing file: " + this.fobj.getName());
                Thread.dumpStack();
            }
            status = parser.parse(false);
        }
        catch (Exception ex) {
            JMManager.getLog().notify(1, (Throwable)ex);
            this.dumpSource(ex);
        }
        this.tokens = parser.getTokens();
        if (this.tokens == null) {
            this.tokens = new Token[0];
        }
        if (status != 0) {
            this.hasSyntaxErrors = true;
            this.topNode = new ASTRepairer(this, parser).fixTree();
        } else {
            this.topNode = parser.getASTree();
        }
    }

    Token[] getTokens() {
        return this.tokens;
    }

    public Token getTokenByOffset(int offset) {
        int index;
        if (offset >= this.sourceText.length()) {
            return null;
        }
        int lo = 0;
        int hi = this.tokens.length;
        while (true) {
            if (lo >= hi) {
                return null;
            }
            index = (hi - lo) / 2 + lo;
            int check = this.checkToken(this.tokens[index], offset);
            if (check < 0) {
                hi = index;
                continue;
            }
            if (check <= 0) break;
            lo = index + 1;
        }
        Token result = this.tokens[index];
        Token[] paddings = result.getPadding();
        if (paddings != null) {
            for (int i = paddings.length - 1; i >= 0; --i) {
                if (paddings[i].getEndOffset() <= offset) continue;
                result = paddings[i];
            }
        }
        return result;
    }

    private int checkToken(Token token, int offset) {
        Token[] padding = token.getPadding();
        int startOffset = padding != null && padding.length > 0 ? padding[0].getStartOffset() : token.getStartOffset();
        int endOffset = token.getEndOffset();
        if (offset < startOffset) {
            return -1;
        }
        if (offset >= endOffset) {
            return 1;
        }
        return 0;
    }

    public ASTree getASTree() {
        if (!this.fobj.isValid()) {
            return null;
        }
        if (this.topNode == null) {
            this.createASTree();
        }
        return this.topNode;
    }

    public boolean hasSyntaxError() {
        return this.hasSyntaxErrors;
    }

    FileObject getFileObject() {
        return this.fobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRealSource(boolean overridePositions) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        StyledDocument doc = null;
        DataObject dobj = Util.getModifiedDataObject(this.fobj);
        if (dobj != null) {
            EditorCookie editor = (EditorCookie)dobj.getCookie(EditorCookie.class);
            if (editor != null) {
                doc = editor.getDocument();
            }
            if (!$assertionsDisabled && doc == null) {
                throw new AssertionError((Object)("Modified DO " + this.fobj.getPath() + " without document"));
            }
            if (overridePositions) {
                this.documentPositions = true;
            }
            final String[] str = new String[1];
            final StyledDocument doc2 = doc;
            Runnable run = new Runnable(){

                public void run() {
                    try {
                        str[0] = doc2.getText(0, doc2.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            };
            doc.render(run);
            return str[0];
        }
        InputStream is = this.fobj.getInputStream();
        String encoding = Util.getFileEncoding(this.fobj);
        InputStreamReader fileReader = encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, encoding);
        try {
            String string = Util.readContents(fileReader, this.fobj.getSize());
            return string;
        }
        finally {
            ((Reader)fileReader).close();
        }
    }

    Reader getFileReader(boolean overridePositions) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        return new StringReader(this.getRealSource(overridePositions));
    }

    public Reader getReader() throws FileNotFoundException, UnsupportedEncodingException, IOException {
        if (this.sourceText == null) {
            this.sourceText = this.getRealSource(true);
        }
        return new StringReader(this.sourceText);
    }

    public Resource getResource() {
        return this.rsc;
    }

    public String getJavaDoc(ASTree tree) {
        String javadoText = null;
        Token javaDocToken = this.getComment(tree);
        if (javaDocToken.getType() == 364) {
            javadoText = this.getText(javaDocToken);
        }
        return ASTProvider.removeJavadocStars(javadoText);
    }

    public ASTree findTree(ASTree parentTree, int firstToken, int lastToken, int type) {
        Token tk;
        ASTree[] children = parentTree.getSubTrees();
        for (int i = 0; i < children.length; ++i) {
            ASTree ch = children[i];
            if (ch == null) continue;
            int first = ch.getFirstToken();
            int last = ch.getLastToken();
            if (first == firstToken && last == lastToken && type == ch.getType()) {
                return ch;
            }
            if (first > firstToken || last < lastToken) continue;
            return this.findTree(ch, firstToken, lastToken, type);
        }
        String addMsg = "";
        if (firstToken == lastToken && (tk = this.getToken(firstToken)) != null) {
            addMsg = " found type: " + tk.getType();
            try {
                addMsg = addMsg + " found source text: " + this.getSourceText().substring(tk.getStartOffset(), tk.getEndOffset());
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Child tree not found (type: " + type + " firstToken: " + firstToken + " lastToken: " + lastToken + " resource: " + this.getResource().getName() + addMsg + ")");
    }

    public Token getComment(ASTree t) {
        Token first = this.getToken(t.getFirstToken());
        Token[] pad = first.getPadding();
        for (int i = pad.length - 1; i >= 0; --i) {
            Token c = pad[i];
            if (c.getType() != 364) continue;
            return c;
        }
        return first;
    }

    ASTree[] check(ASTree tree) {
        if (tree == null || tree.getType() == 313) {
            return null;
        }
        return NULL_TREE;
    }

    public ASTree[] filterParts(ASTree[] parts) {
        if (parts != null) {
            ArrayList<Object> typeDecl = null;
            for (int i = parts.length - 1; i >= 0; --i) {
                ASTree tree = parts[i];
                ASTree[] checked = this.check(tree);
                if (checked == NULL_TREE) continue;
                if (typeDecl == null) {
                    typeDecl = new ArrayList<Object>(Arrays.asList((Object[])parts));
                }
                if (checked == null) {
                    typeDecl.remove(i);
                    continue;
                }
                typeDecl.addAll(i, Arrays.asList((Object[])checked));
            }
            if (typeDecl != null) {
                return typeDecl.toArray(new ASTree[typeDecl.size()]);
            }
        }
        return parts;
    }

    public String getText(ASTree tree) {
        if (tree == null) {
            return null;
        }
        return this.getText(tree, tree);
    }

    public String getText(ASTree first, ASTree last) {
        int start = this.getToken(first.getFirstToken()).getStartOffset();
        int end = this.getToken(last.getLastToken()).getEndOffset();
        return this.sourceText.substring(start, end);
    }

    public String getText(Token token) {
        int start = token.getStartOffset();
        int end = token.getEndOffset();
        return this.sourceText.substring(start, end);
    }

    public Token getToken(int index) {
        return index >= 0 && index < this.tokens.length ? this.tokens[index] : null;
    }

    public ASTree getParent(ASTree tree) {
        ASTree parent = this.getASTree();
        int index = tree.getFirstToken();
        while (true) {
            int i;
            ASTree[] parts = parent.getSubTrees();
            ASTree element = null;
            for (i = 0; i < parts.length && ((element = parts[i]) == null || element.getFirstToken() > index || element.getLastToken() < index); ++i) {
            }
            if (i == parts.length) {
                return parent;
            }
            if (element == tree) {
                return parent;
            }
            parent = element;
        }
    }

    public boolean isFromDocument() {
        return this.documentPositions;
    }

    public PositionBounds createBounds(ASTree startTree, ASTree endTree, boolean inclDoc) {
        Token startToken = inclDoc ? this.getComment(startTree) : this.getToken(startTree.getFirstToken());
        Token endToken = this.getToken(endTree.getLastToken());
        if (startToken == null || endToken == null) {
            String startTreeText = null;
            String endTreeText = null;
            try {
                startTreeText = startTree.toString();
                endTreeText = endTree.toString();
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            RuntimeException ex = startToken == null ? new RuntimeException("First token is null for ASTree: " + startTreeText + " of type: " + startTree.getType() + ";\ncalling startTree.getFirstToken() returns " + startTree.getFirstToken()) : new RuntimeException("Last token is null for ASTree: " + endTreeText + " of type: " + endTree.getType() + ";\ncalling endTree.getLastToken() returns " + endTree.getLastToken());
            ex.printStackTrace();
            this.dumpSource(ex);
        }
        return this.createBounds(new int[]{startToken.getStartOffset(), endToken.getEndOffset()});
    }

    public PositionBounds createBounds(int startOffset, int endOffset) {
        return this.createBounds(new int[]{startOffset, endOffset});
    }

    public PositionBounds createBounds(int[] oldOffsets) {
        if (this.editor == null) {
            DataObject dobj;
            try {
                dobj = DataObject.find((FileObject)this.fobj);
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return null;
            }
            this.editor = Util.findCloneableEditorSupport(dobj);
        }
        int[] offsets = this.getDocumentOffsets(oldOffsets);
        PositionRef start = this.editor.createPositionRef(offsets[0], Position.Bias.Forward);
        PositionRef end = this.editor.createPositionRef(offsets[1], Position.Bias.Backward);
        return new PositionBounds(start, end);
    }

    public int[] getDocumentOffsets(int[] offsets) {
        if (!this.isFromDocument()) {
            return this.convertToDocumentOffsets(offsets);
        }
        return offsets;
    }

    public int[] convertToDocumentOffsets(int[] offsets) {
        int pos = -1;
        int firstOffset = 0;
        int[] newOffsets = (int[])offsets.clone();
        int srcLastIdx = this.sourceText.length() - 1;
        while (pos < offsets[offsets.length - 1] && (pos = this.sourceText.indexOf(13, pos + 1)) != -1) {
            if (pos < srcLastIdx && this.sourceText.charAt(pos + 1) != '\n') continue;
            while (firstOffset < offsets.length && offsets[firstOffset] <= pos) {
                ++firstOffset;
            }
            int i = firstOffset;
            while (i < offsets.length) {
                int n = i++;
                newOffsets[n] = newOffsets[n] - 1;
            }
        }
        return newOffsets;
    }

    public String getSourceText() {
        if (this.sourceText == null) {
            try {
                this.getReader();
            }
            catch (Exception ex) {
                JMManager.getLog().log(16, "Error opening stream for: " + this.getResource().getName() + "; " + ex.toString());
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return this.sourceText;
    }

    private static String removeJavadocStars(String rawText) {
        if (rawText == null) {
            return null;
        }
        rawText = "\n".concat(rawText.substring(1, rawText.length() - 2));
        String[] lines = docRegExp.split(rawText, Integer.MAX_VALUE);
        StringBuffer purgedComment = new StringBuffer(rawText.length());
        for (int i = 1; i < lines.length; ++i) {
            if (i + 1 == lines.length) {
                if (lines[i].trim().length() == 0) continue;
                purgedComment.append(lines[i]);
                continue;
            }
            purgedComment.append(lines[i]).append('\n');
        }
        return purgedComment.toString();
    }

    public ASTree getRootTree() {
        return this.getASTree();
    }

    public String getSourceLevel() {
        return SourceLevelQuery.getSourceLevel((FileObject)this.fobj);
    }

    public String getClassPath() {
        return null;
    }

    public ErrConsumer getErrorConsumer() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSource(Exception exc) {
        String dumpDir = System.getProperty("netbeans.user") + "/var/log/";
        String src = this.getSourceText();
        String rscName = this.getResource() == null ? "null" : this.getResource().getName();
        int pos = rscName.lastIndexOf(47);
        String origName = pos >= 0 ? rscName.substring(pos + 1) : rscName;
        String name = null;
        File f = new File(dumpDir + origName + ".dump");
        for (int i = 1; i < 255 && f.exists(); ++i) {
            f = new File(dumpDir + origName + '_' + i + ".dump");
        }
        if (!f.exists()) {
            try {
                FileOutputStream os = new FileOutputStream(f);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                try {
                    writer.println(src);
                    writer.println("----- Original exception ---------------------------------------------");
                    exc.printStackTrace(writer);
                    name = f.getName();
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().annotate((Throwable)ioe, 0, "Error when writing parser dump file!", null, null, null);
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
                name = null;
            }
        }
        if (name != null) {
            ErrorManager.getDefault().notify(1, (Throwable)new RuntimeException("Invalid AST returned from parser or error parsing '" + rscName + "'. Please report a bug against java module and attach dump file '" + dumpDir + name + "'."));
        } else {
            ErrorManager.getDefault().log(16, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + dumpDir + "' and " + "clean all *.dump files in that directory.");
        }
    }

    public String toString() {
        return "ASTProvider@" + System.identityHashCode(this) + " for \"" + this.getResource().getName() + "\"";
    }

    static {
        $assertionsDisabled = !ASTProvider.class.desiredAssertionStatus();
        NULL_TREE = new ASTree[0];
        docRegExp = Pattern.compile("\\r?\\n(\\s*\\*+)?");
    }
}

