/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.parser.ScopeMember;

class PackageImpScope
implements ScopeMember {
    private String jPackage;
    private ClassPath classPath;
    private Map positiveCache;
    private Set negativeCache;

    PackageImpScope(String pack, ClassPath cp) {
        this.jPackage = pack.length() > 0 ? pack.concat(".") : pack;
        this.classPath = cp;
        this.positiveCache = new HashMap();
        this.negativeCache = new HashSet();
    }

    public Object lookup(Object key) {
        if (this.negativeCache.contains(key)) {
            return null;
        }
        Object val = this.positiveCache.get(key);
        if (val != null) {
            return val;
        }
        String className = this.jPackage.concat((String)key);
        JavaClass jcls = ClassIndex.getClassByFqn(className, this.classPath);
        if (jcls != null) {
            String name = jcls.getName();
            this.positiveCache.put(key, name);
            return name;
        }
        this.negativeCache.add(key);
        return null;
    }
}

