/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.netbeans.lib.java.parser.Factory;
import org.netbeans.lib.java.parser.JScanner;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.modules.javacore.parser.ASTProvider;

public class TokenIterator {
    JScanner scanner;
    ASTProvider provider;
    int tokenIndex;
    Token currentToken;

    public TokenIterator(InputStream stream, String sourceLevel) {
        this(new InputStreamReader(stream), sourceLevel);
    }

    public TokenIterator(Reader reader, String sourceLevel) {
        this(reader, sourceLevel, false);
    }

    public TokenIterator(InputStream stream, String sourceLevel, boolean liteScan) {
        this(new InputStreamReader(stream), sourceLevel, liteScan);
    }

    public TokenIterator(Reader reader, String sourceLevel, boolean liteScan) {
        this.scanner = Factory.getDefault().getScanner(reader, sourceLevel, liteScan);
    }

    public TokenIterator(ASTProvider p) {
        this.provider = p;
    }

    public int getNextTokenType() throws IOException {
        if (this.scanner != null) {
            return this.scanner.yylex();
        }
        try {
            this.currentToken = this.provider.getToken(this.tokenIndex++);
            return this.currentToken != null ? this.currentToken.getType() : 0;
        }
        catch (IndexOutOfBoundsException ex) {
            return 0;
        }
    }

    public String getIdentifierText() {
        if (this.scanner != null) {
            return this.scanner.yytext();
        }
        return (String)this.currentToken.getValue();
    }

    public int getIdentifierHash() {
        if (this.scanner != null) {
            return this.scanner.yyhash();
        }
        return this.currentToken.getValue().hashCode();
    }

    public boolean isDeprecated() {
        if (this.scanner != null) {
            boolean b = this.scanner.isDeprecated();
            this.scanner.resetDeprecatedFlag();
            return b;
        }
        return this.currentToken.getDeprecatedFlag();
    }
}

