/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.nodes;

import java.util.List;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.client.WsCompileClientEditorSupport;
import org.netbeans.modules.websvc.api.registry.WebServicesRegistryView;
import org.netbeans.modules.websvc.core.client.nodes.ServiceClientNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ClientViewChildren
extends FilterNode.Children {
    public ClientViewChildren(FileObject wsdlFolder) throws DataObjectNotFoundException {
        super(DataObject.find((FileObject)wsdlFolder).getNodeDelegate());
    }

    protected Node[] createNodes(Object key) {
        Node[] results = new Node[]{};
        Node origNode = (Node)key;
        DataObject wsdlDataObject = (DataObject)origNode.getCookie(DataObject.class);
        if (wsdlDataObject != null && this.isClient(wsdlDataObject)) {
            WebServicesRegistryView registryView = (WebServicesRegistryView)Lookup.getDefault().lookup(WebServicesRegistryView.class);
            Node[] serviceNodes = registryView.getWebServiceNodes(wsdlDataObject.getPrimaryFile());
            if (serviceNodes != null) {
                results = new Node[serviceNodes.length];
                for (int i = 0; i < serviceNodes.length; ++i) {
                    results[i] = new ServiceClientNode(origNode, serviceNodes[i]);
                }
            } else {
                results = new Node[]{new ServiceClientNode(origNode, null)};
                final FileObject wsdlFileObject = wsdlDataObject.getPrimaryFile();
                final WebServicesRegistryView regView = registryView;
                Thread registerThread = new Thread(new Runnable(){

                    public void run() {
                        regView.registerService(wsdlFileObject, true);
                    }
                }, "RegisterWSClient " + wsdlFileObject.getNameExt());
                registerThread.start();
            }
        }
        return results;
    }

    private boolean isClient(DataObject dobj) {
        FileObject wsdlFileObject = dobj.getPrimaryFile();
        WebServicesClientSupport wss = WebServicesClientSupport.getWebServicesClientSupport((FileObject)wsdlFileObject);
        List wsClients = wss.getServiceClients();
        for (WsCompileClientEditorSupport.ServiceSettings wsClient : wsClients) {
            String wsdlFileName = wsdlFileObject.getName();
            if (!wsdlFileName.equals(wsClient.getServiceName())) continue;
            return true;
        }
        return false;
    }
}

