/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.project;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.websvc.api.webservices.WsCompileEditorSupport;
import org.netbeans.modules.websvc.core.project.WsCompileFeatures;
import org.openide.ErrorManager;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerWsCompile
extends JPanel
implements WsCompileEditorSupport.Panel,
HelpCtx.Provider {
    public static final Color ErrorTextForegroundColor = new Color(89, 79, 191);
    private static final int MAX_IMPORTANT_FEATURES = 12;
    private DefaultListModel servicesModel;
    private JCheckBox[] featureCheckboxes;
    private int serviceType;
    private String features;
    private boolean updatingDisplay;
    private boolean processingCheckBox;
    private boolean processingFeatureString;
    private JCheckBox jChkFeatureA;
    private JCheckBox jChkFeatureB;
    private JCheckBox jChkFeatureC;
    private JCheckBox jChkFeatureD;
    private JCheckBox jChkFeatureE;
    private JCheckBox jChkFeatureF;
    private JCheckBox jChkFeatureG;
    private JCheckBox jChkFeatureH;
    private JCheckBox jChkFeatureI;
    private JCheckBox jChkFeatureJ;
    private JCheckBox jChkFeatureK;
    private JCheckBox jChkFeatureL;
    private JLabel jLblEnabledFeatures;
    private JLabel jLblError;
    private JLabel jLblPanelDescription;
    private JLabel jLblServices;
    private JList jLstServices;
    private JPanel jPnlFeatures;
    private JPanel jPnlOptions;
    private JPanel jPnlServices;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTxtEnabledFeatures;
    private static final HashSet masterWsCompileFeatures = new HashSet<String>(WsCompileFeatures.getFeaturesMap().keySet());

    public CustomizerWsCompile() {
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jPnlServices = new JPanel();
        this.jLblServices = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jLstServices = new JList();
        this.jPnlFeatures = new JPanel();
        this.jLblPanelDescription = new JLabel();
        this.jPnlOptions = new JPanel();
        this.jChkFeatureA = new JCheckBox();
        this.jChkFeatureB = new JCheckBox();
        this.jChkFeatureC = new JCheckBox();
        this.jChkFeatureD = new JCheckBox();
        this.jChkFeatureE = new JCheckBox();
        this.jChkFeatureF = new JCheckBox();
        this.jChkFeatureG = new JCheckBox();
        this.jChkFeatureH = new JCheckBox();
        this.jChkFeatureI = new JCheckBox();
        this.jChkFeatureJ = new JCheckBox();
        this.jChkFeatureK = new JCheckBox();
        this.jChkFeatureL = new JCheckBox();
        this.jLblEnabledFeatures = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTxtEnabledFeatures = new JTextArea();
        this.jLblError = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jPnlServices.setLayout(new GridBagLayout());
        this.jLblServices.setDisplayedMnemonic(NbBundle.getMessage(CustomizerWsCompile.class, (String)"LBL_WebServicesMnemonic").charAt(0));
        this.jLblServices.setLabelFor(this.jLstServices);
        this.jLblServices.setText(NbBundle.getMessage(CustomizerWsCompile.class, (String)"LBL_WebServices"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.jPnlServices.add((Component)this.jLblServices, gridBagConstraints);
        this.jLstServices.setSelectionMode(0);
        this.jLstServices.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CustomizerWsCompile.this.jLstServicesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jLstServices);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.jPnlServices.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPnlServices, gridBagConstraints);
        this.jPnlFeatures.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLblPanelDescription, (String)NbBundle.getMessage(CustomizerWsCompile.class, (String)"LBL_PanelDescriptionService"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlFeatures.add((Component)this.jLblPanelDescription, gridBagConstraints);
        this.jPnlOptions.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureA, (String)"Feature A");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureA, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureB, (String)"Feature B");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureB, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureC, (String)"Feature C");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureC, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureD, (String)"Feature D");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureD, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureE, (String)"Feature E");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureE, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureF, (String)"Feature F");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureF, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureG, (String)"Feature G");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureG, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureH, (String)"Feature H");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureH, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureI, (String)"Feature I");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureI, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureJ, (String)"Feature J");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureJ, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureK, (String)"Feature K");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureK, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jChkFeatureL, (String)"Feature L");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPnlOptions.add((Component)this.jChkFeatureL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPnlFeatures.add((Component)this.jPnlOptions, gridBagConstraints);
        this.jLblEnabledFeatures.setLabelFor(this.jTxtEnabledFeatures);
        Mnemonics.setLocalizedText((JLabel)this.jLblEnabledFeatures, (String)NbBundle.getMessage(CustomizerWsCompile.class, (String)"LBL_EnabledFeatures"));
        this.jLblEnabledFeatures.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 11);
        this.jPnlFeatures.add((Component)this.jLblEnabledFeatures, gridBagConstraints);
        this.jTxtEnabledFeatures.setLineWrap(true);
        this.jTxtEnabledFeatures.setRows(3);
        this.jTxtEnabledFeatures.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.jTxtEnabledFeatures);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.jPnlFeatures.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.add((Component)this.jPnlFeatures, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLblError, (String)" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLblError, gridBagConstraints);
    }

    private void jLstServicesValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            WsCompileEditorSupport.ServiceSettings entry = (WsCompileEditorSupport.ServiceSettings)this.jLstServices.getSelectedValue();
            if (entry != null) {
                this.updateServiceFeatures(entry);
            } else {
                this.disableServiceFeatures();
            }
        }
    }

    private void initUserComponents() {
        this.updatingDisplay = false;
        this.processingCheckBox = false;
        this.processingFeatureString = false;
        this.jLblError.setForeground(ErrorTextForegroundColor);
        this.servicesModel = new DefaultListModel();
        this.featureCheckboxes = new JCheckBox[12];
        this.featureCheckboxes[0] = this.jChkFeatureA;
        this.featureCheckboxes[1] = this.jChkFeatureB;
        this.featureCheckboxes[2] = this.jChkFeatureC;
        this.featureCheckboxes[3] = this.jChkFeatureD;
        this.featureCheckboxes[4] = this.jChkFeatureE;
        this.featureCheckboxes[5] = this.jChkFeatureF;
        this.featureCheckboxes[6] = this.jChkFeatureG;
        this.featureCheckboxes[7] = this.jChkFeatureH;
        this.featureCheckboxes[8] = this.jChkFeatureI;
        this.featureCheckboxes[9] = this.jChkFeatureJ;
        this.featureCheckboxes[10] = this.jChkFeatureK;
        this.featureCheckboxes[11] = this.jChkFeatureL;
        ItemListener checkBoxListener = new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (!CustomizerWsCompile.this.processingFeatureString) {
                    JCheckBox source = (JCheckBox)evt.getSource();
                    String feature = source.getText();
                    CustomizerWsCompile.this.enableFeature(feature, evt.getStateChange() == 1);
                }
            }
        };
        for (int i = 0; i < 12; ++i) {
            this.featureCheckboxes[i].addItemListener(checkBoxListener);
        }
        this.jTxtEnabledFeatures.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (!CustomizerWsCompile.this.updatingDisplay) {
                    CustomizerWsCompile.this.updateFeatureList(e);
                }
            }

            public void insertUpdate(DocumentEvent e) {
                if (!CustomizerWsCompile.this.updatingDisplay) {
                    CustomizerWsCompile.this.updateFeatureList(e);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (!CustomizerWsCompile.this.updatingDisplay) {
                    CustomizerWsCompile.this.updateFeatureList(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableFeature(String feature, boolean enable) {
        boolean modified = false;
        Set featureSet = this.featuresAsSet(this.features);
        if (enable && !featureSet.contains(feature)) {
            featureSet.add(feature);
            modified = true;
        } else if (!enable && featureSet.contains(feature)) {
            featureSet.remove(feature);
            modified = true;
        }
        if (modified) {
            try {
                this.processingCheckBox = true;
                String newFeatures = this.featuresAsString(featureSet);
                this.jTxtEnabledFeatures.setText(newFeatures);
            }
            finally {
                this.processingCheckBox = false;
            }
        }
    }

    private Set featuresAsSet(String featureString) {
        HashSet<String> set = new HashSet<String>(10);
        String[] featureList = featureString.split(",");
        for (int i = 0; i < featureList.length; ++i) {
            String feature = featureList[i].trim();
            if (feature == null || feature.length() <= 0) continue;
            set.add(feature);
        }
        return set;
    }

    private String featuresAsString(Set featureSet) {
        StringBuffer featureString = new StringBuffer(featureSet.size() * 16);
        Iterator iter = featureSet.iterator();
        while (iter.hasNext()) {
            String feature = (String)iter.next();
            featureString.append(feature);
            if (!iter.hasNext()) continue;
            featureString.append(", ");
        }
        return featureString.toString();
    }

    private void updateFeatureList(DocumentEvent e) {
        Document doc = e.getDocument();
        String oldFeatures = this.features;
        try {
            this.features = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
        if (!this.features.equals(oldFeatures)) {
            WsCompileEditorSupport.ServiceSettings entry = (WsCompileEditorSupport.ServiceSettings)this.jLstServices.getSelectedValue();
            entry.setNewFeatures(this.features);
            this.checkSettings(entry);
            if (!this.processingCheckBox) {
                this.updateCheckBoxes(this.features);
            }
            WsCompileEditorSupport.FeatureDescriptor oldF = new WsCompileEditorSupport.FeatureDescriptor(entry.getServiceName(), oldFeatures);
            WsCompileEditorSupport.FeatureDescriptor newF = new WsCompileEditorSupport.FeatureDescriptor(entry.getServiceName(), this.features);
            this.firePropertyChange("featuresChanged", oldF, newF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCheckBoxes(String features) {
        try {
            this.processingFeatureString = true;
            Set featureSet = this.featuresAsSet(features);
            for (int i = 0; i < 12; ++i) {
                String feature = this.featureCheckboxes[i].getText();
                this.featureCheckboxes[i].setSelected(featureSet.contains(feature));
            }
        }
        finally {
            this.processingFeatureString = false;
        }
    }

    private boolean checkSettings(WsCompileEditorSupport.ServiceSettings settings) {
        String message = this.validateSettings(settings);
        if (message != null) {
            this.jLblError.setText(message);
        } else {
            this.jLblError.setText(" ");
        }
        return message != null;
    }

    private String validateSettings(WsCompileEditorSupport.ServiceSettings settings) {
        String message = null;
        List availableFeatures = settings.getAvailableFeatures();
        String[] featuresList = settings.getNewFeatures().split(",");
        for (int i = 0; i < featuresList.length; ++i) {
            featuresList[i] = featuresList[i].trim();
            if (featuresList[i] == null || featuresList[i].length() <= 0 || availableFeatures.contains(featuresList[i])) continue;
            if (masterWsCompileFeatures.contains(featuresList[i])) {
                message = NbBundle.getMessage(CustomizerWsCompile.class, (String)"ERR_FeatureNotSupported", (Object)featuresList[i]);
                break;
            }
            message = NbBundle.getMessage(CustomizerWsCompile.class, (String)"ERR_InvalidFeature", (Object)featuresList[i]);
            break;
        }
        boolean usesRpcLiteral = false;
        boolean usesDocumentLiteral = false;
        for (int i = 0; i < featuresList.length; ++i) {
            if ("rpcliteral".equals(featuresList[i])) {
                usesRpcLiteral = true;
                continue;
            }
            if (!"documentliteral".equals(featuresList[i])) continue;
            usesDocumentLiteral = true;
        }
        if (usesRpcLiteral && usesDocumentLiteral) {
            message = NbBundle.getMessage(CustomizerWsCompile.class, (String)"ERR_InvalidBinding");
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceFeatures(WsCompileEditorSupport.ServiceSettings entry) {
        try {
            int index;
            this.updatingDisplay = true;
            this.enableServiceFeatures();
            Iterator iter = entry.getImportantFeatures().iterator();
            for (index = 0; iter.hasNext() && index < 12; ++index) {
                String feature = (String)iter.next();
                this.featureCheckboxes[index].setVisible(true);
                this.featureCheckboxes[index].setText(feature);
                this.featureCheckboxes[index].setToolTipText(WsCompileFeatures.getFeaturesMap().get(feature));
            }
            while (index < 12) {
                this.featureCheckboxes[index++].setVisible(false);
            }
            this.features = entry.getNewFeatures();
            this.updateCheckBoxes(this.features);
            this.jTxtEnabledFeatures.setText(this.features);
            this.checkSettings(entry);
        }
        finally {
            this.updatingDisplay = false;
        }
    }

    private void enableServiceFeatures() {
    }

    private void disableServiceFeatures() {
    }

    public void addNotify() {
        super.addNotify();
        this.jLstServices.setModel(this.servicesModel);
        this.jLstServices.setSelectedIndex(0);
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public void initValues(List settings) {
        assert (settings.size() > 0);
        this.jLblServices.setText(NbBundle.getMessage(CustomizerWsCompile.class, (String)"LBL_WebServices"));
        this.jLblPanelDescription.setText(NbBundle.getMessage(CustomizerWsCompile.class, (String)"LBL_PanelDescriptionService"));
        this.servicesModel.clear();
        for (WsCompileEditorSupport.ServiceSettings entry : settings) {
            this.servicesModel.addElement(entry);
        }
    }

    public JPanel getComponent() {
        return this;
    }

    public void validatePanel() throws WizardValidationException {
        String message;
        WsCompileEditorSupport.ServiceSettings entry = (WsCompileEditorSupport.ServiceSettings)this.jLstServices.getSelectedValue();
        if (entry != null && (message = this.validateSettings(entry)) != null) {
            throw new WizardValidationException((JComponent)this.jTxtEnabledFeatures, message, message);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

