/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.websvc.core.webservices.ui.panels.SelectHandlerPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSHandlerDialog {
    private Dialog dialog;
    private SelectHandlerPanel sPanel;
    private AddMessageHandlerDialogDesc dlgDesc;
    private boolean isJaxWS;

    public WSHandlerDialog(Project project, boolean isJaxWS) {
        this.isJaxWS = isJaxWS;
        this.sPanel = new SelectHandlerPanel(project);
        this.dlgDesc = new AddMessageHandlerDialogDesc(this.sPanel);
        this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.dlgDesc);
    }

    public void show() {
        this.dialog.setVisible(true);
    }

    public boolean okButtonPressed() {
        return this.dlgDesc.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Set<String> getSelectedClasses() {
        HashSet<String> selectedClasses = new HashSet<String>();
        Node[] nodes = this.sPanel.getSelectedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            JavaClass jc = JMIUtils.getJavaClassFromNode((Node)nodes[i]);
            selectedClasses.add(jc.getName());
        }
        return selectedClasses;
    }

    class AddMessageHandlerDialogDesc
    extends DialogDescriptor {
        Project project;
        final SelectHandlerPanel sPanel;
        private Object[] closingOptionsWithoutOK;
        private Object[] closingOptionsWithOK;

        public AddMessageHandlerDialogDesc(SelectHandlerPanel sPanel) {
            super((Object)sPanel, NbBundle.getMessage(WSHandlerDialog.class, (String)"TTL_SelectHandler"));
            this.closingOptionsWithoutOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION};
            this.closingOptionsWithOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION, DialogDescriptor.OK_OPTION};
            this.sPanel = sPanel;
            this.setButtonListener(new AddMessageActionListener(sPanel));
        }

        private boolean isHandler(JavaClass ce) {
            if (ce != null) {
                if (WSHandlerDialog.this.isJaxWS) {
                    JavaClass handlerClass = JMIUtils.findClass((String)"javax.xml.ws.handler.Handler");
                    JavaClass logicalHandlerClass = JMIUtils.findClass((String)"javax.xml.ws.handler.LogicalHandler");
                    return ce.isSubTypeOf((ClassDefinition)handlerClass) || ce.isSubTypeOf((ClassDefinition)logicalHandlerClass);
                }
                JavaClass handlerClass = JMIUtils.findClass((String)"javax.xml.rpc.handler.Handler");
                return ce.isSubTypeOf((ClassDefinition)handlerClass);
            }
            return false;
        }

        class AddMessageActionListener
        implements ActionListener {
            SelectHandlerPanel sPanel;

            public AddMessageActionListener(SelectHandlerPanel sPanel) {
                this.sPanel = sPanel;
            }

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == NotifyDescriptor.OK_OPTION) {
                    boolean accepted = true;
                    String errMsg = null;
                    Node[] selectedNodes = this.sPanel.getSelectedNodes();
                    for (int i = 0; i < selectedNodes.length; ++i) {
                        Node node = selectedNodes[i];
                        JavaClass classElement = JMIUtils.getJavaClassFromNode((Node)node);
                        if (classElement == null) {
                            errMsg = NbBundle.getMessage(WSHandlerDialog.class, (String)"NotJavaClass_msg");
                            accepted = false;
                            break;
                        }
                        if (AddMessageHandlerDialogDesc.this.isHandler(classElement)) continue;
                        errMsg = NbBundle.getMessage(WSHandlerDialog.class, (String)"NotHandlerClass_msg", (Object)classElement.getName());
                        accepted = false;
                        break;
                    }
                    if (!accepted) {
                        NotifyDescriptor.Message notifyDescr = new NotifyDescriptor.Message(errMsg, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescr);
                        AddMessageHandlerDialogDesc.this.setClosingOptions(AddMessageHandlerDialogDesc.this.closingOptionsWithoutOK);
                    } else {
                        AddMessageHandlerDialogDesc.this.setClosingOptions(AddMessageHandlerDialogDesc.this.closingOptionsWithOK);
                    }
                }
            }
        }
    }
}

