/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui;

import java.awt.Image;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.ui.nodes.ComponentMethodModel;
import org.netbeans.modules.j2ee.common.ui.nodes.ComponentMethodViewStrategy;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class WebServiceChildren
extends ComponentMethodModel {
    private WebserviceDescription webServiceDescription;
    private FileObject srcRoot;

    public WebServiceChildren(WebserviceDescription webServiceDescription, FileObject srcRoot) {
        this.webServiceDescription = webServiceDescription;
        this.srcRoot = srcRoot;
    }

    public ComponentMethodViewStrategy createViewStrategy() {
        WSComponentMethodViewStrategy strategy = WSComponentMethodViewStrategy.instance();
        return strategy;
    }

    protected JavaClass getImplBean() {
        return this.getImplBeanClass(this.webServiceDescription);
    }

    protected Collection getInterfaces() {
        HashSet<JavaClass> set = new HashSet<JavaClass>();
        set.add(this.getServiceEndpointInterface(this.webServiceDescription));
        return set;
    }

    private JavaClass getServiceEndpointInterface(WebserviceDescription webServiceDescription) {
        PortComponent portComponent = webServiceDescription.getPortComponent(0);
        String sei = portComponent.getServiceEndpointInterface();
        if (sei != null) {
            sei = sei.trim();
        }
        return JMIUtils.findClass((String)sei);
    }

    private JavaClass getImplBeanClass(WebserviceDescription webServiceDescription) {
        WebServicesSupport wsSupport;
        String implBean;
        PortComponent portComponent = webServiceDescription.getPortComponent(0);
        ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
        String link = serviceImplBean.getServletLink();
        if (link == null) {
            link = serviceImplBean.getEjbLink();
        }
        if (link != null) {
            link = link.trim();
        }
        if ((implBean = (wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)this.srcRoot)).getImplementationBean(link)) != null) {
            return JMIUtils.findClass((String)implBean);
        }
        return null;
    }

    public static class WSComponentMethodViewStrategy
    implements ComponentMethodViewStrategy {
        private static WSComponentMethodViewStrategy wsmvStrategy;

        private WSComponentMethodViewStrategy() {
        }

        public static WSComponentMethodViewStrategy instance() {
            if (wsmvStrategy == null) {
                wsmvStrategy = new WSComponentMethodViewStrategy();
            }
            return wsmvStrategy;
        }

        public Image getBadge(Method method, Collection interfaces) {
            return null;
        }

        public void deleteImplMethod(Method m, JavaClass implClass, Collection interfaces) throws IOException {
            for (JavaClass intf : interfaces) {
                try {
                    intf.getContents().remove(m);
                }
                catch (JmiException e) {
                    throw new IOException(e.getMessage());
                }
            }
            Method[] methods = JMIUtils.getMethods((JavaClass)implClass);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!JMIUtils.equalMethods((Method)m, (Method)method)) continue;
                try {
                    implClass.getContents().remove(method);
                    break;
                }
                catch (JmiException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }

        public OpenCookie getOpenCookie(Method m, JavaClass implClass, Collection interfaces) {
            Method[] methods = JMIUtils.getMethods((JavaClass)implClass);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!JMIUtils.equalMethods((Method)m, (Method)method)) continue;
                return (OpenCookie)JMIUtils.getCookie((Feature)method, OpenCookie.class);
            }
            return null;
        }

        public Image getIcon(Method me, Collection interfaces) {
            return Utilities.loadImage((String)"org/openide/src/resources/methodPublic.gif");
        }
    }
}

