/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.j2ee.metadata.NNListener;
import org.netbeans.modules.j2ee.metadata.Utils;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NNModelBuilder
implements NNListener {
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance(NNModelBuilder.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(1);
    protected BaseBean ddRoot;
    private Collection supportedNNs;
    protected static final String JAVA_CLASS_REF = "$JAVACLASS";
    protected static final String JAVA_CLASS_SIMPLE_REF = "$JAVACLASS_SIMPLE";
    protected static final String MEMBER_NAME_REF = "$MEMBER";
    protected static final String MEMBER_CLASS_REF = "$MEMBERCLASS";
    protected static final String MEMBER_CLASS_SIMPLE_REF = "$MEMBERCLASS_SIMPLE";
    protected static final String JAVA_CLASS_MEMBERNAME_REF = "$JAVA_CLASS-MEMBER";
    protected static final String CUSTOM_ATTRIBUTE_MARKER = "<CUSTOM>";
    protected static final String ELEMENTS_DELIMITER = "/";
    protected static final String ATTRS_BLOCK_DELIMITER = "#";
    protected static final String ATTRS_DELIMITER = ";";
    protected static final String ATTRS_VALUE_DELIMITER = "=";
    protected static final String ATTR_MAPPING_MARKER = "!";
    protected static final String NEW_ATTR_MAPPING_MARKER = "*";
    protected static final String ATTRS_KEY_MARK = "$";
    protected static final String MAPPING_KEY_CONDITION_DELIMITER = "?";

    public NNModelBuilder(BaseBean ddRoot) {
        this.ddRoot = ddRoot;
    }

    protected abstract Map<String, String> getAnnotation2ModelMapping();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getSupportedAnnotations() {
        NNModelBuilder nNModelBuilder = this;
        synchronized (nNModelBuilder) {
            if (this.supportedNNs == null) {
                this.supportedNNs = this.getSupportedAnnotationsFromMapping();
            }
            return this.supportedNNs;
        }
    }

    @Override
    public void addClassAnnotation(JavaClass javaClass, Annotation annotation, AnnotationType t) {
        String annotationClass = t.getName();
        String javaClassName = javaClass.getName();
        Map attributes = Utils.getNNAttributes(annotation);
        this.addNNToModel(annotationClass, javaClassName, null, null, attributes, false);
    }

    @Override
    public void removeClassAnnotation(JavaClass javaClass, Annotation annotation, AnnotationType t) {
        String annotationClass = t.getName();
        String javaClassName = javaClass.getName();
        this.removeNNFromModel(annotationClass, javaClassName, null, null, null, false);
    }

    @Override
    public void addMemberAnnotation(boolean field, JavaClass javaClass, Element member, Annotation annotation, AnnotationType t) {
        String annotationClass = t.getName();
        String javaClassName = javaClass.getName();
        String memberName = ((NamedElement)member).getName();
        String memberType = ((TypedElement)member).getType().getName();
        Map attributes = Utils.getNNAttributes(annotation);
        this.addNNToModel(annotationClass, javaClassName, memberName, memberType, attributes, field);
    }

    @Override
    public void removeMemberAnnotation(boolean field, JavaClass javaClass, String memberName, String memberType, Annotation annotation, AnnotationType t) {
        String annotationClass = t.getName();
        String javaClassName = javaClass.getName();
        this.removeNNFromModel(annotationClass, javaClassName, memberName, memberType, null, field);
    }

    @Override
    public void addClassAttribute(JavaClass javaClass, Annotation annotation, AnnotationType t, String attributeName, String attributeValue) {
        String annotationClass = t.getName();
        String javaClassName = javaClass.getName();
        this.updateNNModelAttribute(annotationClass, javaClassName, null, null, attributeName, attributeValue);
    }

    @Override
    public void removeClassAttribute(JavaClass javaClass, Annotation annotation, AnnotationType t, String attributeName) {
        String annotationClass = t.getName();
        String javaClassName = javaClass.getName();
        this.updateNNModelAttribute(annotationClass, javaClassName, null, null, attributeName, null);
    }

    @Override
    public void addMemberAttribute(JavaClass javaClass, Element member, Annotation annotation, AnnotationType t, String attributeName, String attributeValue) {
        String annotationClass = t.getName();
        String javaClassName = javaClass.getName();
        String memberType = ((TypedElement)member).getType().getName();
        this.updateNNModelAttribute(annotationClass, javaClassName, ((NamedElement)member).getName(), memberType, attributeName, attributeValue);
    }

    @Override
    public void removeMemberAttribute(JavaClass javaClass, Element member, Annotation annotation, AnnotationType t, String attributeName) {
        String annotationClass = t.getName();
        String javaClassName = javaClass.getName();
        String memberType = ((TypedElement)member).getType().getName();
        this.updateNNModelAttribute(annotationClass, javaClassName, ((NamedElement)member).getName(), memberType, attributeName, null);
    }

    private void addNNToModel(String annotationName, String javaClass, String memberName, String memberClass, Map attributes, boolean field) {
        NNMappingTokenizer mt = null;
        try {
            mt = this.findMapping(annotationName, javaClass, memberName, memberClass);
            if (mt == null) {
                LOGGER.log(1, "No suitable mapping found for " + annotationName + " in java class " + javaClass + " for member " + memberName + " of type " + memberClass);
                return;
            }
            BaseBean parentBean = this.ddRoot;
            BaseBean firstNewBean = null;
            BaseBean firstNewBeanParent = null;
            String firstNewBeanName = null;
            Class firstNewBeanClass = null;
            while (mt.hasMoreElements()) {
                Object beanObj;
                String beanName;
                Class beanClass;
                NNMappingItem nnmi = mt.nextElement();
                if (nnmi.getRefAttrName() != null && nnmi.getAttrNamesMapping().containsValue(nnmi.getRefAttrName())) {
                    for (Object key : nnmi.getAttrNamesMapping().keySet()) {
                        String attrv;
                        String _key = (String)key;
                        String val = (String)nnmi.getAttrNamesMapping().get(_key);
                        if (!nnmi.getRefAttrName().equals(val) || (attrv = (String)attributes.get(_key)) == null) continue;
                        nnmi.setRefAttrValue(attrv);
                    }
                }
                if ((beanClass = NNModelBuilder.identifyBeanType(parentBean, beanName = nnmi.getName())) == null || String.class.isAssignableFrom(beanClass)) continue;
                BaseBean newBean = NNModelBuilder.createBean(parentBean, beanName, nnmi.getNewAttrNamesMapping());
                NNModelBuilder.setBeanProperties(newBean, nnmi.getAttrs(), Collections.EMPTY_MAP);
                if (nnmi.getRefAttrName() != null) {
                    NNModelBuilder.setBeanProperty(newBean, nnmi.getRefAttrName(), String.class, nnmi.getRefAttrValue(), Collections.EMPTY_MAP);
                }
                if (!mt.hasMoreElements()) {
                    NNModelBuilder.setBeanProperties(newBean, attributes, nnmi.getAttrNamesMapping());
                }
                if ((beanObj = NNModelBuilder.findBeans(parentBean, beanName)) != null && !(beanObj instanceof BaseBean) && !(beanObj instanceof BaseBean[])) {
                    throw new IllegalStateException("Found unsupported bean (not instanceof BaseBean or BaseBean[]; type=" + beanObj.getClass().getName());
                }
                if (!beanClass.isArray()) {
                    if (beanObj == null) {
                        if (mt.hasMoreElements() && nnmi.getRefAttrName() != null) {
                            LOGGER.log(1, "path element for " + nnmi.getName() + " is missing => skipping.");
                            return;
                        }
                        if (firstNewBean == null) {
                            firstNewBean = newBean;
                            firstNewBeanParent = parentBean;
                            firstNewBeanClass = beanClass;
                            firstNewBeanName = beanName;
                        } else {
                            NNModelBuilder.setBeanProperty(parentBean, beanName, beanClass, newBean, Collections.EMPTY_MAP);
                        }
                        parentBean = newBean;
                        continue;
                    }
                    parentBean = (BaseBean)beanObj;
                    if (mt.hasMoreElements()) continue;
                    NNModelBuilder.setBeanProperties((BaseBean)beanObj, attributes, nnmi.getAttrNamesMapping());
                    continue;
                }
                BaseBean[] beans = (BaseBean[])beanObj;
                if (beans == null || beans.length == 0) {
                    if (mt.hasMoreElements() && nnmi.getRefAttrName() != null) {
                        LOGGER.log(1, "path element for " + nnmi.getName() + " is missing => skipping.");
                        return;
                    }
                    if (firstNewBean == null) {
                        firstNewBean = newBean;
                        firstNewBeanParent = parentBean;
                        firstNewBeanClass = beanClass;
                        firstNewBeanName = beanName;
                    } else {
                        NNModelBuilder.addBeanArrayProperty(parentBean, beanName, beanClass.getComponentType(), newBean);
                    }
                    parentBean = newBean;
                    continue;
                }
                BaseBean matchingBean = this.findBeanInArray(beans, nnmi.getRefAttrName(), nnmi.getRefAttrValue());
                if (matchingBean != null) {
                    parentBean = matchingBean;
                    if (mt.hasMoreElements()) continue;
                    NNModelBuilder.setBeanProperties(matchingBean, attributes, nnmi.getAttrNamesMapping());
                    continue;
                }
                if (mt.hasMoreElements() && nnmi.getRefAttrName() != null) {
                    LOGGER.log(1, "path element for " + nnmi.getName() + " is missing => skipping.");
                    return;
                }
                if (firstNewBean == null) {
                    firstNewBean = newBean;
                    firstNewBeanParent = parentBean;
                    firstNewBeanClass = beanClass;
                    firstNewBeanName = beanName;
                } else {
                    NNModelBuilder.addBeanArrayProperty(parentBean, beanName, beanClass.getComponentType(), newBean);
                }
                parentBean = newBean;
            }
            if (firstNewBean != null) {
                if (firstNewBeanClass.isArray()) {
                    NNModelBuilder.addBeanArrayProperty(firstNewBeanParent, firstNewBeanName, firstNewBeanClass.getComponentType(), firstNewBean);
                } else {
                    NNModelBuilder.setBeanProperty(firstNewBeanParent, firstNewBeanName, firstNewBeanClass, firstNewBean, Collections.EMPTY_MAP);
                }
            }
            if (memberName == null) {
                LOGGER.log(1, "+++ added class annotation " + annotationName + " into class " + javaClass);
            } else {
                LOGGER.log(1, "+ added member annotation " + annotationName + " to member " + memberName + " in class " + javaClass);
            }
            if (LOG) {
                this.ddRoot.dumpXml();
            }
        }
        catch (Exception iae) {
            String eMsg = "NNModelBuilder.addNNToModel(): An error occured during processing annotation event ";
            eMsg = eMsg + "[annotation='" + annotationName + "', javaClass='" + javaClass + "', memberName='" + memberName + "', memberClass='" + memberClass + "', field?=" + field + "] ";
            eMsg = eMsg + (mt == null ? "(mapping not found)" : mt.toString());
            ErrorManager.getDefault().log(1, eMsg);
            ErrorManager.getDefault().notify(1, (Throwable)iae);
        }
    }

    private void updateNNModelAttribute(String annotationName, String javaClass, String memberName, String memberClass, String attributeName, String attributeValue) {
        NNMappingTokenizer mt = null;
        try {
            mt = this.findMapping(annotationName, javaClass, memberName, memberClass);
            if (mt == null) {
                LOGGER.log(1, "No suitable mapping found for " + annotationName + " in java class " + javaClass + " for member " + memberName + " of type " + memberClass);
                return;
            }
            BaseBean parentBean = this.ddRoot;
            while (mt.hasMoreElements()) {
                String beanName;
                Object beanObj;
                NNMappingItem nnmi = mt.nextElement();
                if (nnmi.getRefAttrName() != null) {
                    for (Object key : nnmi.getAttrNamesMapping().keySet()) {
                        String _key = (String)key;
                        String val = (String)nnmi.getAttrNamesMapping().get(_key);
                        if (!nnmi.getRefAttrName().equals(val) || !attributeName.equals(_key) || attributeValue == null) continue;
                        nnmi.setRefAttrValue(attributeValue);
                    }
                }
                if ((beanObj = NNModelBuilder.findBeans(parentBean, beanName = nnmi.getName())) == null) continue;
                if (beanObj instanceof BaseBean[]) {
                    BaseBean[] beans = (BaseBean[])beanObj;
                    BaseBean matchingBean = null;
                    if (beans == null || beans.length <= 0) continue;
                    matchingBean = this.findBeanInArray(beans, nnmi.getRefAttrName(), nnmi.getRefAttrValue());
                    if (matchingBean == null) break;
                    if (mt.hasMoreElements()) {
                        parentBean = matchingBean;
                        continue;
                    }
                    NNModelBuilder.setBeanProperty(matchingBean, attributeName, String.class, attributeValue, nnmi.getAttrNamesMapping());
                    continue;
                }
                if (!(beanObj instanceof BaseBean)) continue;
                if (mt.hasMoreElements()) {
                    parentBean = (BaseBean)beanObj;
                    continue;
                }
                NNModelBuilder.setBeanProperty((BaseBean)beanObj, attributeName, String.class, attributeValue, nnmi.getAttrNamesMapping());
            }
            if (memberName == null) {
                LOGGER.log(1, "* set attribute " + attributeName + " to value '" + attributeValue + "' of class annotation " + annotationName + " from class " + javaClass);
            } else {
                LOGGER.log(1, "* set attribute " + attributeName + " to value '" + attributeValue + "' of member annotation " + annotationName + " for member " + memberName + " from class " + javaClass);
            }
            if (LOG) {
                this.ddRoot.dumpXml();
            }
        }
        catch (Exception iae) {
            String eMsg = "NNModelBuilder.updateNNModelAttribute(): An error occured during processing annotation event ";
            eMsg = eMsg + "[annotation='" + annotationName + "', javaClass='" + javaClass + "', memberName='" + memberName + "', memberClass='" + memberClass + "', attributeName='" + attributeName + "', attributeValue='" + attributeValue + "'] ";
            eMsg = eMsg + (mt == null ? "(mapping not found)" : mt.toString());
            ErrorManager.getDefault().log(1, eMsg);
            ErrorManager.getDefault().notify(1, (Throwable)iae);
        }
    }

    private void removeNNFromModel(String annotationName, String javaClass, String memberName, String memberClass, Map attributes, boolean field) {
        NNMappingTokenizer mt = null;
        try {
            mt = this.findMapping(annotationName, javaClass, memberName, memberClass);
            if (mt == null) {
                LOGGER.log(1, "No suitable mapping found for " + annotationName + " in java class " + javaClass + " for member " + memberName + " of type " + memberClass);
                return;
            }
            BaseBean parentBean = this.ddRoot;
            while (mt.hasMoreElements()) {
                NNMappingItem nnmi = mt.nextElement();
                String beanName = nnmi.getName();
                Object beanObj = NNModelBuilder.findBeans(parentBean, beanName);
                if (beanObj != null) {
                    if (beanObj instanceof BaseBean[]) {
                        BaseBean[] beans = (BaseBean[])beanObj;
                        BaseBean matchingBean = null;
                        if (beans != null && beans.length > 0) {
                            matchingBean = this.findBeanInArray(beans, nnmi.getRefAttrName(), nnmi.getRefAttrValue());
                            if (matchingBean != null) {
                                if (mt.hasMoreElements()) {
                                    parentBean = matchingBean;
                                    continue;
                                }
                                Class<?> beanClass = NNModelBuilder.identifyBeanType(parentBean, beanName);
                                if (beanClass.isArray()) {
                                    beanClass = beanClass.getComponentType();
                                }
                                NNModelBuilder.removeBeanArrayProperty(parentBean, beanName, matchingBean, beanClass);
                                continue;
                            }
                            LOGGER.log(1, "path element " + beanName + " not found -> ignoring.");
                            return;
                        }
                        LOGGER.log(1, "path element " + beanName + " not found -> ignoring.");
                        return;
                    }
                    if (beanObj instanceof BaseBean) {
                        if (mt.hasMoreElements()) {
                            parentBean = (BaseBean)beanObj;
                            continue;
                        }
                        Class<?> beanClass = NNModelBuilder.identifyBeanType(parentBean, beanName);
                        if (beanClass.isArray()) {
                            beanClass = beanClass.getComponentType();
                        }
                        NNModelBuilder.nullizeBeanProperty(parentBean, beanName, beanClass);
                        continue;
                    }
                    if (!(beanObj instanceof String)) continue;
                    NNModelBuilder.nullizeBeanProperty(parentBean, beanName, String.class);
                    continue;
                }
                LOGGER.log(1, "path element " + beanName + " not found -> ignoring.");
                return;
            }
            if (memberName == null) {
                LOGGER.log(1, "--- removed class annotation " + annotationName + " from class " + javaClass);
            } else {
                LOGGER.log(1, "- removed member annotation " + annotationName + " from member " + memberName + " in class " + javaClass);
            }
            if (LOG) {
                this.ddRoot.dumpXml();
            }
        }
        catch (Exception iae) {
            String eMsg = "NNModelBuilder.removeNNFromModel(): An error occured during processing annotation event ";
            eMsg = eMsg + "[annotation='" + annotationName + "', javaClass='" + javaClass + "', memberName='" + memberName + "', memberClass='" + memberClass + "', field?=" + field + "] ";
            eMsg = eMsg + (mt == null ? "(mapping not found)" : mt.toString());
            ErrorManager.getDefault().log(1, eMsg);
            ErrorManager.getDefault().notify(1, (Throwable)iae);
        }
    }

    private boolean verifyModelMapping(NNMappingTokenizer mt) {
        NNMappingItem nnmi;
        String beanName;
        Object beanObj;
        BaseBean parentBean = this.ddRoot;
        while (mt.hasMoreElements() && (beanObj = NNModelBuilder.findBeans(parentBean, beanName = (nnmi = mt.nextElement()).getName())) != null) {
            if (beanObj instanceof BaseBean[]) {
                BaseBean[] beans = (BaseBean[])beanObj;
                BaseBean matchingBean = null;
                if (beans == null || beans.length <= 0) continue;
                matchingBean = this.findBeanInArray(beans, nnmi.getRefAttrName(), nnmi.getRefAttrValue());
                if (matchingBean != null) {
                    if (mt.hasMoreElements()) {
                        parentBean = matchingBean;
                        continue;
                    }
                    return true;
                }
                return false;
            }
            if (!(beanObj instanceof BaseBean)) continue;
            if (mt.hasMoreElements()) {
                parentBean = (BaseBean)beanObj;
                continue;
            }
            return true;
        }
        return false;
    }

    private BaseBean findBeanInArray(BaseBean[] beans, String refAttrName, String refAttrValue) {
        if (refAttrName == null || refAttrValue == null) {
            String msg = "Looking for bean in array of BaseBeans[";
            for (BaseBean bb : beans) {
                msg = msg + bb.toString();
                msg = msg + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = msg + "]: arguments (refAttrName = " + refAttrName + ", refAttrValue = " + refAttrValue + " cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < beans.length; ++i) {
            String value;
            BaseBean b = beans[i];
            if (!NNModelBuilder.hasProperty(b, refAttrName) || !refAttrValue.equals(value = (String)NNModelBuilder.findBeans(b, refAttrName))) continue;
            return b;
        }
        return null;
    }

    private static void setBeanProperties(BaseBean bean, Map attributes, Map attrNamesMap) {
        Class<?> c = bean.getClass();
        Method setter = null;
        try {
            for (String attrName : attributes.keySet()) {
                String attrValue = (String)attributes.get(attrName);
                if (attrNamesMap.containsKey(attrName) && CUSTOM_ATTRIBUTE_MARKER.equals(attrName = (String)attrNamesMap.get(attrName))) continue;
                setter = c.getMethod("set" + NNModelBuilder.propertize(attrName), String.class);
                setter.invoke((Object)bean, attrValue);
            }
        }
        catch (NoSuchMethodException nsme) {
            if (LOG) {
                throw new IllegalStateException("The '" + bean + "' property doesn't exist", nsme);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot set attributes of bean " + bean, e);
        }
    }

    private static void addBeanArrayProperty(BaseBean bean, String propertyName, Class valueType, Object value) {
        Class<?> c = bean.getClass();
        try {
            Method setter = c.getMethod("add" + NNModelBuilder.propertize(propertyName), valueType);
            setter.invoke((Object)bean, value);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException("The bean property doesn't exist!", nsme);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot call add method for " + propertyName + " of bean " + bean + " to value " + value, e);
        }
    }

    private static void removeBeanArrayProperty(BaseBean bean, String propertyName, BaseBean itemToRemove, Class itemToRemoveType) {
        Class<?> c = bean.getClass();
        try {
            Method setter = c.getMethod("remove" + NNModelBuilder.propertize(propertyName), itemToRemoveType);
            setter.invoke((Object)bean, itemToRemove);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot call remove method for " + propertyName + " of bean " + bean + " to value " + itemToRemove, e);
        }
    }

    private static void nullizeBeanProperty(BaseBean bean, String propertyName, Class propertyType) {
        Class<?> c = bean.getClass();
        try {
            Method setter = c.getMethod("set" + NNModelBuilder.propertize(propertyName), propertyType);
            setter.invoke((Object)bean, new Object[]{null});
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot nullize property " + propertyName + " of bean " + bean, e);
        }
    }

    private static void setBeanProperty(BaseBean bean, String propertyName, Class valueType, Object value, Map attrNamesMap) {
        Class<?> c = bean.getClass();
        Method setter = null;
        try {
            if (attrNamesMap.containsKey(propertyName)) {
                propertyName = (String)attrNamesMap.get(propertyName);
            }
            propertyName = NNModelBuilder.propertize(propertyName);
            setter = c.getMethod("set" + NNModelBuilder.propertize(propertyName), valueType);
            setter.invoke((Object)bean, value);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException("The bean property doesn't exist (bean=" + bean + ")", nsme);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot set property " + propertyName + " of bean " + bean + " to value " + value, e);
        }
    }

    private static BaseBean createBean(BaseBean parent, String beanName, Map newAttrsNamesMap) {
        Class<?> c = parent.getClass();
        try {
            Method getter;
            Object result;
            if (newAttrsNamesMap.containsKey(beanName)) {
                beanName = (String)newAttrsNamesMap.get(beanName);
            }
            if ((result = (getter = c.getMethod("new" + NNModelBuilder.propertize(beanName), new Class[0])).invoke((Object)parent, new Object[0])) != null && result instanceof BaseBean) {
                return (BaseBean)result;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("parent = " + parent + ", beanProperty = " + beanName, e);
        }
    }

    private static boolean hasProperty(BaseBean bean, String propertyName) {
        try {
            Class<?> c = bean.getClass();
            Method getter = c.getMethod("get" + NNModelBuilder.propertize(propertyName), new Class[0]);
            return true;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot test presence of property " + propertyName + " of bean " + bean, e);
        }
    }

    private static Object findBeans(BaseBean parent, String beanProperty) {
        Class<?> c = parent.getClass();
        try {
            Method getter = c.getMethod("get" + NNModelBuilder.propertize(beanProperty), new Class[0]);
            return getter.invoke((Object)parent, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("parent = " + parent + ", beanProperty = " + beanProperty, e);
        }
    }

    private static Class identifyBeanType(BaseBean bean, String beanProperty) {
        Class<?> c = bean.getClass();
        try {
            Method getter = c.getMethod("get" + NNModelBuilder.propertize(beanProperty), new Class[0]);
            return getter.getReturnType();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot identify type of " + beanProperty + " of bean " + bean, e);
        }
    }

    private static BaseBean findBeanByName(BaseBean parent, String beanProperty, String nameProperty, String value) {
        BaseBean[] beans = (BaseBean[])NNModelBuilder.findBeans(parent, beanProperty);
        try {
            for (int i = 0; i < beans.length; ++i) {
                Class<?> c1 = beans[i].getClass();
                Method getter1 = c1.getMethod("get" + NNModelBuilder.propertize(nameProperty), new Class[0]);
                Object result1 = getter1.invoke((Object)beans[i], new Object[0]);
                if (!(result1 instanceof String) || !value.equals((String)result1)) continue;
                return beans[i];
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("parent = " + parent + ", beanProperty = " + beanProperty + ", nameProperty = " + nameProperty + ", value = " + value, e);
        }
    }

    private static String propertize(String propertyName) {
        return Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private NNMappingTokenizer findMapping(String annotationName, String javaClassName, String memberName, String memberClass) {
        for (String mkey : this.getAnnotation2ModelMapping().keySet()) {
            NNMappingKeyParser nnmkp = new NNMappingKeyParser(mkey);
            if (!nnmkp.getAnnotationName().equals(annotationName)) continue;
            List<String> conditionsList = nnmkp.getMappingConditions();
            if (!conditionsList.isEmpty()) {
                Iterator<String> condsItr = conditionsList.iterator();
                boolean allConditionsPasses = true;
                while (condsItr.hasNext()) {
                    String condition = condsItr.next();
                    boolean pass = this.verifyModelMapping(new NNMappingTokenizer(condition, javaClassName, memberName, memberClass));
                    if (pass) continue;
                    allConditionsPasses = false;
                    break;
                }
                if (!allConditionsPasses) continue;
            }
            boolean passes = true;
            String javaCR = nnmkp.getPropertyValue(JAVA_CLASS_REF);
            String memberCR = nnmkp.getPropertyValue(MEMBER_CLASS_REF);
            String mappingValue = this.getAnnotation2ModelMapping().get(mkey);
            if (javaCR != null && !javaCR.equals(javaClassName)) {
                passes = false;
            }
            if (memberCR != null && !memberCR.equals(memberClass)) {
                passes = false;
            }
            String javaCRsimple = nnmkp.getPropertyValue(JAVA_CLASS_SIMPLE_REF);
            String memberCRsimple = nnmkp.getPropertyValue(MEMBER_CLASS_SIMPLE_REF);
            if (javaCRsimple != null && !javaCRsimple.equals(this.getSimpleClassName(javaClassName))) {
                passes = false;
            }
            if (memberCRsimple != null && !memberCR.equals(this.getSimpleClassName(memberClass))) {
                passes = false;
            }
            if (!passes) continue;
            return new NNMappingTokenizer(mappingValue, javaClassName, memberName, memberClass);
        }
        return null;
    }

    private String getSimpleClassName(String fullyQualifiedClassName) {
        int lastDotIndex = fullyQualifiedClassName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            return fullyQualifiedClassName.substring(lastDotIndex + 1);
        }
        return fullyQualifiedClassName;
    }

    private Collection getSupportedAnnotationsFromMapping() {
        Iterator<String> mappingKeys = this.getAnnotation2ModelMapping().keySet().iterator();
        HashSet<String> supportedNNs = new HashSet<String>();
        while (mappingKeys.hasNext()) {
            String mkey = mappingKeys.next();
            NNMappingKeyParser nnmkp = new NNMappingKeyParser(mkey);
            supportedNNs.add(nnmkp.getAnnotationName());
        }
        return Collections.unmodifiableCollection(supportedNNs);
    }

    private class NNMappingItem {
        private String name;
        private String refAttrName;
        private String refAttrValue;
        private Map attrs;
        private Map attrNamesMapping;
        private Map newAttrNamesMapping;

        public NNMappingItem(String name, String refAttrName, String refAttrValue, Map attrs, Map attrNamesMapping, Map newAttrNamesMapping) {
            this.name = name;
            this.attrs = attrs;
            this.refAttrName = refAttrName;
            this.refAttrValue = refAttrValue;
            this.attrNamesMapping = attrNamesMapping;
            this.newAttrNamesMapping = newAttrNamesMapping;
        }

        public String getName() {
            return this.name;
        }

        public Map getAttrs() {
            return this.attrs;
        }

        public Map getAttrNamesMapping() {
            return this.attrNamesMapping;
        }

        public Map getNewAttrNamesMapping() {
            return this.newAttrNamesMapping;
        }

        public String getRefAttrName() {
            return this.refAttrName;
        }

        public String getRefAttrValue() {
            return this.refAttrValue;
        }

        public void setRefAttrValue(String val) {
            this.refAttrValue = val;
        }

        public String toString() {
            return "NNMappingItem(name=" + this.getName() + "; refAttrName=" + this.getRefAttrName() + "; refAttrValue=" + this.getRefAttrValue() + ")";
        }
    }

    private class NNMappingTokenizer {
        private String mapping;
        private StringTokenizer baseTokenizer;
        private String javaClassName;
        private String memberName;
        private String memberClass;

        public NNMappingTokenizer(String mapping, String javaClassName, String memberName, String memberClass) {
            this.mapping = mapping;
            this.javaClassName = javaClassName;
            this.memberName = memberName;
            this.baseTokenizer = new StringTokenizer(mapping, NNModelBuilder.ELEMENTS_DELIMITER);
            this.memberClass = memberClass;
        }

        public boolean hasMoreElements() {
            return this.baseTokenizer.hasMoreTokens();
        }

        public NNMappingItem nextElement() {
            if (this.hasMoreElements()) {
                String element = this.baseTokenizer.nextToken();
                StringTokenizer attrsBlockTokenizer = new StringTokenizer(element, NNModelBuilder.ATTRS_BLOCK_DELIMITER);
                HashMap<String, String> attrsMap = new HashMap<String, String>();
                HashMap<String, String> attrNamesMapping = new HashMap<String, String>();
                HashMap<String, String> newAttrNamesMapping = new HashMap<String, String>();
                String elementName = attrsBlockTokenizer.nextToken();
                String refName = null;
                String refValue = null;
                if (attrsBlockTokenizer.hasMoreTokens()) {
                    String attrpair = attrsBlockTokenizer.nextToken();
                    StringTokenizer attrsTokenizer = new StringTokenizer(attrpair, NNModelBuilder.ATTRS_DELIMITER);
                    while (attrsTokenizer.hasMoreTokens()) {
                        String attrNameValue = attrsTokenizer.nextToken();
                        StringTokenizer nameValueTokenizer = new StringTokenizer(attrNameValue, NNModelBuilder.ATTRS_VALUE_DELIMITER);
                        String name = nameValueTokenizer.nextToken();
                        String value = nameValueTokenizer.nextToken();
                        if (NNModelBuilder.MEMBER_CLASS_SIMPLE_REF.equals(value)) {
                            refName = name;
                            refValue = value = NNModelBuilder.this.getSimpleClassName(this.memberClass);
                            continue;
                        }
                        if (NNModelBuilder.MEMBER_CLASS_REF.equals(value)) {
                            refName = name;
                            refValue = value = this.memberClass;
                            continue;
                        }
                        if (NNModelBuilder.JAVA_CLASS_REF.equals(value)) {
                            refName = name;
                            refValue = this.javaClassName;
                            continue;
                        }
                        if (NNModelBuilder.JAVA_CLASS_SIMPLE_REF.equals(value)) {
                            refName = name;
                            refValue = NNModelBuilder.this.getSimpleClassName(this.javaClassName);
                            continue;
                        }
                        if (NNModelBuilder.MEMBER_NAME_REF.equals(value)) {
                            refName = name;
                            refValue = this.memberName;
                            continue;
                        }
                        if (NNModelBuilder.JAVA_CLASS_MEMBERNAME_REF.equals(value)) {
                            refName = name;
                            refValue = value = this.javaClassName + NNModelBuilder.ELEMENTS_DELIMITER + this.memberName;
                            continue;
                        }
                        if (name.startsWith(NNModelBuilder.ATTR_MAPPING_MARKER)) {
                            attrNamesMapping.put(name.substring(1), value);
                            continue;
                        }
                        if (name.startsWith(NNModelBuilder.NEW_ATTR_MAPPING_MARKER)) {
                            newAttrNamesMapping.put(name.substring(1), value);
                            continue;
                        }
                        attrsMap.put(name, value);
                    }
                }
                return new NNMappingItem(elementName, refName, refValue, attrsMap, attrNamesMapping, newAttrNamesMapping);
            }
            return null;
        }

        public String toString() {
            return "NNMappingTokenizer[mapping=" + this.mapping + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NNMappingKeyParser {
        private String nnmkey;
        private String nnname = null;
        private HashMap<String, String> properties = new HashMap();
        private ArrayList<String> mappingConditions = null;

        public NNMappingKeyParser(String nnmkey) {
            this.parse(nnmkey);
        }

        public String getAnnotationName() {
            return this.nnname;
        }

        public List<String> getMappingConditions() {
            return this.mappingConditions;
        }

        public String getPropertyValue(String propertyName) {
            return this.properties.get(propertyName);
        }

        private void parse(String nnmk) {
            StringTokenizer condt = new StringTokenizer(nnmk, NNModelBuilder.MAPPING_KEY_CONDITION_DELIMITER);
            this.mappingConditions = new ArrayList();
            String firstPart = null;
            while (condt.hasMoreTokens()) {
                if (firstPart != null) {
                    this.mappingConditions.add(condt.nextToken());
                    continue;
                }
                firstPart = condt.nextToken();
            }
            StringTokenizer nnparam = new StringTokenizer(firstPart, NNModelBuilder.ATTRS_BLOCK_DELIMITER);
            while (nnparam.hasMoreTokens()) {
                if (this.nnname == null) {
                    this.nnname = nnparam.nextToken();
                    continue;
                }
                StringTokenizer params = new StringTokenizer(nnparam.nextToken(), NNModelBuilder.ATTRS_DELIMITER);
                while (params.hasMoreTokens()) {
                    String parampair = params.nextToken();
                    int idx = parampair.indexOf(NNModelBuilder.ATTRS_VALUE_DELIMITER);
                    if (idx != -1) {
                        String key = parampair.substring(0, idx);
                        String value = parampair.substring(idx + 1);
                        if (!key.startsWith(NNModelBuilder.ATTRS_KEY_MARK)) {
                            key = NNModelBuilder.ATTRS_KEY_MARK + key;
                        }
                        this.properties.put(key, value);
                        continue;
                    }
                    throw new IllegalStateException("Bad mapping key: " + this.nnmkey);
                }
            }
            if (this.nnname == null) {
                throw new IllegalStateException("Bad mapping key: " + this.nnmkey);
            }
        }
    }
}

