/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.dev.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.netbeans.modules.websvc.dev.wizard.NodeDisplayPanel;
import org.netbeans.modules.websvc.dev.wizard.nodes.PortNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;

public class PortChooser
extends JPanel {
    public static final String IS_VALID = "portChooser_isValid";
    private NodeAcceptor nodeAcceptor;
    private NodeDisplayPanel nodeDisplayPanel;
    private JLabel jLabelDesc;
    private JLabel jLabelError;
    private JPanel jPanelBeanTree;

    public PortChooser(Node root) {
        this.initComponents();
        this.nodeAcceptor = new NodeAcceptorImpl();
        this.nodeDisplayPanel = new NodeDisplayPanel(root);
        this.nodeDisplayPanel.setBorder(new EtchedBorder());
        this.jPanelBeanTree.add(this.nodeDisplayPanel);
        this.nodeDisplayPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                Node[] nodes = PortChooser.this.nodeDisplayPanel.getSelectedNodes();
                PortChooser.this.validateNodes();
            }
        });
        this.validateNodes();
    }

    private void validateNodes() {
        boolean nodeAccepted = this.nodeAcceptor.acceptNodes(this.nodeDisplayPanel.getSelectedNodes());
        if (!nodeAccepted) {
            this.firePropertyChange(IS_VALID, Boolean.TRUE, Boolean.FALSE);
        } else {
            this.firePropertyChange(IS_VALID, Boolean.FALSE, Boolean.TRUE);
        }
    }

    private void setErrorMessage(String message) {
        if (message == null) {
            message = " ";
        }
        this.jLabelError.setText(message);
    }

    public Node[] getSelectedNodes() {
        return this.nodeDisplayPanel.getSelectedNodes();
    }

    public String getSelectedPortOwnerName() {
        return this.nodeDisplayPanel.getSelectedNodes()[0].getParentNode().getDisplayName();
    }

    private void initComponents() {
        this.jLabelDesc = new JLabel();
        this.jPanelBeanTree = new JPanel();
        this.jLabelError = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabelDesc.setDisplayedMnemonic(NbBundle.getMessage(PortChooser.class, (String)"MNE_SelectBeanDescription").charAt(0));
        this.jLabelDesc.setLabelFor(this.jPanelBeanTree);
        this.jLabelDesc.setText(NbBundle.getMessage(PortChooser.class, (String)"LBL_SelectPortDescription"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLabelDesc, gridBagConstraints);
        this.jLabelDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PortChooser.class, (String)"LBL_SelectPortDescription"));
        this.jPanelBeanTree.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        this.add((Component)this.jPanelBeanTree, gridBagConstraints);
        this.jPanelBeanTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PortChooser.class, (String)"A11Y_PortTree_Name"));
        this.jPanelBeanTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PortChooser.class, (String)"A11Y_PortTree_Name"));
        this.jLabelError.setForeground(new Color(255, 0, 0));
        this.jLabelError.setLabelFor(this.jPanelBeanTree);
        this.jLabelError.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this.add((Component)this.jLabelError, gridBagConstraints);
        this.jLabelError.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PortChooser.class, (String)"A11Y_PortTreeError_Name"));
        this.jLabelError.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PortChooser.class, (String)"A11Y_PortTreeError_Name"));
    }

    private class NodeAcceptorImpl
    implements NodeAcceptor {
        private NodeAcceptorImpl() {
        }

        public boolean acceptNodes(Node[] nodes) {
            PortChooser.this.setErrorMessage(" ");
            if (nodes.length == 0) {
                PortChooser.this.setErrorMessage(NbBundle.getMessage(PortChooser.class, (String)"LBL_SelectOnePort"));
                return false;
            }
            PortNode port = (PortNode)((Object)nodes[0].getLookup().lookup(PortNode.class));
            if (port == null) {
                PortChooser.this.setErrorMessage(NbBundle.getMessage(PortChooser.class, (String)"LBL_NodeIsNotPort"));
                return false;
            }
            return true;
        }
    }
}

