/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.diff;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.text.syntax.XMLKit;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.diff.Change;
import org.netbeans.modules.xml.xdm.diff.DiffFinder;
import org.netbeans.modules.xml.xdm.diff.Difference;
import org.netbeans.modules.xml.xdm.diff.XDMTreeDiff;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.visitor.PositionFinderVisitor;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XDMUtil {
    public static final String NS_PREFIX = "xmlns";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    public static final String XML_PROLOG = "<?xml version=\"1.0\"?>\n";

    public String prettyPrintXML(String doc, String indentation) throws UnsupportedEncodingException, IOException, BadLocationException {
        BaseDocument sd1 = new BaseDocument(XMLKit.class, false);
        XDMModel m1 = this.createXDMModel((javax.swing.text.Document)sd1, doc);
        Document root1 = m1.getDocument();
        BaseDocument sd2 = new BaseDocument(XMLKit.class, false);
        XDMModel m2 = this.createXDMModel((javax.swing.text.Document)sd2);
        m2.setPretty(true);
        m2.setIndentation(indentation);
        m2.sync();
        Node root2 = m2.getDocument();
        root2 = this.doPrettyPrint(m2, root2, root1);
        m2.flush();
        String prettyXMLStr = sd2.getText(0, sd2.getLength());
        int firstChildPos1 = -1;
        Node firstChild1 = (Node)root1.getChildNodes().item(0);
        if (firstChild1 != null) {
            firstChildPos1 = new PositionFinderVisitor().findPosition(m1.getDocument(), firstChild1);
        }
        int firstChildPos2 = -1;
        Node firstChild2 = (Node)root2.getChildNodes().item(0);
        if (firstChild2 != null) {
            firstChildPos2 = new PositionFinderVisitor().findPosition(m2.getDocument(), firstChild2);
        }
        return firstChildPos1 == -1 ? doc : sd1.getText(0, firstChildPos1) + sd2.getText(firstChildPos2, sd2.getLength() - firstChildPos2);
    }

    public List<Difference> compareXML(String xml1, String xml2, ComparisonCriteria criteria) throws Exception {
        XDMUtil util = new XDMUtil();
        List<Difference> diffs = this.compareXML(xml1, xml2, criteria, true);
        XDMUtil.filterNSAttrDiffs(diffs);
        XDMUtil.filterNSPrefixDiffs(diffs);
        XDMUtil.filterAttrWhitespaceDiffs(diffs);
        return diffs;
    }

    public List<Difference> compareXML(String firstDoc, String secondDoc, ComparisonCriteria type, boolean filterWhiteSpace) throws BadLocationException, IOException {
        BaseDocument sd1 = new BaseDocument(XMLKit.class, false);
        XDMModel m1 = this.createXDMModel((javax.swing.text.Document)sd1);
        sd1.remove(0, XML_PROLOG.length());
        sd1.insertString(0, firstDoc, null);
        m1.sync();
        BaseDocument sd2 = new BaseDocument(XMLKit.class, false);
        sd2.getText(0, sd2.getLength());
        XDMModel m2 = this.createXDMModel((javax.swing.text.Document)sd2);
        sd2.remove(0, XML_PROLOG.length());
        sd2.insertString(0, secondDoc, null);
        m2.setPretty(true);
        m2.sync();
        XDMTreeDiff dif = new XDMTreeDiff(m1.getElementIdentity());
        List<Difference> diffs = dif.performDiff(m1.getDocument(), m2.getDocument());
        if (filterWhiteSpace) {
            diffs = XDMUtil.filterWhitespace(diffs);
        }
        if (type == ComparisonCriteria.EQUAL) {
            ArrayList<Difference> filteredDiffs = new ArrayList<Difference>();
            for (Difference d : diffs) {
                Change c;
                if (!(d instanceof Change) || (c = (Change)d).isPositionChanged() && !c.isTokenChanged() && !c.isAttributeChanged()) continue;
                if (c.isAttributeChanged() && !c.isTokenChanged()) {
                    int i;
                    ArrayList<Change.AttributeChange> removeList = new ArrayList<Change.AttributeChange>();
                    List<Change.AttributeDiff> attrChanges = c.getAttrChanges();
                    for (i = 0; i < attrChanges.size(); ++i) {
                        Change.AttributeChange ac;
                        if (!(attrChanges.get(i) instanceof Change.AttributeChange) || !(ac = (Change.AttributeChange)attrChanges.get(i)).isPositionChanged() || ac.isTokenChanged()) continue;
                        removeList.add(ac);
                    }
                    for (i = 0; i < removeList.size(); ++i) {
                        c.removeAttrChanges((Change.AttributeDiff)removeList.get(i));
                    }
                    if (c.getAttrChanges().size() == 0) continue;
                }
                filteredDiffs.add(d);
            }
            return filteredDiffs;
        }
        return diffs;
    }

    private XDMModel createXDMModel(javax.swing.text.Document sd) throws BadLocationException, IOException {
        return this.createXDMModel(sd, "");
    }

    private XDMModel createXDMModel(javax.swing.text.Document sd, String content) throws BadLocationException, IOException {
        boolean foundXMLProlog = true;
        if (content.indexOf("<?xml") == -1) {
            sd.insertString(0, XML_PROLOG + content, null);
        } else {
            sd.insertString(0, content, null);
        }
        Lookup lookup = Lookups.singleton((Object)sd);
        ModelSource ms = new ModelSource(lookup, true);
        XDMModel model = new XDMModel(ms);
        model.sync();
        return model;
    }

    private Node doPrettyPrint(XDMModel m2, Node n2, Node n1) {
        Node newNode = null;
        NodeList childs1 = n1.getChildNodes();
        int count = 0;
        for (int i = 0; i < childs1.getLength(); ++i) {
            n1 = (NodeImpl)childs1.item(i);
            newNode = ((NodeImpl)n1).copy();
            List<Node> ancestors = m2.add(n2, newNode, count++);
            n2 = ancestors.get(0);
        }
        ArrayList<Node> ancestors = new ArrayList<Node>();
        this.fixPrettyText(m2, n2, ancestors);
        n2 = (Node)ancestors.get(0);
        return n2;
    }

    private void fixPrettyText(XDMModel m, Node n, List<Node> ancestors) {
        int i;
        Node parent = n;
        int index = m.getIndentation().length();
        NodeList childs = parent.getChildNodes();
        ArrayList<Node> visitList = new ArrayList<Node>();
        for (i = 0; i < childs.getLength(); ++i) {
            Node child = (Node)childs.item(i);
            if (XDMUtil.checkPrettyText(child)) {
                Text txt = (Text)((NodeImpl)child).cloneNode(true);
                if (txt.getText().length() >= index + 1) {
                    txt.setText("\n" + txt.getText().substring(index + 1));
                }
                List<Node> ancestors2 = m.modify(child, txt);
                parent = ancestors2.get(0);
                continue;
            }
            if (!(childs.item(i) instanceof Element)) continue;
            visitList.add((Node)childs.item(i));
        }
        ancestors.add(parent);
        for (i = 0; i < visitList.size(); ++i) {
            this.fixPrettyText(m, (Node)visitList.get(i), ancestors);
        }
        visitList.clear();
    }

    public static boolean checkPrettyText(Node txt) {
        return txt instanceof Text && ((NodeImpl)txt).getTokens().size() == 1 && XDMUtil.isWhitespaceOnly(((NodeImpl)txt).getTokens().get(0).getValue());
    }

    public static boolean isPossibleWhiteSpace(String text) {
        return text.length() > 0 && Character.isWhitespace(text.charAt(0)) && Character.isWhitespace(text.charAt(text.length() - 1));
    }

    public static boolean isWhitespaceOnly(String tn) {
        return XDMUtil.isPossibleWhiteSpace(tn) && tn.trim().length() == 0;
    }

    public static int findPosition(Node n) {
        return new PositionFinderVisitor().findPosition((Node)((Object)n.getOwnerDocument()), n);
    }

    public static List<Difference> filterWhitespace(List<Difference> diffs) {
        return DiffFinder.filterWhitespace(diffs);
    }

    public static void filterAttributeOrderChange(List<Difference> diffs) {
        ArrayList<Difference> removeDiffs = new ArrayList<Difference>();
        for (Difference dif : diffs) {
            Change c;
            if (!(dif instanceof Change) || !(c = (Change)dif).isAttributeChanged() || c.isPositionChanged() || c.isTokenChanged()) continue;
            List<Change.AttributeDiff> attrdiffs = c.getAttrChanges();
            int size = attrdiffs.size();
            ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
            for (Change.AttributeDiff attrdif : attrdiffs) {
                Change.AttributeChange attrChange;
                if (!(attrdif instanceof Change.AttributeChange) || !(attrChange = (Change.AttributeChange)attrdif).isPositionChanged() || attrChange.isTokenChanged()) continue;
                removeAttrs.add(attrdif);
            }
            for (Change.AttributeDiff attrdif : removeAttrs) {
                c.removeAttrChanges(attrdif);
            }
            if (size <= 0 || c.getAttrChanges().size() != 0) continue;
            removeDiffs.add(dif);
        }
        for (Difference dif : removeDiffs) {
            diffs.remove(dif);
        }
    }

    public static void filterNSAttrDiffs(List<Difference> diffs) {
        ArrayList<Difference> removeDiffs = new ArrayList<Difference>();
        for (Difference dif : diffs) {
            Change c;
            if (!(dif instanceof Change) || !(c = (Change)dif).isAttributeChanged() || c.isPositionChanged() || c.isTokenChanged() || !XDMUtil.removeNSAttrDiffs(c) && !XDMUtil.removeSchemaLocationAttrDiffs(c)) continue;
            removeDiffs.add(dif);
        }
        for (Difference dif : removeDiffs) {
            diffs.remove(dif);
        }
    }

    public static void filterNSPrefixDiffs(List<Difference> diffs) {
        ArrayList<Difference> removeDiffs = new ArrayList<Difference>();
        for (Difference dif : diffs) {
            String oName;
            Change c;
            if (!(dif instanceof Change) || !(c = (Change)dif).isTokenChanged() || c.isPositionChanged()) continue;
            oName = oName.substring((oName = c.getOldNodeInfo().getNode().getNodeName().trim()).indexOf(58) != -1 ? oName.indexOf(58) + 1 : 0);
            String nName = c.getNewNodeInfo().getNode().getNodeName().trim();
            if (!oName.equals(nName = nName.substring(nName.indexOf(58) != -1 ? nName.indexOf(58) + 1 : 0)) || c.isAttributeChanged() && (!c.isAttributeChanged() || !XDMUtil.removeNSAttrDiffs(c) && !XDMUtil.removeSchemaLocationAttrDiffs(c))) continue;
            removeDiffs.add(dif);
        }
        for (Difference dif : removeDiffs) {
            diffs.remove(dif);
        }
    }

    public static void filterAttrWhitespaceDiffs(List<Difference> diffs) {
        ArrayList<Difference> removeDiffs = new ArrayList<Difference>();
        for (Difference dif : diffs) {
            Change c;
            if (!(dif instanceof Change) || !(c = (Change)dif).isAttributeChanged() || c.isPositionChanged() || c.isTokenChanged()) continue;
            List<Change.AttributeDiff> attrdiffs = c.getAttrChanges();
            int size = attrdiffs.size();
            ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
            for (Change.AttributeDiff attrdif : attrdiffs) {
                Change.AttributeChange attrChange;
                if (!(attrdif instanceof Change.AttributeChange) || (attrChange = (Change.AttributeChange)attrdif).isPositionChanged()) continue;
                Attribute oldAttr = attrdif.getOldAttribute();
                Attribute newAttr = attrdif.getNewAttribute();
                if (oldAttr == null || newAttr == null || !oldAttr.getNodeValue().trim().equals(newAttr.getNodeValue().trim())) continue;
                removeAttrs.add(attrdif);
            }
            for (Change.AttributeDiff attrdif : removeAttrs) {
                c.removeAttrChanges(attrdif);
            }
            if (size <= 0 || attrdiffs.size() != 0) continue;
            removeDiffs.add(dif);
        }
        for (Difference dif : removeDiffs) {
            diffs.remove(dif);
        }
    }

    public static boolean removeNSAttrDiffs(Change c) {
        List<Change.AttributeDiff> attrdiffs = c.getAttrChanges();
        int size = attrdiffs.size();
        ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
        for (Change.AttributeDiff attrdif : attrdiffs) {
            Attribute oldAttr = attrdif.getOldAttribute();
            Attribute newAttr = attrdif.getNewAttribute();
            if (oldAttr != null && oldAttr.getName().startsWith(NS_PREFIX)) {
                removeAttrs.add(attrdif);
                continue;
            }
            if (newAttr == null || !newAttr.getName().startsWith(NS_PREFIX)) continue;
            removeAttrs.add(attrdif);
        }
        for (Change.AttributeDiff attrdif : removeAttrs) {
            c.removeAttrChanges(attrdif);
        }
        return size > 0 && attrdiffs.size() == 0;
    }

    public static boolean removeSchemaLocationAttrDiffs(Change c) {
        List<Change.AttributeDiff> attrdiffs = c.getAttrChanges();
        int size = attrdiffs.size();
        ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
        for (Change.AttributeDiff attrdif : attrdiffs) {
            Attribute oldAttr = attrdif.getOldAttribute();
            Attribute newAttr = attrdif.getNewAttribute();
            if (oldAttr != null && oldAttr.getName().endsWith(SCHEMA_LOCATION)) {
                removeAttrs.add(attrdif);
                continue;
            }
            if (newAttr == null || !newAttr.getName().endsWith(SCHEMA_LOCATION)) continue;
            removeAttrs.add(attrdif);
        }
        for (Change.AttributeDiff attrdif : removeAttrs) {
            c.removeAttrChanges(attrdif);
        }
        return size > 0 && attrdiffs.size() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ComparisonCriteria {
        EQUAL,
        IDENTICAL;

    }
}

