/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.WeakListeners;

public class JspParserAccess {
    public static synchronized JspParserAPI.WebModule getJspParserWM(WebModule webModule) {
        return new WM(webModule);
    }

    private static final class WM
    extends JspParserAPI.WebModule
    implements PropertyChangeListener {
        WebModule webModule;
        PropertyChangeSupport pcs;

        private WM(WebModule webModule) {
            this.webModule = webModule;
            this.pcs = new PropertyChangeSupport(this);
            if (webModule != null) {
                ClassPath cp = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/execute");
                cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cp));
            }
        }

        public File[] getExtraClasspathEntries() {
            Project p;
            J2eeModuleProvider jprovider;
            File[] entries = null;
            if (this.webModule != null && (jprovider = (J2eeModuleProvider)(p = FileOwnerQuery.getOwner((FileObject)this.webModule.getDocumentBase())).getLookup().lookup(J2eeModuleProvider.class)) != null) {
                String serverID = jprovider.getServerInstanceID();
                J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(serverID);
                if (platform != null) {
                    entries = platform.getClasspathEntries();
                }
            }
            return entries;
        }

        public FileObject getDocumentBase() {
            if (this.webModule != null) {
                return this.webModule.getDocumentBase();
            }
            return null;
        }

        public InputStream getEditorInputStream(FileObject fo) {
            InputStream result = null;
            EditorCookie ec = null;
            try {
                ec = (EditorCookie)DataObject.find((FileObject)fo).getCookie(EditorCookie.class);
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            if (ec != null && ec instanceof CloneableEditorSupport) {
                try {
                    result = ((CloneableEditorSupport)ec).getInputStream();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return result;
        }

        private void fireLibraries() {
            this.firePropertyChange("libraries");
        }

        private void firePackageRoots() {
            this.firePropertyChange("package_roots");
        }

        private void firePropertyChange(String propertyName) {
            this.pcs.firePropertyChange(propertyName, null, null);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("entries".equals(evt.getPropertyName())) {
                this.fireLibraries();
            }
            if ("roots".equals(evt.getPropertyName())) {
                this.firePackageRoots();
            }
        }
    }
}

