/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.general;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.netbeans.core.IDESettings;
import org.netbeans.modules.options.general.GeneralOptionsModel;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.options.SystemOption;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class GeneralOptionsPanel
extends JPanel
implements ActionListener {
    private JRadioButton rbFlatternPackages = new JRadioButton();
    private JRadioButton rbTreePackages = new JRadioButton();
    private JComboBox cbWebBrowser = new JComboBox();
    private JRadioButton rbNoProxy = new JRadioButton();
    private JRadioButton rbSystemProxy = new JRadioButton();
    private JRadioButton rbHTTPProxy = new JRadioButton();
    private JTextField tfHost = new JTextField();
    private JTextField tfPort = new JTextField();
    private JTextField tfNonProxy = new JTextField();
    private JComboBox cbUpdatePeriod = new JComboBox<String>(new String[]{GeneralOptionsPanel.loc("CTL_Update_every_startup"), GeneralOptionsPanel.loc("CTL_Update_every_day"), GeneralOptionsPanel.loc("CTL_Update_every_week"), GeneralOptionsPanel.loc("CTL_Update_every_2weeks"), GeneralOptionsPanel.loc("CTL_Update_every_month"), GeneralOptionsPanel.loc("CTL_Update_never")});
    private JCheckBox cbAskBeforeCheck = new JCheckBox();
    private boolean changed = false;
    private GeneralOptionsModel model;

    GeneralOptionsPanel() {
        this.cbWebBrowser.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Web_Browser"));
        this.cbWebBrowser.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Web_Browser"));
        this.tfHost.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Host"));
        this.tfHost.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Host"));
        this.tfPort.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Port"));
        this.tfPort.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Port"));
        this.tfNonProxy.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_NonProxy"));
        this.tfNonProxy.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_NonProxy"));
        this.cbUpdatePeriod.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Update_Period"));
        this.cbUpdatePeriod.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Update_Period"));
        this.cbAskBeforeCheck.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Ask_Before_Check"));
        this.cbAskBeforeCheck.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Ask_Before_Check"));
        this.rbNoProxy.addActionListener(this);
        this.rbSystemProxy.addActionListener(this);
        this.rbHTTPProxy.addActionListener(this);
        this.rbFlatternPackages.addActionListener(this);
        this.rbTreePackages.addActionListener(this);
        this.cbWebBrowser.addActionListener(this);
        this.tfHost.addActionListener(this);
        this.tfPort.addActionListener(this);
        this.tfNonProxy.addActionListener(this);
        this.cbUpdatePeriod.addActionListener(this);
        this.cbAskBeforeCheck.addActionListener(this);
        ButtonGroup bgPackages = new ButtonGroup();
        bgPackages.add(this.rbFlatternPackages);
        bgPackages.add(this.rbTreePackages);
        GeneralOptionsPanel.loc(this.rbFlatternPackages, "Flattern_Packages");
        GeneralOptionsPanel.loc(this.rbTreePackages, "Tree_Packages");
        ButtonGroup bgProxy = new ButtonGroup();
        bgProxy.add(this.rbNoProxy);
        bgProxy.add(this.rbSystemProxy);
        bgProxy.add(this.rbHTTPProxy);
        GeneralOptionsPanel.loc(this.rbNoProxy, "No_Proxy");
        GeneralOptionsPanel.loc(this.rbSystemProxy, "Use_System_Proxy_Settings");
        GeneralOptionsPanel.loc(this.rbHTTPProxy, "Use_HTTP_Proxy");
        this.tfPort.setColumns(4);
        FormLayout layout = new FormLayout("5dlu, l:p, 5dlu, p:g, 5dlu, l:p, 5dlu, p", "p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        CellConstraints lc = new CellConstraints();
        builder.addSeparator(GeneralOptionsPanel.loc("General"), cc.xyw(1, 1, 8));
        builder.addLabel(GeneralOptionsPanel.loc("Package_View_Type"), lc.xy(2, 3), (Component)this.rbFlatternPackages, cc.xyw(4, 3, 3));
        builder.add((Component)this.rbTreePackages, cc.xyw(4, 5, 3));
        builder.addLabel(GeneralOptionsPanel.loc("Web_Browser"), lc.xy(2, 7), (Component)this.cbWebBrowser, cc.xyw(4, 7, 5));
        builder.addSeparator(GeneralOptionsPanel.loc("Proxy_Settings"), cc.xyw(1, 9, 8));
        builder.addLabel(GeneralOptionsPanel.loc("Web_Proxy"), lc.xy(2, 11), (Component)this.rbNoProxy, cc.xyw(4, 11, 3));
        builder.add((Component)this.rbSystemProxy, cc.xyw(4, 13, 3));
        builder.add((Component)this.rbHTTPProxy, cc.xyw(4, 15, 3));
        builder.addLabel(GeneralOptionsPanel.loc("Proxy_Host"), lc.xy(2, 17), (Component)this.tfHost, cc.xyw(4, 17, 1));
        builder.addLabel(GeneralOptionsPanel.loc("Proxy_Port"), lc.xy(6, 17), (Component)this.tfPort, cc.xyw(8, 17, 1));
        builder.addLabel(GeneralOptionsPanel.loc("Non_Proxy"), lc.xy(2, 19), (Component)this.tfNonProxy, cc.xyw(4, 19, 5));
        builder.addLabel(GeneralOptionsPanel.loc("Non_Proxy_Hint"), lc.xy(4, 21));
        builder.addSeparator(GeneralOptionsPanel.loc("Auto_Update"), cc.xyw(1, 23, 8));
        builder.addLabel(GeneralOptionsPanel.loc("Check_Period"), lc.xy(2, 25), (Component)this.cbUpdatePeriod, cc.xyw(4, 25, 5));
        builder.addLabel(GeneralOptionsPanel.loc("Ask_Before_Check"), lc.xy(2, 27), (Component)this.cbAskBeforeCheck, cc.xyw(4, 27, 3));
        if (System.getProperty("netbeans.system_http_proxy") == null) {
            this.rbSystemProxy.setEnabled(false);
        }
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)GeneralOptionsPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)GeneralOptionsPanel.loc("CTL_" + key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)GeneralOptionsPanel.loc("CTL_" + key));
        }
    }

    void update() {
        this.model = new GeneralOptionsModel();
        this.rbFlatternPackages.setSelected(true);
        switch (this.model.getProxyType()) {
            case 0: {
                this.rbNoProxy.setSelected(true);
                this.tfHost.setEnabled(false);
                this.tfPort.setEnabled(false);
                this.tfNonProxy.setEnabled(false);
                break;
            }
            case 1: {
                this.rbSystemProxy.setSelected(true);
                this.tfHost.setEnabled(false);
                this.tfPort.setEnabled(false);
                this.tfNonProxy.setEnabled(false);
                break;
            }
            default: {
                this.rbHTTPProxy.setSelected(true);
                this.tfHost.setEnabled(true);
                this.tfPort.setEnabled(true);
                this.tfNonProxy.setEnabled(true);
            }
        }
        this.tfHost.setText(this.model.getProxyHost());
        int port = this.model.getProxyPort();
        if (port > 0) {
            this.tfPort.setText(Integer.toString(port));
        } else {
            this.tfPort.setText("");
        }
        this.tfNonProxy.setText(this.model.getUserNonProxy());
        this.cbAskBeforeCheck.setSelected(this.model.getAutoUpdateAskBeforeCheck());
        this.cbUpdatePeriod.setSelectedIndex(this.model.getAutoUpdatePeriod());
        IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        HtmlBrowser.FactoryEditor editor = new HtmlBrowser.FactoryEditor();
        editor.setValue((Object)ideSettings.getWWWBrowser());
        this.cbWebBrowser.removeAllItems();
        String[] tags = editor.getTags();
        int k = tags.length;
        for (int i = 0; i < k; ++i) {
            this.cbWebBrowser.addItem(tags[i]);
        }
        this.cbWebBrowser.setSelectedItem(editor.getAsText());
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            Class<?> clazz = classLoader.loadClass("org.netbeans.modules.java.project.PackageViewSettings");
            SystemOption systemOption = (SystemOption)SystemOption.findObject(clazz, (boolean)true);
            Method method = clazz.getMethod("getPackageViewType", new Class[0]);
            Integer integer = (Integer)method.invoke((Object)systemOption, new Object[0]);
            if (integer == 0) {
                this.rbFlatternPackages.setSelected(true);
            } else {
                this.rbTreePackages.setSelected(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.changed = false;
    }

    void applyChanges() {
        if (this.model == null) {
            return;
        }
        if (this.rbNoProxy.isSelected()) {
            this.model.setProxyType(0);
        } else if (this.rbSystemProxy.isSelected()) {
            this.model.setProxyType(1);
        } else {
            this.model.setProxyType(2);
        }
        this.model.setProxyHost(this.tfHost.getText());
        this.model.setUserNonProxy(this.tfNonProxy.getText());
        try {
            this.model.setProxyPort(Math.max(Integer.parseInt(this.tfPort.getText()), 0));
        }
        catch (NumberFormatException ex) {
            this.model.setProxyPort(0);
        }
        this.model.setAutoUpdateAskBeforeCheck(this.cbAskBeforeCheck.isSelected());
        this.model.setAutoUpdatePeriod(this.cbUpdatePeriod.getSelectedIndex());
        IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        HtmlBrowser.FactoryEditor editor = new HtmlBrowser.FactoryEditor();
        editor.setAsText((String)this.cbWebBrowser.getSelectedItem());
        ideSettings.setWWWBrowser((HtmlBrowser.Factory)editor.getValue());
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            Class<?> clazz = classLoader.loadClass("org.netbeans.modules.java.project.PackageViewSettings");
            SystemOption systemOption = (SystemOption)SystemOption.findObject(clazz, (boolean)true);
            Method method = clazz.getMethod("setPackageViewType", Integer.TYPE);
            Integer integer = new Integer(1);
            if (this.rbFlatternPackages.isSelected()) {
                integer = new Integer(0);
            }
            method.invoke((Object)systemOption, integer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void cancel() {
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        if (!this.tfHost.getText().equals(this.model.getProxyHost())) {
            return true;
        }
        if (this.model.getProxyPort() > 0 ? !this.tfPort.getText().equals(Integer.toString(this.model.getProxyPort())) : !this.tfPort.getText().equals("")) {
            return true;
        }
        if (!this.tfNonProxy.getText().equals(this.model.getUserNonProxy())) {
            return true;
        }
        return this.changed;
    }

    public void actionPerformed(ActionEvent e) {
        this.changed = true;
        this.tfHost.setEnabled(this.rbHTTPProxy.isSelected());
        this.tfPort.setEnabled(this.rbHTTPProxy.isSelected());
        this.tfNonProxy.setEnabled(this.rbHTTPProxy.isSelected());
    }
}

