/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.CharConversionException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.Module;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class ModulesAndDescription
extends JPanel {
    private JEditorPane description;
    private JLabel descriptionLabel;
    private JScrollPane descriptionPane;
    private JList moduleList;
    private JLabel moduleListLabel;
    private JScrollPane modulesArea;

    public ModulesAndDescription(Module[] modules, String labelText) {
        this.initComponents();
        Mnemonics.setLocalizedText((JLabel)this.moduleListLabel, (String)labelText);
        this.moduleList.setListData(modules);
        HTMLEditorKit htmlkit = new HTMLEditorKit();
        StyleSheet css = htmlkit.getStyleSheet();
        if (css.getStyleSheets() == null) {
            StyleSheet css2 = new StyleSheet();
            Font f = this.moduleList.getFont();
            int size = this.moduleList.getFont().getSize();
            css2.addRule("body { font-size: " + size + "; font-family: " + f.getName() + "; }");
            css2.addStyleSheet(css);
            htmlkit.setStyleSheet(css2);
        }
        this.description.setEditorKit(htmlkit);
        if (modules.length > 0) {
            this.moduleList.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.modulesArea = new JScrollPane();
        this.moduleList = new JList();
        this.moduleListLabel = new JLabel();
        this.descriptionPane = new JScrollPane();
        this.description = new JEditorPane();
        this.descriptionLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.moduleList.setSelectionMode(0);
        this.moduleList.setCellRenderer(new ModuleCellRenderer());
        this.moduleList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ModulesAndDescription.this.moduleListValueChanged(evt);
            }
        });
        this.modulesArea.setViewportView(this.moduleList);
        this.moduleList.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ModulesAndDescription.class, (String)"ACN_ModulesAndDescription_moduleList"));
        this.moduleList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ModulesAndDescription.class, (String)"ACD_ModulesAndDescription_moduleList"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        this.add((Component)this.modulesArea, gridBagConstraints);
        this.moduleListLabel.setLabelFor(this.moduleList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 2, 0);
        this.add((Component)this.moduleListLabel, gridBagConstraints);
        this.descriptionPane.setMinimumSize(new Dimension(400, 80));
        this.descriptionPane.setPreferredSize(new Dimension(400, 80));
        this.description.setEditable(false);
        this.descriptionPane.setViewportView(this.description);
        this.description.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ModulesAndDescription.class, (String)"ACN_ModulesAndiDescription_description"));
        this.description.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ModulesAndDescription.class, (String)"ACD_ModulesAndiDescription_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.descriptionPane, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.description);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage((Class)ModulesAndDescription.class, (String)"LBL_ModulesAndDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 2, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
    }

    private void moduleListValueChanged(ListSelectionEvent evt) {
        JList l = (JList)evt.getSource();
        Module m = (Module)l.getSelectedValue();
        if (m != null) {
            String text;
            try {
                text = "<b>" + XMLUtil.toElementContent((String)m.getDisplayName()) + "</b>";
                String longDesc = (String)m.getLocalizedAttribute("OpenIDE-Module-Long-Description");
                if (longDesc != null) {
                    text = text + "<br>" + XMLUtil.toElementContent((String)longDesc);
                }
            }
            catch (CharConversionException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return;
            }
            this.description.setText(text);
            this.description.setCaretPosition(0);
        } else {
            this.description.setText(null);
        }
    }

    private static final class ModuleCellRenderer
    extends DefaultListCellRenderer {
        ModuleCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object val, int idx, boolean sel, boolean focus) {
            return super.getListCellRendererComponent((JList<?>)list, ((Module)val).getDisplayName(), idx, sel, focus);
        }
    }
}

