/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class J2SEAntLogger
extends AntLogger {
    public boolean interestedInSession(AntSession session) {
        return session.getVerbosity() <= 2;
    }

    private static boolean isJ2SEProject(File dir) {
        FileObject projdir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)dir));
        try {
            Project proj = ProjectManager.getDefault().findProject(projdir);
            if (proj != null) {
                return proj.getLookup().lookup(J2SEProject.class) != null;
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return false;
    }

    public boolean interestedInScript(File script, AntSession session) {
        File parent2;
        File parent;
        if (script.getName().equals("build-impl.xml") && (parent = script.getParentFile()) != null && parent.getName().equals("nbproject") && (parent2 = parent.getParentFile()) != null) {
            return J2SEAntLogger.isJ2SEProject(parent2);
        }
        return false;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return AntLogger.ALL_TASKS;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return new int[]{1};
    }

    public void taskFinished(AntEvent event) {
        if ("javac".equals(event.getTaskName())) {
            Throwable t = event.getException();
            AntSession session = event.getSession();
            if (t != null && !session.isExceptionConsumed(t)) {
                session.consumeException(t);
            }
        }
    }

    public void messageLogged(AntEvent event) {
        if (!event.isConsumed() && event.getLogLevel() == 1 && event.getMessage().startsWith("Trying to override old definition of task http://www.netbeans.org/ns/j2se-project/")) {
            event.consume();
        }
    }
}

