/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.modules.java.j2seproject.classpath.J2SEProjectClassPathExtender;
import org.netbeans.modules.java.j2seproject.ui.ActionFilterNode;
import org.netbeans.modules.java.j2seproject.ui.FoldersListSettings;
import org.netbeans.modules.java.j2seproject.ui.LibrariesSourceGroup;
import org.netbeans.modules.java.j2seproject.ui.PlatformNode;
import org.netbeans.modules.java.j2seproject.ui.ProjectNode;
import org.netbeans.modules.java.j2seproject.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.modules.java.j2seproject.ui.customizer.LibrariesChooser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

final class LibrariesNode
extends AbstractNode {
    private static final Image ICON_BADGE = Utilities.loadImage((String)"org/netbeans/modules/java/j2seproject/ui/resources/libraries-badge.png");
    static final RequestProcessor rp = new RequestProcessor();
    private static Icon folderIconCache;
    private static Icon openedFolderIconCache;
    private final String displayName;
    private final Action[] librariesNodeActions;
    static /* synthetic */ Class class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode;
    static /* synthetic */ Class class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender;

    LibrariesNode(String displayName, Project project, PropertyEvaluator eval, UpdateHelper helper, ReferenceHelper refHelper, String classPathProperty, String[] classPathIgnoreRef, String platformProperty, Action[] librariesNodeActions) {
        super((Children)new LibrariesChildren(eval, helper, refHelper, classPathProperty, classPathIgnoreRef, platformProperty), Lookups.singleton((Object)project));
        this.displayName = displayName;
        this.librariesNodeActions = librariesNodeActions;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    public Action[] getActions(boolean context) {
        return this.librariesNodeActions;
    }

    public boolean canCopy() {
        return false;
    }

    public static Action createAddProjectAction(Project p, String classPathId) {
        return new AddProjectAction(p, classPathId);
    }

    public static Action createAddLibraryAction(Project p, String classPathId) {
        return new AddLibraryAction(p, classPathId);
    }

    public static Action createAddFolderAction(Project p, String classPathId) {
        return new AddFolderAction(p, classPathId);
    }

    static synchronized Icon getFolderIcon(boolean opened) {
        if (openedFolderIconCache == null) {
            Node n = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
            openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
            folderIconCache = new ImageIcon(n.getIcon(1));
        }
        if (opened) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = LibrariesNode.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = Utilities.mergeImages((Image)image, (Image)ICON_BADGE, (int)7, (int)7);
        return image;
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            try {
                return FileUtil.isArchiveFile((URL)f.toURI().toURL());
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
                return false;
            }
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class AddFolderAction
    extends AbstractAction {
        private final Project project;
        private final String classPathId;
        static final /* synthetic */ boolean $assertionsDisabled;

        public AddFolderAction(Project project, String classPathId) {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_AddFolder_Action"));
            this.project = project;
            this.classPathId = classPathId;
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
            chooser.setFileSelectionMode(2);
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_AddJar_DialogTitle"));
            SimpleFileFilter fileFilter = new SimpleFileFilter(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"});
            chooser.setFileFilter(fileFilter);
            chooser.setAcceptAllFileFilterUsed(false);
            File curDir = FoldersListSettings.getDefault().getLastUsedClassPathFolder();
            chooser.setCurrentDirectory(curDir);
            int option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
            if (option == 0) {
                File[] files = chooser.getSelectedFiles();
                this.addJarFiles(files, fileFilter);
                curDir = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
                FoldersListSettings.getDefault().setLastUsedClassPathFolder(curDir);
            }
        }

        private void addJarFiles(File[] files, FileFilter fileFilter) {
            J2SEProjectClassPathExtender cpExtender = (J2SEProjectClassPathExtender)this.project.getLookup().lookup(class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender == null ? (class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.classpath.J2SEProjectClassPathExtender")) : class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender);
            if (cpExtender != null) {
                for (int i = 0; i < files.length; ++i) {
                    try {
                        if (!fileFilter.accept(files[i])) continue;
                        FileObject fo = FileUtil.toFileObject((File)files[i]);
                        if (!$assertionsDisabled && fo == null) {
                            throw new AssertionError(files[i]);
                        }
                        cpExtender.addArchiveFile(this.classPathId, fo);
                        continue;
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            } else {
                ErrorManager.getDefault().log("J2SEProjectClassPathExtender not found in the project lookup of project: " + this.project.getProjectDirectory().getPath());
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode).desiredAssertionStatus();
        }
    }

    private static class AddLibraryAction
    extends AbstractAction {
        private final Project project;
        private final String classPathId;

        public AddLibraryAction(Project project, String classPathId) {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_AddLibrary_Action"));
            this.project = project;
            this.classPathId = classPathId;
        }

        public void actionPerformed(ActionEvent e) {
            Object[] options = new Object[]{new JButton(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_AddLibrary")), DialogDescriptor.CANCEL_OPTION};
            ((JButton)options[0]).setEnabled(false);
            ((JButton)options[0]).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"AD_AddLibrary"));
            LibrariesChooser panel = new LibrariesChooser((JButton)options[0], Collections.EMPTY_SET);
            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_CustomizeCompile_Classpath_AddLibrary"), true, options, options[0], 0, null, null);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.setVisible(true);
            if (desc.getValue() == options[0]) {
                this.addLibraries(panel.getSelectedLibraries());
            }
            dlg.dispose();
        }

        private void addLibraries(Library[] libraries) {
            J2SEProjectClassPathExtender cpExtender = (J2SEProjectClassPathExtender)this.project.getLookup().lookup(class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender == null ? (class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.classpath.J2SEProjectClassPathExtender")) : class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender);
            if (cpExtender != null) {
                for (int i = 0; i < libraries.length; ++i) {
                    try {
                        cpExtender.addLibrary(this.classPathId, libraries[i]);
                        continue;
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            } else {
                ErrorManager.getDefault().log("J2SEProjectClassPathExtender not found in the project lookup of project: " + this.project.getProjectDirectory().getPath());
            }
        }
    }

    private static class AddProjectAction
    extends AbstractAction {
        private final Project project;
        private final String classPathId;

        public AddProjectAction(Project project, String classPathId) {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_AddProject_Action"));
            this.project = project;
            this.classPathId = classPathId;
        }

        public void actionPerformed(ActionEvent e) {
            AntArtifactChooser.ArtifactItem[] ai = AntArtifactChooser.showDialog(new String[]{"jar", "folder"}, this.project, null);
            if (ai != null) {
                this.addArtifacts(ai);
            }
        }

        private void addArtifacts(AntArtifactChooser.ArtifactItem[] artifactItems) {
            J2SEProjectClassPathExtender cpExtender = (J2SEProjectClassPathExtender)this.project.getLookup().lookup(class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender == null ? (class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.classpath.J2SEProjectClassPathExtender")) : class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender);
            if (cpExtender != null) {
                for (int i = 0; i < artifactItems.length; ++i) {
                    try {
                        cpExtender.addAntArtifact(this.classPathId, artifactItems[i].getArtifact(), artifactItems[i].getArtifactURI());
                        continue;
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            } else {
                ErrorManager.getDefault().log("J2SEProjectClassPathExtender not found in the project lookup of project: " + this.project.getProjectDirectory().getPath());
            }
        }
    }

    private static class Key {
        static final int TYPE_PLATFORM = 0;
        static final int TYPE_LIBRARY = 1;
        static final int TYPE_PROJECT = 2;
        private int type;
        private String classPathId;
        private String entryId;
        private SourceGroup sg;
        private AntArtifact antArtifact;
        private URI uri;

        Key() {
            this.type = 0;
        }

        Key(SourceGroup sg, String classPathId, String entryId) {
            this.type = 1;
            this.sg = sg;
            this.classPathId = classPathId;
            this.entryId = entryId;
        }

        Key(AntArtifact a, URI uri, String classPathId, String entryId) {
            this.type = 2;
            this.antArtifact = a;
            this.uri = uri;
            this.classPathId = classPathId;
            this.entryId = entryId;
        }

        public int getType() {
            return this.type;
        }

        public String getClassPathId() {
            return this.classPathId;
        }

        public String getEntryId() {
            return this.entryId;
        }

        public SourceGroup getSourceGroup() {
            return this.sg;
        }

        public AntArtifact getProject() {
            return this.antArtifact;
        }

        public URI getArtifactLocation() {
            return this.uri;
        }

        public int hashCode() {
            int hashCode = this.type << 16;
            switch (this.type) {
                case 1: {
                    hashCode ^= this.sg == null ? 0 : this.sg.hashCode();
                    break;
                }
                case 2: {
                    hashCode ^= this.antArtifact == null ? 0 : this.antArtifact.hashCode();
                }
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (other.type != this.type) {
                return false;
            }
            switch (this.type) {
                case 1: {
                    return (this.sg == null ? other.sg == null : this.sg.equals(other.sg)) && (this.classPathId == null ? other.classPathId == null : this.classPathId.equals(other.classPathId)) && (this.entryId == null ? other.entryId == null : this.entryId.equals(other.entryId));
                }
                case 2: {
                    return (this.antArtifact == null ? other.antArtifact == null : this.antArtifact.equals(other.antArtifact)) && (this.classPathId == null ? other.classPathId == null : this.classPathId.equals(other.classPathId)) && (this.entryId == null ? other.entryId == null : this.entryId.equals(other.entryId));
                }
                case 0: {
                    return true;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static class LibrariesChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private static final String LIBRARY_PREFIX = "${libs.";
        private static final String ANT_ARTIFACT_PREFIX = "${reference.";
        private static final String FILE_REF_PREFIX = "${file.reference.";
        private static final String REF_PREFIX = "${";
        private static final String LIBRARIES_ICON = "org/netbeans/modules/java/j2seproject/ui/resources/libraries.gif";
        private static final String ARCHIVE_ICON = "org/netbeans/modules/java/j2seproject/ui/resources/jar.gif";
        private final PropertyEvaluator eval;
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final String classPathProperty;
        private final String platformProperty;
        private final Set classPathIgnoreRef;
        private ClassPath fsListener;
        static final /* synthetic */ boolean $assertionsDisabled;

        LibrariesChildren(PropertyEvaluator eval, UpdateHelper helper, ReferenceHelper refHelper, String classPathProperty, String[] classPathIgnoreRef, String platformProperty) {
            this.eval = eval;
            this.helper = helper;
            this.refHelper = refHelper;
            this.classPathProperty = classPathProperty;
            this.classPathIgnoreRef = new HashSet<String>(Arrays.asList(classPathIgnoreRef));
            this.platformProperty = platformProperty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (this.classPathProperty.equals(propName) || "roots".equals(propName)) {
                LibrariesChildren librariesChildren = this;
                synchronized (librariesChildren) {
                    if (this.fsListener != null) {
                        this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
                rp.post(new Runnable(){

                    public void run() {
                        LibrariesChildren.this.setKeys(LibrariesChildren.this.getKeys());
                    }
                });
            }
        }

        protected void addNotify() {
            this.eval.addPropertyChangeListener((PropertyChangeListener)this);
            this.setKeys(this.getKeys());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeNotify() {
            this.eval.removePropertyChangeListener((PropertyChangeListener)this);
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                if (this.fsListener != null) {
                    this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    this.fsListener = null;
                }
            }
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object obj) {
            Node[] result = null;
            if (obj instanceof Key) {
                Key key = (Key)obj;
                switch (key.getType()) {
                    case 0: {
                        result = new Node[]{PlatformNode.create(this.eval, this.platformProperty)};
                        break;
                    }
                    case 2: {
                        result = new Node[]{new ProjectNode(key.getProject(), key.getArtifactLocation(), this.helper, this.refHelper, key.getClassPathId(), key.getEntryId())};
                        break;
                    }
                    case 1: {
                        result = new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)key.getSourceGroup()), this.helper, key.getClassPathId(), key.getEntryId())};
                    }
                }
            }
            if (result == null) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unknown key type");
                }
                result = new Node[]{};
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getKeys() {
            EditableProperties projectSharedProps = this.helper.getProperties("nbproject/project.properties");
            EditableProperties projectPrivateProps = this.helper.getProperties("nbproject/private/private.properties");
            EditableProperties privateProps = PropertyUtils.getGlobalProperties();
            ArrayList rootsList = new ArrayList();
            List result = this.getKeys(projectSharedProps, projectPrivateProps, privateProps, this.classPathProperty, rootsList);
            FileObject projectDir = this.helper.getAntProjectHelper().getProjectDirectory();
            if (this.platformProperty != null && projectDir != null && projectDir.isValid() && !projectDir.isVirtual()) {
                result.add(new Key());
            }
            ClassPath cp = ClassPathSupport.createClassPath((URL[])rootsList.toArray(new URL[rootsList.size()]));
            cp.addPropertyChangeListener((PropertyChangeListener)this);
            cp.getRoots();
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                this.fsListener = cp;
            }
            return result;
        }

        private List getKeys(EditableProperties projectSharedProps, EditableProperties projectPrivateProps, EditableProperties privateProps, String currentClassPath, List rootsList) {
            ArrayList<Key> result = new ArrayList<Key>();
            String raw = projectSharedProps.getProperty(currentClassPath);
            if (raw == null) {
                raw = projectPrivateProps.getProperty(currentClassPath);
            }
            if (raw == null) {
                raw = privateProps.getProperty(currentClassPath);
            }
            if (raw == null) {
                return result;
            }
            ArrayList<String> pe = new ArrayList<String>(Arrays.asList(PropertyUtils.tokenizePath((String)raw)));
            while (pe.size() > 0) {
                String prop = (String)pe.remove(0);
                String propName = J2SEProjectProperties.getAntPropertyName(prop);
                if (this.classPathIgnoreRef.contains(propName)) continue;
                if (prop.startsWith(LIBRARY_PREFIX)) {
                    String eval = prop.substring(LIBRARY_PREFIX.length(), prop.lastIndexOf(46));
                    Library lib = LibraryManager.getDefault().getLibrary(eval);
                    if (lib == null) continue;
                    List roots = lib.getContent("classpath");
                    ImageIcon libIcon = new ImageIcon(Utilities.loadImage((String)LIBRARIES_ICON));
                    Iterator it = roots.iterator();
                    while (it.hasNext()) {
                        String displayName;
                        Object file;
                        URL rootUrl = (URL)it.next();
                        rootsList.add(rootUrl);
                        FileObject root = URLMapper.findFileObject((URL)rootUrl);
                        if (root == null) continue;
                        if ("jar".equals(rootUrl.getProtocol())) {
                            file = FileUtil.getArchiveFile((FileObject)root);
                            displayName = file.getNameExt();
                        } else {
                            file = FileUtil.toFile((FileObject)root);
                            displayName = file != null ? ((File)file).getAbsolutePath() : root.getNameExt();
                        }
                        displayName = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode") : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"TXT_LibraryPartFormat"), lib.getDisplayName(), displayName);
                        LibrariesSourceGroup sg = new LibrariesSourceGroup(root, displayName, libIcon, libIcon);
                        result.add(new Key(sg, currentClassPath, propName));
                    }
                    continue;
                }
                if (prop.startsWith(ANT_ARTIFACT_PREFIX)) {
                    Object[] ret = this.refHelper.findArtifactAndLocation(prop);
                    if (ret[0] == null || ret[1] == null) continue;
                    AntArtifact artifact = (AntArtifact)ret[0];
                    URI uri = (URI)ret[1];
                    result.add(new Key(artifact, uri, currentClassPath, propName));
                    continue;
                }
                if (prop.startsWith(FILE_REF_PREFIX)) {
                    File file;
                    SourceGroup sg;
                    String evaluatedRef = this.eval.getProperty(propName);
                    if (evaluatedRef == null || (sg = LibrariesChildren.createFileSourceGroup(file = this.helper.getAntProjectHelper().resolveFile(evaluatedRef), rootsList)) == null) continue;
                    result.add(new Key(sg, currentClassPath, propName));
                    continue;
                }
                if (prop.startsWith(REF_PREFIX)) {
                    result.addAll(this.getKeys(projectSharedProps, projectPrivateProps, privateProps, propName, rootsList));
                    continue;
                }
                File file = this.helper.getAntProjectHelper().resolveFile(prop);
                SourceGroup sg = LibrariesChildren.createFileSourceGroup(file, rootsList);
                if (sg == null) continue;
                result.add(new Key(sg, currentClassPath, propName));
            }
            return result;
        }

        private static SourceGroup createFileSourceGroup(File file, List rootsList) {
            try {
                String displayName;
                Icon icon;
                Icon openedIcon;
                URL url = file.toURI().toURL();
                if (FileUtil.isArchiveFile((URL)url)) {
                    url = FileUtil.getArchiveRoot((URL)url);
                    openedIcon = new ImageIcon(Utilities.loadImage((String)ARCHIVE_ICON));
                    icon = openedIcon;
                    displayName = file.getName();
                } else {
                    String sURL = url.toExternalForm();
                    if (!sURL.endsWith("/")) {
                        url = new URL(sURL + "/");
                    }
                    icon = LibrariesNode.getFolderIcon(false);
                    openedIcon = LibrariesNode.getFolderIcon(true);
                    displayName = file.getAbsolutePath();
                }
                rootsList.add(url);
                FileObject root = URLMapper.findFileObject((URL)url);
                if (root != null) {
                    return new LibrariesSourceGroup(root, displayName, icon, openedIcon);
                }
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            return null;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode).desiredAssertionStatus();
        }
    }
}

