/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.openide.ErrorManager;
import org.openide.util.Utilities;

final class CloseButtonTabbedPane
extends JTabbedPane
implements ChangeListener {
    private final Image closeTabImage = this.isWindowsVista() ? Utilities.loadImage((String)"org/netbeans/core/output2/resources/vista_close_enabled.png") : Utilities.loadImage((String)"org/netbeans/core/output2/resources/tabclose.gif");
    private final Image closeTabPressedImage = this.isWindowsVista() ? Utilities.loadImage((String)"org/netbeans/core/output2/resources/vista_close_pressed.png") : null;
    private final Image closeTabMouseOverImage = this.isWindowsVista() ? Utilities.loadImage((String)"org/netbeans/core/output2/resources/vista_close_over.png") : null;
    private final Image closeTabInactiveImage = this.isWindowsVista() ? null : Utilities.loadImage((String)"org/netbeans/core/output2/resources/tabcloseinactive.gif");
    public static final String PROP_CLOSE = "close";
    private int pressedCloseButtonIndex = -1;
    private int mouseOverCloseButtonIndex = -1;
    private boolean draggedOut = false;

    CloseButtonTabbedPane() {
        this.addChangeListener(this);
        CloseButtonListener.install();
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new CBTPPolicy());
    }

    private Component sel() {
        int tabC = this.getTabCount();
        int selIndex = this.getSelectedIndex();
        if (selIndex != -1 && selIndex >= tabC) {
            return tabC > 0 ? this.getComponentAt(tabC - 1) : this;
        }
        Component c = this.getSelectedComponent();
        return c == null ? this : c;
    }

    public int tabForCoordinate(int x, int y) {
        return this.getUI().tabForCoordinate(this, x, y);
    }

    public void stateChanged(ChangeEvent e) {
        this.reset();
        if (this.getSelectedComponent() instanceof AbstractOutputPane) {
            ((AbstractOutputPane)this.getSelectedComponent()).ensureCaretPosition();
        }
    }

    public Component add(Component c) {
        Component result = super.add(c);
        String s = c.getName();
        if (s != null) {
            s = s + " ";
        }
        this.setTitleAt(this.getComponentCount() - 1, s);
        return result;
    }

    public void setTitleAt(int idx, String title) {
        String nue;
        String string = nue = title.indexOf("</html>") != -1 ? Utilities.replaceString((String)title, (String)"</html>", (String)"&nbsp;&nbsp;</html>") : title + "  ";
        if (!title.equals(this.getTitleAt(idx))) {
            super.setTitleAt(idx, nue);
        }
    }

    private void reset() {
        this.setMouseOverCloseButtonIndex(-1);
        this.setPressedCloseButtonIndex(-1);
        this.draggedOut = false;
    }

    private Rectangle getCloseButtonBoundsAt(int i) {
        Rectangle b = this.getBoundsAt(i);
        if (b == null) {
            return null;
        }
        b = new Rectangle(b);
        CloseButtonTabbedPane.fixGetBoundsAt(b);
        Dimension tabsz = this.getSize();
        if (b.x + b.width >= tabsz.width || b.y + b.height >= tabsz.height) {
            return null;
        }
        if (this.isWindowsVista() && i == this.getSelectedIndex()) {
            --b.x;
            b.y -= 2;
        }
        return new Rectangle(b.x + b.width - 13, b.y + b.height / 2 - 5, 8, 8);
    }

    private static void checkUIColors() {
        if (UIManager.getColor("Button.shadow") == null) {
            UIManager.put("Button.shadow", new ColorUIResource(153, 153, 153));
        }
        if (UIManager.getColor("Button.darkShadow") == null) {
            UIManager.put("Button.darkShadow", new ColorUIResource(102, 102, 102));
        }
        if (UIManager.getColor("Button.highlight") == null) {
            UIManager.put("Button.highlight", new ColorUIResource(Color.white));
        }
        if (UIManager.getColor("Button.background") == null) {
            UIManager.put("Button.background", new ColorUIResource(204, 204, 204));
        }
    }

    private boolean isWindowsVista() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("Vista") >= 0 || osName.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    public void paint(Graphics g) {
        super.paint(g);
        CloseButtonTabbedPane.checkUIColors();
        if (this.isWindowsVista()) {
            int selectedIndex = this.getSelectedIndex();
            int n = this.getTabCount();
            for (int i = 0; i < n; ++i) {
                Rectangle r = this.getCloseButtonBoundsAt(i);
                if (r == null) continue;
                if (i == this.mouseOverCloseButtonIndex || i == this.pressedCloseButtonIndex && this.draggedOut) {
                    g.drawImage(this.closeTabMouseOverImage, r.x, r.y, this);
                    continue;
                }
                if (i == this.pressedCloseButtonIndex) {
                    g.drawImage(this.closeTabPressedImage, r.x, r.y, this);
                    continue;
                }
                g.drawImage(this.closeTabImage, r.x, r.y, this);
            }
        } else {
            int selectedIndex = this.getSelectedIndex();
            int n = this.getTabCount();
            for (int i = 0; i < n; ++i) {
                Rectangle r = this.getCloseButtonBoundsAt(i);
                if (r == null) continue;
                if (i == this.pressedCloseButtonIndex && !this.draggedOut) {
                    g.setColor(UIManager.getColor("Button.shadow"));
                    g.fillRect(r.x, r.y, r.width, r.height);
                }
                if (i != selectedIndex) {
                    g.drawImage(this.closeTabInactiveImage, r.x + 2, r.y + 2, this);
                } else {
                    g.drawImage(this.closeTabImage, r.x + 2, r.y + 2, this);
                }
                if (i == this.mouseOverCloseButtonIndex || i == this.pressedCloseButtonIndex && this.draggedOut) {
                    g.setColor(UIManager.getColor("Button.darkShadow"));
                    g.drawRect(r.x, r.y, r.width, r.height);
                    g.setColor(i == selectedIndex ? UIManager.getColor("Button.highlight") : UIManager.getColor("Button.background"));
                    g.drawRect(r.x + 1, r.y + 1, r.width, r.height);
                    g.setColor(UIManager.getColor("Button.highlight").brighter());
                    g.drawLine(r.x + r.width, r.y + 1, r.x + r.width, r.y + 1);
                    g.drawLine(r.x + 1, r.y + r.height, r.x + 1, r.y + r.height);
                    continue;
                }
                if (i != this.pressedCloseButtonIndex) continue;
                g.setColor(UIManager.getColor("Button.shadow"));
                g.drawRect(r.x, r.y, r.width, r.height);
                g.setColor(i == selectedIndex ? UIManager.getColor("Button.highlight") : UIManager.getColor("Button.background"));
                g.drawLine(r.x + 1, r.y + r.height + 1, r.x + r.width + 1, r.y + r.height + 1);
                g.drawLine(r.x + r.width + 1, r.y + 1, r.x + r.width + 1, r.y + r.height + 1);
                g.setColor(UIManager.getColor("Button.background"));
                g.drawLine(r.x + 1, r.y + 1, r.x + r.width, r.y + 1);
                g.drawLine(r.x + 1, r.y + 1, r.x + 1, r.y + r.height);
            }
        }
    }

    private void setPressedCloseButtonIndex(int index) {
        Rectangle r;
        if (this.pressedCloseButtonIndex == index) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            JComponent c = (JComponent)this.getComponentAt(this.pressedCloseButtonIndex);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, c.getToolTipText());
        }
        this.pressedCloseButtonIndex = index;
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void setMouseOverCloseButtonIndex(int index) {
        Rectangle r;
        if (this.mouseOverCloseButtonIndex == index) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            JComponent c = (JComponent)this.getComponentAt(this.mouseOverCloseButtonIndex);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, c.getToolTipText());
        }
        this.mouseOverCloseButtonIndex = index;
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    private void fireCloseRequest(Component c) {
        this.firePropertyChange(PROP_CLOSE, null, c);
    }

    public static void fixGetBoundsAt(Rectangle b) {
        if (b.y < 0) {
            b.y = -b.y;
        }
        if (b.x < 0) {
            b.x = -b.x;
        }
    }

    public static int findTabForCoordinate(JTabbedPane tab, int x, int y) {
        for (int i = 0; i < tab.getTabCount(); ++i) {
            Rectangle b = tab.getBoundsAt(i);
            if (b == null) continue;
            b = new Rectangle(b);
            CloseButtonTabbedPane.fixGetBoundsAt(b);
            if (!b.contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    protected void processMouseEvent(MouseEvent me) {
        try {
            super.processMouseEvent(me);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            ErrorManager.getDefault().annotate((Throwable)aioobe, "Suppressed AIOOBE bug in BasicTabbedPaneUI");
            ErrorManager.getDefault().notify(1, (Throwable)aioobe);
        }
    }

    private static class CloseButtonListener
    implements AWTEventListener {
        private static boolean installed = false;

        private CloseButtonListener() {
        }

        private static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new CloseButtonListener(), 48L);
        }

        public void eventDispatched(AWTEvent ev) {
            Component c;
            MouseEvent e = (MouseEvent)ev;
            for (c = (Component)e.getSource(); c != null && !(c instanceof CloseButtonTabbedPane); c = c.getParent()) {
            }
            if (c == null) {
                return;
            }
            CloseButtonTabbedPane tab = (CloseButtonTabbedPane)c;
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), tab);
            if (e.getID() == 500) {
                return;
            }
            int index = CloseButtonTabbedPane.findTabForCoordinate(tab, p.x, p.y);
            Rectangle r = null;
            if (index >= 0) {
                r = tab.getCloseButtonBoundsAt(index);
            }
            if (r == null) {
                r = new Rectangle(0, 0, 0, 0);
            }
            switch (e.getID()) {
                case 501: {
                    if (!r.contains(p)) break;
                    tab.setPressedCloseButtonIndex(index);
                    tab.draggedOut = false;
                    e.consume();
                    return;
                }
                case 502: {
                    if (r.contains(p) && tab.pressedCloseButtonIndex >= 0) {
                        Component tc = tab.getComponentAt(tab.pressedCloseButtonIndex);
                        tab.reset();
                        tab.fireCloseRequest(tc);
                        e.consume();
                        return;
                    }
                    tab.reset();
                    break;
                }
                case 504: {
                    break;
                }
                case 505: {
                    break;
                }
                case 503: {
                    if (r.contains(p)) {
                        tab.setMouseOverCloseButtonIndex(index);
                        tab.draggedOut = false;
                        e.consume();
                        return;
                    }
                    if (tab.mouseOverCloseButtonIndex < 0) break;
                    tab.setMouseOverCloseButtonIndex(-1);
                    tab.draggedOut = false;
                    e.consume();
                    break;
                }
                case 506: {
                    if (tab.pressedCloseButtonIndex < 0) break;
                    if (tab.draggedOut != !r.contains(p)) {
                        tab.draggedOut = !r.contains(p);
                        tab.repaint(r.x, r.y, r.width + 2, r.height + 2);
                    }
                    e.consume();
                    return;
                }
            }
        }
    }

    private class CBTPPolicy
    extends FocusTraversalPolicy {
        private CBTPPolicy() {
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getFirstComponent(Container aContainer) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getLastComponent(Container aContainer) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getDefaultComponent(Container aContainer) {
            return CloseButtonTabbedPane.this.sel();
        }
    }
}

