dojo.provide("popupcalendar.PopupCalendar");

dojo.require("dojo.widget.*");
dojo.require("dojo.event.*");
dojo.require("popupcalendar.Calendar");

popupcalendar.PopupCalendar = function() {
	dojo.widget.HtmlWidget.call(this);
};
dojo.inherits(popupcalendar.PopupCalendar, dojo.widget.HtmlWidget);
dojo.widget.tags.addParseTreeHandler("dojo:popupcalendar");
dojo.lang.extend(popupcalendar.PopupCalendar, {
	widgetType: "PopupCalendar",

	// TODO These are part of dojo widget framework and may be used in future
	// templateString: "<div></div>",
	// templateCssPath: dojo.uri.dojoUri("../bpui/widget/templates/PopupCalendar.css"),
	
	initialize: function(args, frag) {
		this.fieldNode = dojo.byId(this.baseId + "_field");
		this.calendarNode = dojo.byId(this.baseId + "_calendar");

		// Share the same date format with the popup
		var calParams = this.calendarParams;
		if (calParams) {
			this.yearIndex = calParams.yearIndex;
			this.monthIndex = calParams.monthIndex;
			this.dayIndex = calParams.dayIndex;
			this.separator = calParams.separator;
		}
		this.formatter = new popupcalendar.Calendar.DateFormat(
			this.yearIndex, this.monthIndex, this.dayIndex, this.separator);
	},

	// Default widget values
	fieldErrorColor: 'pink',
	yearIndex: 6, monthIndex: 0, dayIndex: 3, separator: '/',
	calendarParams: {},

	/**
	 * Get a unique per-HTML page calendar instance.
	 */
	getPopupInstance: function() {
		// TODO get this to work with other calendar-type widgets
		if (popupcalendar.PopupCalendar.POPUP_INSTANCE == null) {
			var popup = dojo.widget.createWidget("Calendar");
			popup.domNode.style.position = "absolute";
			popup.hide();
			document.body.appendChild(popup.domNode);
			popupcalendar.PopupCalendar.POPUP_INSTANCE = popup;
		}
		return popupcalendar.PopupCalendar.POPUP_INSTANCE;
	},

	togglePopup: function() {
		var popup = this.getPopupInstance();
		var owner = popup.ownerDropdown;
		if (!owner) {
			// Popup hidden and no one owns it
			this.updateAndOpen(popup);
		} else if (owner == this) {
			// Popup visible and I am owner
			owner.updateAndClose();
		} else {
			// Popup visible but someone else is owner
			owner.updateAndClose();
			this.updateAndOpen(popup);
		}
	},
	
	updateAndOpen: function(popup) {
		// Make us the owner...
		popup.ownerDropdown = this;

		// Save a copy of the original background
		this.fieldNode.origBackground = this.fieldNode.style.background;
		var fieldDate;
		try {
			fieldDate = this.parseField();
			// We have a valid value which is either 1) a selected date or
			// 2) no date selected (null)
			if (fieldDate) {
				// Reformat the date to match date format pattern
				this.fieldNode.value = this.formatter.format(fieldDate);
			}
			this.fieldNode.style.background = this.fieldNode.origBackground;
		} catch (err) {
			// TODO refine err handling
			// Invalid value
			fieldDate = null;
			this.fieldNode.style.background = this.fieldErrorColor;
		}

		// Init our instance specific calendar params
		popup.initParams(this.calendarParams);
		popup.isPopup = true;
		popup.selectedDate = fieldDate;
		var pos = dojo.style.getAbsolutePosition(this.calendarNode);
		dojo.html.placeOnScreen(popup.domNode, pos.x, pos.y);

		// Hook into any popup close events
		this.connectArgs = {
			srcObj: popup,
			srcFunc: "requestClose",
			targetObj: this,
			targetFunc: "updateAndClose",
			once: true
		};
		dojo.event.kwConnect(this.connectArgs);
		/*
		// TODO this doesn't work at all, click elsewhere should close
		dojo.event.connect(popup.domNode, "onblur", function (evt) {
							   alert("ho");
							   popup.hide();
						   });
		*/
		popup.doRender();
		popup.show();
	},

	updateAndClose: function() {
		var popup = this.getPopupInstance();
		if (popup.selectedDate) {
			this.fieldNode.value = this.formatter.format(popup.selectedDate);
		} else {
			// No date selected so show prompt
			this.fieldNode.value = this.fieldNode.title;
		}
		this.fieldNode.style.background = this.fieldNode.origBackground;

		dojo.event.kwDisconnect(this.connectArgs);
		popup.hide();

		// We're no longer the owner
		popup.ownerDropdown = null;
	},

	/**
	 * Parse the input field value and return a Date or null
	 */
	parseField: function() {
		var text = this.fieldNode.value;

		// If text is initial prompt then this is not an error
		var tooltip = this.fieldNode.title;
		if (text.search("^" + tooltip + "$") == 0) {
			return null;
		}

		// Check for only whitespace chars which is not an error
		if (text.search(/\S/) == -1) {
			return null;
		}

		// If no digits then flag as error
		var parts = text.match(/\d+/g);
		if (parts == null) {
			throw new Error("No digits found");
		}

		var year, month, day;
		if (parts.length == 1) {
			if (parts[0].length <= 2) {
				// Assume it's a month and return the same day (or near) in
				// that month of the current year
				month = (parseInt(parts.shift(), 10) - 1) % 12;
				var today = new Date();
				var newDay = new Date(today.getFullYear(), month,
									  today.getDate());
				return newDay;
			} else {
				// Assume it's a year and return the same day (or near) of
				// that year
				year = parseInt(parts.shift(), 10);
				var today = new Date();
				var newDay = new Date(year, today.getMonth(), today.getDate());
				return newDay;
			}
		}

		if (parts.length != 3) {
			throw new Error("Format is 3 numbers separated by a non-digit");
		}

		var yearIndex = this.yearIndex;
		var monthIndex = this.monthIndex;
		var dayIndex = this.dayIndex;
		if (yearIndex < dayIndex && yearIndex < monthIndex) {
			// Year is first
			if (parts[0].length != 4) {
				return null;
			}
			year = parseInt(parts.shift(), 10);
		}
		if (dayIndex < monthIndex) {
			// TODO do some range checking
			// Specify radix of 10 since leading 0 can be interpreted as octal
			day = parseInt(parts.shift(), 10);
			month = parseInt(parts.shift(), 10);
		} else {
			// TODO do some range checking
			month = parseInt(parts.shift(), 10);
			day = parseInt(parts.shift(), 10);
		}
		if (yearIndex > dayIndex && yearIndex > monthIndex) {
			// Year is last
			if (parts[0].length != 4) {
				return null;
			}
			year = parseInt(parts.shift(), 10);
		}

		if (year == null || month == null || day == null) {
			return null;
		}
		// Convert to javascript month numbering
		month--;
		return new Date(year, month, day);
	}
});
