/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinter;

import java.io.IOException;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.prettyprinter.IWriterEraser;
import org.python.pydev.parser.prettyprinter.PrettyPrinterPrefs;

public class WriteState
implements IWriterEraser {
    private IWriterEraser writer;
    private PrettyPrinterPrefs prefs;
    private StringBuffer indentation = new StringBuffer();
    private FastStack<SimpleNode> stmtStack = new FastStack();
    public static final int INITIAL_STATE = -1;
    public static final int LAST_STATE_NEW_LINE = 0;
    public static final int LAST_STATE_INDENT = 1;
    public static final int LAST_STATE_WRITE = 2;
    private int lastWrite = 0;
    int lastState = -1;

    public WriteState(IWriterEraser writer, PrettyPrinterPrefs prefs) {
        this.writer = writer;
        this.prefs = prefs;
    }

    public int getIndentLen() {
        return this.indentation.length();
    }

    public String getIndentChars(int numberOfChars) {
        return this.indentation.toString().substring(this.indentation.length() - numberOfChars);
    }

    public void indent() {
        this.indentation.append(this.prefs.getIndent());
    }

    public void dedent() {
        int len = this.indentation.length();
        this.indentation.delete(len - this.prefs.getIndent().length(), len);
    }

    public void writeIndentString() throws IOException {
        this.lastState = 1;
        this.writer.write(this.prefs.getIndent());
        ++this.lastWrite;
    }

    public void writeIndent() throws IOException {
        this.lastState = 1;
        this.writer.write(this.indentation.toString());
        ++this.lastWrite;
    }

    public void writeNewLine() throws IOException {
        this.writeNewLine(true);
    }

    public boolean writeNewLine(boolean force) throws IOException {
        if (force || this.lastState == 2) {
            this.lastState = 0;
            this.writer.write(this.prefs.getNewLine());
            ++this.lastWrite;
            return true;
        }
        return false;
    }

    public void writeIndent(int i) throws IOException {
        this.lastState = 1;
        this.writeIndent();
        String indent = this.prefs.getIndent();
        int j = 0;
        while (j < i) {
            this.writer.write(indent);
            ++this.lastWrite;
            ++j;
        }
    }

    public void pushInStmt(SimpleNode node) {
        this.stmtStack.push((Object)node);
    }

    public SimpleNode popInStmt() {
        return (SimpleNode)this.stmtStack.pop();
    }

    public boolean inStmt() {
        return this.stmtStack.size() > 0;
    }

    public void eraseIndent() {
        if (this.indentation.toString().length() > 0) {
            this.writer.erase(this.prefs.getIndent());
        }
    }

    public void write(String o) {
        this.lastState = 2;
        this.writer.write(o);
        ++this.lastWrite;
    }

    public void erase(String o) {
        this.writer.erase(o);
    }

    public void pushTempBuffer() {
        this.writer.pushTempBuffer();
    }

    public String popTempBuffer() {
        return this.writer.popTempBuffer();
    }

    public boolean lastIsWrite() {
        return this.lastState == 2;
    }

    public boolean lastIsIndent() {
        return this.lastState == 1;
    }

    public boolean lastIsNewLine() {
        return this.lastState == 0;
    }

    public String toString() {
        return this.writer.toString();
    }

    public void writeWithoutChangingState(String string) {
        this.writer.write(string);
        ++this.lastWrite;
    }

    public int getLastWrite() {
        return this.lastWrite;
    }

    public void writeLinesAfterMethod() {
        int i = 0;
        while (i < this.prefs.getLinesAfterMethod()) {
            try {
                this.writeNewLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
    }

    public void writeLinesAfterClass() {
        int i = 0;
        while (i < this.prefs.getLinesAfterClass()) {
            try {
                this.writeNewLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
    }

    public void writeSpacesBeforeComment() {
        if (this.lastState == 2) {
            this.write(this.prefs.getSpacesBeforeComment());
        }
    }
}

