'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.11.1/tcllib-1.11.1/modules/simulation/montecarlo.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2008 Arjen Markus <arjenmarkus@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "simulation::montecarlo" n 0.1 simulation "Tcl Simulation Tools"
.BS
.SH NAME
simulation::montecarlo \- Monte Carlo simulations
.SH SYNOPSIS
package require \fBTcl  ?8.4?\fR
.sp
package require \fBsimulation::montecarlo  0.1\fR
.sp
package require \fBsimulation::random \fR
.sp
package require \fBmath::statistics \fR
.sp
\fB::simulation::montecarlo::getOption\fR \fIkeyword\fR
.sp
\fB::simulation::montecarlo::hasOption\fR \fIkeyword\fR
.sp
\fB::simulation::montecarlo::setOption\fR \fIkeyword\fR \fIvalue\fR
.sp
\fB::simulation::montecarlo::setTrialResult\fR \fIvalues\fR
.sp
\fB::simulation::montecarlo::setExpResult\fR \fIvalues\fR
.sp
\fB::simulation::montecarlo::getTrialResults\fR
.sp
\fB::simulation::montecarlo::getExpResult\fR
.sp
\fB::simulation::montecarlo::transposeData\fR \fIvalues\fR
.sp
\fB::simulation::montecarlo::integral2D\fR \fI...\fR
.sp
\fB::simulation::montecarlo::singleExperiment\fR \fIargs\fR
.sp
.BE
.SH DESCRIPTION
.PP
The technique of \fIMonte Carlo simulations\fR is basically simple:
.IP \(bu
generate random values for one or more parameters.
.IP \(bu
evaluate the model of some system you are interested in and record the
interesting results for each realisation of these parameters.
.IP \(bu
after a suitable number of such trials, deduce an overall characteristic
of the model.
.PP
You can think of a model of a network of computers, an ecosystem of some
kind or in fact anything that can be quantitatively described and has
some stochastic element in it.
.PP
The package \fIsimulation::montecarlo\fR offers a basic framework for
such a modelling technique:
.nf

#
# MC experiments:
# Determine the mean and median of a set of points and compare them
#
::simulation::montecarlo::singleExperiment -init {
    package require math::statistics

    set prng [::simulation::random::prng_Normal 0.0 1.0]
} -loop {
    set numbers {}
    for { set i 0 } { $i < [getOption samples] } { incr i } {
        lappend numbers [$prng]
    }
    set mean   [::math::statistics::mean $numbers]
    set median [::math::statistics::median $numbers] ;# ? Exists?
    setTrialResult [list $mean $median]
} -final {
    set result [getTrialResults]
    set means   {}
    set medians {}
    foreach r $result {
        foreach {m M} $r break
        lappend means   $m
        lappend medians $M
    }
    puts [getOption reportfile] "Correlation: [::math::statistics::corr $means $medians]"

} -trials 100 -samples 10 -verbose 1 -columns {Mean Median}

.fi
This example attemps to find out how well the median value and the mean
value of a random set of numbers correlate. Sometimes a median value is
a more robust characteristic than a mean value - especially if you have
a statistical distribution with "fat" tails.
.SH PROCEDURES
The package defines the following auxiliary procedures:
.TP
\fB::simulation::montecarlo::getOption\fR \fIkeyword\fR
Get the value of an option given as part of the \fIsingeExperiment\fR command.
.RS
.TP
string \fIkeyword\fR
Given keyword (without leading minus)
.RE
.sp
.TP
\fB::simulation::montecarlo::hasOption\fR \fIkeyword\fR
Returns 1 if the option is available, 0 if not.
.RS
.TP
string \fIkeyword\fR
Given keyword (without leading minus)
.RE
.sp
.TP
\fB::simulation::montecarlo::setOption\fR \fIkeyword\fR \fIvalue\fR
Set the value of the given option.
.RS
.TP
string \fIkeyword\fR
Given keyword (without leading minus)
.TP
string \fIvalue\fR
(New) value for the option
.RE
.sp
.TP
\fB::simulation::montecarlo::setTrialResult\fR \fIvalues\fR
Store the results of the trial for later analysis
.RS
.TP
list \fIvalues\fR
List of values to be stored
.RE
.sp
.TP
\fB::simulation::montecarlo::setExpResult\fR \fIvalues\fR
Set the results of the entire experiment (typically used in the final
phase).
.RS
.TP
list \fIvalues\fR
List of values to be stored
.RE
.sp
.TP
\fB::simulation::montecarlo::getTrialResults\fR
Get the results of all individual trials for analysis (typically used in
the final phase or after completion of the command).
.sp
.TP
\fB::simulation::montecarlo::getExpResult\fR
Get the results of the entire experiment (typically used in the final
phase or even after completion of the \fIsingleExperiment\fR command).
.sp
.TP
\fB::simulation::montecarlo::transposeData\fR \fIvalues\fR
Interchange columns and rows of a list of lists and return the result.
.RS
.TP
list \fIvalues\fR
List of lists of values
.RE
.PP
There are two main procedures: \fIintegral2D\fR and \fIsingleExperiment\fR.
.TP
\fB::simulation::montecarlo::integral2D\fR \fI...\fR
Integrate a function over a two-dimensional region using a Monte Carlo
approach.
.sp
Arguments PM
.sp
.TP
\fB::simulation::montecarlo::singleExperiment\fR \fIargs\fR
Iterate code over a number of trials and store the results. The
iteration is gouverned by parameters given via a list of
keyword-value pairs.
.RS
.TP
int \fIn\fR
List of keyword-value pairs, all of which are available
during the execution via the \fIgetOption\fR command.
.RE
.PP
The \fIsingleExperiment\fR command predefines the following
options:
.IP \(bu
\fI-init code\fR: code to be run at start up
.IP \(bu
\fI-loop body\fR: body of code that defines the computation to
be run time and again. The code should use \fIsetTrialResult\fR
to store the results of each trial (typically a list of numbers,
but the interpretation is up to the implementation). Note: Required keyword.
.IP \(bu
\fI-final code\fR: code to be run at the end
.IP \(bu
\fI-trials n\fR: number of trials in the experiment (required)
.IP \(bu
\fI-reportfile file\fR: opened file to send the output to (default: stdout)
.IP \(bu
\fI-verbose\fR: write the intermediate results (1) or not (0) (default: 0)
.IP \(bu
\fI-analysis proc\fR: either "none" (no automatic analysis), standard
(basic statistics of the trial results and a correlation matrix) or the
name of a procedure that will take care of the analysis.
.IP \(bu
\fI-columns list\fR: list of column names, useful for verbose output
and the analysis
.PP
Any other options can be used via the getOption procedure
in the body.
.SH TIPS
The procedure \fIsingleExperiment\fR works by constructing a
temporary procedure that does the actual work. It loops for the given
number of trials.
.PP
As it constructs a temporary procedure, local variables defined at the
start continue to exist in the loop.
.SH KEYWORDS
math, montecarlo simulation, stochastic modelling
.SH COPYRIGHT
.nf
Copyright (c) 2008 Arjen Markus <arjenmarkus@users.sourceforge.net>

.fi