%  Erzeugt Faltblaetter (zweiseitig mit 6 Spalten)
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{faltblat}

\DeclareOption*{%
  \PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions

\LoadClass[a4paper,12pt,landscape]{article}
\RequirePackage{german}

\setlength{\parindent}{0cm}
\setlength{\hoffset}{-2.54cm}
\setlength{\voffset}{-2.54cm}

% 1,5cm Fusssteg, 1 cm Kopfsteg
\setlength{\textheight}{17.5cm}
\setlength{\headheight}{0pt}
\setlength{\headsep}{0pt}
\setlength{\topmargin}{1.5cm}

% 1 cm vom linken Rand 
\setlength{\textwidth}{7.9cm}
\setlength{\oddsidemargin}{1cm}
\setlength{\evensidemargin}{1cm}
\emergencystretch=10pt

\pagestyle{empty}

% Boxen fr Gesamttext und sechs Spalten ein
\newsavebox\falt
\newbox\ba \newbox\bb \newbox\bc 
\newbox\bd \newbox\be \newbox\bf

% Der gesamte Dokumentinhalt soll in die Hauptbox
% gesteckt werden
\AtBeginDocument{\setbox\falt=\vbox\bgroup}

% Spalte Haupttext dann in 6 Spalten auf
\AtEndDocument{\egroup
\setbox\ba=\vsplit\falt to \textheight
\setbox\bb=\vsplit\falt to \textheight
\setbox\bc=\vsplit\falt to \textheight
\setbox\bd=\vsplit\falt to \textheight
\setbox\be=\vsplit\falt to \textheight
\setbox\bf=\vsplit\falt to \textheight

% Vorderseite enthlt Spalten 5, 6, 1
\hbox{\ifvoid\be\vbox{\strut}\else\box\be\fi
  \hspace{2cm}\ifvoid\bf\vbox{\strut}\else\box\bf\fi
  \hspace{2cm}\box\ba
  }
% Rckseite mit Spalten 2, 3, 4
\newpage
\hbox{\box\bb
  \hspace{2cm}\box\bc
  \hspace{2cm}\box\bd
  }
}