/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArrayMap
implements Map {
    Object[] array;
    int pairs;

    public ArrayMap() {
        this(10);
    }

    public ArrayMap(int size) {
        this.array = new Object[size * 2];
    }

    public ArrayMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    public void clear() {
        Arrays.fill(this.array, 0, this.pairs * 2, null);
        this.pairs = 0;
    }

    public boolean containsKey(Object key) {
        return this.findKey(key) != -1;
    }

    public boolean containsValue(Object value) {
        int i = 0;
        while (i < this.pairs) {
            if (value == null && this.array[i * 2 + 1] == null || value != null && value.equals(this.array[i * 2 + 1])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Set entrySet() {
        return new AbstractSet(){

            public void clear() {
                ArrayMap.this.clear();
            }

            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object val = ArrayMap.this.get(entry.getKey());
                return val == null ? entry.getValue() == null : val.equals(entry.getValue());
            }

            public Iterator iterator() {
                return new ArrayIterator();
            }

            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return ArrayMap.this.remove(((Map.Entry)o).getKey()) != null;
            }

            public int size() {
                return ArrayMap.this.pairs;
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArrayMap)) {
            return false;
        }
        ArrayMap otherMap = (ArrayMap)obj;
        if (otherMap.pairs != this.pairs) {
            return false;
        }
        int i = 0;
        while (i < this.pairs) {
            int index = otherMap.findKey(this.array[i * 2]);
            if (index == -1) {
                return false;
            }
            if (this.array[i * 2 + 1] == null && otherMap.array[index * 2 + 1] != null || this.array[i * 2 + 1] != null && !this.array[i * 2 + 1].equals(otherMap.array[index * 2 + 1])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int findKey(Object key) {
        int i = 0;
        while (i < this.pairs) {
            if (key.equals(this.array[i * 2])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object get(Object key) {
        int pair = this.findKey(key);
        if (pair == -1) {
            return null;
        }
        return this.array[pair * 2 + 1];
    }

    public int hashCode() {
        int result = 0;
        int i = 0;
        while (i < this.pairs) {
            result += this.array[i * 2].hashCode();
            if (this.array[i * 2 + 1] != null) {
                result += this.array[i * 2 + 1].hashCode();
            }
            ++i;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.pairs == 0;
    }

    public Set keySet() {
        return new AbstractSet(){

            public boolean contains(Object k) {
                return ArrayMap.this.containsKey(k);
            }

            public Iterator iterator() {
                return new Iterator(ArrayMap.this){
                    private Iterator i;
                    {
                        this.i = this$0.entrySet().iterator();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public Object next() {
                        return ((Map.Entry)this.i.next()).getKey();
                    }

                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            public int size() {
                return ArrayMap.this.size();
            }
        };
    }

    public Object put(Object key, Object value) {
        Object result = null;
        int i = 0;
        while (i < this.pairs) {
            if (key.equals(this.array[i * 2])) break;
            ++i;
        }
        if (i < this.pairs) {
            result = this.array[i * 2 + 1];
            this.array[i * 2 + 1] = value;
        } else {
            if (this.pairs * 2 == this.array.length) {
                Object[] newArray = new Object[this.array.length * 2];
                System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                this.array = newArray;
            }
            this.array[this.pairs * 2] = key;
            this.array[this.pairs * 2 + 1] = value;
            ++this.pairs;
        }
        return result;
    }

    public void putAll(Map t) {
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        int index = this.findKey(key);
        if (index == -1) {
            return null;
        }
        Object value = this.array[index * 2 + 1];
        this.array[index * 2] = this.array[(this.pairs - 1) * 2];
        this.array[index * 2 + 1] = this.array[(this.pairs - 1) * 2 + 1];
        this.array[(this.pairs - 1) * 2] = null;
        this.array[(this.pairs - 1) * 2 + 1] = null;
        --this.pairs;
        return value;
    }

    public int size() {
        return this.pairs;
    }

    public Collection values() {
        return new AbstractCollection(){

            public boolean contains(Object v) {
                return ArrayMap.this.containsValue(v);
            }

            public Iterator iterator() {
                return new Iterator(ArrayMap.this){
                    private Iterator i;
                    {
                        this.i = this$0.entrySet().iterator();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public Object next() {
                        return ((Map.Entry)this.i.next()).getValue();
                    }

                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            public int size() {
                return ArrayMap.this.size();
            }
        };
    }

    class Entry
    implements Map.Entry {
        int pairIndex;

        Entry(int index) {
            this.pairIndex = index;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == null) return false;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            if (!this.getKey().equals(other.getKey())) return false;
            if (this.getValue() == null) {
                if (other.getValue() == null) return true;
                return false;
            }
            boolean bl = this.getValue().equals(other.getValue());
            if (bl) return true;
            return false;
        }

        public Object getKey() {
            return ArrayMap.this.array[this.pairIndex * 2];
        }

        public Object getValue() {
            return ArrayMap.this.array[this.pairIndex * 2 + 1];
        }

        public int hashCode() {
            return this.getKey().hashCode() + (this.getValue() != null ? this.getValue().hashCode() : 17);
        }

        public Object setValue(Object value) {
            Object previous = ArrayMap.this.array[this.pairIndex * 2 + 1];
            ArrayMap.this.array[this.pairIndex * 2 + 1] = value;
            return previous;
        }
    }

    class ArrayIterator
    implements Iterator {
        int pairIndex = 0;

        ArrayIterator() {
        }

        public boolean hasNext() {
            return this.pairIndex < ArrayMap.this.pairs;
        }

        public Object next() {
            return new Entry(this.pairIndex++);
        }

        public void remove() {
            ArrayMap.this.remove(ArrayMap.this.array[(this.pairIndex - 1) * 2]);
        }
    }
}

