/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.gui;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import jde.debugger.JDEException;
import jde.debugger.gui.LVTreeNode;
import jde.debugger.gui.ReferenceModel;

class ObjectModel
extends ReferenceModel {
    private final ObjectReference m_value;
    private final DefaultTreeModel m_treeModel;

    ObjectModel(ObjectReference value, DefaultTreeModel treeModel) {
        if (null == value) {
            throw new IllegalArgumentException("Null value in constructor.");
        }
        if (null == treeModel) {
            throw new IllegalArgumentException("Null tree model in constructor.");
        }
        this.m_value = value;
        this.m_treeModel = treeModel;
    }

    int getChildCount() {
        return this.getFields().size();
    }

    boolean getAllowsChildren() {
        return true;
    }

    MutableTreeNode createChildAt(int index) throws JDEException {
        Field field = this.getFieldAt(index);
        Value value = this.m_value.getValue(field);
        MutableTreeNode node = LVTreeNode.makeTreeNode(field, value, this.m_treeModel);
        return node;
    }

    String getValue() {
        if (this.m_value instanceof StringReference) {
            StringReference string = (StringReference)this.m_value;
            return '\"' + string.value() + '\"';
        }
        return this.m_value.toString();
    }

    private List getFields() {
        ReferenceType refType = (ReferenceType)this.m_value.type();
        TreeSet<Field> fields = new TreeSet<Field>(new Comparator(){

            public int compare(Object o1, Object o2) {
                Field field1 = (Field)o1;
                Field field2 = (Field)o2;
                return field1.name().compareTo(field2.name());
            }
        });
        fields.addAll(refType.visibleFields());
        return new ArrayList(fields);
    }

    private Field getFieldAt(int index) {
        return (Field)this.getFields().get(index);
    }

    void updateChildren(TreeNode[] children) {
        TreeNode reloadParent = null;
        int index = 0;
        List fields = this.getFields();
        Iterator iter = this.getFields().iterator();
        while (iter.hasNext() && index < children.length) {
            Field field = (Field)iter.next();
            LVTreeNode node = ReferenceModel.asLVTreeNode(children[index]);
            if (null != node && node.getName().equals(field.name())) {
                node.setValue(this.m_value.getValue(field));
            } else {
                if (null != children[index] && null != children[index].getParent()) {
                    reloadParent = children[index].getParent();
                }
                children[index] = null;
            }
            ++index;
        }
        if (null != reloadParent) {
            this.m_treeModel.reload(reloadParent);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + "m_value=" + this.m_value + "," + "m_treeModel=" + this.m_treeModel + "]";
    }
}

