'\"
'\" Generated from file '' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "tcllib" n 1.11.1  "Tcl Standard Library"
.BS
.SH NAME
tcllib \- Tcl Standard Library
.SH DESCRIPTION
A collection of pure-Tcl utility modules for Tcl that provide a wide
variety of functionality, from implementations of standard data
structures to implementations of common networking protocols.  The
intent is to collect commonly used functions into a single library,
which users can rely on to be available and stable.
To locate a manual page for a package with "::", replace "::" with "_".
For example, the manual page for package "foo::bar" would be "foo_bar".
.SH MODULES
.TP
\fBaes\fR 1.0.1
Advanced Encryption Standard (AES) - Implementation of the AES block cipher
.TP
\fBasn\fR 0.8
ASN.1 processing - ASN.1 BER encoder/decoder
.TP
\fBautoproxy\fR 1.5.1
HTTP protocol helper modules - Automatic HTTP proxy usage and authentication
.TP
\fBbase32\fR 0.1
Base32 encoding - base32 standard encoding
.TP
\fBbase32::core\fR 0.1
Base32 encoding - Expanding basic base32 maps
.TP
\fBbase32::hex\fR 0.1
Base32 encoding - base32 extended hex encoding
.TP
\fBbase64\fR 2.4
Text encoding & decoding binary data - base64-encode/decode binary data
.TP
\fBbee\fR 0.1
BitTorrent - BitTorrent Serialization Format Encoder/Decoder
.TP
\fBbibtex\fR 0.5
bibtex - Parse bibtex files
.TP
\fBblowfish\fR 1.0.3
Blowfish Block Cipher - Implementation of the Blowfish block cipher
.TP
\fBcache::async\fR 0.3
In-memory caches - Asynchronous in-memory cache
.TP
\fBcksum\fR 1.1.2
Cyclic Redundancy Checks - Calculate a cksum(1) compatible checksum
.TP
\fBcmdline\fR 1.3.1
Command line and option processing - Procedures to process command lines and options.
.TP
\fBcomm\fR 4.5.7
Remote communication - A remote communication facility for Tcl (8.3 and later)
.TP
\fBcomm::wire\fR 3
Remote communication - The comm wire protocol
.TP
\fBcontrol\fR 0.1.3
Tcl Control Flow Commands - Procedures for control flow structures.
.TP
\fBcounter\fR 2.0.4
Counters and Histograms - Procedures for counters and histograms
.TP
\fBcrc16\fR 1.1.1
Cyclic Redundancy Checks - Perform a 16bit Cyclic Redundancy Check
.TP
\fBcrc32\fR 1.3
Cyclic Redundancy Checks - Perform a 32bit Cyclic Redundancy Check
.TP
\fBcsv\fR 0.7.1
CSV processing - Procedures to handle CSV data.
.TP
\fBdeleg::method\fR 0.2
Interpreter utilities - Creation of comm delegates (snit methods)
.TP
\fBdeleg::proc\fR 0.2
Interpreter utilities - Creation of comm delegates (procedures)
.TP
\fBdes\fR 1.1
Data Encryption Standard (DES) - Implementation of the DES and triple-DES ciphers
.TP
\fBdns\fR 1.3.3
Domain Name Service - Tcl Domain Name Service Client
.TP
\fBdocidx::intro\fR 1.0
Documentation tools - docidx introduction
.TP
\fBdocidx::lang::cmdref\fR 1.0
Documentation tools - docidx language command reference
.TP
\fBdocidx::lang::faq\fR 1.0
Documentation tools - docidx language faq
.TP
\fBdocidx::lang::intro\fR 1.0
Documentation tools - docidx language introduction
.TP
\fBdocidx::lang::syntax\fR 1.0
Documentation tools - docidx language syntax
.TP
\fBdocidx::plugin::apiref\fR 1.0
Documentation tools - docidx plugin API reference
.TP
\fBdocstrip\fR 1.2
Literate programming tool - Docstrip style source code extraction
.TP
\fBdocstrip::util\fR 1.2
Literate programming tool - Docstrip-related utilities
.TP
\fBdoctoc::intro\fR 1.0
Documentation tools - doctoc introduction
.TP
\fBdoctoc::lang::cmdref\fR 1.0
Documentation tools - doctoc language command reference
.TP
\fBdoctoc::lang::faq\fR 1.0
Documentation tools - doctoc language faq
.TP
\fBdoctoc::lang::intro\fR 1.0
Documentation tools - doctoc language introduction
.TP
\fBdoctoc::lang::syntax\fR 1.0
Documentation tools - doctoc language syntax
.TP
\fBdoctoc::plugin::apiref\fR 1.0
Documentation tools - doctoc plugin API reference
.TP
\fBdoctools\fR 1.4
Documentation tools - doctools - Processing documents
.TP
\fBdoctools::changelog\fR 1
Documentation tools - Processing text in Emacs ChangeLog format
.TP
\fBdoctools::cvs\fR 1
Documentation tools - Processing text in 'cvs log' format
.TP
\fBdoctools::idx\fR 1
Documentation tools - docidx - Processing indices
.TP
\fBdoctools::intro\fR 1.0
Documentation tools - doctools introduction
.TP
\fBdoctools::lang::cmdref\fR 1.0
Documentation tools - doctools language command reference
.TP
\fBdoctools::lang::faq\fR 1.0
Documentation tools - doctools language faq
.TP
\fBdoctools::lang::intro\fR 1.0
Documentation tools - doctools language introduction
.TP
\fBdoctools::lang::syntax\fR 1.0
Documentation tools - doctools language syntax
.TP
\fBdoctools::plugin::apiref\fR 1.0
Documentation tools - doctools plugin API reference
.TP
\fBdoctools::toc\fR 1
Documentation tools - doctoc - Processing tables of contents
.TP
\fBdtplite\fR 1.0
- Lightweight DocTools Markup Processor
.TP
\fBexif\fR 1.1.2
EXIF parsing - Tcl EXIF extracts and parses EXIF fields from digital images
.TP
\fBfileutil\fR 1.13.5
file utilities - Procedures implementing some file utilities
.TP
\fBfileutil::magic::cfront\fR 1.0
file utilities - Generator core for compiler of magic(5) files
.TP
\fBfileutil::magic::cgen\fR 1.0
file utilities - Generator core for compiler of magic(5) files
.TP
\fBfileutil::magic::filetype\fR 1.0.2
file utilities - Procedures implementing file-type recognition
.TP
\fBfileutil::magic::mimetype\fR 1.0.2
file utilities - Procedures implementing mime-type recognition
.TP
\fBfileutil::magic::rt\fR 1.0
file utilities - Runtime core for file type recognition engines written in pure Tcl
.TP
\fBfileutil::multi\fR 0.1
file utilities - Multi-file operation, scatter/gather, standard object
.TP
\fBfileutil::multi::op\fR 0.5.2
file utilities - Multi-file operation, scatter/gather
.TP
\fBfileutil::traverse\fR 0.4
file utilities - Iterative directory traversal
.TP
\fBftp\fR 2.4.9
ftp client - Client-side tcl implementation of the ftp protocol
.TP
\fBftp::geturl\fR 0.2.1
ftp client - Uri handler for ftp urls
.TP
\fBftpd\fR 1.2.4
Tcl FTP Server Package - Tcl FTP server implementation
.TP
\fBgrammar::fa\fR 0.3
Finite automaton operations and usage - Create and manipulate finite automatons
.TP
\fBgrammar::fa::dacceptor\fR 0.1.1
Finite automaton operations and usage - Create and use deterministic acceptors
.TP
\fBgrammar::fa::dexec\fR 0.2
Finite automaton operations and usage - Execute deterministic finite automatons
.TP
\fBgrammar::fa::op\fR 0.4
Finite automaton operations and usage - Operations on finite automatons
.TP
\fBgrammar::me::ast\fR 0.1
Grammar operations and usage - Various representations of ASTs
.TP
\fBgrammar::me::cpu\fR 0.2
Grammar operations and usage - Virtual machine implementation II for parsing token streams
.TP
\fBgrammar::me::cpu::core\fR 0.2
Grammar operations and usage - ME virtual machine state manipulation
.TP
\fBgrammar::me::cpu::gasm\fR 0.1
Grammar operations and usage - ME assembler
.TP
\fBgrammar::me::intro\fR 0.1
Grammar operations and usage - Introduction to virtual machines for parsing token streams
.TP
\fBgrammar::me::tcl\fR 0.1
Grammar operations and usage - Virtual machine implementation I for parsing token streams
.TP
\fBgrammar::me::util\fR 0.1
Grammar operations and usage - AST utilities
.TP
\fBgrammar::me::vm\fR 0.1
Grammar operations and usage - Virtual machine for parsing token streams
.TP
\fBgrammar::peg\fR 0.1
Grammar operations and usage - Create and manipulate parsing expression grammars
.TP
\fBgrammar::peg::interp\fR 0.1
Grammar operations and usage - Interpreter for parsing expression grammars
.TP
\fBhtml\fR 1.4
HTML Generation - Procedures to generate HTML structures
.TP
\fBhtmlparse\fR 1.1.3
HTML Parser - Procedures to parse HTML strings
.TP
\fBhuddle\fR 0.1.3
HUDDLE - Create and manipulate huddle object
.TP
\fBident\fR 0.42
Identification protocol client - Ident protocol client
.TP
\fBinifile\fR 0.2.3
Parsing of Windows INI files - Parsing of Windows INI files
.TP
\fBinterp\fR 0.1.1
Interpreter utilities - Interp creation and aliasing
.TP
\fBirc\fR 0.6.1
Low Level Tcl IRC Interface - Create IRC connection and interface.
.TP
\fBjavascript\fR 1.0.2
HTML and Java Script Generation - Procedures to generate HTML and Java Script structures.
.TP
\fBjpeg\fR 0.3.3
JPEG image manipulation - JPEG querying and manipulation of meta data
.TP
\fBjson\fR 1.0
JSON parser - JSON parser
.TP
\fBldap\fR 1.6.9
LDAP client - LDAP client
.TP
\fBldapx\fR 0.2.5
LDAP extended object interface - LDAP extended object interface
.TP
\fBlog\fR 1.2.1
Logging facility - Procedures to log messages of libraries and applications.
.TP
\fBlogger\fR 0.8
Object Oriented logging facility - System to control logging of events.
.TP
\fBlogger::appender\fR 1.2
Object Oriented logging facility - Collection of predefined appenders for logger
.TP
\fBlogger::utils\fR 1.3
Object Oriented logging facility - Utilities for logger
.TP
\fBmap::slippy\fR 0.2
Mapping utilities - Common code for slippy based map packages
.TP
\fBmap::slippy::cache\fR 0.2
Mapping utilities - Management of a tile cache in the local filesystem
.TP
\fBmap::slippy::fetcher\fR 0.2
Mapping utilities - Accessing a server providing tiles for slippy-based maps
.TP
\fBmapproj\fR 0.1
Tcl Library - Map projection routines
.TP
\fBmath\fR 1.2.4
Tcl Math Library - Tcl Math Library
.TP
\fBmath::bigfloat\fR 2.0.1
Tcl Math Library - Arbitrary precision floating-point numbers
.TP
\fBmath::bignum\fR 3.1
Tcl Math Library - Arbitrary precision integer numbers
.TP
\fBmath::calculus\fR 0.7.1
Tcl Math Library - Integration and ordinary differential equations
.TP
\fBmath::calculus::romberg\fR 0.6
Tcl Math Library - Romberg integration
.TP
\fBmath::combinatorics\fR 1.2.3
Tcl Math Library - Combinatorial functions in the Tcl Math Library
.TP
\fBmath::complexnumbers\fR 1.0.2
Tcl Math Library - Straightforward complex number package
.TP
\fBmath::constants\fR 1.0.1
Tcl Math Library - Mathematical and numerical constants
.TP
\fBmath::fourier\fR 1.0.2
Tcl Math Library - Discrete and fast fourier transforms
.TP
\fBmath::fuzzy\fR 0.2
Tcl Math Library - Fuzzy comparison of floating-point numbers
.TP
\fBmath::geometry\fR 1.0.3
Tcl Math Library - Geometrical computations
.TP
\fBmath::interpolate\fR 1.0.2
Tcl Math Library - Interpolation routines
.TP
\fBmath::linearalgebra\fR 1.1
Tcl Math Library - Linear Algebra
.TP
\fBmath::optimize\fR 1.0
Tcl Math Library - Optimisation routines
.TP
\fBmath::polynomials\fR 1.0.1
Tcl Math Library - Polynomial functions
.TP
\fBmath::rationalfunctions\fR 1.0.1
Math - Polynomial functions
.TP
\fBmath::roman\fR math
- Tools for creating and manipulating roman numerals
.TP
\fBmath::special\fR 0.2
Tcl Math Library - Special mathematical functions
.TP
\fBmath::statistics\fR 0.5
Tcl Math Library - Basic statistical functions and procedures
.TP
\fBmd4\fR 1.0.5
MD4 Message-Digest Algorithm - MD4 Message-Digest Algorithm
.TP
\fBmd5\fR 2.0.7
MD5 Message-Digest Algorithm - MD5 Message-Digest Algorithm
.TP
\fBmd5crypt\fR 1.1.0
MD5-based password encryption - MD5-based password encryption
.TP
\fBmime\fR 1.5.4
Mime - Manipulation of MIME body parts
.TP
\fBmpexpand\fR 1.0
Documentation toolbox - Markup processor
.TP
\fBmultiplexer\fR 0.2
One-to-many communication with sockets. - One-to-many communication with sockets.
.TP
\fBnameserv\fR 0.4.2
Name service facility - Name service facility, Client
.TP
\fBnameserv::auto\fR 0.3
Name service facility - Name service facility, Client Extension
.TP
\fBnameserv::common\fR 0.1
Name service facility - Name service facility, shared definitions
.TP
\fBnameserv::protocol\fR 0.1
Name service facility - Name service facility, client/server protocol
.TP
\fBnameserv::server\fR 0.3.2
Name service facility - Name service facility, Server
.TP
\fBncgi\fR 1.3
CGI Support - Procedures to manipulate CGI values.
.TP
\fBnmea\fR 0.1
NMEA protocol implementation - Process NMEA data
.TP
\fBnns::intro\fR 1.0
Name service facility - Name service facility, introduction
.TP
\fBnntp\fR 1.5.1
Tcl NNTP Client Library - Tcl client for the NNTP protocol
.TP
\fBntp::time\fR 1.2.1
Network Time Facilities - Tcl Time Service Client
.TP
\fBotp\fR 1.0.0
RFC 2289 A One-Time Password System - One-Time Passwords
.TP
\fBpage\fR 1.0
- Parser Generator
.TP
\fBpage::intro\fR 1.0
Parser generator tools - page introduction
.TP
\fBpage::pluginmgr\fR 1.0
Parser generator tools - page plugin manager
.TP
\fBpage::util::flow\fR 1.0
Parser generator tools - page dataflow/treewalker utility
.TP
\fBpage::util::norm::lemon\fR 1.0
Parser generator tools - page AST normalization, LEMON
.TP
\fBpage::util::norm::peg\fR 1.0
Parser generator tools - page AST normalization, PEG
.TP
\fBpage::util::peg\fR 1.0
Parser generator tools - page PEG transformation utilities
.TP
\fBpage::util::quote\fR 1.0
Parser generator tools - page character quoting utilities
.TP
\fBpicoirc\fR 0.5
Simple embeddable IRC interface - Small and simple embeddable IRC client.
.TP
\fBpluginmgr\fR 0.2
Plugin management - Manage a plugin
.TP
\fBpng\fR 0.1.2
Image manipulation - PNG querying and manipulation of meta data
.TP
\fBpop3\fR 1.6.3
Tcl POP3 Client Library - Tcl client for POP3 email protocol
.TP
\fBpop3d\fR 1.1.0
Tcl POP3 Server Package - Tcl POP3 server implementation
.TP
\fBpop3d::dbox\fR 1.0.2
Tcl POP3 Server Package - Simple mailbox database for pop3d
.TP
\fBpop3d::udb\fR 1.0.1
Tcl POP3 Server Package - Simple user database for pop3d
.TP
\fBprofiler\fR 0.3
Tcl Profiler - Tcl source code profiler
.TP
\fBrc4\fR 1.1.0
RC4 Stream Cipher - Impementation of the RC4 stream cipher
.TP
\fBrcs\fR 2.0.2
RCS low level utilities - RCS low level utilities
.TP
\fBreport\fR 0.3.1
Matrix reports - Create and manipulate report objects
.TP
\fBripemd128\fR 1.0.3
RIPEMD Message-Digest Algorithm - RIPEMD-128 Message-Digest Algorithm
.TP
\fBripemd160\fR 1.0.3
RIPEMD Message-Digest Algorithm - RIPEMD-160 Message-Digest Algorithm
.TP
\fBS3\fR 1.0.0
Amazon S3 Web Service Interface - Amazon S3 Web Service Interface
.TP
\fBSASL\fR 1.3.0
Simple Authentication and Security Layer (SASL) - Implementation of SASL mechanisms for Tcl
.TP
\fBsha1\fR 2.0.3
SHA-x Message-Digest Algorithm - SHA1 Message-Digest Algorithm
.TP
\fBsha256\fR 1.0.2
SHA-x Message-Digest Algorithm - SHA256 Message-Digest Algorithm
.TP
\fBsimulation::annealing\fR 0.2
Tcl Simulation Tools - Simulated annealing
.TP
\fBsimulation::montecarlo\fR 0.1
Tcl Simulation Tools - Monte Carlo simulations
.TP
\fBsimulation::random\fR 0.1
Tcl Simulation Tools - Pseudo-random number generators
.TP
\fBsmtp\fR 1.4.5
smtp client - Client-side tcl implementation of the smtp protocol
.TP
\fBsmtpd\fR 1.4
Tcl SMTP Server Package - Tcl SMTP server implementation
.TP
\fBsnit\fR 2.2.1
Snit's Not Incr Tcl, OO system - Snit's Not Incr Tcl
.TP
\fBsnitfaq\fR 2.2
Snit's Not Incr Tcl, OO system - Snit Frequently Asked Questions
.TP
\fBsoundex\fR 1.0
Soundex - Soundex
.TP
\fBstooop\fR 4.4.1
Simple Tcl Only Object Oriented Programming - Object oriented extension.
.TP
\fBstringprep\fR 1.0.0
Preparation of Internationalized Strings - Implementation of stringprep
.TP
\fBstringprep::data\fR 1.0.0
Preparation of Internationalized Strings - stringprep data tables, generated, internal
.TP
\fBstruct::disjointset\fR 1.0
Tcl Data Structures - Disjoint set data structure
.TP
\fBstruct::graph\fR 2.3
Tcl Data Structures - Create and manipulate directed graph objects
.TP
\fBstruct::graph v1\fR 1.2.1
Tcl Data Structures - Create and manipulate directed graph objects
.TP
\fBstruct::graph::op\fR 0.9
Tcl Data Structures - Operation for (un)directed graph objects
.TP
\fBstruct::list\fR 1.7
Tcl Data Structures - Procedures for manipulating lists
.TP
\fBstruct::matrix\fR 2.0.1
Tcl Data Structures - Create and manipulate matrix objects
.TP
\fBstruct::matrix v1\fR 1.2.1
Tcl Data Structures - Create and manipulate matrix objects
.TP
\fBstruct::pool\fR 1.2.1
Tcl Data Structures - Create and manipulate pool objects (of discrete items)
.TP
\fBstruct::prioqueue\fR 1.4
Tcl Data Structures - Create and manipulate prioqueue objects
.TP
\fBstruct::queue\fR 1.4.1
Tcl Data Structures - Create and manipulate queue objects
.TP
\fBstruct::record\fR 1.2.1
Tcl Data Structures - Define and create records (similar to 'C' structures)
.TP
\fBstruct::set\fR 2.2.3
Tcl Data Structures - Procedures for manipulating sets
.TP
\fBstruct::skiplist\fR 1.3
Tcl Data Structures - Create and manipulate skiplists
.TP
\fBstruct::stack\fR 1.3.3
Tcl Data Structures - Create and manipulate stack objects
.TP
\fBstruct::tree\fR 2.1.1
Tcl Data Structures - Create and manipulate tree objects
.TP
\fBstruct::tree v1\fR 1.2.2
Tcl Data Structures - Create and manipulate tree objects
.TP
\fBsum\fR 1.1.0
Cyclic Redundancy Checks - Calculate a sum(1) compatible checksum
.TP
\fBtar\fR 0.4
Tar file handling - Tar file creation, extraction & manipulation
.TP
\fBtcldocstrip\fR 1.0
- Tcl-based Docstrip Processor
.TP
\fBtcllib::ip\fR 1.1.2
Domain Name Service - IPv4 and IPv6 address manipulation
.TP
\fBterm\fR 0.1
Terminal control - General terminal control
.TP
\fBterm::ansi::code\fR 0.1
Terminal control - Helper for control sequences
.TP
\fBterm::ansi::code::attr\fR 0.1
Terminal control - ANSI attribute sequences
.TP
\fBterm::ansi::code::ctrl\fR 0.1
Terminal control - ANSI control sequences
.TP
\fBterm::ansi::code::macros\fR 0.1
Terminal control - Macro sequences
.TP
\fBterm::ansi::ctrl::unix\fR 0.1
Terminal control - Control operations and queries
.TP
\fBterm::ansi::send\fR 0.1
Terminal control - Output of ANSI control sequences to terminals
.TP
\fBterm::interact::menu\fR 0.1
Terminal control - Terminal widget, menu
.TP
\fBterm::interact::pager\fR 0.1
Terminal control - Terminal widget, paging
.TP
\fBterm::receive\fR 0.1
Terminal control - General input from terminals
.TP
\fBterm::receive::bind\fR 0.1
Terminal control - Keyboard dispatch from terminals
.TP
\fBterm::send\fR 0.1
Terminal control - General output to terminals
.TP
\fBtextutil\fR 0.7.1
Text and string utilities, macro processing - Procedures to manipulate texts and strings.
.TP
\fBtextutil::adjust\fR 0.7
Text and string utilities, macro processing - Procedures to adjust, indent, and undent paragraphs
.TP
\fBtextutil::expander\fR 1.3.1
Text and string utilities, macro processing - Procedures to process templates and expand text.
.TP
\fBtextutil::repeat\fR 0.7.1
Text and string utilities, macro processing - Procedures to repeat strings.
.TP
\fBtextutil::split\fR 0.7
Text and string utilities, macro processing - Procedures to split texts
.TP
\fBtextutil::string\fR 0.7
Text and string utilities, macro processing - Procedures to manipulate texts and strings.
.TP
\fBtextutil::tabify\fR 0.7
Text and string utilities, macro processing - Procedures to (un)tabify strings
.TP
\fBtextutil::trim\fR 0.7
Text and string utilities, macro processing - Procedures to trim strings
.TP
\fBtie\fR 1.1
Tcl Data Structures - Array persistence, standard data sources
.TP
\fBtie\fR 1.1
Tcl Data Structures - Array persistence
.TP
\fBtiff\fR 0.2.1
TIFF image manipulation - TIFF reading, writing, and querying and manipulation of meta data
.TP
\fBtransfer::connect\fR 0.1
Data transfer facilities - Connection setup
.TP
\fBtransfer::copy\fR 0.2
Data transfer facilities - Data transfer foundation
.TP
\fBtransfer::copy::queue\fR 0.1
Data transfer facilities - Queued transfers
.TP
\fBtransfer::data::destination\fR 0.1
Data transfer facilities - Data destination
.TP
\fBtransfer::data::source\fR 0.1
Data transfer facilities - Data source
.TP
\fBtransfer::receiver\fR 0.1
Data transfer facilities - Data source
.TP
\fBtransfer::transmitter\fR 0.1
Data transfer facilities - Data source
.TP
\fBtreeql\fR 1.3.1
Tree Query Language - Query tree objects
.TP
\fBuevent\fR 0.2
User events - User events
.TP
\fBuevent::onidle\fR 0.1
User events - Request merging and deferal to idle time
.TP
\fBunicode\fR 1.0.0
Unicode normalization - Implementation of Unicode normalization
.TP
\fBunicode::data\fR 1.0.0
Preparation of Internationalized Strings - unicode data tables, generated, internal
.TP
\fBunits\fR 1.2
Convert and manipulate quantities with units - unit conversion
.TP
\fBuri\fR 1.2.1
Tcl Uniform Resource Identifier Management - URI utilities
.TP
\fBuri::urn\fR 1.1.2
Tcl Uniform Resource Identifier Management - URI utilities, URN scheme
.TP
\fBuuencode\fR 1.1.4
Text encoding & decoding binary data - UU-encode/decode binary data
.TP
\fBuuid\fR 1.0.1
uuid - UUID generation and comparison
.TP
\fBwip\fR 2.1.1
Word Interpreter - Word Interpreter
.TP
\fBxsxp\fR 1.0
eXtremely Simple Xml Parser - eXtremely Simple Xml Parser
.TP
\fByaml\fR 0.3.3
YAML processing - YAML Format Encoder/Decoder
.TP
\fByencode\fR 1.1.2
Text encoding & decoding binary data - Y-encode/decode binary data
.PP