/***************************************************************************
                           cstringlist.h  -  description
                             -------------------
    begin                : Sat Jun 1 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSTRINGLIST_H
#define CSTRINGLIST_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cthread.h>
#include <dclib/core/clist.h>

class DLL_EXPORT CStringListObject : public CObject {
public:
	/** */
	CStringListObject() {
		m_pObject = 0;
	};
	/** */
	virtual ~CStringListObject() {};

	/** */
	CString m_s;
	/** */
	CObject * m_pObject;
};

class DLL_EXPORT CStringList : public CObject {
public: 
	/** */
	CStringList( int maxdepth = 0, int depth = 0 );
	/** */
	virtual ~CStringList();

	/** */
	int Add( const CString & s, CObject * object = 0 );
	/** */
	int Get( const CString & s, CObject *& object );
	/** */
	int Del( const CString & s, bool bdelobj = TRUE );
	/** */
	int Remove( const CString & s ) { return Del(s,FALSE); };
	/** */
	void Clear();
	/** */
	long Count() const;
	/** */
	int Next( CObject *& object );
	/** */
	int Next( CString & s, CObject *& object );
private:
	/** */
	int m_nDepth;
	/** */
	int m_nMaxDepth;
	/** */
	long m_nSize;
	/** */
	long m_nCachePos;
	/** */
	CStringListObject * m_nCacheObj;
	/** */
	CStringList ** m_pStringList;
	/** */
	CList<CStringListObject> ** m_pList;
};

/** */
inline long CStringList::Count() const
{ return m_nSize; }

class DLL_EXPORT CThreadStringList : public CStringList, public CThread {
public:
	/** */
	CThreadStringList( int depth = 0 ) : CStringList(depth) {};
	/** */
	virtual ~CThreadStringList() {};
};

#endif
