/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class StandardDrawing
extends CompositeFigure
implements Drawing {
    private transient Vector fListeners = new Vector(2);
    private transient Thread fDrawingLockHolder = null;
    private static final long serialVersionUID = -2602151437447962046L;
    private int drawingSerializedDataVersion = 1;

    public void addDrawingChangeListener(DrawingChangeListener drawingChangeListener) {
        this.fListeners.addElement(drawingChangeListener);
    }

    public void removeDrawingChangeListener(DrawingChangeListener drawingChangeListener) {
        this.fListeners.removeElement(drawingChangeListener);
    }

    public Enumeration drawingChangeListeners() {
        return this.fListeners.elements();
    }

    public synchronized Figure remove(Figure figure) {
        if (figure.listener() != null) {
            figure.listener().figureRequestRemove(new FigureChangeEvent(figure, null));
            return figure;
        }
        return null;
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        Figure figure = figureChangeEvent.getFigure();
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            figure.removeFromContainer(this);
            figure.release();
        } else {
            System.out.println("Attempt to remove non-existing figure");
        }
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener drawingChangeListener = (DrawingChangeListener)this.fListeners.elementAt(i);
                drawingChangeListener.drawingInvalidated(new DrawingChangeEvent(this, figureChangeEvent.getInvalidatedRectangle()));
            }
        }
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener drawingChangeListener = (DrawingChangeListener)this.fListeners.elementAt(i);
                drawingChangeListener.drawingRequestUpdate(new DrawingChangeEvent(this, null));
            }
        }
    }

    public Vector handles() {
        Vector<NullHandle> vector = new Vector<NullHandle>();
        vector.addElement(new NullHandle(this, RelativeLocator.northWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.northEast()));
        vector.addElement(new NullHandle(this, RelativeLocator.southWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.southEast()));
        return vector;
    }

    public Rectangle displayBox() {
        if (this.fFigures.size() > 0) {
            FigureEnumeration figureEnumeration = this.figures();
            Rectangle rectangle = figureEnumeration.nextFigure().displayBox();
            while (figureEnumeration.hasMoreElements()) {
                rectangle.add(figureEnumeration.nextFigure().displayBox());
            }
            return rectangle;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public void basicDisplayBox(Point point, Point point2) {
    }

    public synchronized void lock() {
        Thread thread = Thread.currentThread();
        if (this.fDrawingLockHolder == thread) {
            return;
        }
        while (this.fDrawingLockHolder != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fDrawingLockHolder = thread;
    }

    public synchronized void unlock() {
        if (this.fDrawingLockHolder != null) {
            this.fDrawingLockHolder = null;
            this.notifyAll();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.fListeners = new Vector(2);
    }
}

