//
// Register Declarations for Microchip 16F687 Processor
//
//
// This header file was automatically generated by:
//
//	inc2h.pl V4585
//
//	Copyright (c) 2002, Kevin L. Pauba, All Rights Reserved
//
//	SDCC is licensed under the GNU Public license (GPL) v2.  Note that
//	this license covers the code to the compiler and other executables,
//	but explicitly does not cover any code or objects generated by sdcc.
//	We have not yet decided on a license for the run time libraries, but
//	it will not put any requirements on code linked against it. See:
// 
//	http://www.gnu.org/copyleft/gpl/html
//
//	See http://sdcc.sourceforge.net/ for the latest information on sdcc.
//
// 
#ifndef P16F687_H
#define P16F687_H

//
// Register addresses.
//
#define INDF_ADDR	0x0000
#define TMR0_ADDR	0x0001
#define PCL_ADDR	0x0002
#define STATUS_ADDR	0x0003
#define FSR_ADDR	0x0004
#define PORTA_ADDR	0x0005
#define PORTB_ADDR	0x0006
#define PORTC_ADDR	0x0007
#define PCLATH_ADDR	0x000A
#define INTCON_ADDR	0x000B
#define PIR1_ADDR	0x000C
#define PIR2_ADDR	0x000D
#define TMR1L_ADDR	0x000E
#define TMR1H_ADDR	0x000F
#define T1CON_ADDR	0x0010
#define SSPBUF_ADDR	0x0013
#define SSPCON_ADDR	0x0014
#define RCSTA_ADDR	0x0018
#define TXREG_ADDR	0x0019
#define RCREG_ADDR	0x001A
#define ADRESH_ADDR	0x001E
#define ADCON0_ADDR	0x001F
#define OPTION_REG_ADDR	0x0081
#define TRISA_ADDR	0x0085
#define TRISB_ADDR	0x0086
#define TRISC_ADDR	0x0087
#define PIE1_ADDR	0x008C
#define PIE2_ADDR	0x008D
#define PCON_ADDR	0x008E
#define OSCCON_ADDR	0x008F
#define OSCTUNE_ADDR	0x0090
#define SSPADD_ADDR	0x0093
#define MSK_ADDR	0x0093
#define SSPMSK_ADDR	0x0093
#define SSPSTAT_ADDR	0x0094
#define WPU_ADDR	0x0095
#define WPUA_ADDR	0x0095
#define IOC_ADDR	0x0096
#define IOCA_ADDR	0x0096
#define WDTCON_ADDR	0x0097
#define TXSTA_ADDR	0x0098
#define SPBRG_ADDR	0x0099
#define SPBRGH_ADDR	0x009A
#define BAUDCTL_ADDR	0x009B
#define ADRESL_ADDR	0x009E
#define ADCON1_ADDR	0x009F
#define EEDAT_ADDR	0x010C
#define EEDATA_ADDR	0x010C
#define EEADR_ADDR	0x010D
#define EEDATH_ADDR	0x010E
#define EEADRH_ADDR	0x010F
#define WPUB_ADDR	0x0115
#define IOCB_ADDR	0x0116
#define VRCON_ADDR	0x0118
#define CM1CON0_ADDR	0x0119
#define CM2CON0_ADDR	0x011A
#define CM2CON1_ADDR	0x011B
#define ANSEL_ADDR	0x011E
#define ANSELH_ADDR	0x011F
#define EECON1_ADDR	0x018C
#define EECON2_ADDR	0x018D
#define SRCON_ADDR	0x019E

//
// Memory organization.
//



//         LIST
// P16F687.INC  Standard Header File, Version 1.00    Microchip Technology, Inc.
//         NOLIST

// This header file defines configurations, registers, and other useful bits of
// information for the PIC16F687 microcontroller.  These names are taken to match 
// the data sheets as closely as possible.  

// Note that the processor must be selected before this file is 
// included.  The processor may be selected the following ways:

//       1. Command line switch:
//               C:\ MPASM MYFILE.ASM /PIC16F687
//       2. LIST directive in the source file
//               LIST   P=PIC16F687
//       3. Processor Type entry in the MPASM full-screen interface

//==========================================================================
//
//       Revision History
//
//==========================================================================
//1.00   10/12/04 Original
//2.00	04/21/05 Modified to match released datasheet
//==========================================================================
//
//       Verify Processor
//
//==========================================================================

//        IFNDEF __16F687
//            MESSG "Processor-header file mismatch.  Verify selected processor."
//         ENDIF

//==========================================================================
//
//       Register Definitions
//
//==========================================================================

#define W                    0x0000
#define F                    0x0001

//----- Register Files------------------------------------------------------

extern __sfr  __at (INDF_ADDR)                    INDF;
extern __sfr  __at (TMR0_ADDR)                    TMR0;
extern __sfr  __at (PCL_ADDR)                     PCL;
extern __sfr  __at (STATUS_ADDR)                  STATUS;
extern __sfr  __at (FSR_ADDR)                     FSR;
extern __sfr  __at (PORTA_ADDR)                   PORTA;
extern __sfr  __at (PORTB_ADDR)                   PORTB;
extern __sfr  __at (PORTC_ADDR)                   PORTC;

extern __sfr  __at (PCLATH_ADDR)                  PCLATH;
extern __sfr  __at (INTCON_ADDR)                  INTCON;
extern __sfr  __at (PIR1_ADDR)                    PIR1;
extern __sfr  __at (PIR2_ADDR)                    PIR2;
extern __sfr  __at (TMR1L_ADDR)                   TMR1L;		
extern __sfr  __at (TMR1H_ADDR)                   TMR1H;		
extern __sfr  __at (T1CON_ADDR)                   T1CON;		


extern __sfr  __at (SSPBUF_ADDR)                  SSPBUF;
extern __sfr  __at (SSPCON_ADDR)                  SSPCON;


extern __sfr  __at (RCSTA_ADDR)                   RCSTA;
extern __sfr  __at (TXREG_ADDR)                   TXREG;		
extern __sfr  __at (RCREG_ADDR)                   RCREG;

extern __sfr  __at (ADRESH_ADDR)                  ADRESH;		
extern __sfr  __at (ADCON0_ADDR)                  ADCON0;		


extern __sfr  __at (OPTION_REG_ADDR)              OPTION_REG;

extern __sfr  __at (TRISA_ADDR)                   TRISA;
extern __sfr  __at (TRISB_ADDR)                   TRISB;
extern __sfr  __at (TRISC_ADDR)                   TRISC;

extern __sfr  __at (PIE1_ADDR)                    PIE1;
extern __sfr  __at (PIE2_ADDR)                    PIE2;
extern __sfr  __at (PCON_ADDR)                    PCON;
extern __sfr  __at (OSCCON_ADDR)                  OSCCON;
extern __sfr  __at (OSCTUNE_ADDR)                 OSCTUNE;

extern __sfr  __at (SSPADD_ADDR)                  SSPADD;
extern __sfr  __at (MSK_ADDR)                     MSK;
extern __sfr  __at (SSPMSK_ADDR)                  SSPMSK;
extern __sfr  __at (SSPSTAT_ADDR)                 SSPSTAT;
extern __sfr  __at (WPU_ADDR)                     WPU;
extern __sfr  __at (WPUA_ADDR)                    WPUA;
extern __sfr  __at (IOC_ADDR)                     IOC;
extern __sfr  __at (IOCA_ADDR)                    IOCA;
extern __sfr  __at (WDTCON_ADDR)                  WDTCON;
extern __sfr  __at (TXSTA_ADDR)                   TXSTA;
extern __sfr  __at (SPBRG_ADDR)                   SPBRG;
extern __sfr  __at (SPBRGH_ADDR)                  SPBRGH;	
extern __sfr  __at (BAUDCTL_ADDR)                 BAUDCTL;


extern __sfr  __at (ADRESL_ADDR)                  ADRESL;		
extern __sfr  __at (ADCON1_ADDR)                  ADCON1;


extern __sfr  __at (EEDAT_ADDR)                   EEDAT;
extern __sfr  __at (EEDATA_ADDR)                  EEDATA;
extern __sfr  __at (EEADR_ADDR)                   EEADR;
extern __sfr  __at (EEDATH_ADDR)                  EEDATH;
extern __sfr  __at (EEADRH_ADDR)                  EEADRH;


extern __sfr  __at (WPUB_ADDR)                    WPUB;
extern __sfr  __at (IOCB_ADDR)                    IOCB;

extern __sfr  __at (VRCON_ADDR)                   VRCON;
extern __sfr  __at (CM1CON0_ADDR)                 CM1CON0;
extern __sfr  __at (CM2CON0_ADDR)                 CM2CON0;
extern __sfr  __at (CM2CON1_ADDR)                 CM2CON1;

extern __sfr  __at (ANSEL_ADDR)                   ANSEL;
extern __sfr  __at (ANSELH_ADDR)                  ANSELH;

extern __sfr  __at (EECON1_ADDR)                  EECON1;
extern __sfr  __at (EECON2_ADDR)                  EECON2;


extern __sfr  __at (SRCON_ADDR)                   SRCON;



//----- BANK 0 REGISTER DEFINITIONS ----------------------------------------
//----- STATUS Bits --------------------------------------------------------


//----- INTCON Bits --------------------------------------------------------


//----- PIR1 Bits ----------------------------------------------------------




//----- PIR2 Bits ----------------------------------------------------------


//----- T1CON Bits ---------------------------------------------------------



//----- SSPCON Bits --------------------------------------------------------



//----- RCSTA Bits ---------------------------------------------------------



//----- ADCON0 Bits --------------------------------------------------------


//----- BANK 1 REGISTER DEFINITIONS ----------------------------------------
//----- OPTION Bits --------------------------------------------------------


//----- TRISA Bits --------------------------------------------------------


//----- TRISB Bits --------------------------------------------------------


//----- TRISC Bits --------------------------------------------------------


//----- PIE1 Bits ----------------------------------------------------------




//----- PIE2 Bits ----------------------------------------------------------


//----- PCON Bits ----------------------------------------------------------


//----- OSCCON Bits --------------------------------------------------------


//----- OSCTUNE Bits -------------------------------------------------------


//----- SSPSTAT Bits --------------------------------------------------------


//----- WPUA --------------------------------------------------------------



//----- IOC --------------------------------------------------------------


//----- IOCA --------------------------------------------------------------


//----- WDTCON Bits --------------------------------------------------------


//----- TXSTA Bits -------------------------------------------------------


//----- SPBRG Bits -------------------------------------------------------


//----- SPBRGH Bits -------------------------------------------------------


//----- BAUDCTL Bits -------------------------------------------------------




//----- ADCON1 -------------------------------------------------------------


//----- BANK 2 REGISTER DEFINITIONS ----------------------------------------
//----- WPUB Bits ----------------------------------------------------------


//----- IOCB --------------------------------------------------------------


//----- VRCON Bits ---------------------------------------------------------


//----- CM1CON0 Bits -------------------------------------------------------



//----- CM2CON0 Bits -------------------------------------------------------



//----- CM2CON1 Bits -------------------------------------------------------


//----- ANSELH -------------------------------------------------------------


//----- ANSEL --------------------------------------------------------------


//----- BANK 3 REGISTER DEFINITIONS ----------------------------------------
//----- EECON1 -------------------------------------------------------------


//----- SRCON ---------------------------------------------------------------


//==========================================================================
//
//       RAM Definition
//
//==========================================================================

//         __MAXRAM H'1FF'
//         __BADRAM H'08'-H'09', H'11'-H'12', H'15'-H'17', H'1B'- H'1D'
//         __BADRAM H'88'-H'89', H'91'-H'92', H'9C'-H'9D', H'C0'-H'EF'
//         __BADRAM H'108'-H'109', H'10E'-H'114', H'117', H'11C'-H'11D', H'120'-H'16F'
//         __BADRAM H'188'-H'189', H'18E'-H'19D', H'19F'-H'1EF'

//==========================================================================
//
//       Configuration Bits
//
//==========================================================================

#define _FCMEN_ON            0x3FFF
#define _FCMEN_OFF           0x37FF
#define _IESO_ON             0x3FFF
#define _IESO_OFF            0x3BFF
#define _BOR_ON              0x3FFF
#define _BOR_NSLEEP          0x3EFF
#define _BOR_SBODEN          0x3DFF
#define _BOR_OFF             0x3CFF
#define _CPD_ON              0x3F7F
#define _CPD_OFF             0x3FFF
#define _CP_ON               0x3FBF
#define _CP_OFF              0x3FFF
#define _MCLRE_ON            0x3FFF
#define _MCLRE_OFF           0x3FDF
#define _PWRTE_OFF           0x3FFF
#define _PWRTE_ON            0x3FEF
#define _WDT_ON              0x3FFF
#define _WDT_OFF             0x3FF7
#define _LP_OSC              0x3FF8
#define _XT_OSC              0x3FF9
#define _HS_OSC              0x3FFA
#define _EC_OSC              0x3FFB
#define _INTRC_OSC_NOCLKOUT  0x3FFC
#define _INTRC_OSC_CLKOUT    0x3FFD
#define _EXTRC_OSC_NOCLKOUT  0x3FFE
#define _EXTRC_OSC_CLKOUT    0x3FFF
#define _INTOSCIO            0x3FFC
#define _INTOSC              0x3FFD
#define _EXTRCIO             0x3FFE
#define _EXTRC               0x3FFF

//         LIST

// ----- ADCON0 bits --------------------
typedef union {
  struct {
    unsigned char ADON:1;
    unsigned char GO:1;
    unsigned char CHS0:1;
    unsigned char CHS1:1;
    unsigned char CHS2:1;
    unsigned char CHS3:1;
    unsigned char VCFG:1;
    unsigned char ADFM:1;
  };
  struct {
    unsigned char :1;
    unsigned char NOT_DONE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char GO_DONE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __ADCON0_bits_t;
extern volatile __ADCON0_bits_t __at(ADCON0_ADDR) ADCON0_bits;

#define ADON                 ADCON0_bits.ADON
#define GO                   ADCON0_bits.GO
#define NOT_DONE             ADCON0_bits.NOT_DONE
#define GO_DONE              ADCON0_bits.GO_DONE
#define CHS0                 ADCON0_bits.CHS0
#define CHS1                 ADCON0_bits.CHS1
#define CHS2                 ADCON0_bits.CHS2
#define CHS3                 ADCON0_bits.CHS3
#define VCFG                 ADCON0_bits.VCFG
#define ADFM                 ADCON0_bits.ADFM

// ----- ADCON1 bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char ADCS0:1;
    unsigned char ADCS1:1;
    unsigned char ADCS2:1;
    unsigned char :1;
  };
} __ADCON1_bits_t;
extern volatile __ADCON1_bits_t __at(ADCON1_ADDR) ADCON1_bits;

#define ADCS0                ADCON1_bits.ADCS0
#define ADCS1                ADCON1_bits.ADCS1
#define ADCS2                ADCON1_bits.ADCS2

// ----- ANSEL bits --------------------
typedef union {
  struct {
    unsigned char ANS0:1;
    unsigned char ANS1:1;
    unsigned char ANS2:1;
    unsigned char ANS3:1;
    unsigned char ANS4:1;
    unsigned char ANS5:1;
    unsigned char ANS6:1;
    unsigned char ANS7:1;
  };
} __ANSEL_bits_t;
extern volatile __ANSEL_bits_t __at(ANSEL_ADDR) ANSEL_bits;

#define ANS0                 ANSEL_bits.ANS0
#define ANS1                 ANSEL_bits.ANS1
#define ANS2                 ANSEL_bits.ANS2
#define ANS3                 ANSEL_bits.ANS3
#define ANS4                 ANSEL_bits.ANS4
#define ANS5                 ANSEL_bits.ANS5
#define ANS6                 ANSEL_bits.ANS6
#define ANS7                 ANSEL_bits.ANS7

// ----- ANSELH bits --------------------
typedef union {
  struct {
    unsigned char ANS8:1;
    unsigned char ANS9:1;
    unsigned char ANS10:1;
    unsigned char ANS11:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __ANSELH_bits_t;
extern volatile __ANSELH_bits_t __at(ANSELH_ADDR) ANSELH_bits;

#define ANS8                 ANSELH_bits.ANS8
#define ANS9                 ANSELH_bits.ANS9
#define ANS10                ANSELH_bits.ANS10
#define ANS11                ANSELH_bits.ANS11

// ----- BAUDCTL bits --------------------
typedef union {
  struct {
    unsigned char ABDEN:1;
    unsigned char WUE:1;
    unsigned char :1;
    unsigned char BRG16:1;
    unsigned char SCKP:1;
    unsigned char :1;
    unsigned char RCIDL:1;
    unsigned char ABDOVF:1;
  };
} __BAUDCTL_bits_t;
extern volatile __BAUDCTL_bits_t __at(BAUDCTL_ADDR) BAUDCTL_bits;

#define ABDEN                BAUDCTL_bits.ABDEN
#define WUE                  BAUDCTL_bits.WUE
#define BRG16                BAUDCTL_bits.BRG16
#define SCKP                 BAUDCTL_bits.SCKP
#define RCIDL                BAUDCTL_bits.RCIDL
#define ABDOVF               BAUDCTL_bits.ABDOVF

// ----- CM1CON0 bits --------------------
typedef union {
  struct {
    unsigned char C1CH0:1;
    unsigned char C1CH1:1;
    unsigned char C1R:1;
    unsigned char :1;
    unsigned char C1POL:1;
    unsigned char C1OE:1;
    unsigned char C1OUT:1;
    unsigned char C1ON:1;
  };
} __CM1CON0_bits_t;
extern volatile __CM1CON0_bits_t __at(CM1CON0_ADDR) CM1CON0_bits;

#define C1CH0                CM1CON0_bits.C1CH0
#define C1CH1                CM1CON0_bits.C1CH1
#define C1R                  CM1CON0_bits.C1R
#define C1POL                CM1CON0_bits.C1POL
#define C1OE                 CM1CON0_bits.C1OE
#define C1OUT                CM1CON0_bits.C1OUT
#define C1ON                 CM1CON0_bits.C1ON

// ----- CM2CON0 bits --------------------
typedef union {
  struct {
    unsigned char C2CH0:1;
    unsigned char C2CH1:1;
    unsigned char C2R:1;
    unsigned char :1;
    unsigned char C2POL:1;
    unsigned char C2OE:1;
    unsigned char C2OUT:1;
    unsigned char C2ON:1;
  };
} __CM2CON0_bits_t;
extern volatile __CM2CON0_bits_t __at(CM2CON0_ADDR) CM2CON0_bits;

#define C2CH0                CM2CON0_bits.C2CH0
#define C2CH1                CM2CON0_bits.C2CH1
#define C2R                  CM2CON0_bits.C2R
#define C2POL                CM2CON0_bits.C2POL
#define C2OE                 CM2CON0_bits.C2OE
#define C2OUT                CM2CON0_bits.C2OUT
#define C2ON                 CM2CON0_bits.C2ON

// ----- CM2CON1 bits --------------------
typedef union {
  struct {
    unsigned char C2SYNC:1;
    unsigned char T1GSS:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char MC2OUT:1;
    unsigned char MC1OUT:1;
  };
} __CM2CON1_bits_t;
extern volatile __CM2CON1_bits_t __at(CM2CON1_ADDR) CM2CON1_bits;

#define C2SYNC               CM2CON1_bits.C2SYNC
#define T1GSS                CM2CON1_bits.T1GSS
#define MC2OUT               CM2CON1_bits.MC2OUT
#define MC1OUT               CM2CON1_bits.MC1OUT

// ----- EECON1 bits --------------------
typedef union {
  struct {
    unsigned char RD:1;
    unsigned char WR:1;
    unsigned char WREN:1;
    unsigned char WRERR:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char EEPGD:1;
  };
} __EECON1_bits_t;
extern volatile __EECON1_bits_t __at(EECON1_ADDR) EECON1_bits;

#define RD                   EECON1_bits.RD
#define WR                   EECON1_bits.WR
#define WREN                 EECON1_bits.WREN
#define WRERR                EECON1_bits.WRERR
#define EEPGD                EECON1_bits.EEPGD

// ----- INTCON bits --------------------
typedef union {
  struct {
    unsigned char RABIF:1;
    unsigned char INTF:1;
    unsigned char T0IF:1;
    unsigned char RABIE:1;
    unsigned char INTE:1;
    unsigned char T0IE:1;
    unsigned char PEIE:1;
    unsigned char GIE:1;
  };
} __INTCON_bits_t;
extern volatile __INTCON_bits_t __at(INTCON_ADDR) INTCON_bits;

#define RABIF                INTCON_bits.RABIF
#define INTF                 INTCON_bits.INTF
#define T0IF                 INTCON_bits.T0IF
#define RABIE                INTCON_bits.RABIE
#define INTE                 INTCON_bits.INTE
#define T0IE                 INTCON_bits.T0IE
#define PEIE                 INTCON_bits.PEIE
#define GIE                  INTCON_bits.GIE

// ----- IOC bits --------------------
typedef union {
  struct {
    unsigned char IOC0:1;
    unsigned char IOC1:1;
    unsigned char IOC2:1;
    unsigned char IOC3:1;
    unsigned char IOC4:1;
    unsigned char IOC5:1;
    unsigned char :1;
    unsigned char :1;
  };
} __IOC_bits_t;
extern volatile __IOC_bits_t __at(IOC_ADDR) IOC_bits;

#define IOC0                 IOC_bits.IOC0
#define IOC1                 IOC_bits.IOC1
#define IOC2                 IOC_bits.IOC2
#define IOC3                 IOC_bits.IOC3
#define IOC4                 IOC_bits.IOC4
#define IOC5                 IOC_bits.IOC5

// ----- IOCA bits --------------------
typedef union {
  struct {
    unsigned char IOCA0:1;
    unsigned char IOCA1:1;
    unsigned char IOCA2:1;
    unsigned char IOCA3:1;
    unsigned char IOCA4:1;
    unsigned char IOCA5:1;
    unsigned char :1;
    unsigned char :1;
  };
} __IOCA_bits_t;
extern volatile __IOCA_bits_t __at(IOCA_ADDR) IOCA_bits;

#define IOCA0                IOCA_bits.IOCA0
#define IOCA1                IOCA_bits.IOCA1
#define IOCA2                IOCA_bits.IOCA2
#define IOCA3                IOCA_bits.IOCA3
#define IOCA4                IOCA_bits.IOCA4
#define IOCA5                IOCA_bits.IOCA5

// ----- IOCB bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char IOCB4:1;
    unsigned char IOCB5:1;
    unsigned char IOCB6:1;
    unsigned char IOCB7:1;
  };
} __IOCB_bits_t;
extern volatile __IOCB_bits_t __at(IOCB_ADDR) IOCB_bits;

#define IOCB4                IOCB_bits.IOCB4
#define IOCB5                IOCB_bits.IOCB5
#define IOCB6                IOCB_bits.IOCB6
#define IOCB7                IOCB_bits.IOCB7

// ----- OPTION_REG bits --------------------
typedef union {
  struct {
    unsigned char PS0:1;
    unsigned char PS1:1;
    unsigned char PS2:1;
    unsigned char PSA:1;
    unsigned char T0SE:1;
    unsigned char T0CS:1;
    unsigned char INTEDG:1;
    unsigned char NOT_RABPU:1;
  };
} __OPTION_REG_bits_t;
extern volatile __OPTION_REG_bits_t __at(OPTION_REG_ADDR) OPTION_REG_bits;

#define PS0                  OPTION_REG_bits.PS0
#define PS1                  OPTION_REG_bits.PS1
#define PS2                  OPTION_REG_bits.PS2
#define PSA                  OPTION_REG_bits.PSA
#define T0SE                 OPTION_REG_bits.T0SE
#define T0CS                 OPTION_REG_bits.T0CS
#define INTEDG               OPTION_REG_bits.INTEDG
#define NOT_RABPU            OPTION_REG_bits.NOT_RABPU

// ----- OSCCON bits --------------------
typedef union {
  struct {
    unsigned char SCS:1;
    unsigned char LTS:1;
    unsigned char HTS:1;
    unsigned char OSTS:1;
    unsigned char IRCF0:1;
    unsigned char IRCF1:1;
    unsigned char IRCF2:1;
    unsigned char :1;
  };
} __OSCCON_bits_t;
extern volatile __OSCCON_bits_t __at(OSCCON_ADDR) OSCCON_bits;

#define SCS                  OSCCON_bits.SCS
#define LTS                  OSCCON_bits.LTS
#define HTS                  OSCCON_bits.HTS
#define OSTS                 OSCCON_bits.OSTS
#define IRCF0                OSCCON_bits.IRCF0
#define IRCF1                OSCCON_bits.IRCF1
#define IRCF2                OSCCON_bits.IRCF2

// ----- OSCTUNE bits --------------------
typedef union {
  struct {
    unsigned char TUN0:1;
    unsigned char TUN1:1;
    unsigned char TUN2:1;
    unsigned char TUN3:1;
    unsigned char TUN4:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __OSCTUNE_bits_t;
extern volatile __OSCTUNE_bits_t __at(OSCTUNE_ADDR) OSCTUNE_bits;

#define TUN0                 OSCTUNE_bits.TUN0
#define TUN1                 OSCTUNE_bits.TUN1
#define TUN2                 OSCTUNE_bits.TUN2
#define TUN3                 OSCTUNE_bits.TUN3
#define TUN4                 OSCTUNE_bits.TUN4

// ----- PCON bits --------------------
typedef union {
  struct {
    unsigned char NOT_BOR:1;
    unsigned char NOT_POR:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char SBOREN:1;
    unsigned char ULPWUE:1;
    unsigned char :1;
    unsigned char :1;
  };
} __PCON_bits_t;
extern volatile __PCON_bits_t __at(PCON_ADDR) PCON_bits;

#define NOT_BOR              PCON_bits.NOT_BOR
#define NOT_POR              PCON_bits.NOT_POR
#define SBOREN               PCON_bits.SBOREN
#define ULPWUE               PCON_bits.ULPWUE

// ----- PIE1 bits --------------------
typedef union {
  struct {
    unsigned char T1IE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char SSPIE:1;
    unsigned char TXIE:1;
    unsigned char RCIE:1;
    unsigned char ADIE:1;
    unsigned char :1;
  };
  struct {
    unsigned char TMR1IE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __PIE1_bits_t;
extern volatile __PIE1_bits_t __at(PIE1_ADDR) PIE1_bits;

#define T1IE                 PIE1_bits.T1IE
#define TMR1IE               PIE1_bits.TMR1IE
#define SSPIE                PIE1_bits.SSPIE
#define TXIE                 PIE1_bits.TXIE
#define RCIE                 PIE1_bits.RCIE
#define ADIE                 PIE1_bits.ADIE

// ----- PIE2 bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char EEIE:1;
    unsigned char C1IE:1;
    unsigned char C2IE:1;
    unsigned char OSFIE:1;
  };
} __PIE2_bits_t;
extern volatile __PIE2_bits_t __at(PIE2_ADDR) PIE2_bits;

#define EEIE                 PIE2_bits.EEIE
#define C1IE                 PIE2_bits.C1IE
#define C2IE                 PIE2_bits.C2IE
#define OSFIE                PIE2_bits.OSFIE

// ----- PIR1 bits --------------------
typedef union {
  struct {
    unsigned char T1IF:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char SSPIF:1;
    unsigned char TXIF:1;
    unsigned char RCIF:1;
    unsigned char ADIF:1;
    unsigned char :1;
  };
  struct {
    unsigned char TMR1IF:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __PIR1_bits_t;
extern volatile __PIR1_bits_t __at(PIR1_ADDR) PIR1_bits;

#define T1IF                 PIR1_bits.T1IF
#define TMR1IF               PIR1_bits.TMR1IF
#define SSPIF                PIR1_bits.SSPIF
#define TXIF                 PIR1_bits.TXIF
#define RCIF                 PIR1_bits.RCIF
#define ADIF                 PIR1_bits.ADIF

// ----- PIR2 bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char EEIF:1;
    unsigned char C1IF:1;
    unsigned char C2IF:1;
    unsigned char OSFIF:1;
  };
} __PIR2_bits_t;
extern volatile __PIR2_bits_t __at(PIR2_ADDR) PIR2_bits;

#define EEIF                 PIR2_bits.EEIF
#define C1IF                 PIR2_bits.C1IF
#define C2IF                 PIR2_bits.C2IF
#define OSFIF                PIR2_bits.OSFIF

// ----- PORTA bits --------------------
typedef union {
  struct {
    unsigned char RA0:1;
    unsigned char RA1:1;
    unsigned char RA2:1;
    unsigned char RA3:1;
    unsigned char RA4:1;
    unsigned char RA5:1;
    unsigned char :1;
    unsigned char :1;
  };
} __PORTA_bits_t;
extern volatile __PORTA_bits_t __at(PORTA_ADDR) PORTA_bits;

#define RA0                  PORTA_bits.RA0
#define RA1                  PORTA_bits.RA1
#define RA2                  PORTA_bits.RA2
#define RA3                  PORTA_bits.RA3
#define RA4                  PORTA_bits.RA4
#define RA5                  PORTA_bits.RA5

// ----- PORTB bits --------------------
typedef union {
  struct {
    unsigned char RB0:1;
    unsigned char RB1:1;
    unsigned char RB2:1;
    unsigned char RB3:1;
    unsigned char RB4:1;
    unsigned char RB5:1;
    unsigned char RB6:1;
    unsigned char RB7:1;
  };
} __PORTB_bits_t;
extern volatile __PORTB_bits_t __at(PORTB_ADDR) PORTB_bits;

#define RB0                  PORTB_bits.RB0
#define RB1                  PORTB_bits.RB1
#define RB2                  PORTB_bits.RB2
#define RB3                  PORTB_bits.RB3
#define RB4                  PORTB_bits.RB4
#define RB5                  PORTB_bits.RB5
#define RB6                  PORTB_bits.RB6
#define RB7                  PORTB_bits.RB7

// ----- PORTC bits --------------------
typedef union {
  struct {
    unsigned char RC0:1;
    unsigned char RC1:1;
    unsigned char RC2:1;
    unsigned char RC3:1;
    unsigned char RC4:1;
    unsigned char RC5:1;
    unsigned char RC6:1;
    unsigned char RC7:1;
  };
} __PORTC_bits_t;
extern volatile __PORTC_bits_t __at(PORTC_ADDR) PORTC_bits;

#define RC0                  PORTC_bits.RC0
#define RC1                  PORTC_bits.RC1
#define RC2                  PORTC_bits.RC2
#define RC3                  PORTC_bits.RC3
#define RC4                  PORTC_bits.RC4
#define RC5                  PORTC_bits.RC5
#define RC6                  PORTC_bits.RC6
#define RC7                  PORTC_bits.RC7

// ----- RCSTA bits --------------------
typedef union {
  struct {
    unsigned char RX9D:1;
    unsigned char OERR:1;
    unsigned char FERR:1;
    unsigned char ADDEN:1;
    unsigned char CREN:1;
    unsigned char SREN:1;
    unsigned char RX9:1;
    unsigned char SPEN:1;
  };
} __RCSTA_bits_t;
extern volatile __RCSTA_bits_t __at(RCSTA_ADDR) RCSTA_bits;

#define RX9D                 RCSTA_bits.RX9D
#define OERR                 RCSTA_bits.OERR
#define FERR                 RCSTA_bits.FERR
#define ADDEN                RCSTA_bits.ADDEN
#define CREN                 RCSTA_bits.CREN
#define SREN                 RCSTA_bits.SREN
#define RX9                  RCSTA_bits.RX9
#define SPEN                 RCSTA_bits.SPEN

// ----- SPBRG bits --------------------
typedef union {
  struct {
    unsigned char BRG0:1;
    unsigned char BRG1:1;
    unsigned char BRG2:1;
    unsigned char BRG3:1;
    unsigned char BRG4:1;
    unsigned char BRG5:1;
    unsigned char BRG6:1;
    unsigned char BRG7:1;
  };
} __SPBRG_bits_t;
extern volatile __SPBRG_bits_t __at(SPBRG_ADDR) SPBRG_bits;

#define BRG0                 SPBRG_bits.BRG0
#define BRG1                 SPBRG_bits.BRG1
#define BRG2                 SPBRG_bits.BRG2
#define BRG3                 SPBRG_bits.BRG3
#define BRG4                 SPBRG_bits.BRG4
#define BRG5                 SPBRG_bits.BRG5
#define BRG6                 SPBRG_bits.BRG6
#define BRG7                 SPBRG_bits.BRG7

// ----- SPBRGH bits --------------------
typedef union {
  struct {
    unsigned char BRG8:1;
    unsigned char BRG9:1;
    unsigned char BRG10:1;
    unsigned char BRG11:1;
    unsigned char BRG12:1;
    unsigned char BRG13:1;
    unsigned char BRG14:1;
    unsigned char BRG15:1;
  };
} __SPBRGH_bits_t;
extern volatile __SPBRGH_bits_t __at(SPBRGH_ADDR) SPBRGH_bits;

#define BRG8                 SPBRGH_bits.BRG8
#define BRG9                 SPBRGH_bits.BRG9
#define BRG10                SPBRGH_bits.BRG10
#define BRG11                SPBRGH_bits.BRG11
#define BRG12                SPBRGH_bits.BRG12
#define BRG13                SPBRGH_bits.BRG13
#define BRG14                SPBRGH_bits.BRG14
#define BRG15                SPBRGH_bits.BRG15

// ----- SRCON bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char PULSR:1;
    unsigned char PULSS:1;
    unsigned char C2REN:1;
    unsigned char C1SEN:1;
    unsigned char SR0:1;
    unsigned char SR1:1;
  };
} __SRCON_bits_t;
extern volatile __SRCON_bits_t __at(SRCON_ADDR) SRCON_bits;

#define PULSR                SRCON_bits.PULSR
#define PULSS                SRCON_bits.PULSS
#define C2REN                SRCON_bits.C2REN
#define C1SEN                SRCON_bits.C1SEN
#define SR0                  SRCON_bits.SR0
#define SR1                  SRCON_bits.SR1

// ----- SSPCON bits --------------------
typedef union {
  struct {
    unsigned char SSPM0:1;
    unsigned char SSPM1:1;
    unsigned char SSPM2:1;
    unsigned char SSPM3:1;
    unsigned char CKP:1;
    unsigned char SSPEN:1;
    unsigned char SSPOV:1;
    unsigned char WCOL:1;
  };
} __SSPCON_bits_t;
extern volatile __SSPCON_bits_t __at(SSPCON_ADDR) SSPCON_bits;

#define SSPM0                SSPCON_bits.SSPM0
#define SSPM1                SSPCON_bits.SSPM1
#define SSPM2                SSPCON_bits.SSPM2
#define SSPM3                SSPCON_bits.SSPM3
#define CKP                  SSPCON_bits.CKP
#define SSPEN                SSPCON_bits.SSPEN
#define SSPOV                SSPCON_bits.SSPOV
#define WCOL                 SSPCON_bits.WCOL

// ----- SSPSTAT bits --------------------
typedef union {
  struct {
    unsigned char BF:1;
    unsigned char UA:1;
    unsigned char R:1;
    unsigned char S:1;
    unsigned char P:1;
    unsigned char D:1;
    unsigned char CKE:1;
    unsigned char SMP:1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char I2C_READ:1;
    unsigned char I2C_START:1;
    unsigned char I2C_STOP:1;
    unsigned char I2C_DATA:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_W:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_A:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_WRITE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_ADDRESS:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char R_W:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char D_A:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char READ_WRITE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char DATA_ADDRESS:1;
    unsigned char :1;
    unsigned char :1;
  };
} __SSPSTAT_bits_t;
extern volatile __SSPSTAT_bits_t __at(SSPSTAT_ADDR) SSPSTAT_bits;

#define BF                   SSPSTAT_bits.BF
#define UA                   SSPSTAT_bits.UA
#define R                    SSPSTAT_bits.R
#define I2C_READ             SSPSTAT_bits.I2C_READ
#define NOT_W                SSPSTAT_bits.NOT_W
#define NOT_WRITE            SSPSTAT_bits.NOT_WRITE
#define R_W                  SSPSTAT_bits.R_W
#define READ_WRITE           SSPSTAT_bits.READ_WRITE
#define S                    SSPSTAT_bits.S
#define I2C_START            SSPSTAT_bits.I2C_START
#define P                    SSPSTAT_bits.P
#define I2C_STOP             SSPSTAT_bits.I2C_STOP
#define D                    SSPSTAT_bits.D
#define I2C_DATA             SSPSTAT_bits.I2C_DATA
#define NOT_A                SSPSTAT_bits.NOT_A
#define NOT_ADDRESS          SSPSTAT_bits.NOT_ADDRESS
#define D_A                  SSPSTAT_bits.D_A
#define DATA_ADDRESS         SSPSTAT_bits.DATA_ADDRESS
#define CKE                  SSPSTAT_bits.CKE
#define SMP                  SSPSTAT_bits.SMP

// ----- STATUS bits --------------------
typedef union {
  struct {
    unsigned char C:1;
    unsigned char DC:1;
    unsigned char Z:1;
    unsigned char NOT_PD:1;
    unsigned char NOT_TO:1;
    unsigned char RP0:1;
    unsigned char RP1:1;
    unsigned char IRP:1;
  };
} __STATUS_bits_t;
extern volatile __STATUS_bits_t __at(STATUS_ADDR) STATUS_bits;

#define C                    STATUS_bits.C
#define DC                   STATUS_bits.DC
#define Z                    STATUS_bits.Z
#define NOT_PD               STATUS_bits.NOT_PD
#define NOT_TO               STATUS_bits.NOT_TO
#define RP0                  STATUS_bits.RP0
#define RP1                  STATUS_bits.RP1
#define IRP                  STATUS_bits.IRP

// ----- T1CON bits --------------------
typedef union {
  struct {
    unsigned char TMR1ON:1;
    unsigned char TMR1CS:1;
    unsigned char NOT_T1SYNC:1;
    unsigned char T1OSCEN:1;
    unsigned char T1CKPS0:1;
    unsigned char T1CKPS1:1;
    unsigned char TMR1GE:1;
    unsigned char T1GINV:1;
  };
} __T1CON_bits_t;
extern volatile __T1CON_bits_t __at(T1CON_ADDR) T1CON_bits;

#define TMR1ON               T1CON_bits.TMR1ON
#define TMR1CS               T1CON_bits.TMR1CS
#define NOT_T1SYNC           T1CON_bits.NOT_T1SYNC
#define T1OSCEN              T1CON_bits.T1OSCEN
#define T1CKPS0              T1CON_bits.T1CKPS0
#define T1CKPS1              T1CON_bits.T1CKPS1
#define TMR1GE               T1CON_bits.TMR1GE
#define T1GINV               T1CON_bits.T1GINV

// ----- TRISA bits --------------------
typedef union {
  struct {
    unsigned char TRISA0:1;
    unsigned char TRISA1:1;
    unsigned char TRISA2:1;
    unsigned char TRISA3:1;
    unsigned char TRISA4:1;
    unsigned char TRISA5:1;
    unsigned char :1;
    unsigned char :1;
  };
} __TRISA_bits_t;
extern volatile __TRISA_bits_t __at(TRISA_ADDR) TRISA_bits;

#define TRISA0               TRISA_bits.TRISA0
#define TRISA1               TRISA_bits.TRISA1
#define TRISA2               TRISA_bits.TRISA2
#define TRISA3               TRISA_bits.TRISA3
#define TRISA4               TRISA_bits.TRISA4
#define TRISA5               TRISA_bits.TRISA5

// ----- TRISB bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char TRISB4:1;
    unsigned char TRISB5:1;
    unsigned char TRISB6:1;
    unsigned char TRISB7:1;
  };
} __TRISB_bits_t;
extern volatile __TRISB_bits_t __at(TRISB_ADDR) TRISB_bits;

#define TRISB4               TRISB_bits.TRISB4
#define TRISB5               TRISB_bits.TRISB5
#define TRISB6               TRISB_bits.TRISB6
#define TRISB7               TRISB_bits.TRISB7

// ----- TRISC bits --------------------
typedef union {
  struct {
    unsigned char TRISC0:1;
    unsigned char TRISC1:1;
    unsigned char TRISC2:1;
    unsigned char TRISC3:1;
    unsigned char TRISC4:1;
    unsigned char TRISC5:1;
    unsigned char TRISC6:1;
    unsigned char TRISC7:1;
  };
} __TRISC_bits_t;
extern volatile __TRISC_bits_t __at(TRISC_ADDR) TRISC_bits;

#define TRISC0               TRISC_bits.TRISC0
#define TRISC1               TRISC_bits.TRISC1
#define TRISC2               TRISC_bits.TRISC2
#define TRISC3               TRISC_bits.TRISC3
#define TRISC4               TRISC_bits.TRISC4
#define TRISC5               TRISC_bits.TRISC5
#define TRISC6               TRISC_bits.TRISC6
#define TRISC7               TRISC_bits.TRISC7

// ----- TXSTA bits --------------------
typedef union {
  struct {
    unsigned char TX9D:1;
    unsigned char TRMT:1;
    unsigned char BRGH:1;
    unsigned char SENB:1;
    unsigned char SYNC:1;
    unsigned char TXEN:1;
    unsigned char TX9:1;
    unsigned char CSRC:1;
  };
} __TXSTA_bits_t;
extern volatile __TXSTA_bits_t __at(TXSTA_ADDR) TXSTA_bits;

#define TX9D                 TXSTA_bits.TX9D
#define TRMT                 TXSTA_bits.TRMT
#define BRGH                 TXSTA_bits.BRGH
#define SENB                 TXSTA_bits.SENB
#define SYNC                 TXSTA_bits.SYNC
#define TXEN                 TXSTA_bits.TXEN
#define TX9                  TXSTA_bits.TX9
#define CSRC                 TXSTA_bits.CSRC

// ----- VRCON bits --------------------
typedef union {
  struct {
    unsigned char VR0:1;
    unsigned char VR1:1;
    unsigned char VR2:1;
    unsigned char VR3:1;
    unsigned char VP6EN:1;
    unsigned char VRR:1;
    unsigned char C2VREN:1;
    unsigned char C1VREN:1;
  };
} __VRCON_bits_t;
extern volatile __VRCON_bits_t __at(VRCON_ADDR) VRCON_bits;

#define VR0                  VRCON_bits.VR0
#define VR1                  VRCON_bits.VR1
#define VR2                  VRCON_bits.VR2
#define VR3                  VRCON_bits.VR3
#define VP6EN                VRCON_bits.VP6EN
#define VRR                  VRCON_bits.VRR
#define C2VREN               VRCON_bits.C2VREN
#define C1VREN               VRCON_bits.C1VREN

// ----- WDTCON bits --------------------
typedef union {
  struct {
    unsigned char SWDTEN:1;
    unsigned char WDTPS0:1;
    unsigned char WDTPS1:1;
    unsigned char WDTPS2:1;
    unsigned char WDTPS3:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __WDTCON_bits_t;
extern volatile __WDTCON_bits_t __at(WDTCON_ADDR) WDTCON_bits;

#define SWDTEN               WDTCON_bits.SWDTEN
#define WDTPS0               WDTCON_bits.WDTPS0
#define WDTPS1               WDTCON_bits.WDTPS1
#define WDTPS2               WDTCON_bits.WDTPS2
#define WDTPS3               WDTCON_bits.WDTPS3

// ----- WPUA bits --------------------
typedef union {
  struct {
    unsigned char WPUA0:1;
    unsigned char WPUA1:1;
    unsigned char WPUA2:1;
    unsigned char :1;
    unsigned char WPUA4:1;
    unsigned char WPUA5:1;
    unsigned char :1;
    unsigned char :1;
  };
} __WPUA_bits_t;
extern volatile __WPUA_bits_t __at(WPUA_ADDR) WPUA_bits;

#define WPUA0                WPUA_bits.WPUA0
#define WPUA1                WPUA_bits.WPUA1
#define WPUA2                WPUA_bits.WPUA2
#define WPUA4                WPUA_bits.WPUA4
#define WPUA5                WPUA_bits.WPUA5

// ----- WPUB bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char WPUB4:1;
    unsigned char WPUB5:1;
    unsigned char WPUB6:1;
    unsigned char WPUB7:1;
  };
} __WPUB_bits_t;
extern volatile __WPUB_bits_t __at(WPUB_ADDR) WPUB_bits;

#define WPUB4                WPUB_bits.WPUB4
#define WPUB5                WPUB_bits.WPUB5
#define WPUB6                WPUB_bits.WPUB6
#define WPUB7                WPUB_bits.WPUB7

#endif
