/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import java.awt.color.ICC_Profile;
import java.nio.ByteBuffer;

public class ColorLookUpTable {
    private static float[] D50 = new float[]{0.96422f, 1.0f, 0.82521f};
    int nIn;
    int nOut;
    int nInTableEntries;
    int nOutTableEntries;
    int gridpoints;
    int nClut;
    double[][] inTable;
    short[][] outTable;
    double[] clut;
    float[][] inMatrix;
    boolean useMatrix = false;
    int[] multiplier;
    int[] offsets;
    boolean inputLab;
    boolean outputLab;

    public ColorLookUpTable(ICC_Profile iCC_Profile, int n) {
        switch (n) {
            case 1093812784: 
            case 1093812785: 
            case 1093812786: {
                if (iCC_Profile.getColorSpaceType() == 0) {
                    this.useMatrix = true;
                }
                this.inputLab = false;
                this.outputLab = iCC_Profile.getPCSType() == 1;
                break;
            }
            case 1110589744: 
            case 1110589745: 
            case 1110589746: {
                if (iCC_Profile.getPCSType() == 0) {
                    this.useMatrix = true;
                }
                this.inputLab = iCC_Profile.getPCSType() == 1;
                this.outputLab = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a clut-type tag.");
            }
        }
        byte[] byArray = iCC_Profile.getData(n);
        if (byArray == null) {
            throw new IllegalArgumentException("Unsuitable profile, does not contain a CLUT.");
        }
        if (byArray[0] != 109 || byArray[1] != 102 || byArray[2] != 116) {
            throw new IllegalArgumentException("Unsuitable profile, invalid CLUT data.");
        }
        if (byArray[3] == 50) {
            this.readClut16(byArray);
        } else if (byArray[3] == 49) {
            this.readClut8(byArray);
        } else {
            throw new IllegalArgumentException("Unknown/invalid CLUT type.");
        }
    }

    private void readClut16(byte[] byArray) {
        int n;
        int n2;
        int n3;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.nIn = byArray[8] & 0xFF;
        this.nOut = byArray[9] & 0xFF;
        this.nInTableEntries = byteBuffer.getShort(48);
        this.nOutTableEntries = byteBuffer.getShort(50);
        this.gridpoints = byArray[10] & 0xFF;
        this.inMatrix = new float[3][3];
        for (n3 = 0; n3 < 3; ++n3) {
            for (n2 = 0; n2 < 3; ++n2) {
                this.inMatrix[n3][n2] = (float)byteBuffer.getInt(12 + (n3 * 3 + n2) * 4) / 65536.0f;
            }
        }
        this.inTable = new double[this.nIn][this.nInTableEntries];
        for (n3 = 0; n3 < this.nIn; ++n3) {
            for (n2 = 0; n2 < this.nInTableEntries; ++n2) {
                this.inTable[n3][n2] = (double)(byteBuffer.getShort(52 + (n3 * this.nInTableEntries + n2) * 2) & 0xFFFF) / 65536.0;
            }
        }
        this.nClut = this.nOut;
        this.multiplier = new int[this.nIn];
        this.multiplier[this.nIn - 1] = this.nOut;
        for (n3 = 0; n3 < this.nIn; ++n3) {
            this.nClut *= this.gridpoints;
            if (n3 <= 0) continue;
            this.multiplier[this.nIn - n3 - 1] = this.multiplier[this.nIn - n3] * this.gridpoints;
        }
        n3 = 52 + this.nIn * this.nInTableEntries * 2;
        this.clut = new double[this.nClut];
        for (n2 = 0; n2 < this.nClut; ++n2) {
            this.clut[n2] = (double)(byteBuffer.getShort(n3 + n2 * 2) & 0xFFFF) / 65536.0;
        }
        this.outTable = new short[this.nOut][this.nOutTableEntries];
        for (n2 = 0; n2 < this.nOut; ++n2) {
            for (n = 0; n < this.nOutTableEntries; ++n) {
                this.outTable[n2][n] = byteBuffer.getShort(n3 + (this.nClut + n2 * this.nOutTableEntries + n) * 2);
            }
        }
        this.offsets = new int[1 << (this.nIn & 0x1F)];
        this.offsets[0] = 0;
        for (n2 = 0; n2 < this.nIn; ++n2) {
            n = 1 << (n2 & 0x1F);
            for (int i = 0; i < n; ++i) {
                this.offsets[n + i] = this.offsets[i] + this.multiplier[n2];
            }
        }
    }

    private void readClut8(byte[] byArray) {
        int n;
        int n2;
        int n3;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.nIn = byArray[8] & 0xFF;
        this.nOut = byArray[9] & 0xFF;
        this.nInTableEntries = 256;
        this.nOutTableEntries = 256;
        this.gridpoints = byArray[10] & 0xFF;
        this.inMatrix = new float[3][3];
        for (n3 = 0; n3 < 3; ++n3) {
            for (n2 = 0; n2 < 3; ++n2) {
                this.inMatrix[n3][n2] = (float)byteBuffer.getInt(12 + (n3 * 3 + n2) * 4) / 65536.0f;
            }
        }
        this.inTable = new double[this.nIn][this.nInTableEntries];
        for (n3 = 0; n3 < this.nIn; ++n3) {
            for (n2 = 0; n2 < this.nInTableEntries; ++n2) {
                this.inTable[n3][n2] = (double)(byteBuffer.get(48 + (n3 * this.nInTableEntries + n2)) & 0xFF) / 255.0;
            }
        }
        this.nClut = this.nOut;
        this.multiplier = new int[this.nIn];
        this.multiplier[this.nIn - 1] = this.nOut;
        for (n3 = 0; n3 < this.nIn; ++n3) {
            this.nClut *= this.gridpoints;
            if (n3 <= 0) continue;
            this.multiplier[this.nIn - n3 - 1] = this.multiplier[this.nIn - n3] * this.gridpoints;
        }
        n3 = 48 + this.nIn * this.nInTableEntries;
        this.clut = new double[this.nClut];
        for (n2 = 0; n2 < this.nClut; ++n2) {
            this.clut[n2] = (double)(byteBuffer.get(n3 + n2) & 0xFF) / 255.0;
        }
        this.outTable = new short[this.nOut][this.nOutTableEntries];
        for (n2 = 0; n2 < this.nOut; ++n2) {
            for (n = 0; n < this.nOutTableEntries; ++n) {
                this.outTable[n2][n] = (short)(byteBuffer.get(n3 + this.nClut + n2 * this.nOutTableEntries + n) * 257);
            }
        }
        this.offsets = new int[1 << (this.nIn & 0x1F)];
        this.offsets[0] = 0;
        for (n2 = 0; n2 < this.nIn; ++n2) {
            n = 1 << (n2 & 0x1F);
            for (int i = 0; i < n; ++i) {
                this.offsets[n + i] = this.offsets[i] + this.multiplier[n2];
            }
        }
    }

    float[] lookup(float[] fArray) {
        int n;
        int n2;
        int n3;
        float[] fArray2 = new float[fArray.length];
        if (this.useMatrix) {
            for (n3 = 0; n3 < 3; ++n3) {
                fArray2[n3] = fArray[0] * this.inMatrix[n3][0] + fArray[1] * this.inMatrix[n3][1] + fArray[2] * this.inMatrix[n3][2];
            }
        } else if (this.inputLab) {
            fArray2 = this.XYZtoLab(fArray);
        } else {
            System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        }
        for (n3 = 0; n3 < this.nIn; ++n3) {
            int n4 = (int)Math.floor((double)fArray2[n3] * (double)(this.nInTableEntries - 1));
            if (n4 >= this.nInTableEntries - 1) {
                fArray2[n3] = (float)this.inTable[n3][this.nInTableEntries - 1];
                continue;
            }
            if (n4 < 0) {
                fArray2[n3] = (float)this.inTable[n3][0];
                continue;
            }
            double d = (double)fArray2[n3] * ((double)this.nInTableEntries - 1.0) - (double)n4;
            fArray2[n3] = (float)(this.inTable[n3][n4] * (1.0 - d) + this.inTable[n3][n4 + 1] * d);
        }
        double[] dArray = new double[this.nOut];
        double[] dArray2 = new double[1 << (this.nIn & 0x1F)];
        double[] dArray3 = new double[this.nIn];
        int n5 = 0;
        for (n2 = 0; n2 < this.nIn; ++n2) {
            n = (int)Math.floor((double)fArray2[n2] * ((double)this.gridpoints - 1.0));
            double d = (double)fArray2[n2] * ((double)this.gridpoints - 1.0) - (double)n;
            if (n >= this.gridpoints - 1) {
                n = this.gridpoints - 1;
                d = 1.0;
            } else if (n < 0) {
                n = 0;
            }
            dArray3[n2] = d;
            n5 += n * this.multiplier[n2];
        }
        dArray2[0] = 1.0;
        for (n2 = 0; n2 < this.nIn; ++n2) {
            n = 1 << (n2 & 0x1F);
            int n6 = 0;
            while (n6 < n) {
                dArray2[n + n6] = dArray2[n6] * dArray3[n2];
                int n7 = n6++;
                dArray2[n7] = dArray2[n7] * (1.0 - dArray3[n2]);
            }
        }
        for (n2 = 0; n2 < this.nOut; ++n2) {
            dArray[n2] = dArray2[0] * this.clut[n5 + n2];
        }
        for (n2 = 1; n2 < 1 << (this.nIn & 0x1F); ++n2) {
            n = n5 + this.offsets[n2];
            for (int i = 0; i < this.nOut; ++i) {
                int n8 = i;
                dArray[n8] = dArray[n8] + dArray2[n2] * this.clut[n + i];
            }
        }
        float[] fArray3 = new float[this.nOut];
        for (n = 0; n < this.nOut; ++n) {
            int n9 = (int)Math.floor(dArray[n] * ((double)this.nOutTableEntries - 1.0));
            if (n9 >= this.nOutTableEntries - 1) {
                fArray3[n] = this.outTable[n][this.nOutTableEntries - 1];
                continue;
            }
            if (n9 < 0) {
                fArray3[n] = this.outTable[n][0];
                continue;
            }
            double d = dArray[n] * ((double)this.nOutTableEntries - 1.0) - (double)n9;
            fArray3[n] = (float)((double)(this.outTable[n][n9] & 0xFFFF) * (1.0 - d) + (double)(this.outTable[n][n9 + 1] & 0xFFFF) * d) / 65536.0f;
        }
        if (this.outputLab) {
            return this.LabtoXYZ(fArray3);
        }
        return fArray3;
    }

    private float[] LabtoXYZ(float[] fArray) {
        fArray[0] = (float)(100.392156862745 * (double)fArray[0]);
        fArray[1] = fArray[1] * 256.0f - 128.0f;
        fArray[2] = fArray[2] * 256.0f - 128.0f;
        float[] fArray2 = new float[3];
        fArray2[1] = (fArray[0] + 16.0f) / 116.0f;
        fArray2[0] = fArray[1] / 500.0f + fArray2[1];
        fArray2[2] = fArray2[1] - fArray[2] / 200.0f;
        for (int i = 0; i < 3; ++i) {
            float f = fArray2[i];
            double d = f * f * fArray2[i];
            fArray2[i] = d <= 0.008856 ? (fArray2[i] - 0.13793103f) / 7.787f : (float)d;
            fArray2[i] = D50[i] * fArray2[i];
        }
        return fArray2;
    }

    private float[] XYZtoLab(float[] fArray) {
        float[] fArray2 = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray2[i] = fArray[i] / D50[i];
            fArray2[i] = fArray2[i] <= 0.008856f ? 7.787069f * fArray2[i] + 0.13793103f : (float)Math.exp(0.3333333333333333 * Math.log(fArray2[i]));
        }
        float[] fArray3 = new float[]{116.0f * fArray2[1] - 16.0f, 500.0f * (fArray2[0] - fArray2[1]), 200.0f * (fArray2[1] - fArray2[2])};
        fArray3[0] = (float)((double)fArray3[0] / 100.392156862745);
        fArray3[1] = (fArray3[1] + 128.0f) / 256.0f;
        fArray3[2] = (fArray3[2] + 128.0f) / 256.0f;
        for (int i = 0; i < 3; ++i) {
            if (fArray3[i] < 0.0f) {
                fArray3[i] = 0.0f;
            }
            if (!(fArray3[i] > 1.0f)) continue;
            fArray3[i] = 1.0f;
        }
        return fArray3;
    }
}

