/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.event.ComponentEvent;

public abstract class InputEvent
extends ComponentEvent {
    private static final long serialVersionUID = -2482525981698309786L;
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON2_MASK = 8;
    public static final int BUTTON3_MASK = 4;
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_DOWN_MASK = 512;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_DOWN_MASK = 4096;
    public static final int ALT_GRAPH_DOWN_MASK = 8192;
    static final int CONVERT_MASK = 10176;
    private final long when;
    int modifiers;
    int modifiersEx;

    InputEvent(Component component, int n, long l, int n2) {
        super(component, n);
        this.when = l;
        this.modifiers = n2 & 0x3F;
        this.modifiersEx = n2 & 0x3FC0;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 1) != 0 || (this.modifiersEx & 0x40) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers & 2) != 0 || (this.modifiersEx & 0x80) != 0;
    }

    public boolean isMetaDown() {
        return (this.modifiers & 4) != 0 || (this.modifiersEx & 0x100) != 0;
    }

    public boolean isAltDown() {
        return (this.modifiers & 8) != 0 || (this.modifiersEx & 0x200) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers & 0x20) != 0 || (this.modifiersEx & 0x2000) != 0;
    }

    public long getWhen() {
        return this.when;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getModifiersEx() {
        return this.modifiersEx;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public static String getModifiersExText(int n) {
        if ((n &= 0x3FC0) == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 0x100) != 0) {
            stringBuffer.append("Meta+");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("Ctrl+");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append("Alt+");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append("Shift+");
        }
        if ((n & 0x2000) != 0) {
            stringBuffer.append("Alt Graph+");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append("Button1+");
        }
        if ((n & 0x800) != 0) {
            stringBuffer.append("Button2+");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("Button3+");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }
}

