/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.SocketAddress;

public class InetSocketAddress
extends SocketAddress {
    private static final long serialVersionUID = 5076001401234631237L;
    private String hostname;
    private InetAddress addr;
    private int port;

    public InetSocketAddress(InetAddress inetAddress, int n) throws IllegalArgumentException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Bad port number: " + n);
        }
        if (inetAddress == null) {
            inetAddress = InetAddress.ANY_IF;
        }
        this.addr = inetAddress;
        this.port = n;
    }

    public InetSocketAddress(int n) throws IllegalArgumentException {
        this((InetAddress)null, n);
    }

    public InetSocketAddress(String string, int n) {
        this(string, n, true);
    }

    private InetSocketAddress(String string, int n, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Null host name value");
        }
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Bad port number: " + n);
        }
        this.port = n;
        this.hostname = string;
        this.addr = null;
        if (bl) {
            try {
                this.addr = InetAddress.getByName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static InetSocketAddress createUnresolved(String string, int n) {
        return new InetSocketAddress(string, n, false);
    }

    public final boolean equals(Object object) {
        if (object instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
            if (this.addr == null && inetSocketAddress.addr != null) {
                return false;
            }
            if (this.addr == null && inetSocketAddress.addr == null) {
                return this.hostname.equals(inetSocketAddress.hostname) && inetSocketAddress.port == this.port;
            }
            return this.addr.equals(inetSocketAddress.addr) && inetSocketAddress.port == this.port;
        }
        return false;
    }

    public final InetAddress getAddress() {
        return this.addr;
    }

    public final String getHostName() {
        if (this.hostname == null) {
            this.hostname = this.addr.getHostName();
        }
        return this.hostname;
    }

    public final int getPort() {
        return this.port;
    }

    public final int hashCode() {
        return this.port + this.addr.hashCode();
    }

    public final boolean isUnresolved() {
        return this.addr == null;
    }

    public String toString() {
        return (this.addr == null ? this.hostname : this.addr.toString()) + ":" + this.port;
    }
}

