/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Properties;
import org.jgraph.layout.AnnealingLayoutAlgorithm;
import org.jgraph.layout.AnnealingLayoutConfigurationDialog;
import org.jgraph.layout.LayoutAlgorithm;
import org.jgraph.layout.LayoutController;

public class AnnealingLayoutController
implements LayoutController {
    public static final String KEY_TITLE = "Simulated Annealing";
    public static final String KEY_CONFIG_NAME = "CONFIG_NAME";
    public static final String KEY_INIT_TEMPERATURE = "Start Temperature";
    public static final String KEY_MIN_TEMPERATURE = "min. Temperature";
    public static final String KEY_MIN_DISTANCE = "min. Distance";
    public static final String KEY_TEMP_SCALE_FACTOR = "Temperature Scalefactor";
    public static final String KEY_COMPUTE_PERMUTATION = "should compute per Permutation";
    public static final String KEY_IS_UPHILL_MOVE_ALLOWED = "are Uphill-Moves allowed";
    public static final String KEY_MAX_ROUNDS = "max. Rounds";
    public static final String KEY_TRIES_PER_CELL = "tries per cell";
    public static final String KEY_COST_FUNCTION_CONFIG = "Costfunction Config";
    public static final String KEY_LAMBDA = "Lambda";
    public static final String KEY_BOUNDS = "Bounds of resulting graph";
    public static final String KEY_LAYOUT_UPDATE_INIT_TEMPERATURE = "Layout Update Start Temperature";
    public static final String KEY_LAYOUT_UPDATE_MIN_TEMPERATURE = "Layout Update min. Temperature";
    public static final String KEY_LAYOUT_UPDATE_MIN_DISTANCE = "Layout Update min. Distance";
    public static final String KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR = "Layout Update Temperature Scalefactor";
    public static final String KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION = "Layout Update should compute per Permutation";
    public static final String KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED = "Layout Update are Uphill-Moves allowed";
    public static final String KEY_LAYOUT_UPDATE_MAX_ROUNDS = "Layout Update max. Rounds";
    public static final String KEY_LAYOUT_UPDATE_TRIES_PER_CELL = "Layout Update tries per cell";
    public static final String KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG = "Layout Update Costfunction Config";
    public static final String KEY_LAYOUT_UPDATE_LAMBDA = "Layout Update Lambda";
    public static final String KEY_LAYOUT_UPDATE_BOUNDS = "Layout Update Bounds of resulting graph";
    public static final String KEY_LAYOUT_UPDATE_METHOD = "Layout Update Method";
    public static final String KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY = "Layout Update Method Neighbors only";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER = "Layout Update Method Perimeter";
    public static final String KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH = "Layout Update Method Neighbors depth";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS = "Layout Update Method Perimeter radius";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE = "Layout Update Method Perimeter radius increase";
    public static final String KEY_LAYOUT_UPDATE_ENABLED = "Layout Update enabled";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED = "Layout Update clustering enabled";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR = "Layout Update clustering factor";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE = "Layout Update clustering move scaling factor";
    public static final int COUT_COSTFUNCTION = 6;
    public static final int COSTFUNCTION_EDGE_DISTANCE = 1;
    public static final int COSTFUNCTION_EDGE_CROSSING = 2;
    public static final int COSTFUNCTION_EDGE_LENGTH = 4;
    public static final int COSTFUNCTION_BORDERLINE = 8;
    public static final int COSTFUNCTION_NODE_DISTRIBUTION = 16;
    public static final int COSTFUNCTION_NODE_DISTANCE = 32;
    protected Properties[] config = new Properties[2];
    protected AnnealingLayoutConfigurationDialog dialog;
    private boolean isOptimizer = false;

    public AnnealingLayoutController() {
        this.config[0] = new Properties();
        this.config[0].put(KEY_CONFIG_NAME, "Default Values");
        this.config[0].put(KEY_INIT_TEMPERATURE, "300.0");
        this.config[0].put(KEY_MIN_TEMPERATURE, "2.0");
        this.config[0].put(KEY_MIN_DISTANCE, "50.0");
        this.config[0].put(KEY_TEMP_SCALE_FACTOR, "0.95");
        this.config[0].put(KEY_COMPUTE_PERMUTATION, "true");
        this.config[0].put(KEY_IS_UPHILL_MOVE_ALLOWED, "true");
        this.config[0].put(KEY_MAX_ROUNDS, "10000");
        this.config[0].put(KEY_TRIES_PER_CELL, "8");
        this.config[0].put(KEY_COST_FUNCTION_CONFIG, "111110");
        this.config[0].put(KEY_BOUNDS, "0.0");
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(1000.0));
        arrayList.add(new Double(100000.0));
        arrayList.add(new Double(0.02));
        arrayList.add(new Double(2000.0));
        arrayList.add(new Double(150.0));
        arrayList.add(new Double(1000000.0));
        this.config[0].put(KEY_LAMBDA, arrayList);
        Rectangle rectangle = new Rectangle(0, 0, 1000, 700);
        this.config[0].put(KEY_BOUNDS, rectangle);
        this.config[0].put(KEY_LAYOUT_UPDATE_ENABLED, "true");
        this.config[0].put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, "40.0");
        this.config[0].put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, "2.0");
        this.config[0].put(KEY_LAYOUT_UPDATE_MIN_DISTANCE, "50.0");
        this.config[0].put(KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR, "0.95");
        this.config[0].put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, "true");
        this.config[0].put(KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED, "true");
        this.config[0].put(KEY_LAYOUT_UPDATE_MAX_ROUNDS, "10000");
        this.config[0].put(KEY_LAYOUT_UPDATE_TRIES_PER_CELL, "8");
        this.config[0].put(KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG, "111110");
        this.config[0].put(KEY_LAYOUT_UPDATE_METHOD, KEY_LAYOUT_UPDATE_METHOD_PERIMETER);
        this.config[0].put(KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH, "1");
        this.config[0].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS, "100.0");
        this.config[0].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE, "20.0");
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        arrayList2.add(new Double(1000.0));
        arrayList2.add(new Double(100000.0));
        arrayList2.add(new Double(0.02));
        arrayList2.add(new Double(2000.0));
        arrayList2.add(new Double(150.0));
        arrayList2.add(new Double(1000000.0));
        this.config[0].put(KEY_LAYOUT_UPDATE_LAMBDA, arrayList2);
        Rectangle rectangle2 = new Rectangle(0, 0, 1000, 700);
        this.config[0].put(KEY_LAYOUT_UPDATE_BOUNDS, rectangle2);
        this.config[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, "true");
        this.config[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, "8.0");
        this.config[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE, "0.1");
        this.config[1] = new Properties();
        this.config[1].put(KEY_CONFIG_NAME, "Heavy Values");
        this.config[1].put(KEY_INIT_TEMPERATURE, "500.0");
        this.config[1].put(KEY_MIN_TEMPERATURE, "0.5");
        this.config[1].put(KEY_MIN_DISTANCE, "50.0");
        this.config[1].put(KEY_TEMP_SCALE_FACTOR, "0.97");
        this.config[1].put(KEY_COMPUTE_PERMUTATION, "true");
        this.config[1].put(KEY_IS_UPHILL_MOVE_ALLOWED, "true");
        this.config[1].put(KEY_MAX_ROUNDS, "10000");
        this.config[1].put(KEY_TRIES_PER_CELL, "8");
        this.config[1].put(KEY_COST_FUNCTION_CONFIG, "111111");
        this.config[1].put(KEY_BOUNDS, "0.0");
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        arrayList3.add(new Double(1000.0));
        arrayList3.add(new Double(100000.0));
        arrayList3.add(new Double(0.02));
        arrayList3.add(new Double(2000.0));
        arrayList3.add(new Double(150.0));
        arrayList3.add(new Double(1000000.0));
        this.config[1].put(KEY_LAMBDA, arrayList3);
        Rectangle rectangle3 = new Rectangle(0, 0, 1000, 700);
        this.config[1].put(KEY_BOUNDS, rectangle3);
        this.config[1].put(KEY_LAYOUT_UPDATE_ENABLED, "true");
        this.config[1].put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, "40.0");
        this.config[1].put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, "2.0");
        this.config[1].put(KEY_LAYOUT_UPDATE_MIN_DISTANCE, "50.0");
        this.config[1].put(KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR, "0.97");
        this.config[1].put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, "true");
        this.config[1].put(KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED, "true");
        this.config[1].put(KEY_LAYOUT_UPDATE_MAX_ROUNDS, "10000");
        this.config[1].put(KEY_LAYOUT_UPDATE_TRIES_PER_CELL, "8");
        this.config[1].put(KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG, "111111");
        this.config[1].put(KEY_LAYOUT_UPDATE_METHOD, KEY_LAYOUT_UPDATE_METHOD_PERIMETER);
        this.config[1].put(KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH, "2");
        this.config[1].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS, "200.0");
        this.config[1].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE, "40.0");
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        arrayList4.add(new Double(1000.0));
        arrayList4.add(new Double(100000.0));
        arrayList4.add(new Double(0.02));
        arrayList4.add(new Double(2000.0));
        arrayList4.add(new Double(150.0));
        arrayList4.add(new Double(1000000.0));
        this.config[1].put(KEY_LAYOUT_UPDATE_LAMBDA, arrayList4);
        Rectangle rectangle4 = new Rectangle(0, 0, 1000, 700);
        this.config[1].put(KEY_LAYOUT_UPDATE_BOUNDS, rectangle4);
        this.config[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, "true");
        this.config[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, "12.0");
        this.config[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE, "0.2");
    }

    public AnnealingLayoutController(boolean bl) {
        this();
        this.isOptimizer = bl;
    }

    public void setConfigurationDialog(AnnealingLayoutConfigurationDialog annealingLayoutConfigurationDialog) {
        this.dialog = annealingLayoutConfigurationDialog;
    }

    public boolean isConfigurable() {
        return true;
    }

    public void configure() {
        if (this.dialog == null) {
            this.dialog = new AnnealingLayoutConfigurationDialog(null, this.config, this.isOptimizer);
        }
        this.dialog.validate();
        this.dialog.setVisible(true);
        this.dialog.pack();
    }

    public Properties getConfiguration() {
        if (this.dialog == null) {
            this.dialog = new AnnealingLayoutConfigurationDialog(null, this.config, this.isOptimizer);
        }
        Properties properties = new Properties();
        properties.put("CAPTION", KEY_TITLE);
        properties.put(KEY_INIT_TEMPERATURE, String.valueOf(this.dialog.getInitTemperature()));
        properties.put(KEY_MIN_TEMPERATURE, String.valueOf(this.dialog.getMinTemperature()));
        properties.put(KEY_MIN_DISTANCE, String.valueOf(this.dialog.getMinDistance()));
        properties.put(KEY_TEMP_SCALE_FACTOR, String.valueOf(this.dialog.getTemperatureScaleFactor()));
        properties.put(KEY_COMPUTE_PERMUTATION, String.valueOf(this.dialog.getComputePermutation()));
        properties.put(KEY_IS_UPHILL_MOVE_ALLOWED, String.valueOf(this.dialog.getUphillMovesAllowed()));
        properties.put(KEY_MAX_ROUNDS, String.valueOf(this.dialog.getMaxRounds()));
        properties.put(KEY_TRIES_PER_CELL, String.valueOf(this.dialog.getTriesPerCell()));
        properties.put(KEY_COST_FUNCTION_CONFIG, String.valueOf(Integer.toBinaryString(this.dialog.getCostFunctionConfiguration())));
        properties.put(KEY_LAMBDA, this.dialog.getLambda());
        properties.put(KEY_BOUNDS, this.dialog.getResultBounds());
        properties.put(KEY_LAYOUT_UPDATE_ENABLED, String.valueOf(this.dialog.getLayoutUpdateEnabled()));
        properties.put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, String.valueOf(this.dialog.getLayoutUpdateInitTemperature()));
        properties.put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, String.valueOf(this.dialog.getLayoutUpdateMinTemperature()));
        properties.put(KEY_LAYOUT_UPDATE_MIN_DISTANCE, String.valueOf(this.dialog.getLayoutUpdateMinDistance()));
        properties.put(KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR, String.valueOf(this.dialog.getLayoutUpdateTemperatureScaleFactor()));
        properties.put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, String.valueOf(this.dialog.getLayoutUpdateComputePermutation()));
        properties.put(KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED, String.valueOf(this.dialog.getLayoutUpdateUphillMovesAllowed()));
        properties.put(KEY_LAYOUT_UPDATE_MAX_ROUNDS, String.valueOf(this.dialog.getLayoutUpdateMaxRounds()));
        properties.put(KEY_LAYOUT_UPDATE_TRIES_PER_CELL, String.valueOf(this.dialog.getLayoutUpdateTriesPerCell()));
        properties.put(KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG, String.valueOf(Integer.toBinaryString(this.dialog.getLayoutUpdateCostFunctionConfiguration())));
        properties.put(KEY_LAYOUT_UPDATE_LAMBDA, this.dialog.getLayoutUpdateLambda());
        properties.put(KEY_LAYOUT_UPDATE_BOUNDS, this.dialog.getLayoutUpdateResultBounds());
        properties.put(KEY_LAYOUT_UPDATE_METHOD, this.dialog.getLayoutUpdateMethod());
        properties.put(KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH, String.valueOf(this.dialog.getLayoutUpdateMethodNeighborsDepth()));
        properties.put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS, String.valueOf(this.dialog.getLayoutUpdateMethodPerimeterRadius()));
        properties.put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE, String.valueOf(this.dialog.getLayoutUpdateMethodPerimeterRadiusIncrease()));
        properties.put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, String.valueOf(this.dialog.getLayoutUpdateClusteringEnabled()));
        properties.put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, String.valueOf(this.dialog.getLayoutUpdateClusteringFactor()));
        properties.put(KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE, String.valueOf(this.dialog.getLayoutUpdateClusteringMoveScaleFactor()));
        this.addAdditionalConfigurationData(properties);
        return properties;
    }

    protected void addAdditionalConfigurationData(Properties properties) {
    }

    public void setConfiguration(Properties properties) {
        this.dialog.setInitTemperature(Double.parseDouble((String)properties.get(KEY_INIT_TEMPERATURE)));
        this.dialog.setMinTemperature(Double.parseDouble((String)properties.get(KEY_MIN_TEMPERATURE)));
        this.dialog.setMinDistance(Double.parseDouble((String)properties.get(KEY_MIN_DISTANCE)));
        this.dialog.setTemperatureScaleFactor(Double.parseDouble((String)properties.get(KEY_TEMP_SCALE_FACTOR)));
        this.dialog.setComputePermutation(this.isTrue((String)properties.get(KEY_COMPUTE_PERMUTATION)));
        this.dialog.setUphillMovesAllowed(this.isTrue((String)properties.get(KEY_IS_UPHILL_MOVE_ALLOWED)));
        this.dialog.setMaxRounds(Integer.parseInt((String)properties.get(KEY_MAX_ROUNDS)));
        this.dialog.setTriesPerCell(Integer.parseInt((String)properties.get(KEY_TRIES_PER_CELL)));
        this.dialog.setCostFunctionConfiguration(Integer.parseInt((String)properties.get(KEY_COST_FUNCTION_CONFIG), 2));
        this.dialog.setLambda((ArrayList)properties.get(KEY_LAMBDA));
        this.dialog.setResultBounds((Rectangle)properties.get(KEY_BOUNDS));
        this.dialog.setLayoutUpdateEnabled(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_ENABLED)));
        this.dialog.setLayoutUpdateInitTemperature(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE)));
        this.dialog.setLayoutUpdateMinTemperature(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE)));
        this.dialog.setLayoutUpdateMinDistance(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_MIN_DISTANCE)));
        this.dialog.setLayoutUpdateTemperatureScaleFactor(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR)));
        this.dialog.setLayoutUpdateComputePermutation(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION)));
        this.dialog.setLayoutUpdateUphillMovesAllowed(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED)));
        this.dialog.setLayoutUpdateMaxRounds(Integer.parseInt((String)properties.get(KEY_LAYOUT_UPDATE_MAX_ROUNDS)));
        this.dialog.setLayoutUpdateTriesPerCell(Integer.parseInt((String)properties.get(KEY_LAYOUT_UPDATE_TRIES_PER_CELL)));
        this.dialog.setLayoutUpdateCostFunctionConfiguration(Integer.parseInt((String)properties.get(KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG), 2));
        this.dialog.setLayoutUpdateLambda((ArrayList)properties.get(KEY_LAYOUT_UPDATE_LAMBDA));
        this.dialog.setLayoutUpdateResultBounds((Rectangle)properties.get(KEY_LAYOUT_UPDATE_BOUNDS));
        this.dialog.setLayoutUpdateMethod((String)properties.get(KEY_LAYOUT_UPDATE_METHOD));
        this.dialog.setLayoutUpdateMethodNeighborsDepth(Integer.parseInt((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH)));
        this.dialog.setLayoutUpdateMethodPerimeterRadius(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS)));
        this.dialog.setLayoutUpdateMethodPerimeterRadiusIncrease(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE)));
        this.dialog.setLayoutUpdateClusteringEnabled(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED)));
        this.dialog.setLayoutUpdateClusteringFactor(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR)));
        this.dialog.setLayoutUpdateClusteringMoveScaleFactor(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE)));
    }

    private boolean isTrue(String string) {
        return "TRUE".equals(string.toUpperCase());
    }

    public LayoutAlgorithm getLayoutAlgorithm() {
        return new AnnealingLayoutAlgorithm();
    }

    public String toString() {
        return KEY_TITLE;
    }
}

