/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.jgraph.layout.LayoutController;
import org.jgraph.layout.LayoutRegistry;
import org.jgraph.pad.resources.Translator;

public class LayoutDialog
extends JDialog {
    private boolean canceled;
    private JPanel pnlApplyTo;
    private JButton cmdConfigure;
    private JPanel pnlLayoutControllers;
    private JScrollPane scrollLayoutControllers;
    private JRadioButton cmdSelectedNodes;
    private ButtonGroup cmdGrpApplyTo;
    private JRadioButton cmdAllNodes;
    private JList lstLayoutControllers;
    private JPanel pnlButtons;
    private JButton cmdCancel;
    private JPanel pnlMain;
    private JLabel lblApplyTo;
    private JButton cmdFinished;

    public LayoutDialog(Dialog dialog) {
        super(dialog, true);
        this.init();
    }

    public LayoutDialog(Frame frame) {
        super(frame, true);
        this.init();
    }

    protected void init() {
        this.initComponents();
        this.fillList();
        try {
            this.lstLayoutControllers.setSelectedIndex(0);
        }
        catch (Exception exception) {}
    }

    protected void fillList() {
        try {
            DefaultListModel<LayoutController> defaultListModel = new DefaultListModel<LayoutController>();
            Iterator iterator = LayoutRegistry.registeredLayoutControllers();
            while (iterator.hasNext()) {
                LayoutController layoutController = (LayoutController)iterator.next();
                defaultListModel.addElement(layoutController);
            }
            this.lstLayoutControllers.setModel(defaultListModel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void cancel() {
        this.canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    protected void finish() {
        this.canceled = false;
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void configure() {
        try {
            LayoutController layoutController = (LayoutController)this.lstLayoutControllers.getSelectedValue();
            if (!layoutController.isConfigurable()) {
                String string = Translator.getString("Error.ThisLayoutCannotBeConfigured");
                JOptionPane.showMessageDialog(this, string, null, 1);
                return;
            }
            layoutController.configure();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isApplyLayoutToAll() {
        return this.cmdAllNodes.isSelected();
    }

    public LayoutController getSelectedLayoutController() {
        try {
            return (LayoutController)this.lstLayoutControllers.getSelectedValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void initComponents() {
        this.cmdGrpApplyTo = new ButtonGroup();
        this.pnlMain = new JPanel();
        this.pnlApplyTo = new JPanel();
        this.lblApplyTo = new JLabel();
        this.cmdAllNodes = new JRadioButton();
        this.cmdSelectedNodes = new JRadioButton();
        this.pnlButtons = new JPanel();
        this.cmdConfigure = new JButton();
        this.cmdCancel = new JButton();
        this.cmdFinished = new JButton();
        this.pnlLayoutControllers = new JPanel();
        this.scrollLayoutControllers = new JScrollPane();
        this.lstLayoutControllers = new JList();
        this.setTitle(Translator.getString("Layout"));
        this.setName("Layout");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LayoutDialog.this.closeDialog(windowEvent);
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.lblApplyTo.setText(Translator.getString("Apply to"));
        this.lblApplyTo.setName("ApplyTo");
        this.pnlApplyTo.add(this.lblApplyTo);
        this.cmdAllNodes.setFont(new Font("Dialog", 0, 12));
        this.cmdAllNodes.setText(Translator.getString("AllNodes"));
        this.cmdAllNodes.setName("AllNodes");
        this.cmdGrpApplyTo.add(this.cmdAllNodes);
        this.pnlApplyTo.add(this.cmdAllNodes);
        this.cmdSelectedNodes.setFont(new Font("Dialog", 0, 12));
        this.cmdSelectedNodes.setSelected(true);
        this.cmdSelectedNodes.setText(Translator.getString("SelectedNodes"));
        this.cmdSelectedNodes.setName("SelectedNodes");
        this.cmdGrpApplyTo.add(this.cmdSelectedNodes);
        this.pnlApplyTo.add(this.cmdSelectedNodes);
        this.pnlMain.add((Component)this.pnlApplyTo, "North");
        this.cmdConfigure.setText(Translator.getString("Configure"));
        this.cmdConfigure.setName("Configure");
        this.cmdConfigure.setFocusPainted(false);
        this.cmdConfigure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDialog.this.configureButtonActionPerformed(actionEvent);
            }
        });
        this.pnlButtons.add(this.cmdConfigure);
        this.cmdFinished.setText(Translator.getString("OK"));
        this.cmdFinished.setName("OK");
        this.cmdFinished.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDialog.this.finishedButtonActionPerformed(actionEvent);
            }
        });
        this.pnlButtons.add(this.cmdFinished);
        this.getRootPane().setDefaultButton(this.cmdFinished);
        this.cmdCancel.setText(Translator.getString("Cancel"));
        this.cmdCancel.setName("Cancel");
        this.cmdCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LayoutDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.pnlButtons.add(this.cmdCancel);
        this.pnlMain.add((Component)this.pnlButtons, "South");
        this.getContentPane().add((Component)this.pnlMain, "South");
        this.pnlLayoutControllers.setLayout(new BorderLayout());
        this.scrollLayoutControllers.setViewportView(this.lstLayoutControllers);
        this.pnlLayoutControllers.add((Component)this.scrollLayoutControllers, "Center");
        this.getContentPane().add((Component)this.pnlLayoutControllers, "Center");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.pack();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    protected void configureButtonActionPerformed(ActionEvent actionEvent) {
        this.configure();
    }

    protected void finishedButtonActionPerformed(ActionEvent actionEvent) {
        this.finish();
    }

    protected void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    protected void closeDialog(WindowEvent windowEvent) {
        this.cancel();
    }

    public static void main(String[] stringArray) {
        new LayoutDialog(new JFrame()).setVisible(true);
        System.exit(0);
    }
}

