/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import org.jgraph.GPGraphpad;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphTransferable;
import org.jgraph.graph.ParentMap;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GPTransferable;
import org.jgraph.pad.RealGraphCellRenderer;
import org.jgraph.pad.resources.Translator;

public class GPLibraryPanel
extends JComponent {
    public static final String LIBRARY_FORMAT = "LIB-1.0";
    protected int MAX = 60;
    protected ScrollablePanel panel;
    protected GraphCellsComponent selected = null;
    protected Border oldBorder = null;
    protected boolean dragging = false;
    protected JComboBox combo = new JComboBox();
    public boolean fullLibraryAccess = true;

    public GPLibraryPanel(String string, String[] stringArray, int n) {
        this.MAX = n;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(2 * this.MAX + 35, 0));
        this.setTransferHandler(new DNDTransferHandler());
        this.add((Component)this.combo, "North");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                GPLibraryPanel.this.setSelected(GPLibraryPanel.this.selected);
            }

            public void focusLost(FocusEvent focusEvent) {
                GPLibraryPanel.this.setSelected(GPLibraryPanel.this.selected);
            }
        });
        this.combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = GPLibraryPanel.this.combo.getSelectedItem();
                if (object instanceof ScrollablePanel) {
                    if (GPLibraryPanel.this.panel != null) {
                        GPLibraryPanel.this.remove(GPLibraryPanel.this.panel.getParent().getParent());
                        GPLibraryPanel.this.panel.getParent().getParent().remove(GPLibraryPanel.this.panel);
                    }
                    GPLibraryPanel.this.panel = (ScrollablePanel)object;
                    JScrollPane jScrollPane = new JScrollPane(GPLibraryPanel.this.panel);
                    jScrollPane.getViewport().setBackground(Color.white);
                    GPLibraryPanel.this.add((Component)jScrollPane, "Center");
                    GPLibraryPanel.this.panel.getParent().addMouseListener(new MouseAdapter(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void mousePressed(MouseEvent mouseEvent) {
                            2.access$000(this.this$1).setSelected(null);
                            2.access$000(this.this$1).requestFocus();
                        }

                        public void mouseReleased(MouseEvent mouseEvent) {
                            if (2.access$000(this.this$1).isPopupTrigger(mouseEvent)) {
                                2.access$000(this.this$1).showPopupMenu(2.access$000(this.this$1).panel, mouseEvent.getPoint());
                            }
                        }
                    });
                    GPLibraryPanel.this.validate();
                }
            }

            static /* synthetic */ GPLibraryPanel access$000(2 var0) {
                return var0.GPLibraryPanel.this;
            }
        });
        if (stringArray != null && stringArray.length > 0) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.openLibrary(stringArray[n2]);
                ++n2;
            }
        }
        if (stringArray == null && string == null) {
            string = "No Name";
        }
        if (string != null && string.length() > 0) {
            this.addLibrary(string);
        }
        this.fullLibraryAccess = new Boolean(Translator.getString("FullLibraryAccess"));
    }

    protected boolean isPopupTrigger(MouseEvent mouseEvent) {
        return SwingUtilities.isRightMouseButton(mouseEvent);
    }

    public void showPopupMenu(Component component, Point point) {
        Container container = this;
        while ((container = container.getParent()) != null && !(container instanceof GPGraphpad)) {
        }
        GPGraphpad gPGraphpad = (GPGraphpad)container;
        if (gPGraphpad != null) {
            JPopupMenu jPopupMenu = gPGraphpad.getBarFactory().createLibraryPopupMenu();
            jPopupMenu.show(component, point.x, point.y);
        }
    }

    public ScrollablePanel addLibrary(String string) {
        ScrollablePanel scrollablePanel = new ScrollablePanel(string);
        this.combo.addItem(scrollablePanel);
        this.combo.setSelectedItem(scrollablePanel);
        return scrollablePanel;
    }

    public void openLibrary(Object object) {
        Vector vector;
        Object e;
        if (object instanceof Vector && (e = (vector = (Vector)object).get(0)) != null && e.equals(LIBRARY_FORMAT)) {
            this.addLibrary(vector.get(1).toString());
            int n = 2;
            while (n < vector.size()) {
                Object e2 = vector.get(n);
                Object e3 = vector.get(n + 1);
                Object e4 = vector.get(n + 2);
                Object e5 = vector.get(n + 3);
                GPTransferable gPTransferable = new GPTransferable("", (Object[])e2, (Map)e4, (Rectangle)e5, (ConnectionSet)e3, null);
                this.getTransferHandler().importData(this, gPTransferable);
                n += 4;
            }
        }
    }

    public void closeLibrary() {
        if (this.combo.getItemCount() > 1) {
            this.combo.removeItem(this.panel);
            this.combo.setSelectedIndex(0);
        }
    }

    public void setSelected(GraphCellsComponent graphCellsComponent) {
        if (this.selected != null && this.oldBorder != null) {
            this.selected.setBorder(this.oldBorder);
        }
        this.selected = graphCellsComponent;
        if (this.selected != null && this.hasFocus()) {
            this.oldBorder = this.selected.getBorder();
            this.selected.setBorder(BorderFactory.createLoweredBevelBorder());
        }
    }

    public void delete() {
        if (this.selected != null && this.fullLibraryAccess) {
            GraphCellsComponent graphCellsComponent = this.selected;
            GPTransferable gPTransferable = graphCellsComponent.getTransferable();
            this.panel.getGraph().getModel().remove(gPTransferable.getCells());
            this.panel.remove(graphCellsComponent);
            this.setSelected(null);
            this.panel.revalidate();
            this.repaint();
        }
    }

    public ScrollablePanel getPanel() {
        return this.panel;
    }

    public class GraphCellsComponent
    extends JComponent {
        protected GPGraph graph;
        protected GPTransferable trans;
        protected Object[] cells;
        protected RealGraphCellRenderer renderer;
        protected double scale = 0.5;

        public GraphCellsComponent(GPGraph gPGraph, Object[] objectArray, GPTransferable gPTransferable) {
            this.trans = gPTransferable;
            this.graph = gPGraph;
            this.setBorder(BorderFactory.createLineBorder(gPGraph.getMarqueeColor()));
            CellView[] cellViewArray = GPLibraryPanel.this.panel.getGraph().getGraphLayoutCache().getMapping(objectArray);
            this.renderer = new RealGraphCellRenderer(gPGraph, cellViewArray);
            this.renderer.setLocation(new Point(4, 4));
            Rectangle rectangle = AbstractCellView.getBounds(cellViewArray);
            int n = Math.max(rectangle.width, rectangle.height);
            if (n > GPLibraryPanel.this.MAX) {
                this.scale = (double)GPLibraryPanel.this.MAX / (double)Math.max(rectangle.width, rectangle.height);
                this.renderer.setScale(this.scale);
                rectangle.x = (int)((double)rectangle.x * this.scale);
                rectangle.y = (int)((double)rectangle.y * this.scale);
                rectangle.width = (int)((double)rectangle.width * this.scale);
                rectangle.height = (int)((double)rectangle.height * this.scale);
            }
            this.setPreferredSize(new Dimension(rectangle.width + 8, rectangle.height + 8));
            this.renderer.setSize(this.getPreferredSize());
            this.add(this.renderer);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ GraphCellsComponent this$1;
                {
                    this.this$1 = graphCellsComponent;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!GraphCellsComponent.access$100(this.this$1).isPopupTrigger(mouseEvent)) {
                        GraphCellsComponent.access$100(this.this$1).requestFocus();
                        GraphCellsComponent.access$100(this.this$1).setSelected(this.this$1);
                        GraphCellsComponent.access$100(this.this$1).getTransferHandler().exportAsDrag(GraphCellsComponent.access$100(this.this$1), mouseEvent, 1);
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (GraphCellsComponent.access$100(this.this$1).isPopupTrigger(mouseEvent)) {
                        GraphCellsComponent.access$100(this.this$1).showPopupMenu(GraphCellsComponent.access$100((GraphCellsComponent)this.this$1).panel, mouseEvent.getPoint());
                    }
                }
            });
        }

        public GPTransferable getTransferable() {
            return this.trans;
        }

        static /* synthetic */ GPLibraryPanel access$100(GraphCellsComponent graphCellsComponent) {
            return graphCellsComponent.GPLibraryPanel.this;
        }
    }

    public static class FixedWidthFlowLayout
    extends FlowLayout {
        public FixedWidthFlowLayout() {
            super(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Serializable serializable;
                int n = container.getParent().getSize().width;
                int n2 = this.getVgap();
                int n3 = this.getHgap();
                Dimension dimension = new Dimension(n, 0);
                int n4 = container.getComponentCount();
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n4) {
                    serializable = container.getComponent(n7);
                    if (((Component)serializable).isVisible()) {
                        Dimension dimension2 = ((Component)serializable).getPreferredSize();
                        if ((n5 += dimension2.width + n3) >= n) {
                            dimension.height += n6 + n2;
                            n5 = dimension2.width + n3;
                            n6 = 0;
                        }
                        n6 = Math.max(n6, dimension2.height);
                    }
                    ++n7;
                }
                serializable = container.getInsets();
                dimension.height += n6 + ((Insets)serializable).top + ((Insets)serializable).bottom + n2 * 2;
                return dimension;
            }
        }
    }

    class DNDTransferHandler
    extends TransferHandler {
        DNDTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (GPLibraryPanel.this.selected != null) {
                GPLibraryPanel.this.dragging = true;
                return GPLibraryPanel.this.selected.getTransferable();
            }
            return null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            GPLibraryPanel.this.dragging = false;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            block6: {
                if (!transferable.isDataFlavorSupported(GraphTransferable.dataFlavor) || GPLibraryPanel.this.dragging) break block6;
                try {
                    Object object = transferable.getTransferData(GraphTransferable.dataFlavor);
                    if (object instanceof GraphTransferable && !GPLibraryPanel.this.dragging) {
                        Object object2;
                        GraphTransferable graphTransferable = (GraphTransferable)object;
                        Rectangle rectangle = graphTransferable.getBounds() != null ? graphTransferable.getBounds() : new Rectangle();
                        Map map = graphTransferable.getCells() != null ? GPLibraryPanel.this.panel.getGraph().cloneCells(graphTransferable.getCells()) : new Hashtable();
                        ConnectionSet connectionSet = graphTransferable.getConnectionSet() != null ? graphTransferable.getConnectionSet().clone(map) : new ConnectionSet();
                        ParentMap parentMap = graphTransferable.getParentMap() != null ? graphTransferable.getParentMap().clone(map) : new ParentMap();
                        Map map2 = graphTransferable.getAttributeMap() != null ? graphTransferable.getAttributeMap() : new Hashtable();
                        map2 = GraphConstants.replaceKeys(map, map2);
                        Object[] objectArray = map.values().toArray();
                        GPLibraryPanel.this.panel.getGraph().getModel().insert(objectArray, map2, connectionSet, parentMap, null);
                        int n = 0;
                        while (n < objectArray.length) {
                            Map map3;
                            object2 = GPLibraryPanel.this.panel.getGraph().getGraphLayoutCache().getMapping(objectArray[n], true);
                            if (map2 != null && (map3 = (Map)map2.get(objectArray[n])) != null) {
                                map3 = GraphConstants.cloneMap(map3);
                                GraphConstants.translate(map3, -rectangle.x, -rectangle.y);
                                object2.setAttributes(map3);
                            }
                            ++n;
                        }
                        object2 = graphTransferable.getCells();
                        objectArray = new Object[((Object[])object2).length];
                        int n2 = 0;
                        while (n2 < ((Object[])object2).length) {
                            objectArray[n2] = map.get(object2[n2]);
                            ++n2;
                        }
                        String string = graphTransferable.getPlainData();
                        GPTransferable gPTransferable = new GPTransferable(string, objectArray, map2, rectangle, connectionSet, parentMap);
                        GPLibraryPanel.this.panel.add(new GraphCellsComponent(GPLibraryPanel.this.panel.getGraph(), objectArray, gPTransferable));
                        GPLibraryPanel.this.panel.revalidate();
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
            return false;
        }
    }

    public class ScrollablePanel
    extends JPanel
    implements Scrollable {
        protected GPGraph graph = new GPGraph();
        protected String name;

        public ScrollablePanel(String string) {
            super(new FixedWidthFlowLayout());
            this.setBackground(Color.white);
            this.name = string;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        public GPGraph getGraph() {
            return this.graph;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public Serializable getArchiveableState() {
            Vector<Object> vector = new Vector<Object>();
            vector.add(GPLibraryPanel.LIBRARY_FORMAT);
            vector.add(this.name);
            Component[] componentArray = this.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof GraphCellsComponent) {
                    GPTransferable gPTransferable = ((GraphCellsComponent)componentArray[n]).getTransferable();
                    vector.add(gPTransferable.getCells());
                    vector.add(gPTransferable.getConnectionSet());
                    vector.add(gPTransferable.getAttributeMap());
                    vector.add(gPTransferable.getBounds());
                }
                ++n;
            }
            return vector;
        }
    }
}

