.\" $Xorg: xsetroot.man,v 1.4 2001/02/09 02:05:59 xorgcvs Exp $
.\" Copyright 1988, 1998  The Open Group
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\" $XFree86: xc/programs/xsetroot/xsetroot.man,v 1.7 2001/01/27 18:21:23 dawes Exp $
.\"
.TH XSETROOT 1 __xorgversion__
.SH NAME
xsetroot \- root window parameter setting utility for X
.SH SYNOPSIS
.B xsetroot
[-help] [-def] [-display \fIdisplay\fP]
[-cursor \fIcursorfile maskfile\fP]
[-cursor_name \fIcursorname\fP]
[-bitmap \fIfilename\fP]
[-mod \fIx y\fP] [-gray] [-grey] [-fg \fIcolor\fP] [-bg \fIcolor\fP] [-rv]
[-solid \fIcolor\fP] [-name \fIstring\fP]
.SH DESCRIPTION
The 
.I xsetroot
program
allows you to tailor the appearance of the background ("root")
window on a workstation display running X.  Normally, you experiment with
.I xsetroot
until you find a personalized look that you like, then put the
.I xsetroot
command that produces it into your X startup file.
If no options are specified, or if
.I -def
is specified, the window is reset to its default state.  The
.I -def
option can be specified along with other options and only the non-specified
characteristics will be reset to the default state.
.PP
Only one of the background color/tiling changing options 
(-solid, -gray, -grey, -bitmap, and -mod) may be specified at a time.
.SH OPTIONS
.PP
The various options are as follows:
.IP \fB-help\fP
Print a usage message and exit.
.IP \fB-def\fP
Reset unspecified attributes to the default values.  (Restores the background
to the familiar gray mesh and the cursor to the hollow x shape.)
.IP "\fB-cursor\fP \fIcursorfile\fP \fImaskfile\fP"
This lets you change the pointer cursor to whatever
you want when the pointer cursor is outside of any window.
Cursor and mask files are bitmaps (little pictures), and can be made with the
.I bitmap(1)
program.  You probably want the mask file to be all black until you
get used to the way masks work.
.IP "\fB-cursor_name\fP \fIcursorname\fP
This lets you change the pointer cursor to one of the standard
cursors from the cursor font.  Refer to appendix B of the X protocol for
the names (except that the XC_ prefix is elided for this option).
.IP "\fB-bitmap\fP \fIfilename\fP"
Use the bitmap specified in the file to set the window pattern.  You can
make your own bitmap files (little pictures) using the
.I bitmap(1)
program.  The entire background will be made up of repeated "tiles" of
the bitmap.
.IP "\fB-mod\fP \fIx\fP \fIy\fP"
This is used if you want a plaid-like grid pattern on your screen.
x and y are integers ranging from 1 to 16.  Try the different combinations.
Zero and negative numbers are taken as 1.
.IP \fB-gray\fP
Make the entire background gray.  (Easier on the eyes.)
.IP \fB-grey\fP
Make the entire background grey.
.IP "\fB-fg\fP \fIcolor\fP"
Use ``color'' as the foreground color.  Foreground and background colors
are meaningful only in combination with -cursor, -bitmap, or -mod.
.IP "\fB-bg\fP \fIcolor\fP"
Use ``color'' as the background color.  
.IP \fB-rv\fP
This exchanges the foreground and background colors.  Normally the foreground
color is black and the background color is white.
.IP "\fB-solid\fP \fIcolor\fP"
This sets the background of the root window to the specified color.  This
option is only useful on color servers.
.IP "\fB-name\fP \fIstring\fP"
Set the name of the root window to ``string''.  There is no default value.
Usually a name is assigned to a window so that the
window manager can use a text representation when the window is iconified.
This option is unused since you can't iconify the background.
.IP "\fB-display\fP \fIdisplay\fP"
Specifies the server to connect to; see \fIX(__miscmansuffix__)\fP.
.SH "SEE ALSO"
X(__miscmansuffix__), xset(1), xrdb(1)
.SH AUTHOR
Mark Lillibridge, MIT Project Athena
