.\" $OpenBSD: usbtablet.man,v 1.1.1.1 2009/11/22 19:10:59 matthieu Exp $
.\"
.\" Copyright (c) 1999-2004 Matthieu Herrb and Lennart Augustsson
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH USBTABLET __drivermansuffix__ __vendorversion__
.SH NAME
usbtablet \- USB tablet input driver for *BSD
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" idevname \*q
.B  "  Driver \*qusbtablet\*q"
.BI "  Option \*qDevice\*q   \*q" devpath \*q
.BI "  Option \*qType\*q   \*q" type \*q
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B usbtablet
is an XFree86 input driver for USB tablet devices.
.PP
The
.B usbtablet
driver functions as a pointer input device, and may be used as the
X server's core pointer.
.SH SUPPORTED HARDWARE
This driver supports most USB tablets like the Wacom Graphire or
PenPartner tablets.
.SH CONFIGURATION DETAILS
Please refer to xorg.conf(__filemansuffix__) for general configuration
details and for options that can be used with all input drivers.  This
section only covers configuration details specific to this driver.
.PP
Each device
supports the following entries:
.RS 8
.TP 4
.B Option \fI"Type"\fP \fI"stylus"|"eraser"|"cursor"\fP
sets the type of tool the device represents. This option is mandatory.
.TP 4
.B Option \fI"Device"\fP \fI"path"\fP
sets the path to the special file which represents serial line where
the tablet is plugged in.  You have to specify it for each subsection with
the same value if you want to have multiple devices with the same tablet.
This option is mandatory.
.TP 4
.B Option \fI"Suppress"\fP \fI"Inumber"\fP
sets the position increment under which not to transmit coordinates.
 If you don't specify this entry, the default value is 2.
.TP 4
.B Option \fI"Threshold"\fP \fI"number"\fP
sets the pressure threshold used to generate a button 1 events of stylus
devices. The default value is 5.
.TP 4
.B Option \fI"Mode"\fP \fI"Relative"|"Absolute"\fP
sets the mode of the device.
.TP 4
.B Option \fI"HistorySize"\fP \fI"number"\fP
sets the motion history size. By default the value is zero.
.TP 4
.B Option \fI"FactorX"\fP \fI"number"\fP
Scaling factor between tablet coordinates and X screen coordinates. If
you don't specify it, it will be calculated to match the width of your
tablet to the width of your screen.
.TP 4
.B Option \fI"FactorY"\fP \fI"number"\fP
Scaling factor between tablet coordinates and X screen coordinates. If
you don't specify it, it will be calculated to match the height of your
tablet to the height of your screen.
.TP 4
.TP 4
.B Option \fI"DebugLevel"\fP \fInumber \fP
sets the level of debugging info reported.
.TP 4
.RE
.SH "SEE ALSO"
Xorg(1), xorg.conf(__filemansuffix__), Xserver(1), X(__miscmansuffix__).
.SH AUTHORS
Lennart Augustsson <augustss@netbsd.org> wrote the original version
for XFree86 3.3.6, Matthieu Herrb <matthieu@openbsd.org> adapted it to
XFree86 4.x.

