require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&AR_CR)) {
    sub AR_CR () {	0x8;}
}
unless(defined(&AR_RXDP)) {
    sub AR_RXDP () {	0xc;}
}
unless(defined(&AR_CFG)) {
    sub AR_CFG () {	0x14;}
}
unless(defined(&AR_MIRT)) {
    sub AR_MIRT () {	0x20;}
}
unless(defined(&AR_IER)) {
    sub AR_IER () {	0x24;}
}
unless(defined(&AR_TIMT)) {
    sub AR_TIMT () {	0x28;}
}
unless(defined(&AR_RIMT)) {
    sub AR_RIMT () {	0x2c;}
}
unless(defined(&AR_TXCFG)) {
    sub AR_TXCFG () {	0x30;}
}
unless(defined(&AR_RXCFG)) {
    sub AR_RXCFG () {	0x34;}
}
unless(defined(&AR_MIBC)) {
    sub AR_MIBC () {	0x40;}
}
unless(defined(&AR_TOPS)) {
    sub AR_TOPS () {	0x44;}
}
unless(defined(&AR_RXNPTO)) {
    sub AR_RXNPTO () {	0x48;}
}
unless(defined(&AR_TXNPTO)) {
    sub AR_TXNPTO () {	0x4c;}
}
unless(defined(&AR_RPGTO)) {
    sub AR_RPGTO () {	0x50;}
}
unless(defined(&AR_RPCNT)) {
    sub AR_RPCNT () {	0x54;}
}
unless(defined(&AR_MACMISC)) {
    sub AR_MACMISC () {	0x58;}
}
unless(defined(&AR_GTXTO)) {
    sub AR_GTXTO () {	0x64;}
}
unless(defined(&AR_GTTM)) {
    sub AR_GTTM () {	0x68;}
}
unless(defined(&AR_CST)) {
    sub AR_CST () {	0x6c;}
}
unless(defined(&AR_ISR)) {
    sub AR_ISR () {	0x80;}
}
unless(defined(&AR_ISR_S0)) {
    sub AR_ISR_S0 () {	0x84;}
}
unless(defined(&AR_ISR_S1)) {
    sub AR_ISR_S1 () {	0x88;}
}
unless(defined(&AR_ISR_S2)) {
    sub AR_ISR_S2 () {	0x8c;}
}
unless(defined(&AR_ISR_S3)) {
    sub AR_ISR_S3 () {	0x90;}
}
unless(defined(&AR_ISR_S4)) {
    sub AR_ISR_S4 () {	0x94;}
}
unless(defined(&AR_ISR_S5)) {
    sub AR_ISR_S5 () {	0x98;}
}
unless(defined(&AR_IMR)) {
    sub AR_IMR () {	0xa0;}
}
unless(defined(&AR_IMR_S0)) {
    sub AR_IMR_S0 () {	0xa4;}
}
unless(defined(&AR_IMR_S1)) {
    sub AR_IMR_S1 () {	0xa8;}
}
unless(defined(&AR_IMR_S2)) {
    sub AR_IMR_S2 () {	0xac;}
}
unless(defined(&AR_IMR_S3)) {
    sub AR_IMR_S3 () {	0xb0;}
}
unless(defined(&AR_IMR_S4)) {
    sub AR_IMR_S4 () {	0xb4;}
}
unless(defined(&AR_IMR_S5)) {
    sub AR_IMR_S5 () {	0xb8;}
}
unless(defined(&AR_ISR_RAC)) {
    sub AR_ISR_RAC () {	0xc0;}
}
unless(defined(&AR_ISR_S0_S)) {
    sub AR_ISR_S0_S () {	0xc4;}
}
unless(defined(&AR_ISR_S1_S)) {
    sub AR_ISR_S1_S () {	0xc8;}
}
unless(defined(&AR_ISR_S2_S)) {
    sub AR_ISR_S2_S () {	0xcc;}
}
unless(defined(&AR_ISR_S3_S)) {
    sub AR_ISR_S3_S () {	0xd0;}
}
unless(defined(&AR_ISR_S4_S)) {
    sub AR_ISR_S4_S () {	0xd4;}
}
unless(defined(&AR_ISR_S5_S)) {
    sub AR_ISR_S5_S () {	0xd8;}
}
unless(defined(&AR_DMADBG)) {
    sub AR_DMADBG {
	my($i) = @_;
	eval q((0xe0 + ($i) * 4));
    }
}
unless(defined(&AR_QTXDP)) {
    sub AR_QTXDP {
	my($i) = @_;
	eval q((0x800 + ($i) * 4));
    }
}
unless(defined(&AR_Q_TXE)) {
    sub AR_Q_TXE () {	0x840;}
}
unless(defined(&AR_Q_TXD)) {
    sub AR_Q_TXD () {	0x880;}
}
unless(defined(&AR_QCBRCFG)) {
    sub AR_QCBRCFG {
	my($i) = @_;
	eval q((0x8c0 + ($i) * 4));
    }
}
unless(defined(&AR_QRDYTIMECFG)) {
    sub AR_QRDYTIMECFG {
	my($i) = @_;
	eval q((0x900 + ($i) * 4));
    }
}
unless(defined(&AR_Q_ONESHOTARM_SC)) {
    sub AR_Q_ONESHOTARM_SC () {	0x940;}
}
unless(defined(&AR_Q_ONESHOTARM_CC)) {
    sub AR_Q_ONESHOTARM_CC () {	0x980;}
}
unless(defined(&AR_QMISC)) {
    sub AR_QMISC {
	my($i) = @_;
	eval q((0x9c0 + ($i) * 4));
    }
}
unless(defined(&AR_QSTS)) {
    sub AR_QSTS {
	my($i) = @_;
	eval q((0xa00 + ($i) * 4));
    }
}
unless(defined(&AR_Q_RDYTIMESHDN)) {
    sub AR_Q_RDYTIMESHDN () {	0xa40;}
}
unless(defined(&AR_DQCUMASK)) {
    sub AR_DQCUMASK {
	my($i) = @_;
	eval q((0x1000 + ($i) * 4));
    }
}
unless(defined(&AR_D_GBL_IFS_SIFS)) {
    sub AR_D_GBL_IFS_SIFS () {	0x1030;}
}
unless(defined(&AR_D_TXBLK_CMD)) {
    sub AR_D_TXBLK_CMD () {	0x1038;}
}
unless(defined(&AR_DLCL_IFS)) {
    sub AR_DLCL_IFS {
	my($i) = @_;
	eval q((0x1040 + ($i) * 4));
    }
}
unless(defined(&AR_D_GBL_IFS_SLOT)) {
    sub AR_D_GBL_IFS_SLOT () {	0x1070;}
}
unless(defined(&AR_DRETRY_LIMIT)) {
    sub AR_DRETRY_LIMIT {
	my($i) = @_;
	eval q((0x1080 + ($i) * 4));
    }
}
unless(defined(&AR_D_GBL_IFS_EIFS)) {
    sub AR_D_GBL_IFS_EIFS () {	0x10b0;}
}
unless(defined(&AR_DCHNTIME)) {
    sub AR_DCHNTIME {
	my($i) = @_;
	eval q((0x10c0 + ($i) * 4));
    }
}
unless(defined(&AR_D_GBL_IFS_MISC)) {
    sub AR_D_GBL_IFS_MISC () {	0x10f0;}
}
unless(defined(&AR_DMISC)) {
    sub AR_DMISC {
	my($i) = @_;
	eval q((0x1100 + ($i) * 4));
    }
}
unless(defined(&AR_D_SEQNUM)) {
    sub AR_D_SEQNUM () {	0x1140;}
}
unless(defined(&AR_D_FPCTL)) {
    sub AR_D_FPCTL () {	0x1230;}
}
unless(defined(&AR_D_TXPSE)) {
    sub AR_D_TXPSE () {	0x1270;}
}
unless(defined(&AR_D_TXSLOTMASK)) {
    sub AR_D_TXSLOTMASK () {	0x12f0;}
}
unless(defined(&AR_MAC_SLEEP)) {
    sub AR_MAC_SLEEP () {	0x1f00;}
}
unless(defined(&AR_CFG_LED)) {
    sub AR_CFG_LED () {	0x1f04;}
}
unless(defined(&AR_EEPROM_OFFSET)) {
    sub AR_EEPROM_OFFSET {
	my($i) = @_;
	eval q((0x2000 + ($i) * 4));
    }
}
unless(defined(&AR_RC)) {
    sub AR_RC () {	0x4000;}
}
unless(defined(&AR_WA)) {
    sub AR_WA () {	0x4004;}
}
unless(defined(&AR_PM_STATE)) {
    sub AR_PM_STATE () {	0x4008;}
}
unless(defined(&AR_PCIE_PM_CTRL)) {
    sub AR_PCIE_PM_CTRL () {	0x4014;}
}
unless(defined(&AR_HOST_TIMEOUT)) {
    sub AR_HOST_TIMEOUT () {	0x4018;}
}
unless(defined(&AR_EEPROM)) {
    sub AR_EEPROM () {	0x401c;}
}
unless(defined(&AR_SREV)) {
    sub AR_SREV () {	0x4020;}
}
unless(defined(&AR_AHB_MODE)) {
    sub AR_AHB_MODE () {	0x4024;}
}
unless(defined(&AR_INTR_SYNC_CAUSE)) {
    sub AR_INTR_SYNC_CAUSE () {	0x4028;}
}
unless(defined(&AR_INTR_SYNC_ENABLE)) {
    sub AR_INTR_SYNC_ENABLE () {	0x402c;}
}
unless(defined(&AR_INTR_ASYNC_MASK)) {
    sub AR_INTR_ASYNC_MASK () {	0x4030;}
}
unless(defined(&AR_INTR_SYNC_MASK)) {
    sub AR_INTR_SYNC_MASK () {	0x4034;}
}
unless(defined(&AR_INTR_ASYNC_CAUSE)) {
    sub AR_INTR_ASYNC_CAUSE () {	0x4038;}
}
unless(defined(&AR_INTR_ASYNC_ENABLE)) {
    sub AR_INTR_ASYNC_ENABLE () {	0x403c;}
}
unless(defined(&AR_PCIE_SERDES)) {
    sub AR_PCIE_SERDES () {	0x4040;}
}
unless(defined(&AR_PCIE_SERDES2)) {
    sub AR_PCIE_SERDES2 () {	0x4044;}
}
unless(defined(&AR_GPIO_IN_OUT)) {
    sub AR_GPIO_IN_OUT () {	0x4048;}
}
unless(defined(&AR_GPIO_OE_OUT)) {
    sub AR_GPIO_OE_OUT () {	0x404c;}
}
unless(defined(&AR_GPIO_INTR_POL)) {
    sub AR_GPIO_INTR_POL () {	0x4050;}
}
unless(defined(&AR_GPIO_INPUT_EN_VAL)) {
    sub AR_GPIO_INPUT_EN_VAL () {	0x4054;}
}
unless(defined(&AR_GPIO_INPUT_MUX1)) {
    sub AR_GPIO_INPUT_MUX1 () {	0x4058;}
}
unless(defined(&AR_GPIO_INPUT_MUX2)) {
    sub AR_GPIO_INPUT_MUX2 () {	0x405c;}
}
unless(defined(&AR_GPIO_OUTPUT_MUX)) {
    sub AR_GPIO_OUTPUT_MUX {
	my($i) = @_;
	eval q((0x4060 + ($i) * 4));
    }
}
unless(defined(&AR_INPUT_STATE)) {
    sub AR_INPUT_STATE () {	0x406c;}
}
unless(defined(&AR_EEPROM_STATUS_DATA)) {
    sub AR_EEPROM_STATUS_DATA () {	0x407c;}
}
unless(defined(&AR_OBS)) {
    sub AR_OBS () {	0x4080;}
}
unless(defined(&AR_GPIO_PDPU)) {
    sub AR_GPIO_PDPU () {	0x4088;}
}
unless(defined(&AR_PCIE_MSI)) {
    sub AR_PCIE_MSI () {	0x4094;}
}
unless(defined(&AR_RTC_RC)) {
    sub AR_RTC_RC () {	0x7000;}
}
unless(defined(&AR_RTC_PLL_CONTROL)) {
    sub AR_RTC_PLL_CONTROL () {	0x7014;}
}
unless(defined(&AR_RTC_RESET)) {
    sub AR_RTC_RESET () {	0x7040;}
}
unless(defined(&AR_RTC_STATUS)) {
    sub AR_RTC_STATUS () {	0x7044;}
}
unless(defined(&AR_RTC_SLEEP_CLK)) {
    sub AR_RTC_SLEEP_CLK () {	0x7048;}
}
unless(defined(&AR_RTC_FORCE_WAKE)) {
    sub AR_RTC_FORCE_WAKE () {	0x704c;}
}
unless(defined(&AR_RTC_INTR_CAUSE)) {
    sub AR_RTC_INTR_CAUSE () {	0x7050;}
}
unless(defined(&AR_RTC_INTR_ENABLE)) {
    sub AR_RTC_INTR_ENABLE () {	0x7054;}
}
unless(defined(&AR_RTC_INTR_MASK)) {
    sub AR_RTC_INTR_MASK () {	0x7058;}
}
unless(defined(&AR_IS_ANALOG_REG)) {
    sub AR_IS_ANALOG_REG {
	my($reg) = @_;
	eval q((($reg) >= 0x7800  && ($reg) <= 0x78b4));
    }
}
unless(defined(&AR_AN_RF2G1_CH0)) {
    sub AR_AN_RF2G1_CH0 () {	0x7810;}
}
unless(defined(&AR_AN_RF5G1_CH0)) {
    sub AR_AN_RF5G1_CH0 () {	0x7818;}
}
unless(defined(&AR_AN_RF2G1_CH1)) {
    sub AR_AN_RF2G1_CH1 () {	0x7834;}
}
unless(defined(&AR_AN_RF5G1_CH1)) {
    sub AR_AN_RF5G1_CH1 () {	0x783c;}
}
unless(defined(&AR_AN_SYNTH9)) {
    sub AR_AN_SYNTH9 () {	0x7868;}
}
unless(defined(&AR_AN_TOP1)) {
    sub AR_AN_TOP1 () {	0x7890;}
}
unless(defined(&AR_AN_TOP2)) {
    sub AR_AN_TOP2 () {	0x7894;}
}
unless(defined(&AR_STA_ID0)) {
    sub AR_STA_ID0 () {	0x8000;}
}
unless(defined(&AR_STA_ID1)) {
    sub AR_STA_ID1 () {	0x8004;}
}
unless(defined(&AR_BSS_ID0)) {
    sub AR_BSS_ID0 () {	0x8008;}
}
unless(defined(&AR_BSS_ID1)) {
    sub AR_BSS_ID1 () {	0x800c;}
}
unless(defined(&AR_BCN_RSSI_AVE)) {
    sub AR_BCN_RSSI_AVE () {	0x8010;}
}
unless(defined(&AR_TIME_OUT)) {
    sub AR_TIME_OUT () {	0x8014;}
}
unless(defined(&AR_RSSI_THR)) {
    sub AR_RSSI_THR () {	0x8018;}
}
unless(defined(&AR_USEC)) {
    sub AR_USEC () {	0x801c;}
}
unless(defined(&AR_RESET_TSF)) {
    sub AR_RESET_TSF () {	0x8020;}
}
unless(defined(&AR_MAX_CFP_DUR)) {
    sub AR_MAX_CFP_DUR () {	0x8038;}
}
unless(defined(&AR_RX_FILTER)) {
    sub AR_RX_FILTER () {	0x803c;}
}
unless(defined(&AR_MCAST_FIL0)) {
    sub AR_MCAST_FIL0 () {	0x8040;}
}
unless(defined(&AR_MCAST_FIL1)) {
    sub AR_MCAST_FIL1 () {	0x8044;}
}
unless(defined(&AR_DIAG_SW)) {
    sub AR_DIAG_SW () {	0x8048;}
}
unless(defined(&AR_TSF_L32)) {
    sub AR_TSF_L32 () {	0x804c;}
}
unless(defined(&AR_TSF_U32)) {
    sub AR_TSF_U32 () {	0x8050;}
}
unless(defined(&AR_TST_ADDAC)) {
    sub AR_TST_ADDAC () {	0x8054;}
}
unless(defined(&AR_DEF_ANTENNA)) {
    sub AR_DEF_ANTENNA () {	0x8058;}
}
unless(defined(&AR_AES_MUTE_MASK0)) {
    sub AR_AES_MUTE_MASK0 () {	0x805c;}
}
unless(defined(&AR_AES_MUTE_MASK1)) {
    sub AR_AES_MUTE_MASK1 () {	0x8060;}
}
unless(defined(&AR_GATED_CLKS)) {
    sub AR_GATED_CLKS () {	0x8064;}
}
unless(defined(&AR_OBS_BUS_CTRL)) {
    sub AR_OBS_BUS_CTRL () {	0x8068;}
}
unless(defined(&AR_OBS_BUS_1)) {
    sub AR_OBS_BUS_1 () {	0x806c;}
}
unless(defined(&AR_LAST_TSTP)) {
    sub AR_LAST_TSTP () {	0x8080;}
}
unless(defined(&AR_NAV)) {
    sub AR_NAV () {	0x8084;}
}
unless(defined(&AR_RTS_OK)) {
    sub AR_RTS_OK () {	0x8088;}
}
unless(defined(&AR_RTS_FAIL)) {
    sub AR_RTS_FAIL () {	0x808c;}
}
unless(defined(&AR_ACK_FAIL)) {
    sub AR_ACK_FAIL () {	0x8090;}
}
unless(defined(&AR_FCS_FAIL)) {
    sub AR_FCS_FAIL () {	0x8094;}
}
unless(defined(&AR_BEACON_CNT)) {
    sub AR_BEACON_CNT () {	0x8098;}
}
unless(defined(&AR_SLEEP1)) {
    sub AR_SLEEP1 () {	0x80d4;}
}
unless(defined(&AR_SLEEP2)) {
    sub AR_SLEEP2 () {	0x80d8;}
}
unless(defined(&AR_BSSMSKL)) {
    sub AR_BSSMSKL () {	0x80e0;}
}
unless(defined(&AR_BSSMSKU)) {
    sub AR_BSSMSKU () {	0x80e4;}
}
unless(defined(&AR_TPC)) {
    sub AR_TPC () {	0x80e8;}
}
unless(defined(&AR_TFCNT)) {
    sub AR_TFCNT () {	0x80ec;}
}
unless(defined(&AR_RFCNT)) {
    sub AR_RFCNT () {	0x80f0;}
}
unless(defined(&AR_RCCNT)) {
    sub AR_RCCNT () {	0x80f4;}
}
unless(defined(&AR_CCCNT)) {
    sub AR_CCCNT () {	0x80f8;}
}
unless(defined(&AR_QUIET1)) {
    sub AR_QUIET1 () {	0x80fc;}
}
unless(defined(&AR_QUIET2)) {
    sub AR_QUIET2 () {	0x8100;}
}
unless(defined(&AR_TSF_PARM)) {
    sub AR_TSF_PARM () {	0x8104;}
}
unless(defined(&AR_QOS_NO_ACK)) {
    sub AR_QOS_NO_ACK () {	0x8108;}
}
unless(defined(&AR_PHY_ERR)) {
    sub AR_PHY_ERR () {	0x810c;}
}
unless(defined(&AR_RXFIFO_CFG)) {
    sub AR_RXFIFO_CFG () {	0x8114;}
}
unless(defined(&AR_MIC_QOS_CONTROL)) {
    sub AR_MIC_QOS_CONTROL () {	0x8118;}
}
unless(defined(&AR_MIC_QOS_SELECT)) {
    sub AR_MIC_QOS_SELECT () {	0x811c;}
}
unless(defined(&AR_PCU_MISC)) {
    sub AR_PCU_MISC () {	0x8120;}
}
unless(defined(&AR_FILT_OFDM)) {
    sub AR_FILT_OFDM () {	0x8124;}
}
unless(defined(&AR_FILT_CCK)) {
    sub AR_FILT_CCK () {	0x8128;}
}
unless(defined(&AR_PHY_ERR_1)) {
    sub AR_PHY_ERR_1 () {	0x812c;}
}
unless(defined(&AR_PHY_ERR_MASK_1)) {
    sub AR_PHY_ERR_MASK_1 () {	0x8130;}
}
unless(defined(&AR_PHY_ERR_2)) {
    sub AR_PHY_ERR_2 () {	0x8134;}
}
unless(defined(&AR_PHY_ERR_MASK_2)) {
    sub AR_PHY_ERR_MASK_2 () {	0x8138;}
}
unless(defined(&AR_TSFOOR_THRESHOLD)) {
    sub AR_TSFOOR_THRESHOLD () {	0x813c;}
}
unless(defined(&AR_PHY_ERR_3)) {
    sub AR_PHY_ERR_3 () {	0x8168;}
}
unless(defined(&AR_PHY_ERR_MASK_3)) {
    sub AR_PHY_ERR_MASK_3 () {	0x816c;}
}
unless(defined(&AR_BT_COEX_MODE)) {
    sub AR_BT_COEX_MODE () {	0x8170;}
}
unless(defined(&AR_BT_COEX_WEIGHT)) {
    sub AR_BT_COEX_WEIGHT () {	0x8174;}
}
unless(defined(&AR_BT_COEX_MODE2)) {
    sub AR_BT_COEX_MODE2 () {	0x817c;}
}
unless(defined(&AR_NEXT_NDP2_TIMER)) {
    sub AR_NEXT_NDP2_TIMER {
	my($i) = @_;
	eval q((0x8180 + ($i) * 4));
    }
}
unless(defined(&AR_NDP2_PERIOD)) {
    sub AR_NDP2_PERIOD {
	my($i) = @_;
	eval q((0x81a0 + ($i) * 4));
    }
}
unless(defined(&AR_NDP2_TIMER_MODE)) {
    sub AR_NDP2_TIMER_MODE () {	0x81c0;}
}
unless(defined(&AR_TXSIFS)) {
    sub AR_TXSIFS () {	0x81d0;}
}
unless(defined(&AR_TXOP_X)) {
    sub AR_TXOP_X () {	0x81ec;}
}
unless(defined(&AR_TXOP_0_3)) {
    sub AR_TXOP_0_3 () {	0x81f0;}
}
unless(defined(&AR_TXOP_4_7)) {
    sub AR_TXOP_4_7 () {	0x81f4;}
}
unless(defined(&AR_TXOP_8_11)) {
    sub AR_TXOP_8_11 () {	0x81f8;}
}
unless(defined(&AR_TXOP_12_15)) {
    sub AR_TXOP_12_15 () {	0x81fc;}
}
unless(defined(&AR_NEXT_TBTT_TIMER)) {
    sub AR_NEXT_TBTT_TIMER () {	0x8200;}
}
unless(defined(&AR_NEXT_DMA_BEACON_ALERT)) {
    sub AR_NEXT_DMA_BEACON_ALERT () {	0x8204;}
}
unless(defined(&AR_NEXT_CFP)) {
    sub AR_NEXT_CFP () {	0x8208;}
}
unless(defined(&AR_NEXT_HCF)) {
    sub AR_NEXT_HCF () {	0x820c;}
}
unless(defined(&AR_NEXT_TIM)) {
    sub AR_NEXT_TIM () {	0x8210;}
}
unless(defined(&AR_NEXT_DTIM)) {
    sub AR_NEXT_DTIM () {	0x8214;}
}
unless(defined(&AR_NEXT_QUIET_TIMER)) {
    sub AR_NEXT_QUIET_TIMER () {	0x8218;}
}
unless(defined(&AR_NEXT_NDP_TIMER)) {
    sub AR_NEXT_NDP_TIMER () {	0x821c;}
}
unless(defined(&AR_BEACON_PERIOD)) {
    sub AR_BEACON_PERIOD () {	0x8220;}
}
unless(defined(&AR_DMA_BEACON_PERIOD)) {
    sub AR_DMA_BEACON_PERIOD () {	0x8224;}
}
unless(defined(&AR_SWBA_PERIOD)) {
    sub AR_SWBA_PERIOD () {	0x8228;}
}
unless(defined(&AR_HCF_PERIOD)) {
    sub AR_HCF_PERIOD () {	0x822c;}
}
unless(defined(&AR_TIM_PERIOD)) {
    sub AR_TIM_PERIOD () {	0x8230;}
}
unless(defined(&AR_DTIM_PERIOD)) {
    sub AR_DTIM_PERIOD () {	0x8234;}
}
unless(defined(&AR_QUIET_PERIOD)) {
    sub AR_QUIET_PERIOD () {	0x8238;}
}
unless(defined(&AR_NDP_PERIOD)) {
    sub AR_NDP_PERIOD () {	0x823c;}
}
unless(defined(&AR_TIMER_MODE)) {
    sub AR_TIMER_MODE () {	0x8240;}
}
unless(defined(&AR_SLP32_MODE)) {
    sub AR_SLP32_MODE () {	0x8244;}
}
unless(defined(&AR_SLP32_WAKE)) {
    sub AR_SLP32_WAKE () {	0x8248;}
}
unless(defined(&AR_SLP32_INC)) {
    sub AR_SLP32_INC () {	0x824c;}
}
unless(defined(&AR_SLP_CNT)) {
    sub AR_SLP_CNT () {	0x8250;}
}
unless(defined(&AR_SLP_CYCLE_CNT)) {
    sub AR_SLP_CYCLE_CNT () {	0x8254;}
}
unless(defined(&AR_SLP_MIB_CTRL)) {
    sub AR_SLP_MIB_CTRL () {	0x8258;}
}
unless(defined(&AR_WOW_PATTERN_REG)) {
    sub AR_WOW_PATTERN_REG () {	0x825c;}
}
unless(defined(&AR_WOW_COUNT_REG)) {
    sub AR_WOW_COUNT_REG () {	0x8260;}
}
unless(defined(&AR_MAC_PCU_LOGIC_ANALYZER)) {
    sub AR_MAC_PCU_LOGIC_ANALYZER () {	0x8264;}
}
unless(defined(&AR_WOW_BCN_EN_REG)) {
    sub AR_WOW_BCN_EN_REG () {	0x8270;}
}
unless(defined(&AR_WOW_BCN_TIMO_REG)) {
    sub AR_WOW_BCN_TIMO_REG () {	0x8274;}
}
unless(defined(&AR_WOW_KEEP_ALIVE_TIMO_REG)) {
    sub AR_WOW_KEEP_ALIVE_TIMO_REG () {	0x8278;}
}
unless(defined(&AR_WOW_KEEP_ALIVE_REG)) {
    sub AR_WOW_KEEP_ALIVE_REG () {	0x827c;}
}
unless(defined(&AR_WOW_US_SCALAR_REG)) {
    sub AR_WOW_US_SCALAR_REG () {	0x8284;}
}
unless(defined(&AR_WOW_KEEP_ALIVE_DELAY_REG)) {
    sub AR_WOW_KEEP_ALIVE_DELAY_REG () {	0x8288;}
}
unless(defined(&AR_WOW_PATTERN_MATCH_REG)) {
    sub AR_WOW_PATTERN_MATCH_REG () {	0x828c;}
}
unless(defined(&AR_WOW_PATTERN_OFF1_REG)) {
    sub AR_WOW_PATTERN_OFF1_REG () {	0x8290;}
}
unless(defined(&AR_WOW_PATTERN_OFF2_REG)) {
    sub AR_WOW_PATTERN_OFF2_REG () {	0x8294;}
}
unless(defined(&AR_WOW_EXACT_REG)) {
    sub AR_WOW_EXACT_REG () {	0x829c;}
}
unless(defined(&AR_2040_MODE)) {
    sub AR_2040_MODE () {	0x8318;}
}
unless(defined(&AR_EXTRCCNT)) {
    sub AR_EXTRCCNT () {	0x8328;}
}
unless(defined(&AR_SELFGEN_MASK)) {
    sub AR_SELFGEN_MASK () {	0x832c;}
}
unless(defined(&AR_PCU_TXBUF_CTRL)) {
    sub AR_PCU_TXBUF_CTRL () {	0x8340;}
}
unless(defined(&AR_PCU_MISC_MODE2)) {
    sub AR_PCU_MISC_MODE2 () {	0x8344;}
}
unless(defined(&AR_MAC_PCU_ASYNC_FIFO_REG3)) {
    sub AR_MAC_PCU_ASYNC_FIFO_REG3 () {	0x8358;}
}
unless(defined(&AR_WOW_LENGTH1_REG)) {
    sub AR_WOW_LENGTH1_REG () {	0x8360;}
}
unless(defined(&AR_WOW_LENGTH2_REG)) {
    sub AR_WOW_LENGTH2_REG () {	0x8364;}
}
unless(defined(&AR_WOW_PATTERN_MATCH_LT_256B)) {
    sub AR_WOW_PATTERN_MATCH_LT_256B () {	0x8368;}
}
unless(defined(&AR_RATE_DURATION)) {
    sub AR_RATE_DURATION {
	my($i) = @_;
	eval q((0x8700 + ($i) * 4));
    }
}
unless(defined(&AR_KEYTABLE)) {
    sub AR_KEYTABLE {
	my($i) = @_;
	eval q((0x8800 + ($i) * 32));
    }
}
unless(defined(&AR_KEYTABLE_KEY0)) {
    sub AR_KEYTABLE_KEY0 {
	my($i) = @_;
	eval q(( &AR_KEYTABLE($i) + 0));
    }
}
unless(defined(&AR_KEYTABLE_KEY1)) {
    sub AR_KEYTABLE_KEY1 {
	my($i) = @_;
	eval q(( &AR_KEYTABLE($i) + 4));
    }
}
unless(defined(&AR_KEYTABLE_KEY2)) {
    sub AR_KEYTABLE_KEY2 {
	my($i) = @_;
	eval q(( &AR_KEYTABLE($i) + 8));
    }
}
unless(defined(&AR_KEYTABLE_KEY3)) {
    sub AR_KEYTABLE_KEY3 {
	my($i) = @_;
	eval q(( &AR_KEYTABLE($i) + 12));
    }
}
unless(defined(&AR_KEYTABLE_KEY4)) {
    sub AR_KEYTABLE_KEY4 {
	my($i) = @_;
	eval q(( &AR_KEYTABLE($i) + 16));
    }
}
unless(defined(&AR_KEYTABLE_TYPE)) {
    sub AR_KEYTABLE_TYPE {
	my($i) = @_;
	eval q(( &AR_KEYTABLE($i) + 20));
    }
}
unless(defined(&AR_KEYTABLE_MAC0)) {
    sub AR_KEYTABLE_MAC0 {
	my($i) = @_;
	eval q(( &AR_KEYTABLE($i) + 24));
    }
}
unless(defined(&AR_KEYTABLE_MAC1)) {
    sub AR_KEYTABLE_MAC1 {
	my($i) = @_;
	eval q(( &AR_KEYTABLE($i) + 28));
    }
}
unless(defined(&AR_PHY_BASE)) {
    sub AR_PHY_BASE () {	0x9800;}
}
unless(defined(&AR_PHY)) {
    sub AR_PHY {
	my($i) = @_;
	eval q(( &AR_PHY_BASE + ($i) * 4));
    }
}
unless(defined(&AR_PHY_TEST)) {
    sub AR_PHY_TEST () {	0x9800;}
}
unless(defined(&AR_PHY_TURBO)) {
    sub AR_PHY_TURBO () {	0x9804;}
}
unless(defined(&AR_PHY_TEST2)) {
    sub AR_PHY_TEST2 () {	0x9808;}
}
unless(defined(&AR_PHY_TIMING2)) {
    sub AR_PHY_TIMING2 () {	0x9810;}
}
unless(defined(&AR_PHY_TIMING3)) {
    sub AR_PHY_TIMING3 () {	0x9814;}
}
unless(defined(&AR_PHY_CHIP_ID)) {
    sub AR_PHY_CHIP_ID () {	0x9818;}
}
unless(defined(&AR_PHY_ACTIVE)) {
    sub AR_PHY_ACTIVE () {	0x981c;}
}
unless(defined(&AR_PHY_RF_CTL2)) {
    sub AR_PHY_RF_CTL2 () {	0x9824;}
}
unless(defined(&AR_PHY_RF_CTL3)) {
    sub AR_PHY_RF_CTL3 () {	0x9828;}
}
unless(defined(&AR_PHY_ADC_CTL)) {
    sub AR_PHY_ADC_CTL () {	0x982c;}
}
unless(defined(&AR_PHY_ADC_SERIAL_CTL)) {
    sub AR_PHY_ADC_SERIAL_CTL () {	0x9830;}
}
unless(defined(&AR_PHY_RF_CTL4)) {
    sub AR_PHY_RF_CTL4 () {	0x9834;}
}
unless(defined(&AR_PHY_TSTDAC_CONST)) {
    sub AR_PHY_TSTDAC_CONST () {	0x983c;}
}
unless(defined(&AR_PHY_SETTLING)) {
    sub AR_PHY_SETTLING () {	0x9844;}
}
unless(defined(&AR_PHY_RXGAIN)) {
    sub AR_PHY_RXGAIN () {	0x9848;}
}
unless(defined(&AR_PHY_DESIRED_SZ)) {
    sub AR_PHY_DESIRED_SZ () {	0x9850;}
}
unless(defined(&AR_PHY_FIND_SIG)) {
    sub AR_PHY_FIND_SIG () {	0x9858;}
}
unless(defined(&AR_PHY_AGC_CTL1)) {
    sub AR_PHY_AGC_CTL1 () {	0x985c;}
}
unless(defined(&AR_PHY_AGC_CONTROL)) {
    sub AR_PHY_AGC_CONTROL () {	0x9860;}
}
unless(defined(&AR_PHY_CCA)) {
    sub AR_PHY_CCA {
	my($i) = @_;
	eval q((0x9864 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_SFCORR)) {
    sub AR_PHY_SFCORR () {	0x9868;}
}
unless(defined(&AR_PHY_SFCORR_LOW)) {
    sub AR_PHY_SFCORR_LOW () {	0x986c;}
}
unless(defined(&AR_PHY_SLEEP_CTR_CONTROL)) {
    sub AR_PHY_SLEEP_CTR_CONTROL () {	0x9870;}
}
unless(defined(&AR_PHY_SLEEP_CTR_LIMIT)) {
    sub AR_PHY_SLEEP_CTR_LIMIT () {	0x9874;}
}
unless(defined(&AR_PHY_SLEEP_SCAL)) {
    sub AR_PHY_SLEEP_SCAL () {	0x9878;}
}
unless(defined(&AR_PHY_PLL_CTL)) {
    sub AR_PHY_PLL_CTL () {	0x987c;}
}
unless(defined(&AR_PHY_BIN_MASK_1)) {
    sub AR_PHY_BIN_MASK_1 () {	0x9900;}
}
unless(defined(&AR_PHY_BIN_MASK_2)) {
    sub AR_PHY_BIN_MASK_2 () {	0x9904;}
}
unless(defined(&AR_PHY_BIN_MASK_3)) {
    sub AR_PHY_BIN_MASK_3 () {	0x9908;}
}
unless(defined(&AR_PHY_MASK_CTL)) {
    sub AR_PHY_MASK_CTL () {	0x990c;}
}
unless(defined(&AR_PHY_RX_DELAY)) {
    sub AR_PHY_RX_DELAY () {	0x9914;}
}
unless(defined(&AR_PHY_SEARCH_START_DELAY)) {
    sub AR_PHY_SEARCH_START_DELAY () {	0x9918;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_0)) {
    sub AR_PHY_TIMING_CTRL4_0 () {	0x9920;}
}
unless(defined(&AR_PHY_TIMING_CTRL4)) {
    sub AR_PHY_TIMING_CTRL4 {
	my($i) = @_;
	eval q((0x9920 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_TIMING5)) {
    sub AR_PHY_TIMING5 () {	0x9924;}
}
unless(defined(&AR_PHY_POWER_TX_RATE1)) {
    sub AR_PHY_POWER_TX_RATE1 () {	0x9934;}
}
unless(defined(&AR_PHY_POWER_TX_RATE2)) {
    sub AR_PHY_POWER_TX_RATE2 () {	0x9938;}
}
unless(defined(&AR_PHY_POWER_TX_RATE_MAX)) {
    sub AR_PHY_POWER_TX_RATE_MAX () {	0x993c;}
}
unless(defined(&AR_PHY_RADAR_EXT)) {
    sub AR_PHY_RADAR_EXT () {	0x9940;}
}
unless(defined(&AR_PHY_FRAME_CTL)) {
    sub AR_PHY_FRAME_CTL () {	0x9944;}
}
unless(defined(&AR_PHY_SPUR_REG)) {
    sub AR_PHY_SPUR_REG () {	0x994c;}
}
unless(defined(&AR_PHY_RADAR_0)) {
    sub AR_PHY_RADAR_0 () {	0x9954;}
}
unless(defined(&AR_PHY_RADAR_1)) {
    sub AR_PHY_RADAR_1 () {	0x9958;}
}
unless(defined(&AR_PHY_SWITCH_CHAIN_0)) {
    sub AR_PHY_SWITCH_CHAIN_0 () {	0x9960;}
}
unless(defined(&AR_PHY_SWITCH_COM)) {
    sub AR_PHY_SWITCH_COM () {	0x9964;}
}
unless(defined(&AR_PHY_SIGMA_DELTA)) {
    sub AR_PHY_SIGMA_DELTA () {	0x996c;}
}
unless(defined(&AR_PHY_RESTART)) {
    sub AR_PHY_RESTART () {	0x9970;}
}
unless(defined(&AR_PHY_RFBUS_REQ)) {
    sub AR_PHY_RFBUS_REQ () {	0x997c;}
}
unless(defined(&AR_PHY_TIMING7)) {
    sub AR_PHY_TIMING7 () {	0x9980;}
}
unless(defined(&AR_PHY_TIMING8)) {
    sub AR_PHY_TIMING8 () {	0x9984;}
}
unless(defined(&AR_PHY_BIN_MASK2_1)) {
    sub AR_PHY_BIN_MASK2_1 () {	0x9988;}
}
unless(defined(&AR_PHY_BIN_MASK2_2)) {
    sub AR_PHY_BIN_MASK2_2 () {	0x998c;}
}
unless(defined(&AR_PHY_BIN_MASK2_3)) {
    sub AR_PHY_BIN_MASK2_3 () {	0x9990;}
}
unless(defined(&AR_PHY_BIN_MASK2_4)) {
    sub AR_PHY_BIN_MASK2_4 () {	0x9994;}
}
unless(defined(&AR_PHY_TIMING9)) {
    sub AR_PHY_TIMING9 () {	0x9998;}
}
unless(defined(&AR_PHY_TIMING10)) {
    sub AR_PHY_TIMING10 () {	0x999c;}
}
unless(defined(&AR_PHY_TIMING11)) {
    sub AR_PHY_TIMING11 () {	0x99a0;}
}
unless(defined(&AR_PHY_RX_CHAINMASK)) {
    sub AR_PHY_RX_CHAINMASK () {	0x99a4;}
}
unless(defined(&AR_PHY_MULTICHAIN_GAIN_CTL)) {
    sub AR_PHY_MULTICHAIN_GAIN_CTL () {	0x99ac;}
}
unless(defined(&AR_PHY_NEW_ADC_DC_GAIN_CORR)) {
    sub AR_PHY_NEW_ADC_DC_GAIN_CORR {
	my($i) = @_;
	eval q((0x99b4 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_EXT_CCA0)) {
    sub AR_PHY_EXT_CCA0 () {	0x99b8;}
}
unless(defined(&AR_PHY_EXT_CCA)) {
    sub AR_PHY_EXT_CCA {
	my($i) = @_;
	eval q((0x99bc + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_SFCORR_EXT)) {
    sub AR_PHY_SFCORR_EXT () {	0x99c0;}
}
unless(defined(&AR_PHY_HALFGI)) {
    sub AR_PHY_HALFGI () {	0x99d0;}
}
unless(defined(&AR_PHY_CHANNEL_MASK_01_30)) {
    sub AR_PHY_CHANNEL_MASK_01_30 () {	0x99d4;}
}
unless(defined(&AR_PHY_CHANNEL_MASK_31_60)) {
    sub AR_PHY_CHANNEL_MASK_31_60 () {	0x99d8;}
}
unless(defined(&AR_PHY_CHAN_INFO_MEMORY)) {
    sub AR_PHY_CHAN_INFO_MEMORY () {	0x99dc;}
}
unless(defined(&AR_PHY_HEAVY_CLIP_ENABLE)) {
    sub AR_PHY_HEAVY_CLIP_ENABLE () {	0x99e0;}
}
unless(defined(&AR_PHY_HEAVY_CLIP_FACTOR_RIFS)) {
    sub AR_PHY_HEAVY_CLIP_FACTOR_RIFS () {	0x99ec;}
}
unless(defined(&AR_PHY_CALMODE)) {
    sub AR_PHY_CALMODE () {	0x99f0;}
}
unless(defined(&AR_PHY_REFCLKDLY)) {
    sub AR_PHY_REFCLKDLY () {	0x99f4;}
}
unless(defined(&AR_PHY_REFCLKPD)) {
    sub AR_PHY_REFCLKPD () {	0x99f8;}
}
unless(defined(&AR_PHY_BB_RFGAIN)) {
    sub AR_PHY_BB_RFGAIN {
	my($i) = @_;
	eval q((0x9a00 + ($i) * 4));
    }
}
unless(defined(&AR_PHY_CAL_MEAS_0)) {
    sub AR_PHY_CAL_MEAS_0 {
	my($i) = @_;
	eval q((0x9c10 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_CAL_MEAS_1)) {
    sub AR_PHY_CAL_MEAS_1 {
	my($i) = @_;
	eval q((0x9c14 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_CAL_MEAS_2)) {
    sub AR_PHY_CAL_MEAS_2 {
	my($i) = @_;
	eval q((0x9c18 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_CAL_MEAS_3)) {
    sub AR_PHY_CAL_MEAS_3 {
	my($i) = @_;
	eval q((0x9c1c + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_CURRENT_RSSI)) {
    sub AR_PHY_CURRENT_RSSI () {	0x9c1c;}
}
unless(defined(&AR_PHY_RFBUS_GRANT)) {
    sub AR_PHY_RFBUS_GRANT () {	0x9c20;}
}
unless(defined(&AR9280_PHY_CURRENT_RSSI)) {
    sub AR9280_PHY_CURRENT_RSSI () {	0x9c3c;}
}
unless(defined(&AR_PHY_CHAN_INFO_GAIN_DIFF)) {
    sub AR_PHY_CHAN_INFO_GAIN_DIFF () {	0x9cf4;}
}
unless(defined(&AR_PHY_CHAN_INFO_GAIN)) {
    sub AR_PHY_CHAN_INFO_GAIN () {	0x9cfc;}
}
unless(defined(&AR_PHY_MODE)) {
    sub AR_PHY_MODE () {	0xa200;}
}
unless(defined(&AR_PHY_CCK_TX_CTRL)) {
    sub AR_PHY_CCK_TX_CTRL () {	0xa204;}
}
unless(defined(&AR_PHY_CCK_DETECT)) {
    sub AR_PHY_CCK_DETECT () {	0xa208;}
}
unless(defined(&AR_PHY_GAIN_2GHZ)) {
    sub AR_PHY_GAIN_2GHZ () {	0xa20c;}
}
unless(defined(&AR_PHY_CCK_RXCTRL4)) {
    sub AR_PHY_CCK_RXCTRL4 () {	0xa21c;}
}
unless(defined(&AR_PHY_DAG_CTRLCCK)) {
    sub AR_PHY_DAG_CTRLCCK () {	0xa228;}
}
unless(defined(&AR_PHY_FORCE_CLKEN_CCK)) {
    sub AR_PHY_FORCE_CLKEN_CCK () {	0xa22c;}
}
unless(defined(&AR_PHY_POWER_TX_RATE3)) {
    sub AR_PHY_POWER_TX_RATE3 () {	0xa234;}
}
unless(defined(&AR_PHY_POWER_TX_RATE4)) {
    sub AR_PHY_POWER_TX_RATE4 () {	0xa238;}
}
unless(defined(&AR_PHY_SCRM_SEQ_XR)) {
    sub AR_PHY_SCRM_SEQ_XR () {	0xa23c;}
}
unless(defined(&AR_PHY_HEADER_DETECT_XR)) {
    sub AR_PHY_HEADER_DETECT_XR () {	0xa240;}
}
unless(defined(&AR_PHY_CHIRP_DETECTED_XR)) {
    sub AR_PHY_CHIRP_DETECTED_XR () {	0xa244;}
}
unless(defined(&AR_PHY_BLUETOOTH)) {
    sub AR_PHY_BLUETOOTH () {	0xa254;}
}
unless(defined(&AR_PHY_TPCRG1)) {
    sub AR_PHY_TPCRG1 () {	0xa258;}
}
unless(defined(&AR_PHY_TX_PWRCTRL4)) {
    sub AR_PHY_TX_PWRCTRL4 () {	0xa264;}
}
unless(defined(&AR_PHY_ANALOG_SWAP)) {
    sub AR_PHY_ANALOG_SWAP () {	0xa268;}
}
unless(defined(&AR_PHY_TPCRG5)) {
    sub AR_PHY_TPCRG5 () {	0xa26c;}
}
unless(defined(&AR_PHY_TX_PWRCTRL6_0)) {
    sub AR_PHY_TX_PWRCTRL6_0 () {	0xa270;}
}
unless(defined(&AR_PHY_TX_PWRCTRL7)) {
    sub AR_PHY_TX_PWRCTRL7 () {	0xa274;}
}
unless(defined(&AR_PHY_TX_PWRCTRL9)) {
    sub AR_PHY_TX_PWRCTRL9 () {	0xa27c;}
}
unless(defined(&AR_PHY_PDADC_TBL_BASE)) {
    sub AR_PHY_PDADC_TBL_BASE () {	0xa280;}
}
unless(defined(&AR_PHY_TX_GAIN_TBL)) {
    sub AR_PHY_TX_GAIN_TBL {
	my($i) = @_;
	eval q((0xa300 + ($i) * 4));
    }
}
unless(defined(&AR_PHY_CL_CAL_CTL)) {
    sub AR_PHY_CL_CAL_CTL () {	0xa358;}
}
unless(defined(&AR_PHY_POWER_TX_RATE5)) {
    sub AR_PHY_POWER_TX_RATE5 () {	0xa38c;}
}
unless(defined(&AR_PHY_POWER_TX_RATE6)) {
    sub AR_PHY_POWER_TX_RATE6 () {	0xa390;}
}
unless(defined(&AR_PHY_CH0_TX_PWRCTRL11)) {
    sub AR_PHY_CH0_TX_PWRCTRL11 () {	0xa398;}
}
unless(defined(&AR_PHY_CAL_CHAINMASK)) {
    sub AR_PHY_CAL_CHAINMASK () {	0xa39c;}
}
unless(defined(&AR_PHY_VIT_MASK2_M_46_61)) {
    sub AR_PHY_VIT_MASK2_M_46_61 () {	0xa3a0;}
}
unless(defined(&AR_PHY_VIT_MASK2_M_31_45)) {
    sub AR_PHY_VIT_MASK2_M_31_45 () {	0xa3a4;}
}
unless(defined(&AR_PHY_VIT_MASK2_M_16_30)) {
    sub AR_PHY_VIT_MASK2_M_16_30 () {	0xa3a8;}
}
unless(defined(&AR_PHY_VIT_MASK2_M_00_15)) {
    sub AR_PHY_VIT_MASK2_M_00_15 () {	0xa3ac;}
}
unless(defined(&AR_PHY_PILOT_MASK_01_30)) {
    sub AR_PHY_PILOT_MASK_01_30 () {	0xa3b0;}
}
unless(defined(&AR_PHY_PILOT_MASK_31_60)) {
    sub AR_PHY_PILOT_MASK_31_60 () {	0xa3b4;}
}
unless(defined(&AR_PHY_VIT_MASK2_P_15_01)) {
    sub AR_PHY_VIT_MASK2_P_15_01 () {	0xa3b8;}
}
unless(defined(&AR_PHY_VIT_MASK2_P_30_16)) {
    sub AR_PHY_VIT_MASK2_P_30_16 () {	0xa3bc;}
}
unless(defined(&AR_PHY_VIT_MASK2_P_45_31)) {
    sub AR_PHY_VIT_MASK2_P_45_31 () {	0xa3c0;}
}
unless(defined(&AR_PHY_VIT_MASK2_P_61_46)) {
    sub AR_PHY_VIT_MASK2_P_61_46 () {	0xa3c4;}
}
unless(defined(&AR_PHY_POWER_TX_SUB)) {
    sub AR_PHY_POWER_TX_SUB () {	0xa3c8;}
}
unless(defined(&AR_PHY_POWER_TX_RATE7)) {
    sub AR_PHY_POWER_TX_RATE7 () {	0xa3cc;}
}
unless(defined(&AR_PHY_POWER_TX_RATE8)) {
    sub AR_PHY_POWER_TX_RATE8 () {	0xa3d0;}
}
unless(defined(&AR_PHY_POWER_TX_RATE9)) {
    sub AR_PHY_POWER_TX_RATE9 () {	0xa3d4;}
}
unless(defined(&AR_PHY_XPA_CFG)) {
    sub AR_PHY_XPA_CFG () {	0xa3d8;}
}
unless(defined(&AR_PHY_TX_PWRCTRL6_1)) {
    sub AR_PHY_TX_PWRCTRL6_1 () {	0xb270;}
}
unless(defined(&AR_PHY_CH1_TX_PWRCTRL11)) {
    sub AR_PHY_CH1_TX_PWRCTRL11 () {	0xb398;}
}
unless(defined(&AR_CR_RXE)) {
    sub AR_CR_RXE () {	0x4;}
}
unless(defined(&AR_CR_RXD)) {
    sub AR_CR_RXD () {	0x20;}
}
unless(defined(&AR_CR_SWI)) {
    sub AR_CR_SWI () {	0x40;}
}
unless(defined(&AR_CFG_SWTD)) {
    sub AR_CFG_SWTD () {	0x1;}
}
unless(defined(&AR_CFG_SWTB)) {
    sub AR_CFG_SWTB () {	0x2;}
}
unless(defined(&AR_CFG_SWRD)) {
    sub AR_CFG_SWRD () {	0x4;}
}
unless(defined(&AR_CFG_SWRB)) {
    sub AR_CFG_SWRB () {	0x8;}
}
unless(defined(&AR_CFG_SWRG)) {
    sub AR_CFG_SWRG () {	0x10;}
}
unless(defined(&AR_CFG_AP_ADHOC_INDICATION)) {
    sub AR_CFG_AP_ADHOC_INDICATION () {	0x20;}
}
unless(defined(&AR_CFG_PHOK)) {
    sub AR_CFG_PHOK () {	0x100;}
}
unless(defined(&AR_CFG_EEBS)) {
    sub AR_CFG_EEBS () {	0x200;}
}
unless(defined(&AR_CFG_CLK_GATE_DIS)) {
    sub AR_CFG_CLK_GATE_DIS () {	0x400;}
}
unless(defined(&AR_CFG_PCI_MASTER_REQ_Q_THRESH_M)) {
    sub AR_CFG_PCI_MASTER_REQ_Q_THRESH_M () {	0x60000;}
}
unless(defined(&AR_CFG_PCI_MASTER_REQ_Q_THRESH_S)) {
    sub AR_CFG_PCI_MASTER_REQ_Q_THRESH_S () {	17;}
}
unless(defined(&AR_IER_ENABLE)) {
    sub AR_IER_ENABLE () {	0x1;}
}
unless(defined(&AR_TIMT_LAST_M)) {
    sub AR_TIMT_LAST_M () {	0xffff;}
}
unless(defined(&AR_TIMT_LAST_S)) {
    sub AR_TIMT_LAST_S () {	0;}
}
unless(defined(&AR_TIMT_FIRST_M)) {
    sub AR_TIMT_FIRST_M () {	0xffff0000;}
}
unless(defined(&AR_TIMT_FIRST_S)) {
    sub AR_TIMT_FIRST_S () {	16;}
}
unless(defined(&AR_RIMT_LAST_M)) {
    sub AR_RIMT_LAST_M () {	0xffff;}
}
unless(defined(&AR_RIMT_LAST_S)) {
    sub AR_RIMT_LAST_S () {	0;}
}
unless(defined(&AR_RIMT_FIRST_M)) {
    sub AR_RIMT_FIRST_M () {	0xffff0000;}
}
unless(defined(&AR_RIMT_FIRST_S)) {
    sub AR_RIMT_FIRST_S () {	16;}
}
unless(defined(&AR_DMASZ_4B)) {
    sub AR_DMASZ_4B () {	0;}
}
unless(defined(&AR_DMASZ_8B)) {
    sub AR_DMASZ_8B () {	1;}
}
unless(defined(&AR_DMASZ_16B)) {
    sub AR_DMASZ_16B () {	2;}
}
unless(defined(&AR_DMASZ_32B)) {
    sub AR_DMASZ_32B () {	3;}
}
unless(defined(&AR_DMASZ_64B)) {
    sub AR_DMASZ_64B () {	4;}
}
unless(defined(&AR_DMASZ_128B)) {
    sub AR_DMASZ_128B () {	5;}
}
unless(defined(&AR_DMASZ_256B)) {
    sub AR_DMASZ_256B () {	6;}
}
unless(defined(&AR_DMASZ_512B)) {
    sub AR_DMASZ_512B () {	7;}
}
unless(defined(&AR_TXCFG_DMASZ_M)) {
    sub AR_TXCFG_DMASZ_M () {	0x7;}
}
unless(defined(&AR_TXCFG_DMASZ_S)) {
    sub AR_TXCFG_DMASZ_S () {	0;}
}
unless(defined(&AR_TXCFG_FTRIG_M)) {
    sub AR_TXCFG_FTRIG_M () {	0x3f0;}
}
unless(defined(&AR_TXCFG_FTRIG_S)) {
    sub AR_TXCFG_FTRIG_S () {	4;}
}
unless(defined(&AR_TXCFG_FTRIG_IMMED)) {
    sub AR_TXCFG_FTRIG_IMMED () {	( 0/ 64);}
}
unless(defined(&AR_TXCFG_FTRIG_64B)) {
    sub AR_TXCFG_FTRIG_64B () {	( 64/ 64);}
}
unless(defined(&AR_TXCFG_FTRIG_128B)) {
    sub AR_TXCFG_FTRIG_128B () {	(128/ 64);}
}
unless(defined(&AR_TXCFG_FTRIG_192B)) {
    sub AR_TXCFG_FTRIG_192B () {	(192/ 64);}
}
unless(defined(&AR_TXCFG_FTRIG_256B)) {
    sub AR_TXCFG_FTRIG_256B () {	(256/ 64);}
}
unless(defined(&AR_TXCFG_FTRIG_512B)) {
    sub AR_TXCFG_FTRIG_512B () {	(512/ 64);}
}
unless(defined(&AR_TXCFG_ADHOC_BEACON_ATIM_TX_POLICY)) {
    sub AR_TXCFG_ADHOC_BEACON_ATIM_TX_POLICY () {	0x800;}
}
unless(defined(&AR_RXCFG_DMASZ_M)) {
    sub AR_RXCFG_DMASZ_M () {	0x7;}
}
unless(defined(&AR_RXCFG_DMASZ_S)) {
    sub AR_RXCFG_DMASZ_S () {	0;}
}
unless(defined(&AR_RXCFG_CHIRP)) {
    sub AR_RXCFG_CHIRP () {	0x8;}
}
unless(defined(&AR_RXCFG_ZLFDMA)) {
    sub AR_RXCFG_ZLFDMA () {	0x10;}
}
unless(defined(&AR_MIBC_COW)) {
    sub AR_MIBC_COW () {	0x1;}
}
unless(defined(&AR_MIBC_FMC)) {
    sub AR_MIBC_FMC () {	0x2;}
}
unless(defined(&AR_MIBC_CMC)) {
    sub AR_MIBC_CMC () {	0x4;}
}
unless(defined(&AR_MIBC_MCS)) {
    sub AR_MIBC_MCS () {	0x8;}
}
unless(defined(&AR_TOPS_MASK)) {
    sub AR_TOPS_MASK () {	0xffff;}
}
unless(defined(&AR_RXNPTO_MASK)) {
    sub AR_RXNPTO_MASK () {	0x3ff;}
}
unless(defined(&AR_TXNPTO_MASK)) {
    sub AR_TXNPTO_MASK () {	0x3ff;}
}
unless(defined(&AR_TXNPTO_QCU_MASK)) {
    sub AR_TXNPTO_QCU_MASK () {	0xffc00;}
}
unless(defined(&AR_RPGTO_MASK)) {
    sub AR_RPGTO_MASK () {	0x3ff;}
}
unless(defined(&AR_RPCNT_MASK)) {
    sub AR_RPCNT_MASK () {	0x1f;}
}
unless(defined(&AR_MACMISC_PCI_EXT_FORCE)) {
    sub AR_MACMISC_PCI_EXT_FORCE () {	0x10;}
}
unless(defined(&AR_MACMISC_DMA_OBS_M)) {
    sub AR_MACMISC_DMA_OBS_M () {	0x1e0;}
}
unless(defined(&AR_MACMISC_DMA_OBS_S)) {
    sub AR_MACMISC_DMA_OBS_S () {	5;}
}
unless(defined(&AR_MACMISC_MISC_OBS_M)) {
    sub AR_MACMISC_MISC_OBS_M () {	0xe00;}
}
unless(defined(&AR_MACMISC_MISC_OBS_S)) {
    sub AR_MACMISC_MISC_OBS_S () {	9;}
}
unless(defined(&AR_MACMISC_MISC_OBS_BUS_LSB_M)) {
    sub AR_MACMISC_MISC_OBS_BUS_LSB_M () {	0x7000;}
}
unless(defined(&AR_MACMISC_MISC_OBS_BUS_LSB_S)) {
    sub AR_MACMISC_MISC_OBS_BUS_LSB_S () {	12;}
}
unless(defined(&AR_MACMISC_MISC_OBS_BUS_MSB_M)) {
    sub AR_MACMISC_MISC_OBS_BUS_MSB_M () {	0x38000;}
}
unless(defined(&AR_MACMISC_MISC_OBS_BUS_MSB_S)) {
    sub AR_MACMISC_MISC_OBS_BUS_MSB_S () {	15;}
}
unless(defined(&AR_GTXTO_TIMEOUT_COUNTER_M)) {
    sub AR_GTXTO_TIMEOUT_COUNTER_M () {	0xffff;}
}
unless(defined(&AR_GTXTO_TIMEOUT_COUNTER_S)) {
    sub AR_GTXTO_TIMEOUT_COUNTER_S () {	0;}
}
unless(defined(&AR_GTXTO_TIMEOUT_LIMIT_M)) {
    sub AR_GTXTO_TIMEOUT_LIMIT_M () {	0xffff0000;}
}
unless(defined(&AR_GTXTO_TIMEOUT_LIMIT_S)) {
    sub AR_GTXTO_TIMEOUT_LIMIT_S () {	16;}
}
unless(defined(&AR_GTTM_USEC)) {
    sub AR_GTTM_USEC () {	0x1;}
}
unless(defined(&AR_GTTM_IGNORE_IDLE)) {
    sub AR_GTTM_IGNORE_IDLE () {	0x2;}
}
unless(defined(&AR_GTTM_RESET_IDLE)) {
    sub AR_GTTM_RESET_IDLE () {	0x4;}
}
unless(defined(&AR_GTTM_CST_USEC)) {
    sub AR_GTTM_CST_USEC () {	0x8;}
}
unless(defined(&AR_CST_TIMEOUT_COUNTER_M)) {
    sub AR_CST_TIMEOUT_COUNTER_M () {	0xffff;}
}
unless(defined(&AR_CST_TIMEOUT_COUNTER_S)) {
    sub AR_CST_TIMEOUT_COUNTER_S () {	0;}
}
unless(defined(&AR_CST_TIMEOUT_LIMIT_M)) {
    sub AR_CST_TIMEOUT_LIMIT_M () {	0xffff0000;}
}
unless(defined(&AR_CST_TIMEOUT_LIMIT_S)) {
    sub AR_CST_TIMEOUT_LIMIT_S () {	16;}
}
unless(defined(&AR_ISR_RXOK)) {
    sub AR_ISR_RXOK () {	0x1;}
}
unless(defined(&AR_ISR_RXDESC)) {
    sub AR_ISR_RXDESC () {	0x2;}
}
unless(defined(&AR_ISR_RXERR)) {
    sub AR_ISR_RXERR () {	0x4;}
}
unless(defined(&AR_ISR_RXNOPKT)) {
    sub AR_ISR_RXNOPKT () {	0x8;}
}
unless(defined(&AR_ISR_RXEOL)) {
    sub AR_ISR_RXEOL () {	0x10;}
}
unless(defined(&AR_ISR_RXORN)) {
    sub AR_ISR_RXORN () {	0x20;}
}
unless(defined(&AR_ISR_TXOK)) {
    sub AR_ISR_TXOK () {	0x40;}
}
unless(defined(&AR_ISR_TXDESC)) {
    sub AR_ISR_TXDESC () {	0x80;}
}
unless(defined(&AR_ISR_TXERR)) {
    sub AR_ISR_TXERR () {	0x100;}
}
unless(defined(&AR_ISR_TXNOPKT)) {
    sub AR_ISR_TXNOPKT () {	0x200;}
}
unless(defined(&AR_ISR_TXEOL)) {
    sub AR_ISR_TXEOL () {	0x400;}
}
unless(defined(&AR_ISR_TXURN)) {
    sub AR_ISR_TXURN () {	0x800;}
}
unless(defined(&AR_ISR_MIB)) {
    sub AR_ISR_MIB () {	0x1000;}
}
unless(defined(&AR_ISR_SWI)) {
    sub AR_ISR_SWI () {	0x2000;}
}
unless(defined(&AR_ISR_RXPHY)) {
    sub AR_ISR_RXPHY () {	0x4000;}
}
unless(defined(&AR_ISR_RXKCM)) {
    sub AR_ISR_RXKCM () {	0x8000;}
}
unless(defined(&AR_ISR_SWBA)) {
    sub AR_ISR_SWBA () {	0x10000;}
}
unless(defined(&AR_ISR_BRSSI)) {
    sub AR_ISR_BRSSI () {	0x20000;}
}
unless(defined(&AR_ISR_BMISS)) {
    sub AR_ISR_BMISS () {	0x40000;}
}
unless(defined(&AR_ISR_TXMINTR)) {
    sub AR_ISR_TXMINTR () {	0x80000;}
}
unless(defined(&AR_ISR_BNR)) {
    sub AR_ISR_BNR () {	0x100000;}
}
unless(defined(&AR_ISR_RXCHIRP)) {
    sub AR_ISR_RXCHIRP () {	0x200000;}
}
unless(defined(&AR_ISR_BCNMISC)) {
    sub AR_ISR_BCNMISC () {	0x800000;}
}
unless(defined(&AR_ISR_TIM)) {
    sub AR_ISR_TIM () {	0x800000;}
}
unless(defined(&AR_ISR_RXMINTR)) {
    sub AR_ISR_RXMINTR () {	0x1000000;}
}
unless(defined(&AR_ISR_QCBROVF)) {
    sub AR_ISR_QCBROVF () {	0x2000000;}
}
unless(defined(&AR_ISR_QCBRURN)) {
    sub AR_ISR_QCBRURN () {	0x4000000;}
}
unless(defined(&AR_ISR_QTRIG)) {
    sub AR_ISR_QTRIG () {	0x8000000;}
}
unless(defined(&AR_ISR_GENTMR)) {
    sub AR_ISR_GENTMR () {	0x10000000;}
}
unless(defined(&AR_ISR_TXINTM)) {
    sub AR_ISR_TXINTM () {	0x40000000;}
}
unless(defined(&AR_ISR_RXINTM)) {
    sub AR_ISR_RXINTM () {	0x80000000;}
}
unless(defined(&AR_ISR_S0_QCU_TXOK_M)) {
    sub AR_ISR_S0_QCU_TXOK_M () {	0x3ff;}
}
unless(defined(&AR_ISR_S0_QCU_TXOK_S)) {
    sub AR_ISR_S0_QCU_TXOK_S () {	0;}
}
unless(defined(&AR_ISR_S0_QCU_TXDESC_M)) {
    sub AR_ISR_S0_QCU_TXDESC_M () {	0x3ff0000;}
}
unless(defined(&AR_ISR_S0_QCU_TXDESC_S)) {
    sub AR_ISR_S0_QCU_TXDESC_S () {	16;}
}
unless(defined(&AR_ISR_S1_QCU_TXERR_M)) {
    sub AR_ISR_S1_QCU_TXERR_M () {	0x3ff;}
}
unless(defined(&AR_ISR_S1_QCU_TXERR_S)) {
    sub AR_ISR_S1_QCU_TXERR_S () {	0;}
}
unless(defined(&AR_ISR_S1_QCU_TXEOL_M)) {
    sub AR_ISR_S1_QCU_TXEOL_M () {	0x3ff0000;}
}
unless(defined(&AR_ISR_S1_QCU_TXEOL_S)) {
    sub AR_ISR_S1_QCU_TXEOL_S () {	16;}
}
unless(defined(&AR_ISR_S2_QCU_TXURN_M)) {
    sub AR_ISR_S2_QCU_TXURN_M () {	0x3ff;}
}
unless(defined(&AR_ISR_S2_QCU_TXURN_S)) {
    sub AR_ISR_S2_QCU_TXURN_S () {	0;}
}
unless(defined(&AR_ISR_S2_CST)) {
    sub AR_ISR_S2_CST () {	0x400000;}
}
unless(defined(&AR_ISR_S2_GTT)) {
    sub AR_ISR_S2_GTT () {	0x800000;}
}
unless(defined(&AR_ISR_S2_TIM)) {
    sub AR_ISR_S2_TIM () {	0x1000000;}
}
unless(defined(&AR_ISR_S2_CABEND)) {
    sub AR_ISR_S2_CABEND () {	0x2000000;}
}
unless(defined(&AR_ISR_S2_DTIMSYNC)) {
    sub AR_ISR_S2_DTIMSYNC () {	0x4000000;}
}
unless(defined(&AR_ISR_S2_BCNTO)) {
    sub AR_ISR_S2_BCNTO () {	0x8000000;}
}
unless(defined(&AR_ISR_S2_CABTO)) {
    sub AR_ISR_S2_CABTO () {	0x10000000;}
}
unless(defined(&AR_ISR_S2_DTIM)) {
    sub AR_ISR_S2_DTIM () {	0x20000000;}
}
unless(defined(&AR_ISR_S2_TSFOOR)) {
    sub AR_ISR_S2_TSFOOR () {	0x40000000;}
}
unless(defined(&AR_ISR_S2_TBTT_TIME)) {
    sub AR_ISR_S2_TBTT_TIME () {	0x80000000;}
}
unless(defined(&AR_ISR_S3_QCU_QCBROVF_M)) {
    sub AR_ISR_S3_QCU_QCBROVF_M () {	0x3ff;}
}
unless(defined(&AR_ISR_S3_QCU_QCBROVF_S)) {
    sub AR_ISR_S3_QCU_QCBROVF_S () {	0;}
}
unless(defined(&AR_ISR_S3_QCU_QCBRURN_M)) {
    sub AR_ISR_S3_QCU_QCBRURN_M () {	0x3ff0000;}
}
unless(defined(&AR_ISR_S3_QCU_QCBRURN_S)) {
    sub AR_ISR_S3_QCU_QCBRURN_S () {	0;}
}
unless(defined(&AR_ISR_S4_QCU_QTRIG_M)) {
    sub AR_ISR_S4_QCU_QTRIG_M () {	0x3ff;}
}
unless(defined(&AR_ISR_S4_QCU_QTRIG_S)) {
    sub AR_ISR_S4_QCU_QTRIG_S () {	0;}
}
unless(defined(&AR_ISR_S5_TIMER_TRIG_M)) {
    sub AR_ISR_S5_TIMER_TRIG_M () {	0xff;}
}
unless(defined(&AR_ISR_S5_TIMER_TRIG_S)) {
    sub AR_ISR_S5_TIMER_TRIG_S () {	0;}
}
unless(defined(&AR_ISR_S5_TIMER_THRESH_M)) {
    sub AR_ISR_S5_TIMER_THRESH_M () {	0x7fe00;}
}
unless(defined(&AR_ISR_S5_TIMER_THRESH_S)) {
    sub AR_ISR_S5_TIMER_THRESH_S () {	9;}
}
unless(defined(&AR_ISR_S5_TIM_TIMER)) {
    sub AR_ISR_S5_TIM_TIMER () {	0x10;}
}
unless(defined(&AR_ISR_S5_DTIM_TIMER)) {
    sub AR_ISR_S5_DTIM_TIMER () {	0x20;}
}
unless(defined(&AR_ISR_S5_GENTIMER_TRIG_M)) {
    sub AR_ISR_S5_GENTIMER_TRIG_M () {	0xff80;}
}
unless(defined(&AR_ISR_S5_GENTIMER_TRIG_S)) {
    sub AR_ISR_S5_GENTIMER_TRIG_S () {	0;}
}
unless(defined(&AR_ISR_S5_GENTIMER_THRESH_M)) {
    sub AR_ISR_S5_GENTIMER_THRESH_M () {	0xff800000;}
}
unless(defined(&AR_ISR_S5_GENTIMER_THRESH_S)) {
    sub AR_ISR_S5_GENTIMER_THRESH_S () {	16;}
}
unless(defined(&AR_IMR_RXOK)) {
    sub AR_IMR_RXOK () {	0x1;}
}
unless(defined(&AR_IMR_RXDESC)) {
    sub AR_IMR_RXDESC () {	0x2;}
}
unless(defined(&AR_IMR_RXERR)) {
    sub AR_IMR_RXERR () {	0x4;}
}
unless(defined(&AR_IMR_RXNOPKT)) {
    sub AR_IMR_RXNOPKT () {	0x8;}
}
unless(defined(&AR_IMR_RXEOL)) {
    sub AR_IMR_RXEOL () {	0x10;}
}
unless(defined(&AR_IMR_RXORN)) {
    sub AR_IMR_RXORN () {	0x20;}
}
unless(defined(&AR_IMR_TXOK)) {
    sub AR_IMR_TXOK () {	0x40;}
}
unless(defined(&AR_IMR_TXDESC)) {
    sub AR_IMR_TXDESC () {	0x80;}
}
unless(defined(&AR_IMR_TXERR)) {
    sub AR_IMR_TXERR () {	0x100;}
}
unless(defined(&AR_IMR_TXNOPKT)) {
    sub AR_IMR_TXNOPKT () {	0x200;}
}
unless(defined(&AR_IMR_TXEOL)) {
    sub AR_IMR_TXEOL () {	0x400;}
}
unless(defined(&AR_IMR_TXURN)) {
    sub AR_IMR_TXURN () {	0x800;}
}
unless(defined(&AR_IMR_MIB)) {
    sub AR_IMR_MIB () {	0x1000;}
}
unless(defined(&AR_IMR_SWI)) {
    sub AR_IMR_SWI () {	0x2000;}
}
unless(defined(&AR_IMR_RXPHY)) {
    sub AR_IMR_RXPHY () {	0x4000;}
}
unless(defined(&AR_IMR_RXKCM)) {
    sub AR_IMR_RXKCM () {	0x8000;}
}
unless(defined(&AR_IMR_SWBA)) {
    sub AR_IMR_SWBA () {	0x10000;}
}
unless(defined(&AR_IMR_BRSSI)) {
    sub AR_IMR_BRSSI () {	0x20000;}
}
unless(defined(&AR_IMR_BMISS)) {
    sub AR_IMR_BMISS () {	0x40000;}
}
unless(defined(&AR_IMR_TXMINTR)) {
    sub AR_IMR_TXMINTR () {	0x80000;}
}
unless(defined(&AR_IMR_BNR)) {
    sub AR_IMR_BNR () {	0x100000;}
}
unless(defined(&AR_IMR_RXCHIRP)) {
    sub AR_IMR_RXCHIRP () {	0x200000;}
}
unless(defined(&AR_IMR_BCNMISC)) {
    sub AR_IMR_BCNMISC () {	0x800000;}
}
unless(defined(&AR_IMR_TIM)) {
    sub AR_IMR_TIM () {	0x800000;}
}
unless(defined(&AR_IMR_RXMINTR)) {
    sub AR_IMR_RXMINTR () {	0x1000000;}
}
unless(defined(&AR_IMR_QCBROVF)) {
    sub AR_IMR_QCBROVF () {	0x2000000;}
}
unless(defined(&AR_IMR_QCBRURN)) {
    sub AR_IMR_QCBRURN () {	0x4000000;}
}
unless(defined(&AR_IMR_QTRIG)) {
    sub AR_IMR_QTRIG () {	0x8000000;}
}
unless(defined(&AR_IMR_GENTMR)) {
    sub AR_IMR_GENTMR () {	0x10000000;}
}
unless(defined(&AR_IMR_TXINTM)) {
    sub AR_IMR_TXINTM () {	0x40000000;}
}
unless(defined(&AR_IMR_RXINTM)) {
    sub AR_IMR_RXINTM () {	0x80000000;}
}
unless(defined(&AR_IMR_DEFAULT)) {
    sub AR_IMR_DEFAULT () {	( &AR_IMR_TXERR |  &AR_IMR_TXURN |  &AR_IMR_RXERR |  &AR_IMR_RXORN |  &AR_IMR_BCNMISC |  &AR_IMR_RXINTM |  &AR_IMR_RXMINTR |  &AR_IMR_TXOK);}
}
unless(defined(&AR_IMR_HOSTAP)) {
    sub AR_IMR_HOSTAP () {	( &AR_IMR_DEFAULT |  &AR_IMR_MIB);}
}
unless(defined(&AR_IMR_S0_QCU_TXOK)) {
    sub AR_IMR_S0_QCU_TXOK {
	my($qid) = @_;
	eval q((1<< ($qid)));
    }
}
unless(defined(&AR_IMR_S0_QCU_TXDESC)) {
    sub AR_IMR_S0_QCU_TXDESC {
	my($qid) = @_;
	eval q((1<< (16+ ($qid))));
    }
}
unless(defined(&AR_IMR_S1_QCU_TXERR)) {
    sub AR_IMR_S1_QCU_TXERR {
	my($qid) = @_;
	eval q((1<< ($qid)));
    }
}
unless(defined(&AR_IMR_S1_QCU_TXEOL)) {
    sub AR_IMR_S1_QCU_TXEOL {
	my($qid) = @_;
	eval q((1<< (16+ ($qid))));
    }
}
unless(defined(&AR_IMR_S2_QCU_TXURN)) {
    sub AR_IMR_S2_QCU_TXURN {
	my($qid) = @_;
	eval q((1<< ($qid)));
    }
}
unless(defined(&AR_IMR_S2_CST)) {
    sub AR_IMR_S2_CST () {	0x400000;}
}
unless(defined(&AR_IMR_S2_GTT)) {
    sub AR_IMR_S2_GTT () {	0x800000;}
}
unless(defined(&AR_IMR_S2_TIM)) {
    sub AR_IMR_S2_TIM () {	0x1000000;}
}
unless(defined(&AR_IMR_S2_CABEND)) {
    sub AR_IMR_S2_CABEND () {	0x2000000;}
}
unless(defined(&AR_IMR_S2_DTIMSYNC)) {
    sub AR_IMR_S2_DTIMSYNC () {	0x4000000;}
}
unless(defined(&AR_IMR_S2_BCNTO)) {
    sub AR_IMR_S2_BCNTO () {	0x8000000;}
}
unless(defined(&AR_IMR_S2_CABTO)) {
    sub AR_IMR_S2_CABTO () {	0x10000000;}
}
unless(defined(&AR_IMR_S2_DTIM)) {
    sub AR_IMR_S2_DTIM () {	0x20000000;}
}
unless(defined(&AR_IMR_S2_TSFOOR)) {
    sub AR_IMR_S2_TSFOOR () {	0x40000000;}
}
unless(defined(&AR_IMR_S3_QCU_QCBROVF)) {
    sub AR_IMR_S3_QCU_QCBROVF {
	my($qid) = @_;
	eval q((1<< ($qid)));
    }
}
unless(defined(&AR_IMR_S3_QCU_QCBRURN)) {
    sub AR_IMR_S3_QCU_QCBRURN {
	my($qid) = @_;
	eval q((1<< (16+ ($qid))));
    }
}
unless(defined(&AR_IMR_S4_QCU_QTRIG)) {
    sub AR_IMR_S4_QCU_QTRIG {
	my($qid) = @_;
	eval q((1<< ($qid)));
    }
}
unless(defined(&AR_IMR_S5_TIM_TIMER)) {
    sub AR_IMR_S5_TIM_TIMER () {	0x10;}
}
unless(defined(&AR_IMR_S5_DTIM_TIMER)) {
    sub AR_IMR_S5_DTIM_TIMER () {	0x20;}
}
unless(defined(&AR_IMR_S5_TIMER_TRIG_M)) {
    sub AR_IMR_S5_TIMER_TRIG_M () {	0xff;}
}
unless(defined(&AR_IMR_S5_TIMER_TRIG_S)) {
    sub AR_IMR_S5_TIMER_TRIG_S () {	0;}
}
unless(defined(&AR_IMR_S5_TIMER_THRESH_M)) {
    sub AR_IMR_S5_TIMER_THRESH_M () {	0xff00;}
}
unless(defined(&AR_IMR_S5_TIMER_THRESH_S)) {
    sub AR_IMR_S5_TIMER_THRESH_S () {	0;}
}
unless(defined(&AR_NUM_QCU)) {
    sub AR_NUM_QCU () {	10;}
}
unless(defined(&AR_QCU)) {
    sub AR_QCU {
	my($x) = @_;
	eval q((1<< ($x)));
    }
}
unless(defined(&AR_Q_TXE_M)) {
    sub AR_Q_TXE_M () {	0x3ff;}
}
unless(defined(&AR_Q_TXE_S)) {
    sub AR_Q_TXE_S () {	0;}
}
unless(defined(&AR_Q_TXD_M)) {
    sub AR_Q_TXD_M () {	0x3ff;}
}
unless(defined(&AR_Q_TXD_S)) {
    sub AR_Q_TXD_S () {	0;}
}
unless(defined(&AR_Q_CBRCFG_INTERVAL_M)) {
    sub AR_Q_CBRCFG_INTERVAL_M () {	0xffffff;}
}
unless(defined(&AR_Q_CBRCFG_INTERVAL_S)) {
    sub AR_Q_CBRCFG_INTERVAL_S () {	0;}
}
unless(defined(&AR_Q_CBRCFG_OVF_THRESH_M)) {
    sub AR_Q_CBRCFG_OVF_THRESH_M () {	0xff000000;}
}
unless(defined(&AR_Q_CBRCFG_OVF_THRESH_S)) {
    sub AR_Q_CBRCFG_OVF_THRESH_S () {	24;}
}
unless(defined(&AR_Q_RDYTIMECFG_DURATION_M)) {
    sub AR_Q_RDYTIMECFG_DURATION_M () {	0xffffff;}
}
unless(defined(&AR_Q_RDYTIMECFG_DURATION_S)) {
    sub AR_Q_RDYTIMECFG_DURATION_S () {	0;}
}
unless(defined(&AR_Q_RDYTIMECFG_EN)) {
    sub AR_Q_RDYTIMECFG_EN () {	0x1000000;}
}
unless(defined(&AR_Q_MISC_FSP_M)) {
    sub AR_Q_MISC_FSP_M () {	0xf;}
}
unless(defined(&AR_Q_MISC_FSP_S)) {
    sub AR_Q_MISC_FSP_S () {	0;}
}
unless(defined(&AR_Q_MISC_FSP_ASAP)) {
    sub AR_Q_MISC_FSP_ASAP () {	0;}
}
unless(defined(&AR_Q_MISC_FSP_CBR)) {
    sub AR_Q_MISC_FSP_CBR () {	1;}
}
unless(defined(&AR_Q_MISC_FSP_DBA_GATED)) {
    sub AR_Q_MISC_FSP_DBA_GATED () {	2;}
}
unless(defined(&AR_Q_MISC_FSP_TIM_GATED)) {
    sub AR_Q_MISC_FSP_TIM_GATED () {	3;}
}
unless(defined(&AR_Q_MISC_FSP_BEACON_SENT_GATED)) {
    sub AR_Q_MISC_FSP_BEACON_SENT_GATED () {	4;}
}
unless(defined(&AR_Q_MISC_FSP_BEACON_RCVD_GATED)) {
    sub AR_Q_MISC_FSP_BEACON_RCVD_GATED () {	5;}
}
unless(defined(&AR_Q_MISC_ONE_SHOT_EN)) {
    sub AR_Q_MISC_ONE_SHOT_EN () {	0x10;}
}
unless(defined(&AR_Q_MISC_CBR_INCR_DIS1)) {
    sub AR_Q_MISC_CBR_INCR_DIS1 () {	0x20;}
}
unless(defined(&AR_Q_MISC_CBR_INCR_DIS0)) {
    sub AR_Q_MISC_CBR_INCR_DIS0 () {	0x40;}
}
unless(defined(&AR_Q_MISC_BEACON_USE)) {
    sub AR_Q_MISC_BEACON_USE () {	0x80;}
}
unless(defined(&AR_Q_MISC_CBR_EXP_CNTR_LIMIT_EN)) {
    sub AR_Q_MISC_CBR_EXP_CNTR_LIMIT_EN () {	0x100;}
}
unless(defined(&AR_Q_MISC_RDYTIME_EXP_POLICY)) {
    sub AR_Q_MISC_RDYTIME_EXP_POLICY () {	0x200;}
}
unless(defined(&AR_Q_MISC_RESET_CBR_EXP_CTR)) {
    sub AR_Q_MISC_RESET_CBR_EXP_CTR () {	0x400;}
}
unless(defined(&AR_Q_MISC_DCU_EARLY_TERM_REQ)) {
    sub AR_Q_MISC_DCU_EARLY_TERM_REQ () {	0x800;}
}
unless(defined(&AR_Q_STS_PEND_FR_CNT_M)) {
    sub AR_Q_STS_PEND_FR_CNT_M () {	0x3;}
}
unless(defined(&AR_Q_STS_PEND_FR_CNT_S)) {
    sub AR_Q_STS_PEND_FR_CNT_S () {	0;}
}
unless(defined(&AR_Q_STS_CBR_EXP_CNT_M)) {
    sub AR_Q_STS_CBR_EXP_CNT_M () {	0xff00;}
}
unless(defined(&AR_Q_STS_CBR_EXP_CNT_S)) {
    sub AR_Q_STS_CBR_EXP_CNT_S () {	8;}
}
unless(defined(&AR_NUM_DCU)) {
    sub AR_NUM_DCU () {	10;}
}
unless(defined(&AR_DCU)) {
    sub AR_DCU {
	my($x) = @_;
	eval q((1<< ($x)));
    }
}
unless(defined(&AR_D_QCUMASK_M)) {
    sub AR_D_QCUMASK_M () {	0x3ff;}
}
unless(defined(&AR_D_QCUMASK_S)) {
    sub AR_D_QCUMASK_S () {	0;}
}
unless(defined(&AR_D_GBL_IFS_SIFS_ASYNC_FIFO_DUR)) {
    sub AR_D_GBL_IFS_SIFS_ASYNC_FIFO_DUR () {	0x3ab;}
}
unless(defined(&AR_D_TXBLK_WRITE_BITMASK_M)) {
    sub AR_D_TXBLK_WRITE_BITMASK_M () {	0xffff;}
}
unless(defined(&AR_D_TXBLK_WRITE_BITMASK_S)) {
    sub AR_D_TXBLK_WRITE_BITMASK_S () {	0;}
}
unless(defined(&AR_D_TXBLK_WRITE_SLICE_M)) {
    sub AR_D_TXBLK_WRITE_SLICE_M () {	0xf0000;}
}
unless(defined(&AR_D_TXBLK_WRITE_SLICE_S)) {
    sub AR_D_TXBLK_WRITE_SLICE_S () {	16;}
}
unless(defined(&AR_D_TXBLK_WRITE_DCU_M)) {
    sub AR_D_TXBLK_WRITE_DCU_M () {	0xf00000;}
}
unless(defined(&AR_D_TXBLK_WRITE_DCU_S)) {
    sub AR_D_TXBLK_WRITE_DCU_S () {	20;}
}
unless(defined(&AR_D_TXBLK_WRITE_COMMAND_M)) {
    sub AR_D_TXBLK_WRITE_COMMAND_M () {	0xf000000;}
}
unless(defined(&AR_D_TXBLK_WRITE_COMMAND_S)) {
    sub AR_D_TXBLK_WRITE_COMMAND_S () {	24;}
}
unless(defined(&AR_D_LCL_IFS_CWMIN_M)) {
    sub AR_D_LCL_IFS_CWMIN_M () {	0x3ff;}
}
unless(defined(&AR_D_LCL_IFS_CWMIN_S)) {
    sub AR_D_LCL_IFS_CWMIN_S () {	0;}
}
unless(defined(&AR_D_LCL_IFS_CWMAX_M)) {
    sub AR_D_LCL_IFS_CWMAX_M () {	0xffc00;}
}
unless(defined(&AR_D_LCL_IFS_CWMAX_S)) {
    sub AR_D_LCL_IFS_CWMAX_S () {	10;}
}
unless(defined(&AR_D_LCL_IFS_AIFS_M)) {
    sub AR_D_LCL_IFS_AIFS_M () {	0xff00000;}
}
unless(defined(&AR_D_LCL_IFS_AIFS_S)) {
    sub AR_D_LCL_IFS_AIFS_S () {	20;}
}
unless(defined(&AR_D_GBL_IFS_SLOT_M)) {
    sub AR_D_GBL_IFS_SLOT_M () {	0xffff;}
}
unless(defined(&AR_D_GBL_IFS_SLOT_S)) {
    sub AR_D_GBL_IFS_SLOT_S () {	0;}
}
unless(defined(&AR_D_GBL_IFS_SLOT_ASYNC_FIFO_DUR)) {
    sub AR_D_GBL_IFS_SLOT_ASYNC_FIFO_DUR () {	0x420;}
}
unless(defined(&AR_D_RETRY_LIMIT_FR_SH_M)) {
    sub AR_D_RETRY_LIMIT_FR_SH_M () {	0xf;}
}
unless(defined(&AR_D_RETRY_LIMIT_FR_SH_S)) {
    sub AR_D_RETRY_LIMIT_FR_SH_S () {	0;}
}
unless(defined(&AR_D_RETRY_LIMIT_STA_SH_M)) {
    sub AR_D_RETRY_LIMIT_STA_SH_M () {	0x3f00;}
}
unless(defined(&AR_D_RETRY_LIMIT_STA_SH_S)) {
    sub AR_D_RETRY_LIMIT_STA_SH_S () {	8;}
}
unless(defined(&AR_D_RETRY_LIMIT_STA_LG_M)) {
    sub AR_D_RETRY_LIMIT_STA_LG_M () {	0xfc000;}
}
unless(defined(&AR_D_RETRY_LIMIT_STA_LG_S)) {
    sub AR_D_RETRY_LIMIT_STA_LG_S () {	14;}
}
unless(defined(&AR_D_GBL_IFS_EIFS_M)) {
    sub AR_D_GBL_IFS_EIFS_M () {	0xffff;}
}
unless(defined(&AR_D_GBL_IFS_EIFS_S)) {
    sub AR_D_GBL_IFS_EIFS_S () {	0;}
}
unless(defined(&AR_D_GBL_IFS_EIFS_ASYNC_FIFO_DUR)) {
    sub AR_D_GBL_IFS_EIFS_ASYNC_FIFO_DUR () {	0xa5eb;}
}
unless(defined(&AR_D_CHNTIME_DUR_M)) {
    sub AR_D_CHNTIME_DUR_M () {	0xfffff;}
}
unless(defined(&AR_D_CHNTIME_DUR_S)) {
    sub AR_D_CHNTIME_DUR_S () {	0;}
}
unless(defined(&AR_D_CHNTIME_EN)) {
    sub AR_D_CHNTIME_EN () {	0x100000;}
}
unless(defined(&AR_D_GBL_IFS_MISC_LFSR_SLICE_SEL)) {
    sub AR_D_GBL_IFS_MISC_LFSR_SLICE_SEL () {	0x7;}
}
unless(defined(&AR_D_GBL_IFS_MISC_TURBO_MODE)) {
    sub AR_D_GBL_IFS_MISC_TURBO_MODE () {	0x8;}
}
unless(defined(&AR_D_GBL_IFS_MISC_USEC_DURATION)) {
    sub AR_D_GBL_IFS_MISC_USEC_DURATION () {	0xffc00;}
}
unless(defined(&AR_D_GBL_IFS_MISC_DCU_ARBITER_DLY)) {
    sub AR_D_GBL_IFS_MISC_DCU_ARBITER_DLY () {	0x300000;}
}
unless(defined(&AR_D_GBL_IFS_MISC_RANDOM_LFSR_SLICE_DIS)) {
    sub AR_D_GBL_IFS_MISC_RANDOM_LFSR_SLICE_DIS () {	0x1000000;}
}
unless(defined(&AR_D_GBL_IFS_MISC_SLOT_XMIT_WIND_LEN)) {
    sub AR_D_GBL_IFS_MISC_SLOT_XMIT_WIND_LEN () {	0x6000000;}
}
unless(defined(&AR_D_GBL_IFS_MISC_FORCE_XMIT_SLOT_BOUND)) {
    sub AR_D_GBL_IFS_MISC_FORCE_XMIT_SLOT_BOUND () {	0x8000000;}
}
unless(defined(&AR_D_GBL_IFS_MISC_IGNORE_BACKOFF)) {
    sub AR_D_GBL_IFS_MISC_IGNORE_BACKOFF () {	0x10000000;}
}
unless(defined(&AR_D_MISC_BKOFF_THRESH_M)) {
    sub AR_D_MISC_BKOFF_THRESH_M () {	0x3f;}
}
unless(defined(&AR_D_MISC_BKOFF_THRESH_S)) {
    sub AR_D_MISC_BKOFF_THRESH_S () {	0;}
}
unless(defined(&AR_D_MISC_RETRY_CNT_RESET_EN)) {
    sub AR_D_MISC_RETRY_CNT_RESET_EN () {	0x40;}
}
unless(defined(&AR_D_MISC_CW_RESET_EN)) {
    sub AR_D_MISC_CW_RESET_EN () {	0x80;}
}
unless(defined(&AR_D_MISC_FRAG_WAIT_EN)) {
    sub AR_D_MISC_FRAG_WAIT_EN () {	0x100;}
}
unless(defined(&AR_D_MISC_FRAG_BKOFF_EN)) {
    sub AR_D_MISC_FRAG_BKOFF_EN () {	0x200;}
}
unless(defined(&AR_D_MISC_CW_BKOFF_EN)) {
    sub AR_D_MISC_CW_BKOFF_EN () {	0x1000;}
}
unless(defined(&AR_D_MISC_VIR_COL_HANDLING_M)) {
    sub AR_D_MISC_VIR_COL_HANDLING_M () {	0xc000;}
}
unless(defined(&AR_D_MISC_VIR_COL_HANDLING_S)) {
    sub AR_D_MISC_VIR_COL_HANDLING_S () {	14;}
}
unless(defined(&AR_D_MISC_VIR_COL_HANDLING_DEFAULT)) {
    sub AR_D_MISC_VIR_COL_HANDLING_DEFAULT () {	0;}
}
unless(defined(&AR_D_MISC_VIR_COL_HANDLING_IGNORE)) {
    sub AR_D_MISC_VIR_COL_HANDLING_IGNORE () {	1;}
}
unless(defined(&AR_D_MISC_BEACON_USE)) {
    sub AR_D_MISC_BEACON_USE () {	0x10000;}
}
unless(defined(&AR_D_MISC_ARB_LOCKOUT_CNTRL_M)) {
    sub AR_D_MISC_ARB_LOCKOUT_CNTRL_M () {	0x60000;}
}
unless(defined(&AR_D_MISC_ARB_LOCKOUT_CNTRL_S)) {
    sub AR_D_MISC_ARB_LOCKOUT_CNTRL_S () {	17;}
}
unless(defined(&AR_D_MISC_ARB_LOCKOUT_CNTRL_NONE)) {
    sub AR_D_MISC_ARB_LOCKOUT_CNTRL_NONE () {	0;}
}
unless(defined(&AR_D_MISC_ARB_LOCKOUT_CNTRL_INTRA_FR)) {
    sub AR_D_MISC_ARB_LOCKOUT_CNTRL_INTRA_FR () {	1;}
}
unless(defined(&AR_D_MISC_ARB_LOCKOUT_CNTRL_GLOBAL)) {
    sub AR_D_MISC_ARB_LOCKOUT_CNTRL_GLOBAL () {	2;}
}
unless(defined(&AR_D_MISC_ARB_LOCKOUT_IGNORE)) {
    sub AR_D_MISC_ARB_LOCKOUT_IGNORE () {	0x80000;}
}
unless(defined(&AR_D_MISC_SEQ_NUM_INCR_DIS)) {
    sub AR_D_MISC_SEQ_NUM_INCR_DIS () {	0x100000;}
}
unless(defined(&AR_D_MISC_POST_FR_BKOFF_DIS)) {
    sub AR_D_MISC_POST_FR_BKOFF_DIS () {	0x200000;}
}
unless(defined(&AR_D_MISC_VIT_COL_CW_BKOFF_EN)) {
    sub AR_D_MISC_VIT_COL_CW_BKOFF_EN () {	0x400000;}
}
unless(defined(&AR_D_MISC_BLOWN_IFS_RETRY_EN)) {
    sub AR_D_MISC_BLOWN_IFS_RETRY_EN () {	0x800000;}
}
unless(defined(&AR_D_FPCTL_DCU_M)) {
    sub AR_D_FPCTL_DCU_M () {	0xf;}
}
unless(defined(&AR_D_FPCTL_DCU_S)) {
    sub AR_D_FPCTL_DCU_S () {	0;}
}
unless(defined(&AR_D_FPCTL_PREFETCH_EN)) {
    sub AR_D_FPCTL_PREFETCH_EN () {	0x10;}
}
unless(defined(&AR_D_FPCTL_BURST_PREFETCH_M)) {
    sub AR_D_FPCTL_BURST_PREFETCH_M () {	0x7fe0;}
}
unless(defined(&AR_D_FPCTL_BURST_PREFETCH_S)) {
    sub AR_D_FPCTL_BURST_PREFETCH_S () {	5;}
}
unless(defined(&AR_D_TXPSE_CTRL_M)) {
    sub AR_D_TXPSE_CTRL_M () {	0x3ff;}
}
unless(defined(&AR_D_TXPSE_CTRL_S)) {
    sub AR_D_TXPSE_CTRL_S () {	0;}
}
unless(defined(&AR_D_TXPSE_STATUS)) {
    sub AR_D_TXPSE_STATUS () {	0x10000;}
}
unless(defined(&AR_D_TXSLOTMASK_NUM)) {
    sub AR_D_TXSLOTMASK_NUM () {	0xf;}
}
unless(defined(&AR_MAC_SLEEP_MAC_ASLEEP)) {
    sub AR_MAC_SLEEP_MAC_ASLEEP () {	0x1;}
}
unless(defined(&AR_CFG_SCLK_RATE_IND_M)) {
    sub AR_CFG_SCLK_RATE_IND_M () {	0x3;}
}
unless(defined(&AR_CFG_SCLK_RATE_IND_S)) {
    sub AR_CFG_SCLK_RATE_IND_S () {	0;}
}
unless(defined(&AR_CFG_SCLK_32MHZ)) {
    sub AR_CFG_SCLK_32MHZ () {	0;}
}
unless(defined(&AR_CFG_SCLK_4MHZ)) {
    sub AR_CFG_SCLK_4MHZ () {	1;}
}
unless(defined(&AR_CFG_SCLK_1MHZ)) {
    sub AR_CFG_SCLK_1MHZ () {	2;}
}
unless(defined(&AR_CFG_SCLK_32KHZ)) {
    sub AR_CFG_SCLK_32KHZ () {	3;}
}
unless(defined(&AR_CFG_LED_BLINK_SLOW)) {
    sub AR_CFG_LED_BLINK_SLOW () {	0x8;}
}
unless(defined(&AR_CFG_LED_BLINK_THRESH_SEL_M)) {
    sub AR_CFG_LED_BLINK_THRESH_SEL_M () {	0x70;}
}
unless(defined(&AR_CFG_LED_BLINK_THRESH_SEL_S)) {
    sub AR_CFG_LED_BLINK_THRESH_SEL_S () {	4;}
}
unless(defined(&AR_CFG_LED_MODE_SEL_M)) {
    sub AR_CFG_LED_MODE_SEL_M () {	0x380;}
}
unless(defined(&AR_CFG_LED_MODE_SEL_S)) {
    sub AR_CFG_LED_MODE_SEL_S () {	7;}
}
unless(defined(&AR_CFG_LED_POWER_M)) {
    sub AR_CFG_LED_POWER_M () {	0x280;}
}
unless(defined(&AR_CFG_LED_POWER_S)) {
    sub AR_CFG_LED_POWER_S () {	7;}
}
unless(defined(&AR_CFG_LED_NETWORK_M)) {
    sub AR_CFG_LED_NETWORK_M () {	0x300;}
}
unless(defined(&AR_CFG_LED_NETWORK_S)) {
    sub AR_CFG_LED_NETWORK_S () {	7;}
}
unless(defined(&AR_CFG_LED_MODE_PROP)) {
    sub AR_CFG_LED_MODE_PROP () {	0;}
}
unless(defined(&AR_CFG_LED_MODE_RPROP)) {
    sub AR_CFG_LED_MODE_RPROP () {	1;}
}
unless(defined(&AR_CFG_LED_MODE_SPLIT)) {
    sub AR_CFG_LED_MODE_SPLIT () {	2;}
}
unless(defined(&AR_CFG_LED_MODE_RAND)) {
    sub AR_CFG_LED_MODE_RAND () {	3;}
}
unless(defined(&AR_CFG_LED_MODE_POWER_OFF)) {
    sub AR_CFG_LED_MODE_POWER_OFF () {	4;}
}
unless(defined(&AR_CFG_LED_MODE_POWER_ON)) {
    sub AR_CFG_LED_MODE_POWER_ON () {	5;}
}
unless(defined(&AR_CFG_LED_MODE_NETWORK_OFF)) {
    sub AR_CFG_LED_MODE_NETWORK_OFF () {	4;}
}
unless(defined(&AR_CFG_LED_MODE_NETWORK_ON)) {
    sub AR_CFG_LED_MODE_NETWORK_ON () {	6;}
}
unless(defined(&AR_CFG_LED_ASSOC_CTL_M)) {
    sub AR_CFG_LED_ASSOC_CTL_M () {	0xc00;}
}
unless(defined(&AR_CFG_LED_ASSOC_CTL_S)) {
    sub AR_CFG_LED_ASSOC_CTL_S () {	10;}
}
unless(defined(&AR_CFG_LED_ASSOC_NONE)) {
    sub AR_CFG_LED_ASSOC_NONE () {	0;}
}
unless(defined(&AR_CFG_LED_ASSOC_ACTIVE)) {
    sub AR_CFG_LED_ASSOC_ACTIVE () {	1;}
}
unless(defined(&AR_CFG_LED_ASSOC_PENDING)) {
    sub AR_CFG_LED_ASSOC_PENDING () {	2;}
}
unless(defined(&AR_RC_AHB)) {
    sub AR_RC_AHB () {	0x1;}
}
unless(defined(&AR_RC_APB)) {
    sub AR_RC_APB () {	0x2;}
}
unless(defined(&AR_RC_HOSTIF)) {
    sub AR_RC_HOSTIF () {	0x100;}
}
unless(defined(&AR5416_WA_DEFAULT)) {
    sub AR5416_WA_DEFAULT () {	0x73f;}
}
unless(defined(&AR9280_WA_DEFAULT)) {
    sub AR9280_WA_DEFAULT () {	0x40073b;}
}
unless(defined(&AR9285_WA_DEFAULT)) {
    sub AR9285_WA_DEFAULT () {	0x4a05cb;}
}
unless(defined(&AR_WA_UNTIE_RESET_EN)) {
    sub AR_WA_UNTIE_RESET_EN () {	0x8000;}
}
unless(defined(&AR_WA_RESET_EN)) {
    sub AR_WA_RESET_EN () {	0x40000;}
}
unless(defined(&AR_WA_ANALOG_SHIFT)) {
    sub AR_WA_ANALOG_SHIFT () {	0x100000;}
}
unless(defined(&AR_WA_POR_SHORT)) {
    sub AR_WA_POR_SHORT () {	0x200000;}
}
unless(defined(&AR_PM_STATE_PME_D3COLD_VAUX)) {
    sub AR_PM_STATE_PME_D3COLD_VAUX () {	0x100000;}
}
unless(defined(&AR_PCIE_PM_CTRL_ENA)) {
    sub AR_PCIE_PM_CTRL_ENA () {	0x80000;}
}
unless(defined(&AR_HOST_TIMEOUT_APB_CNTR_M)) {
    sub AR_HOST_TIMEOUT_APB_CNTR_M () {	0xffff;}
}
unless(defined(&AR_HOST_TIMEOUT_APB_CNTR_S)) {
    sub AR_HOST_TIMEOUT_APB_CNTR_S () {	0;}
}
unless(defined(&AR_HOST_TIMEOUT_LCL_CNTR_M)) {
    sub AR_HOST_TIMEOUT_LCL_CNTR_M () {	0xffff0000;}
}
unless(defined(&AR_HOST_TIMEOUT_LCL_CNTR_S)) {
    sub AR_HOST_TIMEOUT_LCL_CNTR_S () {	16;}
}
unless(defined(&AR_EEPROM_ABSENT)) {
    sub AR_EEPROM_ABSENT () {	0x100;}
}
unless(defined(&AR_EEPROM_CORRUPT)) {
    sub AR_EEPROM_CORRUPT () {	0x200;}
}
unless(defined(&AR_EEPROM_PROT_MASK_M)) {
    sub AR_EEPROM_PROT_MASK_M () {	0x3fffc00;}
}
unless(defined(&AR_EEPROM_PROT_MASK_S)) {
    sub AR_EEPROM_PROT_MASK_S () {	10;}
}
unless(defined(&AR_SREV_ID_M)) {
    sub AR_SREV_ID_M () {	0xff;}
}
unless(defined(&AR_SREV_ID_S)) {
    sub AR_SREV_ID_S () {	0;}
}
unless(defined(&AR_SREV_REVISION_M)) {
    sub AR_SREV_REVISION_M () {	0x7;}
}
unless(defined(&AR_SREV_REVISION_S)) {
    sub AR_SREV_REVISION_S () {	0;}
}
unless(defined(&AR_SREV_VERSION_M)) {
    sub AR_SREV_VERSION_M () {	0xf0;}
}
unless(defined(&AR_SREV_VERSION_S)) {
    sub AR_SREV_VERSION_S () {	4;}
}
unless(defined(&AR_SREV_VERSION2_M)) {
    sub AR_SREV_VERSION2_M () {	0xfffc0000;}
}
unless(defined(&AR_SREV_VERSION2_S)) {
    sub AR_SREV_VERSION2_S () {	12;}
}
unless(defined(&AR_SREV_TYPE2_M)) {
    sub AR_SREV_TYPE2_M () {	0x3f000;}
}
unless(defined(&AR_SREV_TYPE2_S)) {
    sub AR_SREV_TYPE2_S () {	12;}
}
unless(defined(&AR_SREV_TYPE2_CHAIN)) {
    sub AR_SREV_TYPE2_CHAIN () {	0x1000;}
}
unless(defined(&AR_SREV_TYPE2_HOST_MODE)) {
    sub AR_SREV_TYPE2_HOST_MODE () {	0x2000;}
}
unless(defined(&AR_SREV_REVISION2_M)) {
    sub AR_SREV_REVISION2_M () {	0xf00;}
}
unless(defined(&AR_SREV_REVISION2_S)) {
    sub AR_SREV_REVISION2_S () {	8;}
}
unless(defined(&AR_SREV_VERSION_5416_PCI)) {
    sub AR_SREV_VERSION_5416_PCI () {	0xd;}
}
unless(defined(&AR_SREV_VERSION_5416_PCIE)) {
    sub AR_SREV_VERSION_5416_PCIE () {	0xc;}
}
unless(defined(&AR_SREV_REVISION_5416_10)) {
    sub AR_SREV_REVISION_5416_10 () {	0;}
}
unless(defined(&AR_SREV_REVISION_5416_20)) {
    sub AR_SREV_REVISION_5416_20 () {	1;}
}
unless(defined(&AR_SREV_REVISION_5416_22)) {
    sub AR_SREV_REVISION_5416_22 () {	2;}
}
unless(defined(&AR_SREV_VERSION_9100)) {
    sub AR_SREV_VERSION_9100 () {	0x14;}
}
unless(defined(&AR_SREV_VERSION_9160)) {
    sub AR_SREV_VERSION_9160 () {	0x40;}
}
unless(defined(&AR_SREV_REVISION_9160_10)) {
    sub AR_SREV_REVISION_9160_10 () {	0;}
}
unless(defined(&AR_SREV_REVISION_9160_11)) {
    sub AR_SREV_REVISION_9160_11 () {	1;}
}
unless(defined(&AR_SREV_VERSION_9280)) {
    sub AR_SREV_VERSION_9280 () {	0x80;}
}
unless(defined(&AR_SREV_REVISION_9280_10)) {
    sub AR_SREV_REVISION_9280_10 () {	0;}
}
unless(defined(&AR_SREV_REVISION_9280_20)) {
    sub AR_SREV_REVISION_9280_20 () {	1;}
}
unless(defined(&AR_SREV_REVISION_9280_21)) {
    sub AR_SREV_REVISION_9280_21 () {	2;}
}
unless(defined(&AR_SREV_VERSION_9285)) {
    sub AR_SREV_VERSION_9285 () {	0xc0;}
}
unless(defined(&AR_SREV_REVISION_9285_10)) {
    sub AR_SREV_REVISION_9285_10 () {	0;}
}
unless(defined(&AR_SREV_REVISION_9285_11)) {
    sub AR_SREV_REVISION_9285_11 () {	1;}
}
unless(defined(&AR_SREV_REVISION_9285_12)) {
    sub AR_SREV_REVISION_9285_12 () {	2;}
}
unless(defined(&AR_SREV_VERSION_9287)) {
    sub AR_SREV_VERSION_9287 () {	0x180;}
}
unless(defined(&AR_SREV_REVISION_9287_10)) {
    sub AR_SREV_REVISION_9287_10 () {	0;}
}
unless(defined(&AR_SREV_REVISION_9287_11)) {
    sub AR_SREV_REVISION_9287_11 () {	1;}
}
unless(defined(&AR_SREV_REVISION_9287_12)) {
    sub AR_SREV_REVISION_9287_12 () {	2;}
}
unless(defined(&AR_AHB_EXACT_WR_EN)) {
    sub AR_AHB_EXACT_WR_EN () {	0x;}
}
unless(defined(&AR_AHB_BUF_WR_EN)) {
    sub AR_AHB_BUF_WR_EN () {	0x1;}
}
unless(defined(&AR_AHB_EXACT_RD_EN)) {
    sub AR_AHB_EXACT_RD_EN () {	0x;}
}
unless(defined(&AR_AHB_CACHELINE_RD_EN)) {
    sub AR_AHB_CACHELINE_RD_EN () {	0x2;}
}
unless(defined(&AR_AHB_PREFETCH_RD_EN)) {
    sub AR_AHB_PREFETCH_RD_EN () {	0x4;}
}
unless(defined(&AR_AHB_PAGE_SIZE_1K)) {
    sub AR_AHB_PAGE_SIZE_1K () {	0x;}
}
unless(defined(&AR_AHB_PAGE_SIZE_2K)) {
    sub AR_AHB_PAGE_SIZE_2K () {	0x8;}
}
unless(defined(&AR_AHB_PAGE_SIZE_4K)) {
    sub AR_AHB_PAGE_SIZE_4K () {	0x10;}
}
unless(defined(&AR_AHB_CUSTOM_BURST_M)) {
    sub AR_AHB_CUSTOM_BURST_M () {	0xc0;}
}
unless(defined(&AR_AHB_CUSTOM_BURST_S)) {
    sub AR_AHB_CUSTOM_BURST_S () {	6;}
}
unless(defined(&AR_AHB_CUSTOM_BURST_ASYNC_FIFO_VAL)) {
    sub AR_AHB_CUSTOM_BURST_ASYNC_FIFO_VAL () {	3;}
}
unless(defined(&AR_INTR_SYNC_RTC_IRQ)) {
    sub AR_INTR_SYNC_RTC_IRQ () {	0x1;}
}
unless(defined(&AR_INTR_SYNC_MAC_IRQ)) {
    sub AR_INTR_SYNC_MAC_IRQ () {	0x2;}
}
unless(defined(&AR_INTR_SYNC_EEPROM_ILLEGAL_ACCESS)) {
    sub AR_INTR_SYNC_EEPROM_ILLEGAL_ACCESS () {	0x4;}
}
unless(defined(&AR_INTR_SYNC_APB_TIMEOUT)) {
    sub AR_INTR_SYNC_APB_TIMEOUT () {	0x8;}
}
unless(defined(&AR_INTR_SYNC_PCI_MODE_CONFLICT)) {
    sub AR_INTR_SYNC_PCI_MODE_CONFLICT () {	0x10;}
}
unless(defined(&AR_INTR_SYNC_HOST1_FATAL)) {
    sub AR_INTR_SYNC_HOST1_FATAL () {	0x20;}
}
unless(defined(&AR_INTR_SYNC_HOST1_PERR)) {
    sub AR_INTR_SYNC_HOST1_PERR () {	0x40;}
}
unless(defined(&AR_INTR_SYNC_TRCV_FIFO_PERR)) {
    sub AR_INTR_SYNC_TRCV_FIFO_PERR () {	0x80;}
}
unless(defined(&AR_INTR_SYNC_RADM_CPL_EP)) {
    sub AR_INTR_SYNC_RADM_CPL_EP () {	0x100;}
}
unless(defined(&AR_INTR_SYNC_RADM_CPL_DLLP_ABORT)) {
    sub AR_INTR_SYNC_RADM_CPL_DLLP_ABORT () {	0x200;}
}
unless(defined(&AR_INTR_SYNC_RADM_CPL_TLP_ABORT)) {
    sub AR_INTR_SYNC_RADM_CPL_TLP_ABORT () {	0x400;}
}
unless(defined(&AR_INTR_SYNC_RADM_CPL_ECRC_ERR)) {
    sub AR_INTR_SYNC_RADM_CPL_ECRC_ERR () {	0x800;}
}
unless(defined(&AR_INTR_SYNC_RADM_CPL_TIMEOUT)) {
    sub AR_INTR_SYNC_RADM_CPL_TIMEOUT () {	0x1000;}
}
unless(defined(&AR_INTR_SYNC_LOCAL_TIMEOUT)) {
    sub AR_INTR_SYNC_LOCAL_TIMEOUT () {	0x2000;}
}
unless(defined(&AR_INTR_SYNC_PM_ACCESS)) {
    sub AR_INTR_SYNC_PM_ACCESS () {	0x4000;}
}
unless(defined(&AR_INTR_SYNC_MAC_AWAKE)) {
    sub AR_INTR_SYNC_MAC_AWAKE () {	0x8000;}
}
unless(defined(&AR_INTR_SYNC_MAC_ASLEEP)) {
    sub AR_INTR_SYNC_MAC_ASLEEP () {	0x10000;}
}
unless(defined(&AR_INTR_SYNC_MAC_SLEEP_ACCESS)) {
    sub AR_INTR_SYNC_MAC_SLEEP_ACCESS () {	0x20000;}
}
unless(defined(&AR_INTR_SYNC_ALL)) {
    sub AR_INTR_SYNC_ALL () {	0x3ffff;}
}
unless(defined(&AR_INTR_SYNC_GPIO_PIN)) {
    sub AR_INTR_SYNC_GPIO_PIN {
	my($i) = @_;
	eval q((1<< (18+ ($i))));
    }
}
unless(defined(&AR_INTR_SYNC_DEFAULT)) {
    sub AR_INTR_SYNC_DEFAULT () {	( &AR_INTR_SYNC_HOST1_FATAL |  &AR_INTR_SYNC_HOST1_PERR |  &AR_INTR_SYNC_RADM_CPL_EP |  &AR_INTR_SYNC_RADM_CPL_DLLP_ABORT |  &AR_INTR_SYNC_RADM_CPL_TLP_ABORT |  &AR_INTR_SYNC_RADM_CPL_ECRC_ERR |  &AR_INTR_SYNC_RADM_CPL_TIMEOUT |  &AR_INTR_SYNC_LOCAL_TIMEOUT |  &AR_INTR_SYNC_MAC_SLEEP_ACCESS);}
}
unless(defined(&AR_INTR_RTC_IRQ)) {
    sub AR_INTR_RTC_IRQ () {	0x1;}
}
unless(defined(&AR_INTR_MAC_IRQ)) {
    sub AR_INTR_MAC_IRQ () {	0x2;}
}
unless(defined(&AR_INTR_EEP_PROT_ACCESS)) {
    sub AR_INTR_EEP_PROT_ACCESS () {	0x4;}
}
unless(defined(&AR_INTR_MAC_AWAKE)) {
    sub AR_INTR_MAC_AWAKE () {	0x20000;}
}
unless(defined(&AR_INTR_MAC_ASLEEP)) {
    sub AR_INTR_MAC_ASLEEP () {	0x40000;}
}
unless(defined(&AR_INTR_GPIO_PIN)) {
    sub AR_INTR_GPIO_PIN {
	my($i) = @_;
	eval q((1<< (18+ ($i))));
    }
}
unless(defined(&AR_INTR_SPURIOUS)) {
    sub AR_INTR_SPURIOUS () {	0xffffffff;}
}
unless(defined(&AR_GPIO_OE_OUT_DRV_M)) {
    sub AR_GPIO_OE_OUT_DRV_M () {	0x3;}
}
unless(defined(&AR_GPIO_OE_OUT_DRV_S)) {
    sub AR_GPIO_OE_OUT_DRV_S () {	0;}
}
unless(defined(&AR_GPIO_OE_OUT_DRV_NO)) {
    sub AR_GPIO_OE_OUT_DRV_NO () {	0;}
}
unless(defined(&AR_GPIO_OE_OUT_DRV_LOW)) {
    sub AR_GPIO_OE_OUT_DRV_LOW () {	1;}
}
unless(defined(&AR_GPIO_OE_OUT_DRV_HI)) {
    sub AR_GPIO_OE_OUT_DRV_HI () {	2;}
}
unless(defined(&AR_GPIO_OE_OUT_DRV_ALL)) {
    sub AR_GPIO_OE_OUT_DRV_ALL () {	3;}
}
unless(defined(&AR_GPIO_INTR_POL_PIN)) {
    sub AR_GPIO_INTR_POL_PIN {
	my($i) = @_;
	eval q((1<< ($i)));
    }
}
unless(defined(&AR_GPIO_INPUT_EN_VAL_BT_PRIORITY_DEF)) {
    sub AR_GPIO_INPUT_EN_VAL_BT_PRIORITY_DEF () {	0x4;}
}
unless(defined(&AR_GPIO_INPUT_EN_VAL_BT_FREQUENCY_DEF)) {
    sub AR_GPIO_INPUT_EN_VAL_BT_FREQUENCY_DEF () {	0x8;}
}
unless(defined(&AR_GPIO_INPUT_EN_VAL_BT_ACTIVE_DEF)) {
    sub AR_GPIO_INPUT_EN_VAL_BT_ACTIVE_DEF () {	0x10;}
}
unless(defined(&AR_GPIO_INPUT_EN_VAL_RFSILENT_DEF)) {
    sub AR_GPIO_INPUT_EN_VAL_RFSILENT_DEF () {	0x80;}
}
unless(defined(&AR_GPIO_INPUT_EN_VAL_BT_PRIORITY_BB)) {
    sub AR_GPIO_INPUT_EN_VAL_BT_PRIORITY_BB () {	0x400;}
}
unless(defined(&AR_GPIO_INPUT_EN_VAL_BT_ACTIVE_BB)) {
    sub AR_GPIO_INPUT_EN_VAL_BT_ACTIVE_BB () {	0x1000;}
}
unless(defined(&AR_GPIO_INPUT_EN_VAL_RFSILENT_BB)) {
    sub AR_GPIO_INPUT_EN_VAL_RFSILENT_BB () {	0x8000;}
}
unless(defined(&AR_GPIO_RTC_RESET_OVERRIDE_ENABLE)) {
    sub AR_GPIO_RTC_RESET_OVERRIDE_ENABLE () {	0x10000;}
}
unless(defined(&AR_GPIO_JTAG_DISABLE)) {
    sub AR_GPIO_JTAG_DISABLE () {	0x20000;}
}
unless(defined(&AR_GPIO_INPUT_MUX1_BT_PRIORITY_M)) {
    sub AR_GPIO_INPUT_MUX1_BT_PRIORITY_M () {	0xf00;}
}
unless(defined(&AR_GPIO_INPUT_MUX1_BT_PRIORITY_S)) {
    sub AR_GPIO_INPUT_MUX1_BT_PRIORITY_S () {	8;}
}
unless(defined(&AR_GPIO_INPUT_MUX1_BT_ACTIVE_M)) {
    sub AR_GPIO_INPUT_MUX1_BT_ACTIVE_M () {	0xf0000;}
}
unless(defined(&AR_GPIO_INPUT_MUX1_BT_ACTIVE_S)) {
    sub AR_GPIO_INPUT_MUX1_BT_ACTIVE_S () {	16;}
}
unless(defined(&AR_GPIO_INPUT_MUX2_CLK25_M)) {
    sub AR_GPIO_INPUT_MUX2_CLK25_M () {	0xf;}
}
unless(defined(&AR_GPIO_INPUT_MUX2_CLK25_S)) {
    sub AR_GPIO_INPUT_MUX2_CLK25_S () {	0;}
}
unless(defined(&AR_GPIO_INPUT_MUX2_RFSILENT_M)) {
    sub AR_GPIO_INPUT_MUX2_RFSILENT_M () {	0xf0;}
}
unless(defined(&AR_GPIO_INPUT_MUX2_RFSILENT_S)) {
    sub AR_GPIO_INPUT_MUX2_RFSILENT_S () {	4;}
}
unless(defined(&AR_GPIO_INPUT_MUX2_RTC_RESET_M)) {
    sub AR_GPIO_INPUT_MUX2_RTC_RESET_M () {	0xf00;}
}
unless(defined(&AR_GPIO_INPUT_MUX2_RTC_RESET_S)) {
    sub AR_GPIO_INPUT_MUX2_RTC_RESET_S () {	8;}
}
unless(defined(&AR_GPIO_OUTPUT_MUX_AS_OUTPUT)) {
    sub AR_GPIO_OUTPUT_MUX_AS_OUTPUT () {	0;}
}
unless(defined(&AR_GPIO_OUTPUT_MUX_AS_PCIE_ATTENTION_LED)) {
    sub AR_GPIO_OUTPUT_MUX_AS_PCIE_ATTENTION_LED () {	1;}
}
unless(defined(&AR_GPIO_OUTPUT_MUX_AS_PCIE_POWER_LED)) {
    sub AR_GPIO_OUTPUT_MUX_AS_PCIE_POWER_LED () {	2;}
}
unless(defined(&AR_GPIO_OUTPUT_MUX_AS_TX_FRAME)) {
    sub AR_GPIO_OUTPUT_MUX_AS_TX_FRAME () {	3;}
}
unless(defined(&AR_GPIO_OUTPUT_MUX_AS_RX_CLEAR_EXTERNAL)) {
    sub AR_GPIO_OUTPUT_MUX_AS_RX_CLEAR_EXTERNAL () {	4;}
}
unless(defined(&AR_GPIO_OUTPUT_MUX_AS_MAC_NETWORK_LED)) {
    sub AR_GPIO_OUTPUT_MUX_AS_MAC_NETWORK_LED () {	5;}
}
unless(defined(&AR_GPIO_OUTPUT_MUX_AS_MAC_POWER_LED)) {
    sub AR_GPIO_OUTPUT_MUX_AS_MAC_POWER_LED () {	6;}
}
unless(defined(&AR_EEPROM_STATUS_DATA_VAL_M)) {
    sub AR_EEPROM_STATUS_DATA_VAL_M () {	0xffff;}
}
unless(defined(&AR_EEPROM_STATUS_DATA_VAL_S)) {
    sub AR_EEPROM_STATUS_DATA_VAL_S () {	0;}
}
unless(defined(&AR_EEPROM_STATUS_DATA_BUSY)) {
    sub AR_EEPROM_STATUS_DATA_BUSY () {	0x10000;}
}
unless(defined(&AR_EEPROM_STATUS_DATA_BUSY_ACCESS)) {
    sub AR_EEPROM_STATUS_DATA_BUSY_ACCESS () {	0x20000;}
}
unless(defined(&AR_EEPROM_STATUS_DATA_PROT_ACCESS)) {
    sub AR_EEPROM_STATUS_DATA_PROT_ACCESS () {	0x40000;}
}
unless(defined(&AR_EEPROM_STATUS_DATA_ABSENT_ACCESS)) {
    sub AR_EEPROM_STATUS_DATA_ABSENT_ACCESS () {	0x80000;}
}
unless(defined(&AR_PCIE_MSI_ENABLE)) {
    sub AR_PCIE_MSI_ENABLE () {	0x1;}
}
unless(defined(&AR_RTC_RC_MAC_WARM)) {
    sub AR_RTC_RC_MAC_WARM () {	0x1;}
}
unless(defined(&AR_RTC_RC_MAC_COLD)) {
    sub AR_RTC_RC_MAC_COLD () {	0x2;}
}
unless(defined(&AR_RTC_RC_COLD_RESET)) {
    sub AR_RTC_RC_COLD_RESET () {	0x4;}
}
unless(defined(&AR_RTC_RC_WARM_RESET)) {
    sub AR_RTC_RC_WARM_RESET () {	0x8;}
}
unless(defined(&AR_RTC_PLL_DIV_M)) {
    sub AR_RTC_PLL_DIV_M () {	0x1f;}
}
unless(defined(&AR_RTC_PLL_DIV_S)) {
    sub AR_RTC_PLL_DIV_S () {	0;}
}
unless(defined(&AR_RTC_PLL_DIV2)) {
    sub AR_RTC_PLL_DIV2 () {	0x20;}
}
unless(defined(&AR_RTC_PLL_REFDIV_5)) {
    sub AR_RTC_PLL_REFDIV_5 () {	0xc0;}
}
unless(defined(&AR_RTC_PLL_CLKSEL_M)) {
    sub AR_RTC_PLL_CLKSEL_M () {	0x300;}
}
unless(defined(&AR_RTC_PLL_CLKSEL_S)) {
    sub AR_RTC_PLL_CLKSEL_S () {	8;}
}
unless(defined(&AR_RTC_9160_PLL_DIV_M)) {
    sub AR_RTC_9160_PLL_DIV_M () {	0x3ff;}
}
unless(defined(&AR_RTC_9160_PLL_DIV_S)) {
    sub AR_RTC_9160_PLL_DIV_S () {	0;}
}
unless(defined(&AR_RTC_9160_PLL_REFDIV_M)) {
    sub AR_RTC_9160_PLL_REFDIV_M () {	0x3c00;}
}
unless(defined(&AR_RTC_9160_PLL_REFDIV_S)) {
    sub AR_RTC_9160_PLL_REFDIV_S () {	10;}
}
unless(defined(&AR_RTC_9160_PLL_CLKSEL_M)) {
    sub AR_RTC_9160_PLL_CLKSEL_M () {	0xc000;}
}
unless(defined(&AR_RTC_9160_PLL_CLKSEL_S)) {
    sub AR_RTC_9160_PLL_CLKSEL_S () {	14;}
}
unless(defined(&AR_RTC_RESET_EN)) {
    sub AR_RTC_RESET_EN () {	0x1;}
}
unless(defined(&AR_RTC_STATUS_M)) {
    sub AR_RTC_STATUS_M () {	0xf;}
}
unless(defined(&AR_RTC_STATUS_S)) {
    sub AR_RTC_STATUS_S () {	0;}
}
unless(defined(&AR_RTC_STATUS_SHUTDOWN)) {
    sub AR_RTC_STATUS_SHUTDOWN () {	0x1;}
}
unless(defined(&AR_RTC_STATUS_ON)) {
    sub AR_RTC_STATUS_ON () {	0x2;}
}
unless(defined(&AR_RTC_STATUS_SLEEP)) {
    sub AR_RTC_STATUS_SLEEP () {	0x4;}
}
unless(defined(&AR_RTC_STATUS_WAKEUP)) {
    sub AR_RTC_STATUS_WAKEUP () {	0x8;}
}
unless(defined(&AR_RTC_FORCE_DERIVED_CLK)) {
    sub AR_RTC_FORCE_DERIVED_CLK () {	0x2;}
}
unless(defined(&AR_RTC_FORCE_WAKE_EN)) {
    sub AR_RTC_FORCE_WAKE_EN () {	0x1;}
}
unless(defined(&AR_RTC_FORCE_WAKE_ON_INT)) {
    sub AR_RTC_FORCE_WAKE_ON_INT () {	0x2;}
}
unless(defined(&AR_AN_RF2G1_CH0_OB_M)) {
    sub AR_AN_RF2G1_CH0_OB_M () {	0x3800000;}
}
unless(defined(&AR_AN_RF2G1_CH0_OB_S)) {
    sub AR_AN_RF2G1_CH0_OB_S () {	23;}
}
unless(defined(&AR_AN_RF2G1_CH0_DB_M)) {
    sub AR_AN_RF2G1_CH0_DB_M () {	0x1c000000;}
}
unless(defined(&AR_AN_RF2G1_CH0_DB_S)) {
    sub AR_AN_RF2G1_CH0_DB_S () {	26;}
}
unless(defined(&AR_AN_RF5G1_CH0_OB5_M)) {
    sub AR_AN_RF5G1_CH0_OB5_M () {	0x70000;}
}
unless(defined(&AR_AN_RF5G1_CH0_OB5_S)) {
    sub AR_AN_RF5G1_CH0_OB5_S () {	16;}
}
unless(defined(&AR_AN_RF5G1_CH0_DB5_M)) {
    sub AR_AN_RF5G1_CH0_DB5_M () {	0x380000;}
}
unless(defined(&AR_AN_RF5G1_CH0_DB5_S)) {
    sub AR_AN_RF5G1_CH0_DB5_S () {	19;}
}
unless(defined(&AR_AN_RF2G1_CH1_OB_M)) {
    sub AR_AN_RF2G1_CH1_OB_M () {	0x3800000;}
}
unless(defined(&AR_AN_RF2G1_CH1_OB_S)) {
    sub AR_AN_RF2G1_CH1_OB_S () {	23;}
}
unless(defined(&AR_AN_RF2G1_CH1_DB_M)) {
    sub AR_AN_RF2G1_CH1_DB_M () {	0x1c000000;}
}
unless(defined(&AR_AN_RF2G1_CH1_DB_S)) {
    sub AR_AN_RF2G1_CH1_DB_S () {	26;}
}
unless(defined(&AR_AN_RF5G1_CH1_OB5_M)) {
    sub AR_AN_RF5G1_CH1_OB5_M () {	0x70000;}
}
unless(defined(&AR_AN_RF5G1_CH1_OB5_S)) {
    sub AR_AN_RF5G1_CH1_OB5_S () {	16;}
}
unless(defined(&AR_AN_RF5G1_CH1_DB5_M)) {
    sub AR_AN_RF5G1_CH1_DB5_M () {	0x380000;}
}
unless(defined(&AR_AN_RF5G1_CH1_DB5_S)) {
    sub AR_AN_RF5G1_CH1_DB5_S () {	19;}
}
unless(defined(&AR_AN_SYNTH9_REFDIVA_M)) {
    sub AR_AN_SYNTH9_REFDIVA_M () {	0xf8000000;}
}
unless(defined(&AR_AN_SYNTH9_REFDIVA_S)) {
    sub AR_AN_SYNTH9_REFDIVA_S () {	27;}
}
unless(defined(&AR_AN_TOP1_DACLPMODE)) {
    sub AR_AN_TOP1_DACLPMODE () {	0x40000;}
}
unless(defined(&AR_AN_TOP2_XPABIAS_LVL_M)) {
    sub AR_AN_TOP2_XPABIAS_LVL_M () {	0xc0000000;}
}
unless(defined(&AR_AN_TOP2_XPABIAS_LVL_S)) {
    sub AR_AN_TOP2_XPABIAS_LVL_S () {	30;}
}
unless(defined(&AR_AN_TOP2_LOCALBIAS)) {
    sub AR_AN_TOP2_LOCALBIAS () {	0x200000;}
}
unless(defined(&AR_AN_TOP2_PWDCLKIND)) {
    sub AR_AN_TOP2_PWDCLKIND () {	0x400000;}
}
unless(defined(&AR_STA_ID1_SADH_M)) {
    sub AR_STA_ID1_SADH_M () {	0xffff;}
}
unless(defined(&AR_STA_ID1_SADH_S)) {
    sub AR_STA_ID1_SADH_S () {	0;}
}
unless(defined(&AR_STA_ID1_STA_AP)) {
    sub AR_STA_ID1_STA_AP () {	0x10000;}
}
unless(defined(&AR_STA_ID1_ADHOC)) {
    sub AR_STA_ID1_ADHOC () {	0x20000;}
}
unless(defined(&AR_STA_ID1_PWR_SAV)) {
    sub AR_STA_ID1_PWR_SAV () {	0x40000;}
}
unless(defined(&AR_STA_ID1_KSRCHDIS)) {
    sub AR_STA_ID1_KSRCHDIS () {	0x80000;}
}
unless(defined(&AR_STA_ID1_PCF)) {
    sub AR_STA_ID1_PCF () {	0x100000;}
}
unless(defined(&AR_STA_ID1_USE_DEFANT)) {
    sub AR_STA_ID1_USE_DEFANT () {	0x200000;}
}
unless(defined(&AR_STA_ID1_DEFANT_UPDATE)) {
    sub AR_STA_ID1_DEFANT_UPDATE () {	0x400000;}
}
unless(defined(&AR_STA_ID1_RTS_USE_DEF)) {
    sub AR_STA_ID1_RTS_USE_DEF () {	0x800000;}
}
unless(defined(&AR_STA_ID1_ACKCTS_6MB)) {
    sub AR_STA_ID1_ACKCTS_6MB () {	0x1000000;}
}
unless(defined(&AR_STA_ID1_BASE_RATE_11B)) {
    sub AR_STA_ID1_BASE_RATE_11B () {	0x2000000;}
}
unless(defined(&AR_STA_ID1_SECTOR_SELF_GEN)) {
    sub AR_STA_ID1_SECTOR_SELF_GEN () {	0x4000000;}
}
unless(defined(&AR_STA_ID1_CRPT_MIC_ENABLE)) {
    sub AR_STA_ID1_CRPT_MIC_ENABLE () {	0x8000000;}
}
unless(defined(&AR_STA_ID1_KSRCH_MODE)) {
    sub AR_STA_ID1_KSRCH_MODE () {	0x10000000;}
}
unless(defined(&AR_STA_ID1_PRESERVE_SEQNUM)) {
    sub AR_STA_ID1_PRESERVE_SEQNUM () {	0x20000000;}
}
unless(defined(&AR_STA_ID1_CBCIV_ENDIAN)) {
    sub AR_STA_ID1_CBCIV_ENDIAN () {	0x40000000;}
}
unless(defined(&AR_STA_ID1_MCAST_KSRCH)) {
    sub AR_STA_ID1_MCAST_KSRCH () {	0x80000000;}
}
unless(defined(&AR_BSS_ID1_U16_M)) {
    sub AR_BSS_ID1_U16_M () {	0xffff;}
}
unless(defined(&AR_BSS_ID1_U16_S)) {
    sub AR_BSS_ID1_U16_S () {	0;}
}
unless(defined(&AR_BSS_ID1_AID_M)) {
    sub AR_BSS_ID1_AID_M () {	0x7ff0000;}
}
unless(defined(&AR_BSS_ID1_AID_S)) {
    sub AR_BSS_ID1_AID_S () {	16;}
}
unless(defined(&AR_TIME_OUT_ACK_M)) {
    sub AR_TIME_OUT_ACK_M () {	0x3fff;}
}
unless(defined(&AR_TIME_OUT_ACK_S)) {
    sub AR_TIME_OUT_ACK_S () {	0;}
}
unless(defined(&AR_TIME_OUT_CTS_M)) {
    sub AR_TIME_OUT_CTS_M () {	0x3fff0000;}
}
unless(defined(&AR_TIME_OUT_CTS_S)) {
    sub AR_TIME_OUT_CTS_S () {	16;}
}
unless(defined(&AR_TIME_OUT_ACK_CTS_ASYNC_FIFO_DUR)) {
    sub AR_TIME_OUT_ACK_CTS_ASYNC_FIFO_DUR () {	0x16001d56;}
}
unless(defined(&AR_RSSI_THR_M)) {
    sub AR_RSSI_THR_M () {	0xff;}
}
unless(defined(&AR_RSSI_THR_S)) {
    sub AR_RSSI_THR_S () {	0;}
}
unless(defined(&AR_RSSI_THR_BM_THR_M)) {
    sub AR_RSSI_THR_BM_THR_M () {	0xff00;}
}
unless(defined(&AR_RSSI_THR_BM_THR_S)) {
    sub AR_RSSI_THR_BM_THR_S () {	8;}
}
unless(defined(&AR_RSSI_BCN_WEIGHT_M)) {
    sub AR_RSSI_BCN_WEIGHT_M () {	0x1f000000;}
}
unless(defined(&AR_RSSI_BCN_WEIGHT_S)) {
    sub AR_RSSI_BCN_WEIGHT_S () {	24;}
}
unless(defined(&AR_RSSI_BCN_RSSI_RST)) {
    sub AR_RSSI_BCN_RSSI_RST () {	0x20000000;}
}
unless(defined(&AR_USEC_USEC_M)) {
    sub AR_USEC_USEC_M () {	0x7f;}
}
unless(defined(&AR_USEC_USEC_S)) {
    sub AR_USEC_USEC_S () {	0;}
}
unless(defined(&AR_USEC_TX_LAT_M)) {
    sub AR_USEC_TX_LAT_M () {	0x7fc000;}
}
unless(defined(&AR_USEC_TX_LAT_S)) {
    sub AR_USEC_TX_LAT_S () {	14;}
}
unless(defined(&AR_USEC_RX_LAT_M)) {
    sub AR_USEC_RX_LAT_M () {	0x1f800000;}
}
unless(defined(&AR_USEC_RX_LAT_S)) {
    sub AR_USEC_RX_LAT_S () {	23;}
}
unless(defined(&AR_USEC_ASYNC_FIFO_DUR)) {
    sub AR_USEC_ASYNC_FIFO_DUR () {	0x12e00074;}
}
unless(defined(&AR_RESET_TSF_ONCE)) {
    sub AR_RESET_TSF_ONCE () {	0x1000000;}
}
unless(defined(&AR_RX_FILTER_UCAST)) {
    sub AR_RX_FILTER_UCAST () {	0x1;}
}
unless(defined(&AR_RX_FILTER_MCAST)) {
    sub AR_RX_FILTER_MCAST () {	0x2;}
}
unless(defined(&AR_RX_FILTER_BCAST)) {
    sub AR_RX_FILTER_BCAST () {	0x4;}
}
unless(defined(&AR_RX_FILTER_CONTROL)) {
    sub AR_RX_FILTER_CONTROL () {	0x8;}
}
unless(defined(&AR_RX_FILTER_BEACON)) {
    sub AR_RX_FILTER_BEACON () {	0x10;}
}
unless(defined(&AR_RX_FILTER_PROM)) {
    sub AR_RX_FILTER_PROM () {	0x20;}
}
unless(defined(&AR_RX_FILTER_PROBEREQ)) {
    sub AR_RX_FILTER_PROBEREQ () {	0x80;}
}
unless(defined(&AR_RX_FILTER_MYBEACON)) {
    sub AR_RX_FILTER_MYBEACON () {	0x200;}
}
unless(defined(&AR_RX_FILTER_COMPR_BAR)) {
    sub AR_RX_FILTER_COMPR_BAR () {	0x400;}
}
unless(defined(&AR_RX_FILTER_PSPOLL)) {
    sub AR_RX_FILTER_PSPOLL () {	0x4000;}
}
unless(defined(&AR_DIAG_CACHE_ACK)) {
    sub AR_DIAG_CACHE_ACK () {	0x1;}
}
unless(defined(&AR_DIAG_ACK_DIS)) {
    sub AR_DIAG_ACK_DIS () {	0x2;}
}
unless(defined(&AR_DIAG_CTS_DIS)) {
    sub AR_DIAG_CTS_DIS () {	0x4;}
}
unless(defined(&AR_DIAG_ENCRYPT_DIS)) {
    sub AR_DIAG_ENCRYPT_DIS () {	0x8;}
}
unless(defined(&AR_DIAG_DECRYPT_DIS)) {
    sub AR_DIAG_DECRYPT_DIS () {	0x10;}
}
unless(defined(&AR_DIAG_RX_DIS)) {
    sub AR_DIAG_RX_DIS () {	0x20;}
}
unless(defined(&AR_DIAG_LOOP_BACK)) {
    sub AR_DIAG_LOOP_BACK () {	0x40;}
}
unless(defined(&AR_DIAG_CORR_FCS)) {
    sub AR_DIAG_CORR_FCS () {	0x80;}
}
unless(defined(&AR_DIAG_CHAN_INFO)) {
    sub AR_DIAG_CHAN_INFO () {	0x100;}
}
unless(defined(&AR_DIAG_SCRAM_SEED_M)) {
    sub AR_DIAG_SCRAM_SEED_M () {	0x1fe00;}
}
unless(defined(&AR_DIAG_SCRAM_SEED_S)) {
    sub AR_DIAG_SCRAM_SEED_S () {	8;}
}
unless(defined(&AR_DIAG_FRAME_NV0)) {
    sub AR_DIAG_FRAME_NV0 () {	0x20000;}
}
unless(defined(&AR_DIAG_OBS_PT_SEL1_M)) {
    sub AR_DIAG_OBS_PT_SEL1_M () {	0xc0000;}
}
unless(defined(&AR_DIAG_OBS_PT_SEL1_S)) {
    sub AR_DIAG_OBS_PT_SEL1_S () {	18;}
}
unless(defined(&AR_DIAG_FORCE_RX_CLEAR)) {
    sub AR_DIAG_FORCE_RX_CLEAR () {	0x100000;}
}
unless(defined(&AR_DIAG_IGNORE_VIRT_CS)) {
    sub AR_DIAG_IGNORE_VIRT_CS () {	0x200000;}
}
unless(defined(&AR_DIAG_FORCE_CH_IDLE_HIGH)) {
    sub AR_DIAG_FORCE_CH_IDLE_HIGH () {	0x400000;}
}
unless(defined(&AR_DIAG_EIFS_CTRL_ENA)) {
    sub AR_DIAG_EIFS_CTRL_ENA () {	0x800000;}
}
unless(defined(&AR_DIAG_DUAL_CHAIN_INFO)) {
    sub AR_DIAG_DUAL_CHAIN_INFO () {	0x1000000;}
}
unless(defined(&AR_DIAG_RX_ABORT)) {
    sub AR_DIAG_RX_ABORT () {	0x2000000;}
}
unless(defined(&AR_DIAG_SATURATE_CYCLE_CNT)) {
    sub AR_DIAG_SATURATE_CYCLE_CNT () {	0x4000000;}
}
unless(defined(&AR_DIAG_OBS_PT_SEL2)) {
    sub AR_DIAG_OBS_PT_SEL2 () {	0x8000000;}
}
unless(defined(&AR_DIAG_RX_CLEAR_CTL_LOW)) {
    sub AR_DIAG_RX_CLEAR_CTL_LOW () {	0x10000000;}
}
unless(defined(&AR_DIAG_RX_CLEAR_EXT_LOW)) {
    sub AR_DIAG_RX_CLEAR_EXT_LOW () {	0x20000000;}
}
unless(defined(&AR_AES_MUTE_MASK0_FC_M)) {
    sub AR_AES_MUTE_MASK0_FC_M () {	0xffff;}
}
unless(defined(&AR_AES_MUTE_MASK0_FC_S)) {
    sub AR_AES_MUTE_MASK0_FC_S () {	0;}
}
unless(defined(&AR_AES_MUTE_MASK0_QOS_M)) {
    sub AR_AES_MUTE_MASK0_QOS_M () {	0xffff0000;}
}
unless(defined(&AR_AES_MUTE_MASK0_QOS_S)) {
    sub AR_AES_MUTE_MASK0_QOS_S () {	16;}
}
unless(defined(&AR_AES_MUTE_MASK1_SEQ_M)) {
    sub AR_AES_MUTE_MASK1_SEQ_M () {	0xffff;}
}
unless(defined(&AR_AES_MUTE_MASK1_SEQ_S)) {
    sub AR_AES_MUTE_MASK1_SEQ_S () {	0;}
}
unless(defined(&AR_AES_MUTE_MASK1_FC_MGMT_M)) {
    sub AR_AES_MUTE_MASK1_FC_MGMT_M () {	0xffff0000;}
}
unless(defined(&AR_AES_MUTE_MASK1_FC_MGMT_S)) {
    sub AR_AES_MUTE_MASK1_FC_MGMT_S () {	16;}
}
unless(defined(&AR_AES_MUTE_MASK1_FC0_MGMT_M)) {
    sub AR_AES_MUTE_MASK1_FC0_MGMT_M () {	0xff0000;}
}
unless(defined(&AR_AES_MUTE_MASK1_FC0_MGMT_S)) {
    sub AR_AES_MUTE_MASK1_FC0_MGMT_S () {	16;}
}
unless(defined(&AR_AES_MUTE_MASK1_FC1_MGMT_M)) {
    sub AR_AES_MUTE_MASK1_FC1_MGMT_M () {	0xff000000;}
}
unless(defined(&AR_AES_MUTE_MASK1_FC1_MGMT_S)) {
    sub AR_AES_MUTE_MASK1_FC1_MGMT_S () {	24;}
}
unless(defined(&AR_GATED_CLKS_TX)) {
    sub AR_GATED_CLKS_TX () {	0x2;}
}
unless(defined(&AR_GATED_CLKS_RX)) {
    sub AR_GATED_CLKS_RX () {	0x4;}
}
unless(defined(&AR_GATED_CLKS_REG)) {
    sub AR_GATED_CLKS_REG () {	0x8;}
}
unless(defined(&AR_OBS_BUS_SEL_1)) {
    sub AR_OBS_BUS_SEL_1 () {	0x40000;}
}
unless(defined(&AR_OBS_BUS_SEL_2)) {
    sub AR_OBS_BUS_SEL_2 () {	0x80000;}
}
unless(defined(&AR_OBS_BUS_SEL_3)) {
    sub AR_OBS_BUS_SEL_3 () {	0xc0000;}
}
unless(defined(&AR_OBS_BUS_SEL_4)) {
    sub AR_OBS_BUS_SEL_4 () {	0x8040000;}
}
unless(defined(&AR_OBS_BUS_SEL_5)) {
    sub AR_OBS_BUS_SEL_5 () {	0x8080000;}
}
unless(defined(&AR_OBS_BUS_1_PCU)) {
    sub AR_OBS_BUS_1_PCU () {	0x1;}
}
unless(defined(&AR_OBS_BUS_1_RX_END)) {
    sub AR_OBS_BUS_1_RX_END () {	0x2;}
}
unless(defined(&AR_OBS_BUS_1_RX_WEP)) {
    sub AR_OBS_BUS_1_RX_WEP () {	0x4;}
}
unless(defined(&AR_OBS_BUS_1_RX_BEACON)) {
    sub AR_OBS_BUS_1_RX_BEACON () {	0x8;}
}
unless(defined(&AR_OBS_BUS_1_RX_FILTER)) {
    sub AR_OBS_BUS_1_RX_FILTER () {	0x10;}
}
unless(defined(&AR_OBS_BUS_1_TX_HCF)) {
    sub AR_OBS_BUS_1_TX_HCF () {	0x20;}
}
unless(defined(&AR_OBS_BUS_1_QUIET_TIME)) {
    sub AR_OBS_BUS_1_QUIET_TIME () {	0x40;}
}
unless(defined(&AR_OBS_BUS_1_CHAN_IDLE)) {
    sub AR_OBS_BUS_1_CHAN_IDLE () {	0x80;}
}
unless(defined(&AR_OBS_BUS_1_TX_HOLD)) {
    sub AR_OBS_BUS_1_TX_HOLD () {	0x100;}
}
unless(defined(&AR_OBS_BUS_1_TX_FRAME)) {
    sub AR_OBS_BUS_1_TX_FRAME () {	0x200;}
}
unless(defined(&AR_OBS_BUS_1_RX_FRAME)) {
    sub AR_OBS_BUS_1_RX_FRAME () {	0x400;}
}
unless(defined(&AR_OBS_BUS_1_RX_CLEAR)) {
    sub AR_OBS_BUS_1_RX_CLEAR () {	0x800;}
}
unless(defined(&AR_OBS_BUS_1_WEP_STATE_M)) {
    sub AR_OBS_BUS_1_WEP_STATE_M () {	0x3f000;}
}
unless(defined(&AR_OBS_BUS_1_WEP_STATE_S)) {
    sub AR_OBS_BUS_1_WEP_STATE_S () {	12;}
}
unless(defined(&AR_OBS_BUS_1_RX_STATE_M)) {
    sub AR_OBS_BUS_1_RX_STATE_M () {	0x1f00000;}
}
unless(defined(&AR_OBS_BUS_1_RX_STATE_S)) {
    sub AR_OBS_BUS_1_RX_STATE_S () {	20;}
}
unless(defined(&AR_OBS_BUS_1_TX_STATE_M)) {
    sub AR_OBS_BUS_1_TX_STATE_M () {	0x7e000000;}
}
unless(defined(&AR_OBS_BUS_1_TX_STATE_S)) {
    sub AR_OBS_BUS_1_TX_STATE_S () {	25;}
}
unless(defined(&AR_SLEEP1_ASSUME_DTIM)) {
    sub AR_SLEEP1_ASSUME_DTIM () {	0x80000;}
}
unless(defined(&AR_SLEEP1_CAB_TIMEOUT_M)) {
    sub AR_SLEEP1_CAB_TIMEOUT_M () {	0xffe00000;}
}
unless(defined(&AR_SLEEP1_CAB_TIMEOUT_S)) {
    sub AR_SLEEP1_CAB_TIMEOUT_S () {	21;}
}
unless(defined(&AR_CAB_TIMEOUT_VAL)) {
    sub AR_CAB_TIMEOUT_VAL () {	10;}
}
unless(defined(&AR_SLEEP2_BEACON_TIMEOUT_M)) {
    sub AR_SLEEP2_BEACON_TIMEOUT_M () {	0xffe00000;}
}
unless(defined(&AR_SLEEP2_BEACON_TIMEOUT_S)) {
    sub AR_SLEEP2_BEACON_TIMEOUT_S () {	21;}
}
unless(defined(&AR_TPC_ACK_M)) {
    sub AR_TPC_ACK_M () {	0x3f;}
}
unless(defined(&AR_TPC_ACK_S)) {
    sub AR_TPC_ACK_S () {	0;}
}
unless(defined(&AR_TPC_CTS_M)) {
    sub AR_TPC_CTS_M () {	0x3f00;}
}
unless(defined(&AR_TPC_CTS_S)) {
    sub AR_TPC_CTS_S () {	8;}
}
unless(defined(&AR_TPC_CHIRP_M)) {
    sub AR_TPC_CHIRP_M () {	0x3f0000;}
}
unless(defined(&AR_TPC_CHIRP_S)) {
    sub AR_TPC_CHIRP_S () {	16;}
}
unless(defined(&AR_QUIET1_NEXT_QUIET_M)) {
    sub AR_QUIET1_NEXT_QUIET_M () {	0xffff;}
}
unless(defined(&AR_QUIET1_NEXT_QUIET_S)) {
    sub AR_QUIET1_NEXT_QUIET_S () {	0;}
}
unless(defined(&AR_QUIET1_QUIET_ENABLE)) {
    sub AR_QUIET1_QUIET_ENABLE () {	0x10000;}
}
unless(defined(&AR_QUIET1_QUIET_ACK_CTS_ENABLE)) {
    sub AR_QUIET1_QUIET_ACK_CTS_ENABLE () {	0x20000;}
}
unless(defined(&AR_QUIET2_QUIET_PERIOD_M)) {
    sub AR_QUIET2_QUIET_PERIOD_M () {	0xffff;}
}
unless(defined(&AR_QUIET2_QUIET_PERIOD_S)) {
    sub AR_QUIET2_QUIET_PERIOD_S () {	0;}
}
unless(defined(&AR_QUIET2_QUIET_DUR_M)) {
    sub AR_QUIET2_QUIET_DUR_M () {	0xffff0000;}
}
unless(defined(&AR_QUIET2_QUIET_DUR_S)) {
    sub AR_QUIET2_QUIET_DUR_S () {	16;}
}
unless(defined(&AR_TSF_INCREMENT_M)) {
    sub AR_TSF_INCREMENT_M () {	0xff;}
}
unless(defined(&AR_TSF_INCREMENT_S)) {
    sub AR_TSF_INCREMENT_S () {	0;}
}
unless(defined(&AR_QOS_NO_ACK_TWO_BIT_M)) {
    sub AR_QOS_NO_ACK_TWO_BIT_M () {	0xf;}
}
unless(defined(&AR_QOS_NO_ACK_TWO_BIT_S)) {
    sub AR_QOS_NO_ACK_TWO_BIT_S () {	0;}
}
unless(defined(&AR_QOS_NO_ACK_BIT_OFF_M)) {
    sub AR_QOS_NO_ACK_BIT_OFF_M () {	0x7f;}
}
unless(defined(&AR_QOS_NO_ACK_BIT_OFF_S)) {
    sub AR_QOS_NO_ACK_BIT_OFF_S () {	4;}
}
unless(defined(&AR_QOS_NO_ACK_BYTE_OFF_M)) {
    sub AR_QOS_NO_ACK_BYTE_OFF_M () {	0x180;}
}
unless(defined(&AR_QOS_NO_ACK_BYTE_OFF_S)) {
    sub AR_QOS_NO_ACK_BYTE_OFF_S () {	7;}
}
unless(defined(&AR_PHY_ERR_DCHIRP)) {
    sub AR_PHY_ERR_DCHIRP () {	0x8;}
}
unless(defined(&AR_PHY_ERR_RADAR)) {
    sub AR_PHY_ERR_RADAR () {	0x20;}
}
unless(defined(&AR_PHY_ERR_OFDM_TIMING)) {
    sub AR_PHY_ERR_OFDM_TIMING () {	0x20000;}
}
unless(defined(&AR_PHY_ERR_CCK_TIMING)) {
    sub AR_PHY_ERR_CCK_TIMING () {	0x2000000;}
}
unless(defined(&AR_PCU_FORCE_BSSID_MATCH)) {
    sub AR_PCU_FORCE_BSSID_MATCH () {	0x1;}
}
unless(defined(&AR_PCU_MIC_NEW_LOC_ENA)) {
    sub AR_PCU_MIC_NEW_LOC_ENA () {	0x4;}
}
unless(defined(&AR_PCU_TX_ADD_TSF)) {
    sub AR_PCU_TX_ADD_TSF () {	0x8;}
}
unless(defined(&AR_PCU_CCK_SIFS_MODE)) {
    sub AR_PCU_CCK_SIFS_MODE () {	0x10;}
}
unless(defined(&AR_PCU_RX_ANT_UPDT)) {
    sub AR_PCU_RX_ANT_UPDT () {	0x800;}
}
unless(defined(&AR_PCU_TXOP_TBTT_LIMIT_ENA)) {
    sub AR_PCU_TXOP_TBTT_LIMIT_ENA () {	0x1000;}
}
unless(defined(&AR_PCU_MISS_BCN_IN_SLEEP)) {
    sub AR_PCU_MISS_BCN_IN_SLEEP () {	0x4000;}
}
unless(defined(&AR_PCU_BUG_12306_FIX_ENA)) {
    sub AR_PCU_BUG_12306_FIX_ENA () {	0x20000;}
}
unless(defined(&AR_PCU_FORCE_QUIET_COLL)) {
    sub AR_PCU_FORCE_QUIET_COLL () {	0x40000;}
}
unless(defined(&AR_PCU_BT_ANT_PREVENT_RX)) {
    sub AR_PCU_BT_ANT_PREVENT_RX () {	0x100000;}
}
unless(defined(&AR_PCU_TBTT_PROTECT)) {
    sub AR_PCU_TBTT_PROTECT () {	0x200000;}
}
unless(defined(&AR_PCU_CLEAR_VMF)) {
    sub AR_PCU_CLEAR_VMF () {	0x1000000;}
}
unless(defined(&AR_PCU_CLEAR_BA_VALID)) {
    sub AR_PCU_CLEAR_BA_VALID () {	0x4000000;}
}
unless(defined(&AR_BT_TIME_EXTEND_M)) {
    sub AR_BT_TIME_EXTEND_M () {	0xff;}
}
unless(defined(&AR_BT_TIME_EXTEND_S)) {
    sub AR_BT_TIME_EXTEND_S () {	0;}
}
unless(defined(&AR_BT_TXSTATE_EXTEND)) {
    sub AR_BT_TXSTATE_EXTEND () {	0x100;}
}
unless(defined(&AR_BT_TX_FRAME_EXTEND)) {
    sub AR_BT_TX_FRAME_EXTEND () {	0x200;}
}
unless(defined(&AR_BT_MODE_M)) {
    sub AR_BT_MODE_M () {	0xc00;}
}
unless(defined(&AR_BT_MODE_S)) {
    sub AR_BT_MODE_S () {	10;}
}
unless(defined(&AR_BT_MODE_LEGACY)) {
    sub AR_BT_MODE_LEGACY () {	0;}
}
unless(defined(&AR_BT_MODE_UNSLOTTED)) {
    sub AR_BT_MODE_UNSLOTTED () {	1;}
}
unless(defined(&AR_BT_MODE_SLOTTED)) {
    sub AR_BT_MODE_SLOTTED () {	2;}
}
unless(defined(&AR_BT_MODE_DISABLED)) {
    sub AR_BT_MODE_DISABLED () {	3;}
}
unless(defined(&AR_BT_QUIET)) {
    sub AR_BT_QUIET () {	0x1000;}
}
unless(defined(&AR_BT_QCU_THRESH_M)) {
    sub AR_BT_QCU_THRESH_M () {	0x1e000;}
}
unless(defined(&AR_BT_QCU_THRESH_S)) {
    sub AR_BT_QCU_THRESH_S () {	13;}
}
unless(defined(&AR_BT_RX_CLEAR_POLARITY)) {
    sub AR_BT_RX_CLEAR_POLARITY () {	0x20000;}
}
unless(defined(&AR_BT_PRIORITY_TIME_M)) {
    sub AR_BT_PRIORITY_TIME_M () {	0xfc0000;}
}
unless(defined(&AR_BT_PRIORITY_TIME_S)) {
    sub AR_BT_PRIORITY_TIME_S () {	18;}
}
unless(defined(&AR_BT_FIRST_SLOT_TIME_M)) {
    sub AR_BT_FIRST_SLOT_TIME_M () {	0xff000000;}
}
unless(defined(&AR_BT_FIRST_SLOT_TIME_S)) {
    sub AR_BT_FIRST_SLOT_TIME_S () {	24;}
}
unless(defined(&AR_BTCOEX_BT_WGHT_M)) {
    sub AR_BTCOEX_BT_WGHT_M () {	0xffff;}
}
unless(defined(&AR_BTCOEX_BT_WGHT_S)) {
    sub AR_BTCOEX_BT_WGHT_S () {	0;}
}
unless(defined(&AR_STOMP_LOW_BT_WGHT)) {
    sub AR_STOMP_LOW_BT_WGHT () {	0xff55;}
}
unless(defined(&AR_BTCOEX_WL_WGHT_M)) {
    sub AR_BTCOEX_WL_WGHT_M () {	0xffff0000;}
}
unless(defined(&AR_BTCOEX_WL_WGHT_S)) {
    sub AR_BTCOEX_WL_WGHT_S () {	16;}
}
unless(defined(&AR_STOMP_LOW_WL_WGHT)) {
    sub AR_STOMP_LOW_WL_WGHT () {	0xaaa8;}
}
unless(defined(&AR_BT_BCN_MISS_THRESH_M)) {
    sub AR_BT_BCN_MISS_THRESH_M () {	0xff;}
}
unless(defined(&AR_BT_BCN_MISS_THRESH_S)) {
    sub AR_BT_BCN_MISS_THRESH_S () {	0;}
}
unless(defined(&AR_BT_BCN_MISS_CNT_M)) {
    sub AR_BT_BCN_MISS_CNT_M () {	0xff00;}
}
unless(defined(&AR_BT_BCN_MISS_CNT_S)) {
    sub AR_BT_BCN_MISS_CNT_S () {	8;}
}
unless(defined(&AR_BT_HOLD_RX_CLEAR)) {
    sub AR_BT_HOLD_RX_CLEAR () {	0x10000;}
}
unless(defined(&AR_BT_DISABLE_BT_ANT)) {
    sub AR_BT_DISABLE_BT_ANT () {	0x100000;}
}
unless(defined(&AR_PCU_TXBUF_CTRL_SIZE_M)) {
    sub AR_PCU_TXBUF_CTRL_SIZE_M () {	0x7ff;}
}
unless(defined(&AR_PCU_TXBUF_CTRL_SIZE_S)) {
    sub AR_PCU_TXBUF_CTRL_SIZE_S () {	0;}
}
unless(defined(&AR_PCU_TXBUF_CTRL_USABLE_SIZE)) {
    sub AR_PCU_TXBUF_CTRL_USABLE_SIZE () {	1792;}
}
unless(defined(&AR9285_PCU_TXBUF_CTRL_USABLE_SIZE)) {
    sub AR9285_PCU_TXBUF_CTRL_USABLE_SIZE () {	(1792/ 2);}
}
unless(defined(&AR_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE)) {
    sub AR_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE () {	0x2;}
}
unless(defined(&AR_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT)) {
    sub AR_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT () {	0x4;}
}
unless(defined(&AR_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE)) {
    sub AR_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE () {	0x40;}
}
unless(defined(&AR_PCU_MISC_MODE2_CFP_IGNORE)) {
    sub AR_PCU_MISC_MODE2_CFP_IGNORE () {	0x80;}
}
unless(defined(&AR_PCU_MISC_MODE2_MGMT_QOS_M)) {
    sub AR_PCU_MISC_MODE2_MGMT_QOS_M () {	0xff00;}
}
unless(defined(&AR_PCU_MISC_MODE2_MGMT_QOS_S)) {
    sub AR_PCU_MISC_MODE2_MGMT_QOS_S () {	8;}
}
unless(defined(&AR_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DUR)) {
    sub AR_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DUR () {	0x10000;}
}
unless(defined(&AR_PCU_MISC_MODE2_ENABLE_AGGWEP)) {
    sub AR_PCU_MISC_MODE2_ENABLE_AGGWEP () {	0x20000;}
}
unless(defined(&AR_PCU_MISC_MODE2_HWWAR1)) {
    sub AR_PCU_MISC_MODE2_HWWAR1 () {	0x100000;}
}
unless(defined(&AR_PCU_MISC_MODE2_HWWAR2)) {
    sub AR_PCU_MISC_MODE2_HWWAR2 () {	0x2000000;}
}
unless(defined(&AR_MAC_PCU_LOGIC_ANALYZER_DISBUG20768)) {
    sub AR_MAC_PCU_LOGIC_ANALYZER_DISBUG20768 () {	0x20000000;}
}
unless(defined(&AR_MAC_PCU_ASYNC_FIFO_REG3_DATAPATH_SEL)) {
    sub AR_MAC_PCU_ASYNC_FIFO_REG3_DATAPATH_SEL () {	0x400;}
}
unless(defined(&AR_MAC_PCU_ASYNC_FIFO_REG3_SOFT_RESET)) {
    sub AR_MAC_PCU_ASYNC_FIFO_REG3_SOFT_RESET () {	0x80000000;}
}
unless(defined(&AR_PHY_ERR_COUNT_M)) {
    sub AR_PHY_ERR_COUNT_M () {	0xffffff;}
}
unless(defined(&AR_PHY_ERR_COUNT_S)) {
    sub AR_PHY_ERR_COUNT_S () {	0;}
}
unless(defined(&AR_TSFOOR_THRESHOLD_VAL_M)) {
    sub AR_TSFOOR_THRESHOLD_VAL_M () {	0xffff;}
}
unless(defined(&AR_TSFOOR_THRESHOLD_VAL_S)) {
    sub AR_TSFOOR_THRESHOLD_VAL_S () {	0;}
}
unless(defined(&AR_TXSIFS_TIME_M)) {
    sub AR_TXSIFS_TIME_M () {	0xff;}
}
unless(defined(&AR_TXSIFS_TIME_S)) {
    sub AR_TXSIFS_TIME_S () {	0;}
}
unless(defined(&AR_TXSIFS_TX_LATENCY_M)) {
    sub AR_TXSIFS_TX_LATENCY_M () {	0xf00;}
}
unless(defined(&AR_TXSIFS_TX_LATENCY_S)) {
    sub AR_TXSIFS_TX_LATENCY_S () {	8;}
}
unless(defined(&AR_TXSIFS_ACK_SHIFT_M)) {
    sub AR_TXSIFS_ACK_SHIFT_M () {	0x7000;}
}
unless(defined(&AR_TXSIFS_ACK_SHIFT_S)) {
    sub AR_TXSIFS_ACK_SHIFT_S () {	12;}
}
unless(defined(&AR_TXOP_X_VAL)) {
    sub AR_TXOP_X_VAL () {	0xff;}
}
unless(defined(&AR_TBTT_TIMER_EN)) {
    sub AR_TBTT_TIMER_EN () {	0x1;}
}
unless(defined(&AR_DBA_TIMER_EN)) {
    sub AR_DBA_TIMER_EN () {	0x2;}
}
unless(defined(&AR_SWBA_TIMER_EN)) {
    sub AR_SWBA_TIMER_EN () {	0x4;}
}
unless(defined(&AR_HCF_TIMER_EN)) {
    sub AR_HCF_TIMER_EN () {	0x8;}
}
unless(defined(&AR_TIM_TIMER_EN)) {
    sub AR_TIM_TIMER_EN () {	0x10;}
}
unless(defined(&AR_DTIM_TIMER_EN)) {
    sub AR_DTIM_TIMER_EN () {	0x20;}
}
unless(defined(&AR_QUIET_TIMER_EN)) {
    sub AR_QUIET_TIMER_EN () {	0x40;}
}
unless(defined(&AR_NDP_TIMER_EN)) {
    sub AR_NDP_TIMER_EN () {	0x80;}
}
unless(defined(&AR_TIMER_OVERFLOW_INDEX_M)) {
    sub AR_TIMER_OVERFLOW_INDEX_M () {	0x700;}
}
unless(defined(&AR_TIMER_OVERFLOW_INDEX_S)) {
    sub AR_TIMER_OVERFLOW_INDEX_S () {	8;}
}
unless(defined(&AR_TIMER_THRESH_M)) {
    sub AR_TIMER_THRESH_M () {	0xfffff000;}
}
unless(defined(&AR_TIMER_THRESH_S)) {
    sub AR_TIMER_THRESH_S () {	12;}
}
unless(defined(&AR_SLP32_HALF_CLK_LATENCY_M)) {
    sub AR_SLP32_HALF_CLK_LATENCY_M () {	0xfffff;}
}
unless(defined(&AR_SLP32_HALF_CLK_LATENCY_S)) {
    sub AR_SLP32_HALF_CLK_LATENCY_S () {	0;}
}
unless(defined(&AR_SLP32_ENA)) {
    sub AR_SLP32_ENA () {	0x100000;}
}
unless(defined(&AR_SLP32_TSF_WRITE_STATUS)) {
    sub AR_SLP32_TSF_WRITE_STATUS () {	0x200000;}
}
unless(defined(&AR_SLP32_WAKE_XTL_TIME_M)) {
    sub AR_SLP32_WAKE_XTL_TIME_M () {	0xffff;}
}
unless(defined(&AR_SLP32_WAKE_XTL_TIME_S)) {
    sub AR_SLP32_WAKE_XTL_TIME_S () {	0;}
}
unless(defined(&AR_SLP_MIB_CLEAR)) {
    sub AR_SLP_MIB_CLEAR () {	0x1;}
}
unless(defined(&AR_SLP_MIB_PENDING)) {
    sub AR_SLP_MIB_PENDING () {	0x2;}
}
unless(defined(&AR_2040_JOINED_RX_CLEAR)) {
    sub AR_2040_JOINED_RX_CLEAR () {	0x1;}
}
unless(defined(&AR_KEYTABLE_TYPE_M)) {
    sub AR_KEYTABLE_TYPE_M () {	0x7;}
}
unless(defined(&AR_KEYTABLE_TYPE_S)) {
    sub AR_KEYTABLE_TYPE_S () {	0;}
}
unless(defined(&AR_KEYTABLE_TYPE_40)) {
    sub AR_KEYTABLE_TYPE_40 () {	0;}
}
unless(defined(&AR_KEYTABLE_TYPE_104)) {
    sub AR_KEYTABLE_TYPE_104 () {	1;}
}
unless(defined(&AR_KEYTABLE_TYPE_128)) {
    sub AR_KEYTABLE_TYPE_128 () {	3;}
}
unless(defined(&AR_KEYTABLE_TYPE_TKIP)) {
    sub AR_KEYTABLE_TYPE_TKIP () {	4;}
}
unless(defined(&AR_KEYTABLE_TYPE_AES)) {
    sub AR_KEYTABLE_TYPE_AES () {	5;}
}
unless(defined(&AR_KEYTABLE_TYPE_CCM)) {
    sub AR_KEYTABLE_TYPE_CCM () {	6;}
}
unless(defined(&AR_KEYTABLE_TYPE_CLR)) {
    sub AR_KEYTABLE_TYPE_CLR () {	7;}
}
unless(defined(&AR_KEYTABLE_ANT)) {
    sub AR_KEYTABLE_ANT () {	0x8;}
}
unless(defined(&AR_KEYTABLE_VALID)) {
    sub AR_KEYTABLE_VALID () {	0x8000;}
}
unless(defined(&AR_PHY_TEST_RFSILENT_BB)) {
    sub AR_PHY_TEST_RFSILENT_BB () {	0x2000;}
}
unless(defined(&AR_PHY_TEST_AGC_CLR)) {
    sub AR_PHY_TEST_AGC_CLR () {	0x10000000;}
}
unless(defined(&AR_PHY_FC_TURBO_MODE)) {
    sub AR_PHY_FC_TURBO_MODE () {	0x1;}
}
unless(defined(&AR_PHY_FC_TURBO_SHORT)) {
    sub AR_PHY_FC_TURBO_SHORT () {	0x2;}
}
unless(defined(&AR_PHY_FC_DYN2040_EN)) {
    sub AR_PHY_FC_DYN2040_EN () {	0x4;}
}
unless(defined(&AR_PHY_FC_DYN2040_PRI_ONLY)) {
    sub AR_PHY_FC_DYN2040_PRI_ONLY () {	0x8;}
}
unless(defined(&AR_PHY_FC_DYN2040_PRI_CH)) {
    sub AR_PHY_FC_DYN2040_PRI_CH () {	0x10;}
}
unless(defined(&AR_PHY_FC_DYN2040_EXT_CH)) {
    sub AR_PHY_FC_DYN2040_EXT_CH () {	0x20;}
}
unless(defined(&AR_PHY_FC_HT_EN)) {
    sub AR_PHY_FC_HT_EN () {	0x40;}
}
unless(defined(&AR_PHY_FC_SHORT_GI_40)) {
    sub AR_PHY_FC_SHORT_GI_40 () {	0x80;}
}
unless(defined(&AR_PHY_FC_WALSH)) {
    sub AR_PHY_FC_WALSH () {	0x100;}
}
unless(defined(&AR_PHY_FC_SINGLE_HT_LTF1)) {
    sub AR_PHY_FC_SINGLE_HT_LTF1 () {	0x200;}
}
unless(defined(&AR_PHY_FC_ENABLE_DAC_FIFO)) {
    sub AR_PHY_FC_ENABLE_DAC_FIFO () {	0x800;}
}
unless(defined(&AR_PHY_TIMING3_DSC_MAN_M)) {
    sub AR_PHY_TIMING3_DSC_MAN_M () {	0xfffe0000;}
}
unless(defined(&AR_PHY_TIMING3_DSC_MAN_S)) {
    sub AR_PHY_TIMING3_DSC_MAN_S () {	17;}
}
unless(defined(&AR_PHY_TIMING3_DSC_EXP_M)) {
    sub AR_PHY_TIMING3_DSC_EXP_M () {	0x1e000;}
}
unless(defined(&AR_PHY_TIMING3_DSC_EXP_S)) {
    sub AR_PHY_TIMING3_DSC_EXP_S () {	13;}
}
unless(defined(&AR_PHY_CHIP_ID_REV_0)) {
    sub AR_PHY_CHIP_ID_REV_0 () {	0x80;}
}
unless(defined(&AR_PHY_CHIP_ID_REV_1)) {
    sub AR_PHY_CHIP_ID_REV_1 () {	0x81;}
}
unless(defined(&AR_PHY_CHIP_ID_9160_REV_0)) {
    sub AR_PHY_CHIP_ID_9160_REV_0 () {	0xb0;}
}
unless(defined(&AR_PHY_ACTIVE_EN)) {
    sub AR_PHY_ACTIVE_EN () {	0x1;}
}
unless(defined(&AR_PHY_ACTIVE_DIS)) {
    sub AR_PHY_ACTIVE_DIS () {	0x;}
}
unless(defined(&AR_PHY_TX_END_DATA_START_M)) {
    sub AR_PHY_TX_END_DATA_START_M () {	0xff;}
}
unless(defined(&AR_PHY_TX_END_DATA_START_S)) {
    sub AR_PHY_TX_END_DATA_START_S () {	0;}
}
unless(defined(&AR_PHY_TX_END_PA_ON_M)) {
    sub AR_PHY_TX_END_PA_ON_M () {	0xff00;}
}
unless(defined(&AR_PHY_TX_END_PA_ON_S)) {
    sub AR_PHY_TX_END_PA_ON_S () {	8;}
}
unless(defined(&AR_PHY_TX_END_TO_A2_RX_ON_M)) {
    sub AR_PHY_TX_END_TO_A2_RX_ON_M () {	0xff0000;}
}
unless(defined(&AR_PHY_TX_END_TO_A2_RX_ON_S)) {
    sub AR_PHY_TX_END_TO_A2_RX_ON_S () {	16;}
}
unless(defined(&AR_PHY_ADC_CTL_OFF_INBUFGAIN_M)) {
    sub AR_PHY_ADC_CTL_OFF_INBUFGAIN_M () {	0x3;}
}
unless(defined(&AR_PHY_ADC_CTL_OFF_INBUFGAIN_S)) {
    sub AR_PHY_ADC_CTL_OFF_INBUFGAIN_S () {	0;}
}
unless(defined(&AR_PHY_ADC_CTL_OFF_PWDDAC)) {
    sub AR_PHY_ADC_CTL_OFF_PWDDAC () {	0x2000;}
}
unless(defined(&AR_PHY_ADC_CTL_OFF_PWDBANDGAP)) {
    sub AR_PHY_ADC_CTL_OFF_PWDBANDGAP () {	0x4000;}
}
unless(defined(&AR_PHY_ADC_CTL_OFF_PWDADC)) {
    sub AR_PHY_ADC_CTL_OFF_PWDADC () {	0x8000;}
}
unless(defined(&AR_PHY_ADC_CTL_ON_INBUFGAIN_M)) {
    sub AR_PHY_ADC_CTL_ON_INBUFGAIN_M () {	0x30000;}
}
unless(defined(&AR_PHY_ADC_CTL_ON_INBUFGAIN_S)) {
    sub AR_PHY_ADC_CTL_ON_INBUFGAIN_S () {	16;}
}
unless(defined(&AR_PHY_SEL_INTERNAL_ADDAC)) {
    sub AR_PHY_SEL_INTERNAL_ADDAC () {	0x;}
}
unless(defined(&AR_PHY_SEL_EXTERNAL_RADIO)) {
    sub AR_PHY_SEL_EXTERNAL_RADIO () {	0x1;}
}
unless(defined(&AR_PHY_RF_CTL4_TX_END_XPAB_OFF_M)) {
    sub AR_PHY_RF_CTL4_TX_END_XPAB_OFF_M () {	0xff000000;}
}
unless(defined(&AR_PHY_RF_CTL4_TX_END_XPAB_OFF_S)) {
    sub AR_PHY_RF_CTL4_TX_END_XPAB_OFF_S () {	24;}
}
unless(defined(&AR_PHY_RF_CTL4_TX_END_XPAA_OFF_M)) {
    sub AR_PHY_RF_CTL4_TX_END_XPAA_OFF_M () {	0xff0000;}
}
unless(defined(&AR_PHY_RF_CTL4_TX_END_XPAA_OFF_S)) {
    sub AR_PHY_RF_CTL4_TX_END_XPAA_OFF_S () {	16;}
}
unless(defined(&AR_PHY_RF_CTL4_FRAME_XPAB_ON_M)) {
    sub AR_PHY_RF_CTL4_FRAME_XPAB_ON_M () {	0xff00;}
}
unless(defined(&AR_PHY_RF_CTL4_FRAME_XPAB_ON_S)) {
    sub AR_PHY_RF_CTL4_FRAME_XPAB_ON_S () {	8;}
}
unless(defined(&AR_PHY_RF_CTL4_FRAME_XPAA_ON_M)) {
    sub AR_PHY_RF_CTL4_FRAME_XPAA_ON_M () {	0xff;}
}
unless(defined(&AR_PHY_RF_CTL4_FRAME_XPAA_ON_S)) {
    sub AR_PHY_RF_CTL4_FRAME_XPAA_ON_S () {	0;}
}
unless(defined(&AR_PHY_SETTLING_SWITCH_M)) {
    sub AR_PHY_SETTLING_SWITCH_M () {	0x3f80;}
}
unless(defined(&AR_PHY_SETTLING_SWITCH_S)) {
    sub AR_PHY_SETTLING_SWITCH_S () {	7;}
}
unless(defined(&AR_PHY_RXGAIN_TXRX_ATTEN_M)) {
    sub AR_PHY_RXGAIN_TXRX_ATTEN_M () {	0x3f000;}
}
unless(defined(&AR_PHY_RXGAIN_TXRX_ATTEN_S)) {
    sub AR_PHY_RXGAIN_TXRX_ATTEN_S () {	12;}
}
unless(defined(&AR_PHY_RXGAIN_TXRX_RF_MAX_M)) {
    sub AR_PHY_RXGAIN_TXRX_RF_MAX_M () {	0x7c0000;}
}
unless(defined(&AR_PHY_RXGAIN_TXRX_RF_MAX_S)) {
    sub AR_PHY_RXGAIN_TXRX_RF_MAX_S () {	18;}
}
unless(defined(&AR9280_PHY_RXGAIN_TXRX_ATTEN_M)) {
    sub AR9280_PHY_RXGAIN_TXRX_ATTEN_M () {	0x3f80;}
}
unless(defined(&AR9280_PHY_RXGAIN_TXRX_ATTEN_S)) {
    sub AR9280_PHY_RXGAIN_TXRX_ATTEN_S () {	7;}
}
unless(defined(&AR9280_PHY_RXGAIN_TXRX_MARGIN_M)) {
    sub AR9280_PHY_RXGAIN_TXRX_MARGIN_M () {	0x1fc000;}
}
unless(defined(&AR9280_PHY_RXGAIN_TXRX_MARGIN_S)) {
    sub AR9280_PHY_RXGAIN_TXRX_MARGIN_S () {	14;}
}
unless(defined(&AR_PHY_DESIRED_SZ_ADC_M)) {
    sub AR_PHY_DESIRED_SZ_ADC_M () {	0xff;}
}
unless(defined(&AR_PHY_DESIRED_SZ_ADC_S)) {
    sub AR_PHY_DESIRED_SZ_ADC_S () {	0;}
}
unless(defined(&AR_PHY_DESIRED_SZ_PGA_M)) {
    sub AR_PHY_DESIRED_SZ_PGA_M () {	0xff00;}
}
unless(defined(&AR_PHY_DESIRED_SZ_PGA_S)) {
    sub AR_PHY_DESIRED_SZ_PGA_S () {	8;}
}
unless(defined(&AR_PHY_DESIRED_SZ_TOT_DES_M)) {
    sub AR_PHY_DESIRED_SZ_TOT_DES_M () {	0xff00000;}
}
unless(defined(&AR_PHY_DESIRED_SZ_TOT_DES_S)) {
    sub AR_PHY_DESIRED_SZ_TOT_DES_S () {	20;}
}
unless(defined(&AR_PHY_FIND_SIG_FIRSTEP_M)) {
    sub AR_PHY_FIND_SIG_FIRSTEP_M () {	0x3f000;}
}
unless(defined(&AR_PHY_FIND_SIG_FIRSTEP_S)) {
    sub AR_PHY_FIND_SIG_FIRSTEP_S () {	12;}
}
unless(defined(&AR_PHY_FIND_SIG_FIRPWR_M)) {
    sub AR_PHY_FIND_SIG_FIRPWR_M () {	0x3fc0000;}
}
unless(defined(&AR_PHY_FIND_SIG_FIRPWR_S)) {
    sub AR_PHY_FIND_SIG_FIRPWR_S () {	18;}
}
unless(defined(&AR_PHY_AGC_CTL1_COARSE_LOW_M)) {
    sub AR_PHY_AGC_CTL1_COARSE_LOW_M () {	0x7f80;}
}
unless(defined(&AR_PHY_AGC_CTL1_COARSE_LOW_S)) {
    sub AR_PHY_AGC_CTL1_COARSE_LOW_S () {	7;}
}
unless(defined(&AR_PHY_AGC_CTL1_COARSE_HIGH_M)) {
    sub AR_PHY_AGC_CTL1_COARSE_HIGH_M () {	0x3f8000;}
}
unless(defined(&AR_PHY_AGC_CTL1_COARSE_HIGH_S)) {
    sub AR_PHY_AGC_CTL1_COARSE_HIGH_S () {	15;}
}
unless(defined(&AR_PHY_AGC_CONTROL_CAL)) {
    sub AR_PHY_AGC_CONTROL_CAL () {	0x1;}
}
unless(defined(&AR_PHY_AGC_CONTROL_NF)) {
    sub AR_PHY_AGC_CONTROL_NF () {	0x2;}
}
unless(defined(&AR_PHY_AGC_CONTROL_ENABLE_NF)) {
    sub AR_PHY_AGC_CONTROL_ENABLE_NF () {	0x8000;}
}
unless(defined(&AR_PHY_AGC_CONTROL_FLTR_CAL)) {
    sub AR_PHY_AGC_CONTROL_FLTR_CAL () {	0x10000;}
}
unless(defined(&AR_PHY_AGC_CONTROL_NO_UPDATE_NF)) {
    sub AR_PHY_AGC_CONTROL_NO_UPDATE_NF () {	0x20000;}
}
unless(defined(&AR_PHY_MAXCCA_PWR_M)) {
    sub AR_PHY_MAXCCA_PWR_M () {	0x1ff;}
}
unless(defined(&AR_PHY_MAXCCA_PWR_S)) {
    sub AR_PHY_MAXCCA_PWR_S () {	0;}
}
unless(defined(&AR_PHY_MINCCA_PWR_M)) {
    sub AR_PHY_MINCCA_PWR_M () {	0xff80000;}
}
unless(defined(&AR_PHY_MINCCA_PWR_S)) {
    sub AR_PHY_MINCCA_PWR_S () {	19;}
}
unless(defined(&AR_PHY_CCA_THRESH62_M)) {
    sub AR_PHY_CCA_THRESH62_M () {	0x7f000;}
}
unless(defined(&AR_PHY_CCA_THRESH62_S)) {
    sub AR_PHY_CCA_THRESH62_S () {	12;}
}
unless(defined(&AR9280_PHY_MINCCA_PWR_M)) {
    sub AR9280_PHY_MINCCA_PWR_M () {	0x1ff00000;}
}
unless(defined(&AR9280_PHY_MINCCA_PWR_S)) {
    sub AR9280_PHY_MINCCA_PWR_S () {	20;}
}
unless(defined(&AR9280_PHY_CCA_THRESH62_M)) {
    sub AR9280_PHY_CCA_THRESH62_M () {	0xff000;}
}
unless(defined(&AR9280_PHY_CCA_THRESH62_S)) {
    sub AR9280_PHY_CCA_THRESH62_S () {	12;}
}
unless(defined(&AR_PHY_SFCORR_LOW_USE_SELF_CORR_LOW)) {
    sub AR_PHY_SFCORR_LOW_USE_SELF_CORR_LOW () {	0x1;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW_M)) {
    sub AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW_M () {	0x3f00;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW_S)) {
    sub AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW_S () {	8;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M1_THRESH_LOW_M)) {
    sub AR_PHY_SFCORR_LOW_M1_THRESH_LOW_M () {	0x1fc000;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M1_THRESH_LOW_S)) {
    sub AR_PHY_SFCORR_LOW_M1_THRESH_LOW_S () {	14;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M2_THRESH_LOW_M)) {
    sub AR_PHY_SFCORR_LOW_M2_THRESH_LOW_M () {	0xfe00000;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M2_THRESH_LOW_S)) {
    sub AR_PHY_SFCORR_LOW_M2_THRESH_LOW_S () {	21;}
}
unless(defined(&AR_PHY_SFCORR_M2COUNT_THR_M)) {
    sub AR_PHY_SFCORR_M2COUNT_THR_M () {	0x1f;}
}
unless(defined(&AR_PHY_SFCORR_M2COUNT_THR_S)) {
    sub AR_PHY_SFCORR_M2COUNT_THR_S () {	0;}
}
unless(defined(&AR_PHY_SFCORR_M1_THRESH_M)) {
    sub AR_PHY_SFCORR_M1_THRESH_M () {	0xfe0000;}
}
unless(defined(&AR_PHY_SFCORR_M1_THRESH_S)) {
    sub AR_PHY_SFCORR_M1_THRESH_S () {	17;}
}
unless(defined(&AR_PHY_SFCORR_M2_THRESH_M)) {
    sub AR_PHY_SFCORR_M2_THRESH_M () {	0x7f000000;}
}
unless(defined(&AR_PHY_SFCORR_M2_THRESH_S)) {
    sub AR_PHY_SFCORR_M2_THRESH_S () {	24;}
}
unless(defined(&AR_PHY_PLL_CTL_40)) {
    sub AR_PHY_PLL_CTL_40 () {	0xaa;}
}
unless(defined(&AR_PHY_PLL_CTL_40_5413)) {
    sub AR_PHY_PLL_CTL_40_5413 () {	0x4;}
}
unless(defined(&AR_PHY_PLL_CTL_44)) {
    sub AR_PHY_PLL_CTL_44 () {	0xab;}
}
unless(defined(&AR_PHY_PLL_CTL_44_2133)) {
    sub AR_PHY_PLL_CTL_44_2133 () {	0xeb;}
}
unless(defined(&AR_PHY_PLL_CTL_40_2133)) {
    sub AR_PHY_PLL_CTL_40_2133 () {	0xea;}
}
unless(defined(&AR_PHY_RX_DELAY_DELAY_M)) {
    sub AR_PHY_RX_DELAY_DELAY_M () {	0x3fff;}
}
unless(defined(&AR_PHY_RX_DELAY_DELAY_S)) {
    sub AR_PHY_RX_DELAY_DELAY_S () {	0;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_IQCORR_Q_Q_COFF_M)) {
    sub AR_PHY_TIMING_CTRL4_IQCORR_Q_Q_COFF_M () {	0x1f;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_IQCORR_Q_Q_COFF_S)) {
    sub AR_PHY_TIMING_CTRL4_IQCORR_Q_Q_COFF_S () {	0;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_IQCORR_Q_I_COFF_M)) {
    sub AR_PHY_TIMING_CTRL4_IQCORR_Q_I_COFF_M () {	0x7e0;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_IQCORR_Q_I_COFF_S)) {
    sub AR_PHY_TIMING_CTRL4_IQCORR_Q_I_COFF_S () {	5;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_IQCORR_ENABLE)) {
    sub AR_PHY_TIMING_CTRL4_IQCORR_ENABLE () {	0x800;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_IQCAL_LOG_COUNT_MAX_M)) {
    sub AR_PHY_TIMING_CTRL4_IQCAL_LOG_COUNT_MAX_M () {	0xf000;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_IQCAL_LOG_COUNT_MAX_S)) {
    sub AR_PHY_TIMING_CTRL4_IQCAL_LOG_COUNT_MAX_S () {	12;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_DO_CAL)) {
    sub AR_PHY_TIMING_CTRL4_DO_CAL () {	0x10000;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_ENABLE_SPUR_RSSI)) {
    sub AR_PHY_TIMING_CTRL4_ENABLE_SPUR_RSSI () {	0x80000000;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_ENABLE_SPUR_FILTER)) {
    sub AR_PHY_TIMING_CTRL4_ENABLE_SPUR_FILTER () {	0x40000000;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_ENABLE_CHAN_MASK)) {
    sub AR_PHY_TIMING_CTRL4_ENABLE_CHAN_MASK () {	0x20000000;}
}
unless(defined(&AR_PHY_TIMING_CTRL4_ENABLE_PILOT_MASK)) {
    sub AR_PHY_TIMING_CTRL4_ENABLE_PILOT_MASK () {	0x10000000;}
}
unless(defined(&AR_PHY_TIMING5_CYCPWR_THR1_M)) {
    sub AR_PHY_TIMING5_CYCPWR_THR1_M () {	0xfe;}
}
unless(defined(&AR_PHY_TIMING5_CYCPWR_THR1_S)) {
    sub AR_PHY_TIMING5_CYCPWR_THR1_S () {	1;}
}
unless(defined(&AR_PHY_POWER_TX_RATE_MAX_TPC_ENABLE)) {
    sub AR_PHY_POWER_TX_RATE_MAX_TPC_ENABLE () {	0x40;}
}
unless(defined(&AR_PHY_FRAME_CTL_TX_CLIP_M)) {
    sub AR_PHY_FRAME_CTL_TX_CLIP_M () {	0x38;}
}
unless(defined(&AR_PHY_FRAME_CTL_TX_CLIP_S)) {
    sub AR_PHY_FRAME_CTL_TX_CLIP_S () {	3;}
}
unless(defined(&AR_PHY_TXPWRADJ_CCK_GAIN_DELTA_M)) {
    sub AR_PHY_TXPWRADJ_CCK_GAIN_DELTA_M () {	0xfc0;}
}
unless(defined(&AR_PHY_TXPWRADJ_CCK_GAIN_DELTA_S)) {
    sub AR_PHY_TXPWRADJ_CCK_GAIN_DELTA_S () {	6;}
}
unless(defined(&AR_PHY_TXPWRADJ_CCK_PCDAC_INDEX_M)) {
    sub AR_PHY_TXPWRADJ_CCK_PCDAC_INDEX_M () {	0xfc0000;}
}
unless(defined(&AR_PHY_TXPWRADJ_CCK_PCDAC_INDEX_S)) {
    sub AR_PHY_TXPWRADJ_CCK_PCDAC_INDEX_S () {	18;}
}
unless(defined(&AR_PHY_RADAR_EXT_ENA)) {
    sub AR_PHY_RADAR_EXT_ENA () {	0x4000;}
}
unless(defined(&AR_PHY_RADAR_0_ENA)) {
    sub AR_PHY_RADAR_0_ENA () {	0x1;}
}
unless(defined(&AR_PHY_RADAR_0_FFT_ENA)) {
    sub AR_PHY_RADAR_0_FFT_ENA () {	0x80000000;}
}
unless(defined(&AR_PHY_RADAR_0_INBAND_M)) {
    sub AR_PHY_RADAR_0_INBAND_M () {	0x3e;}
}
unless(defined(&AR_PHY_RADAR_0_INBAND_S)) {
    sub AR_PHY_RADAR_0_INBAND_S () {	1;}
}
unless(defined(&AR_PHY_RADAR_0_PRSSI_M)) {
    sub AR_PHY_RADAR_0_PRSSI_M () {	0xfc0;}
}
unless(defined(&AR_PHY_RADAR_0_PRSSI_S)) {
    sub AR_PHY_RADAR_0_PRSSI_S () {	6;}
}
unless(defined(&AR_PHY_RADAR_0_HEIGHT_M)) {
    sub AR_PHY_RADAR_0_HEIGHT_M () {	0x3f000;}
}
unless(defined(&AR_PHY_RADAR_0_HEIGHT_S)) {
    sub AR_PHY_RADAR_0_HEIGHT_S () {	12;}
}
unless(defined(&AR_PHY_RADAR_0_RRSSI_M)) {
    sub AR_PHY_RADAR_0_RRSSI_M () {	0xfc0000;}
}
unless(defined(&AR_PHY_RADAR_0_RRSSI_S)) {
    sub AR_PHY_RADAR_0_RRSSI_S () {	18;}
}
unless(defined(&AR_PHY_RADAR_0_FIRPWR_M)) {
    sub AR_PHY_RADAR_0_FIRPWR_M () {	0x7f000000;}
}
unless(defined(&AR_PHY_RADAR_0_FIRPWR_S)) {
    sub AR_PHY_RADAR_0_FIRPWR_S () {	24;}
}
unless(defined(&AR_PHY_RADAR_1_RELPWR_ENA)) {
    sub AR_PHY_RADAR_1_RELPWR_ENA () {	0x800000;}
}
unless(defined(&AR_PHY_RADAR_1_USE_FIR128)) {
    sub AR_PHY_RADAR_1_USE_FIR128 () {	0x400000;}
}
unless(defined(&AR_PHY_RADAR_1_RELPWR_THRESH_M)) {
    sub AR_PHY_RADAR_1_RELPWR_THRESH_M () {	0x3f0000;}
}
unless(defined(&AR_PHY_RADAR_1_RELPWR_THRESH_S)) {
    sub AR_PHY_RADAR_1_RELPWR_THRESH_S () {	16;}
}
unless(defined(&AR_PHY_RADAR_1_BLOCK_CHECK)) {
    sub AR_PHY_RADAR_1_BLOCK_CHECK () {	0x8000;}
}
unless(defined(&AR_PHY_RADAR_1_MAX_RRSSI)) {
    sub AR_PHY_RADAR_1_MAX_RRSSI () {	0x4000;}
}
unless(defined(&AR_PHY_RADAR_1_RELSTEP_CHECK)) {
    sub AR_PHY_RADAR_1_RELSTEP_CHECK () {	0x2000;}
}
unless(defined(&AR_PHY_RADAR_1_RELSTEP_THRESH_M)) {
    sub AR_PHY_RADAR_1_RELSTEP_THRESH_M () {	0x1f00;}
}
unless(defined(&AR_PHY_RADAR_1_RELSTEP_THRESH_S)) {
    sub AR_PHY_RADAR_1_RELSTEP_THRESH_S () {	8;}
}
unless(defined(&AR_PHY_RADAR_1_MAXLEN_M)) {
    sub AR_PHY_RADAR_1_MAXLEN_M () {	0xff;}
}
unless(defined(&AR_PHY_RADAR_1_MAXLEN_S)) {
    sub AR_PHY_RADAR_1_MAXLEN_S () {	0;}
}
unless(defined(&AR_PHY_SIGMA_DELTA_ADC_SEL_M)) {
    sub AR_PHY_SIGMA_DELTA_ADC_SEL_M () {	0x3;}
}
unless(defined(&AR_PHY_SIGMA_DELTA_ADC_SEL_S)) {
    sub AR_PHY_SIGMA_DELTA_ADC_SEL_S () {	0;}
}
unless(defined(&AR_PHY_SIGMA_DELTA_FILT2_M)) {
    sub AR_PHY_SIGMA_DELTA_FILT2_M () {	0xf8;}
}
unless(defined(&AR_PHY_SIGMA_DELTA_FILT2_S)) {
    sub AR_PHY_SIGMA_DELTA_FILT2_S () {	3;}
}
unless(defined(&AR_PHY_SIGMA_DELTA_FILT1_M)) {
    sub AR_PHY_SIGMA_DELTA_FILT1_M () {	0x1f00;}
}
unless(defined(&AR_PHY_SIGMA_DELTA_FILT1_S)) {
    sub AR_PHY_SIGMA_DELTA_FILT1_S () {	8;}
}
unless(defined(&AR_PHY_SIGMA_DELTA_ADC_CLIP_M)) {
    sub AR_PHY_SIGMA_DELTA_ADC_CLIP_M () {	0x1ffe000;}
}
unless(defined(&AR_PHY_SIGMA_DELTA_ADC_CLIP_S)) {
    sub AR_PHY_SIGMA_DELTA_ADC_CLIP_S () {	13;}
}
unless(defined(&AR_PHY_RESTART_DIV_GC_M)) {
    sub AR_PHY_RESTART_DIV_GC_M () {	0x1c0000;}
}
unless(defined(&AR_PHY_RESTART_DIV_GC_S)) {
    sub AR_PHY_RESTART_DIV_GC_S () {	18;}
}
unless(defined(&AR_PHY_RFBUS_REQ_EN)) {
    sub AR_PHY_RFBUS_REQ_EN () {	0x1;}
}
unless(defined(&AR_PHY_TIMING11_SPUR_DELTA_PHASE_M)) {
    sub AR_PHY_TIMING11_SPUR_DELTA_PHASE_M () {	0xfffff;}
}
unless(defined(&AR_PHY_TIMING11_SPUR_DELTA_PHASE_S)) {
    sub AR_PHY_TIMING11_SPUR_DELTA_PHASE_S () {	0;}
}
unless(defined(&AR_PHY_TIMING11_SPUR_FREQ_SD_M)) {
    sub AR_PHY_TIMING11_SPUR_FREQ_SD_M () {	0x3ff00000;}
}
unless(defined(&AR_PHY_TIMING11_SPUR_FREQ_SD_S)) {
    sub AR_PHY_TIMING11_SPUR_FREQ_SD_S () {	20;}
}
unless(defined(&AR_PHY_TIMING11_USE_SPUR_IN_AGC)) {
    sub AR_PHY_TIMING11_USE_SPUR_IN_AGC () {	0x40000000;}
}
unless(defined(&AR_PHY_TIMING11_USE_SPUR_IN_SELFCOR)) {
    sub AR_PHY_TIMING11_USE_SPUR_IN_SELFCOR () {	0x80000000;}
}
unless(defined(&AR_PHY_NEW_ADC_GAIN_CORR_ENABLE)) {
    sub AR_PHY_NEW_ADC_GAIN_CORR_ENABLE () {	0x40000000;}
}
unless(defined(&AR_PHY_NEW_ADC_DC_OFFSET_CORR_ENABLE)) {
    sub AR_PHY_NEW_ADC_DC_OFFSET_CORR_ENABLE () {	0x80000000;}
}
unless(defined(&AR_PHY_EXT_CCA0_THRESH62_M)) {
    sub AR_PHY_EXT_CCA0_THRESH62_M () {	0xff;}
}
unless(defined(&AR_PHY_EXT_CCA0_THRESH62_S)) {
    sub AR_PHY_EXT_CCA0_THRESH62_S () {	0;}
}
unless(defined(&AR_PHY_EXT_MAXCCA_PWR_M)) {
    sub AR_PHY_EXT_MAXCCA_PWR_M () {	0x1ff;}
}
unless(defined(&AR_PHY_EXT_MAXCCA_PWR_S)) {
    sub AR_PHY_EXT_MAXCCA_PWR_S () {	0;}
}
unless(defined(&AR_PHY_EXT_CCA_CYCPWR_THR1_M)) {
    sub AR_PHY_EXT_CCA_CYCPWR_THR1_M () {	0xfe00;}
}
unless(defined(&AR_PHY_EXT_CCA_CYCPWR_THR1_S)) {
    sub AR_PHY_EXT_CCA_CYCPWR_THR1_S () {	9;}
}
unless(defined(&AR_PHY_EXT_CCA_THRESH62_M)) {
    sub AR_PHY_EXT_CCA_THRESH62_M () {	0x7f0000;}
}
unless(defined(&AR_PHY_EXT_CCA_THRESH62_S)) {
    sub AR_PHY_EXT_CCA_THRESH62_S () {	16;}
}
unless(defined(&AR_PHY_EXT_MINCCA_PWR_M)) {
    sub AR_PHY_EXT_MINCCA_PWR_M () {	0xff800000;}
}
unless(defined(&AR_PHY_EXT_MINCCA_PWR_S)) {
    sub AR_PHY_EXT_MINCCA_PWR_S () {	23;}
}
unless(defined(&AR9280_PHY_EXT_MINCCA_PWR_M)) {
    sub AR9280_PHY_EXT_MINCCA_PWR_M () {	0x1ff0000;}
}
unless(defined(&AR9280_PHY_EXT_MINCCA_PWR_S)) {
    sub AR9280_PHY_EXT_MINCCA_PWR_S () {	16;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M1_THRESH_M)) {
    sub AR_PHY_SFCORR_EXT_M1_THRESH_M () {	0x7f;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M1_THRESH_S)) {
    sub AR_PHY_SFCORR_EXT_M1_THRESH_S () {	0;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M2_THRESH_M)) {
    sub AR_PHY_SFCORR_EXT_M2_THRESH_M () {	0x3f80;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M2_THRESH_S)) {
    sub AR_PHY_SFCORR_EXT_M2_THRESH_S () {	7;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M1_THRESH_LOW_M)) {
    sub AR_PHY_SFCORR_EXT_M1_THRESH_LOW_M () {	0x1fc000;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M1_THRESH_LOW_S)) {
    sub AR_PHY_SFCORR_EXT_M1_THRESH_LOW_S () {	14;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M2_THRESH_LOW_M)) {
    sub AR_PHY_SFCORR_EXT_M2_THRESH_LOW_M () {	0xfe00000;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M2_THRESH_LOW_S)) {
    sub AR_PHY_SFCORR_EXT_M2_THRESH_LOW_S () {	21;}
}
unless(defined(&AR_PHY_SFCORR_SPUR_SUBCHNL_SD_M)) {
    sub AR_PHY_SFCORR_SPUR_SUBCHNL_SD_M () {	0xf0000000;}
}
unless(defined(&AR_PHY_SFCORR_SPUR_SUBCHNL_SD_S)) {
    sub AR_PHY_SFCORR_SPUR_SUBCHNL_SD_S () {	28;}
}
unless(defined(&AR_PHY_HALFGI_DSC_EXP_M)) {
    sub AR_PHY_HALFGI_DSC_EXP_M () {	0xf;}
}
unless(defined(&AR_PHY_HALFGI_DSC_EXP_S)) {
    sub AR_PHY_HALFGI_DSC_EXP_S () {	0;}
}
unless(defined(&AR_PHY_HALFGI_DSC_MAN_M)) {
    sub AR_PHY_HALFGI_DSC_MAN_M () {	0x7fff0;}
}
unless(defined(&AR_PHY_HALFGI_DSC_MAN_S)) {
    sub AR_PHY_HALFGI_DSC_MAN_S () {	4;}
}
unless(defined(&AR_PHY_CHAN_INFO_MEMORY_CAPTURE_MASK)) {
    sub AR_PHY_CHAN_INFO_MEMORY_CAPTURE_MASK () {	0x1;}
}
unless(defined(&AR_PHY_RIFS_INIT_DELAY_M)) {
    sub AR_PHY_RIFS_INIT_DELAY_M () {	0x3ff0000;}
}
unless(defined(&AR_PHY_RIFS_INIT_DELAY_S)) {
    sub AR_PHY_RIFS_INIT_DELAY_S () {	16;}
}
unless(defined(&AR_PHY_CALMODE_IQ)) {
    sub AR_PHY_CALMODE_IQ () {	0x;}
}
unless(defined(&AR_PHY_CALMODE_ADC_GAIN)) {
    sub AR_PHY_CALMODE_ADC_GAIN () {	0x1;}
}
unless(defined(&AR_PHY_CALMODE_ADC_DC_PER)) {
    sub AR_PHY_CALMODE_ADC_DC_PER () {	0x2;}
}
unless(defined(&AR_PHY_CALMODE_ADC_DC_INIT)) {
    sub AR_PHY_CALMODE_ADC_DC_INIT () {	0x3;}
}
unless(defined(&AR_PHY_RFBUS_GRANT_EN)) {
    sub AR_PHY_RFBUS_GRANT_EN () {	0x1;}
}
unless(defined(&AR_PHY_CHAN_INFO_GAIN_DIFF_UPPER_LIMIT)) {
    sub AR_PHY_CHAN_INFO_GAIN_DIFF_UPPER_LIMIT () {	320;}
}
unless(defined(&AR_PHY_MODE_ASYNCFIFO)) {
    sub AR_PHY_MODE_ASYNCFIFO () {	0x80;}
}
unless(defined(&AR_PHY_MODE_AR2133)) {
    sub AR_PHY_MODE_AR2133 () {	0x8;}
}
unless(defined(&AR_PHY_MODE_AR5111)) {
    sub AR_PHY_MODE_AR5111 () {	0x;}
}
unless(defined(&AR_PHY_MODE_AR5112)) {
    sub AR_PHY_MODE_AR5112 () {	0x8;}
}
unless(defined(&AR_PHY_MODE_DYNAMIC)) {
    sub AR_PHY_MODE_DYNAMIC () {	0x4;}
}
unless(defined(&AR_PHY_MODE_RF2GHZ)) {
    sub AR_PHY_MODE_RF2GHZ () {	0x2;}
}
unless(defined(&AR_PHY_MODE_RF5GHZ)) {
    sub AR_PHY_MODE_RF5GHZ () {	0x;}
}
unless(defined(&AR_PHY_MODE_CCK)) {
    sub AR_PHY_MODE_CCK () {	0x1;}
}
unless(defined(&AR_PHY_MODE_OFDM)) {
    sub AR_PHY_MODE_OFDM () {	0x;}
}
unless(defined(&AR_PHY_MODE_DYN_CCK_DISABLE)) {
    sub AR_PHY_MODE_DYN_CCK_DISABLE () {	0x100;}
}
unless(defined(&AR_PHY_CCK_TX_CTRL_JAPAN)) {
    sub AR_PHY_CCK_TX_CTRL_JAPAN () {	0x10;}
}
unless(defined(&AR_PHY_CCK_TX_CTRL_TX_DAC_SCALE_CCK_M)) {
    sub AR_PHY_CCK_TX_CTRL_TX_DAC_SCALE_CCK_M () {	0xc;}
}
unless(defined(&AR_PHY_CCK_TX_CTRL_TX_DAC_SCALE_CCK_S)) {
    sub AR_PHY_CCK_TX_CTRL_TX_DAC_SCALE_CCK_S () {	2;}
}
unless(defined(&AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_M)) {
    sub AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_M () {	0x3f;}
}
unless(defined(&AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_S)) {
    sub AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_S () {	0;}
}
unless(defined(&AR_PHY_CCK_DETECT_ANT_SWITCH_TIME_M)) {
    sub AR_PHY_CCK_DETECT_ANT_SWITCH_TIME_M () {	0x1fc0;}
}
unless(defined(&AR_PHY_CCK_DETECT_ANT_SWITCH_TIME_S)) {
    sub AR_PHY_CCK_DETECT_ANT_SWITCH_TIME_S () {	6;}
}
unless(defined(&AR_PHY_CCK_DETECT_BB_ENABLE_ANT_FAST_DIV)) {
    sub AR_PHY_CCK_DETECT_BB_ENABLE_ANT_FAST_DIV () {	0x2000;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_RXTX_MARGIN_M)) {
    sub AR_PHY_GAIN_2GHZ_RXTX_MARGIN_M () {	0xfc0000;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_RXTX_MARGIN_S)) {
    sub AR_PHY_GAIN_2GHZ_RXTX_MARGIN_S () {	18;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_BSW_MARGIN_M)) {
    sub AR_PHY_GAIN_2GHZ_BSW_MARGIN_M () {	0x3c00;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_BSW_MARGIN_S)) {
    sub AR_PHY_GAIN_2GHZ_BSW_MARGIN_S () {	10;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_BSW_ATTEN_M)) {
    sub AR_PHY_GAIN_2GHZ_BSW_ATTEN_M () {	0x1f;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_BSW_ATTEN_S)) {
    sub AR_PHY_GAIN_2GHZ_BSW_ATTEN_S () {	0;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_XATTEN2_MARGIN_M)) {
    sub AR_PHY_GAIN_2GHZ_XATTEN2_MARGIN_M () {	0x3e0000;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_XATTEN2_MARGIN_S)) {
    sub AR_PHY_GAIN_2GHZ_XATTEN2_MARGIN_S () {	17;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_XATTEN1_MARGIN_M)) {
    sub AR_PHY_GAIN_2GHZ_XATTEN1_MARGIN_M () {	0x1f000;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_XATTEN1_MARGIN_S)) {
    sub AR_PHY_GAIN_2GHZ_XATTEN1_MARGIN_S () {	12;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_XATTEN2_DB_M)) {
    sub AR_PHY_GAIN_2GHZ_XATTEN2_DB_M () {	0xfc0;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_XATTEN2_DB_S)) {
    sub AR_PHY_GAIN_2GHZ_XATTEN2_DB_S () {	6;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_XATTEN1_DB_M)) {
    sub AR_PHY_GAIN_2GHZ_XATTEN1_DB_M () {	0x3f;}
}
unless(defined(&AR_PHY_GAIN_2GHZ_XATTEN1_DB_S)) {
    sub AR_PHY_GAIN_2GHZ_XATTEN1_DB_S () {	0;}
}
unless(defined(&AR_PHY_CCK_RXCTRL4_FREQ_EST_SHORT_M)) {
    sub AR_PHY_CCK_RXCTRL4_FREQ_EST_SHORT_M () {	0x1f80000;}
}
unless(defined(&AR_PHY_CCK_RXCTRL4_FREQ_EST_SHORT_S)) {
    sub AR_PHY_CCK_RXCTRL4_FREQ_EST_SHORT_S () {	19;}
}
unless(defined(&AR_PHY_DAG_CTRLCCK_EN_RSSI_THR)) {
    sub AR_PHY_DAG_CTRLCCK_EN_RSSI_THR () {	0x200;}
}
unless(defined(&AR_PHY_DAG_CTRLCCK_RSSI_THR_M)) {
    sub AR_PHY_DAG_CTRLCCK_RSSI_THR_M () {	0x1fc00;}
}
unless(defined(&AR_PHY_DAG_CTRLCCK_RSSI_THR_S)) {
    sub AR_PHY_DAG_CTRLCCK_RSSI_THR_S () {	10;}
}
unless(defined(&AR_PHY_FORCE_CLKEN_CCK_MRC_MUX)) {
    sub AR_PHY_FORCE_CLKEN_CCK_MRC_MUX () {	0x40;}
}
unless(defined(&AR_PHY_TPCRG1_NUM_PD_GAIN_M)) {
    sub AR_PHY_TPCRG1_NUM_PD_GAIN_M () {	0xc000;}
}
unless(defined(&AR_PHY_TPCRG1_NUM_PD_GAIN_S)) {
    sub AR_PHY_TPCRG1_NUM_PD_GAIN_S () {	14;}
}
unless(defined(&AR_PHY_TPCRG1_PD_GAIN_1_M)) {
    sub AR_PHY_TPCRG1_PD_GAIN_1_M () {	0x30000;}
}
unless(defined(&AR_PHY_TPCRG1_PD_GAIN_1_S)) {
    sub AR_PHY_TPCRG1_PD_GAIN_1_S () {	16;}
}
unless(defined(&AR_PHY_TPCRG1_PD_GAIN_2_M)) {
    sub AR_PHY_TPCRG1_PD_GAIN_2_M () {	0xc0000;}
}
unless(defined(&AR_PHY_TPCRG1_PD_GAIN_2_S)) {
    sub AR_PHY_TPCRG1_PD_GAIN_2_S () {	18;}
}
unless(defined(&AR_PHY_TPCRG1_PD_GAIN_3_M)) {
    sub AR_PHY_TPCRG1_PD_GAIN_3_M () {	0x300000;}
}
unless(defined(&AR_PHY_TPCRG1_PD_GAIN_3_S)) {
    sub AR_PHY_TPCRG1_PD_GAIN_3_S () {	20;}
}
unless(defined(&AR_PHY_TPCRG1_PD_CAL_ENABLE)) {
    sub AR_PHY_TPCRG1_PD_CAL_ENABLE () {	0x400000;}
}
unless(defined(&AR_PHY_TX_PWRCTRL_PD_AVG_VALID)) {
    sub AR_PHY_TX_PWRCTRL_PD_AVG_VALID () {	0x1;}
}
unless(defined(&AR_PHY_TX_PWRCTRL_PD_AVG_OUT_M)) {
    sub AR_PHY_TX_PWRCTRL_PD_AVG_OUT_M () {	0x1fe;}
}
unless(defined(&AR_PHY_TX_PWRCTRL_PD_AVG_OUT_S)) {
    sub AR_PHY_TX_PWRCTRL_PD_AVG_OUT_S () {	1;}
}
unless(defined(&AR_PHY_TX_PWRCTRL_ERR_EST_MODE_M)) {
    sub AR_PHY_TX_PWRCTRL_ERR_EST_MODE_M () {	0x3000000;}
}
unless(defined(&AR_PHY_TX_PWRCTRL_ERR_EST_MODE_S)) {
    sub AR_PHY_TX_PWRCTRL_ERR_EST_MODE_S () {	24;}
}
unless(defined(&AR_PHY_TX_PWRCTRL_INIT_TX_GAIN_M)) {
    sub AR_PHY_TX_PWRCTRL_INIT_TX_GAIN_M () {	0x1f80000;}
}
unless(defined(&AR_PHY_TX_PWRCTRL_INIT_TX_GAIN_S)) {
    sub AR_PHY_TX_PWRCTRL_INIT_TX_GAIN_S () {	19;}
}
unless(defined(&AR_PHY_TX_DESIRED_SCALE_CCK_M)) {
    sub AR_PHY_TX_DESIRED_SCALE_CCK_M () {	0x7c00;}
}
unless(defined(&AR_PHY_TX_DESIRED_SCALE_CCK_S)) {
    sub AR_PHY_TX_DESIRED_SCALE_CCK_S () {	10;}
}
unless(defined(&AR_PHY_TX_PWRCTRL9_RES_DC_REMOVAL)) {
    sub AR_PHY_TX_PWRCTRL9_RES_DC_REMOVAL () {	0x80000000;}
}
unless(defined(&AR_PHY_TX_GAIN_M)) {
    sub AR_PHY_TX_GAIN_M () {	0x7f000;}
}
unless(defined(&AR_PHY_TX_GAIN_S)) {
    sub AR_PHY_TX_GAIN_S () {	12;}
}
unless(defined(&AR_PHY_SPUR_REG_MASK_RATE_CNTL)) {
    sub AR_PHY_SPUR_REG_MASK_RATE_CNTL () {	0x3fc0000;}
}
unless(defined(&AR_PHY_SPUR_REG_ENABLE_MASK_PPM)) {
    sub AR_PHY_SPUR_REG_ENABLE_MASK_PPM () {	0x20000;}
}
unless(defined(&AR_PHY_SPUR_REG_MASK_RATE_SELECT)) {
    sub AR_PHY_SPUR_REG_MASK_RATE_SELECT () {	0x1fe00;}
}
unless(defined(&AR_PHY_SPUR_REG_ENABLE_VIT_SPUR_RSSI)) {
    sub AR_PHY_SPUR_REG_ENABLE_VIT_SPUR_RSSI () {	0x100;}
}
unless(defined(&AR_PHY_SPUR_REG_SPUR_RSSI_THRESH_M)) {
    sub AR_PHY_SPUR_REG_SPUR_RSSI_THRESH_M () {	0x7f;}
}
unless(defined(&AR_PHY_SPUR_REG_SPUR_RSSI_THRESH_S)) {
    sub AR_PHY_SPUR_REG_SPUR_RSSI_THRESH_S () {	0;}
}
unless(defined(&AR_SPUR_RSSI_THRESH)) {
    sub AR_SPUR_RSSI_THRESH () {	40;}
}
unless(defined(&AR_PHY_SWAP_ALT_CHAIN)) {
    sub AR_PHY_SWAP_ALT_CHAIN () {	0x40;}
}
unless(defined(&AR_PHY_TPCRG5_PD_GAIN_OVERLAP_M)) {
    sub AR_PHY_TPCRG5_PD_GAIN_OVERLAP_M () {	0xf;}
}
unless(defined(&AR_PHY_TPCRG5_PD_GAIN_OVERLAP_S)) {
    sub AR_PHY_TPCRG5_PD_GAIN_OVERLAP_S () {	0;}
}
unless(defined(&AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_1_M)) {
    sub AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_1_M () {	0x3f0;}
}
unless(defined(&AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_1_S)) {
    sub AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_1_S () {	4;}
}
unless(defined(&AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_2_M)) {
    sub AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_2_M () {	0xfc00;}
}
unless(defined(&AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_2_S)) {
    sub AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_2_S () {	10;}
}
unless(defined(&AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_3_M)) {
    sub AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_3_M () {	0x3f0000;}
}
unless(defined(&AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_3_S)) {
    sub AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_3_S () {	16;}
}
unless(defined(&AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_4_M)) {
    sub AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_4_M () {	0xfc00000;}
}
unless(defined(&AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_4_S)) {
    sub AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_4_S () {	22;}
}
unless(defined(&AR_PHY_PARALLEL_CAL_ENABLE)) {
    sub AR_PHY_PARALLEL_CAL_ENABLE () {	0x1;}
}
unless(defined(&AR_PHY_CL_CAL_ENABLE)) {
    sub AR_PHY_CL_CAL_ENABLE () {	0x2;}
}
unless(defined(&AR_PHY_FORCE_XPA_CFG)) {
    sub AR_PHY_FORCE_XPA_CFG () {	0x1;}
}
unless(defined(&AR_PHY_TX_PWRCTRL_OLPC_TEMP_COMP_M)) {
    sub AR_PHY_TX_PWRCTRL_OLPC_TEMP_COMP_M () {	0xfc00;}
}
unless(defined(&AR_PHY_TX_PWRCTRL_OLPC_TEMP_COMP_S)) {
    sub AR_PHY_TX_PWRCTRL_OLPC_TEMP_COMP_S () {	10;}
}
unless(defined(&AR_PHY_TX_PWRCTRL_OLPC_PWR_M)) {
    sub AR_PHY_TX_PWRCTRL_OLPC_PWR_M () {	0xff0000;}
}
unless(defined(&AR_PHY_TX_PWRCTRL_OLPC_PWR_S)) {
    sub AR_PHY_TX_PWRCTRL_OLPC_PWR_S () {	16;}
}
unless(defined(&AR_PHY_NEW_ADC_DC_GAIN_QGAIN_M)) {
    sub AR_PHY_NEW_ADC_DC_GAIN_QGAIN_M () {	0x3f;}
}
unless(defined(&AR_PHY_NEW_ADC_DC_GAIN_QGAIN_S)) {
    sub AR_PHY_NEW_ADC_DC_GAIN_QGAIN_S () {	0;}
}
unless(defined(&AR_PHY_NEW_ADC_DC_GAIN_IGAIN_M)) {
    sub AR_PHY_NEW_ADC_DC_GAIN_IGAIN_M () {	0xfc0;}
}
unless(defined(&AR_PHY_NEW_ADC_DC_GAIN_IGAIN_S)) {
    sub AR_PHY_NEW_ADC_DC_GAIN_IGAIN_S () {	6;}
}
unless(defined(&AR_PHY_NEW_ADC_DC_GAIN_QDC_M)) {
    sub AR_PHY_NEW_ADC_DC_GAIN_QDC_M () {	0x1ff000;}
}
unless(defined(&AR_PHY_NEW_ADC_DC_GAIN_QDC_S)) {
    sub AR_PHY_NEW_ADC_DC_GAIN_QDC_S () {	12;}
}
unless(defined(&AR_PHY_NEW_ADC_DC_GAIN_IDC_M)) {
    sub AR_PHY_NEW_ADC_DC_GAIN_IDC_M () {	0x3fe00000;}
}
unless(defined(&AR_PHY_NEW_ADC_DC_GAIN_IDC_S)) {
    sub AR_PHY_NEW_ADC_DC_GAIN_IDC_S () {	21;}
}
unless(defined(&AR_BASE_PHY_ACTIVE_DELAY)) {
    sub AR_BASE_PHY_ACTIVE_DELAY () {	100;}
}
unless(defined(&AR_CLOCK_RATE_CCK)) {
    sub AR_CLOCK_RATE_CCK () {	22;}
}
unless(defined(&AR_CLOCK_RATE_5GHZ_OFDM)) {
    sub AR_CLOCK_RATE_5GHZ_OFDM () {	40;}
}
unless(defined(&AR_CLOCK_RATE_2GHZ_OFDM)) {
    sub AR_CLOCK_RATE_2GHZ_OFDM () {	44;}
}
unless(defined(&AR_PWR_DECREASE_FOR_2_CHAIN)) {
    sub AR_PWR_DECREASE_FOR_2_CHAIN () {	6;}
}
unless(defined(&AR_PWR_DECREASE_FOR_3_CHAIN)) {
    sub AR_PWR_DECREASE_FOR_3_CHAIN () {	9;}
}
unless(defined(&AR_SLEEP_SLOP)) {
    sub AR_SLEEP_SLOP () {	3;}
}
unless(defined(&AR_MIN_BEACON_TIMEOUT_VAL)) {
    sub AR_MIN_BEACON_TIMEOUT_VAL () {	1;}
}
unless(defined(&AR_FUDGE)) {
    sub AR_FUDGE () {	2;}
}
unless(defined(&AR_TSF_TO_TU)) {
    sub AR_TSF_TO_TU {
	my($hi, $lo) = @_;
	eval q((($hi) << 22| ($lo) >> 10));
    }
}
unless(defined(&AR_KEY_CACHE_SIZE)) {
    sub AR_KEY_CACHE_SIZE () {	128;}
}
unless(defined(&AR_RSVD_KEYTABLE_ENTRIES)) {
    sub AR_RSVD_KEYTABLE_ENTRIES () {	4;}
}
unless(defined(&AR_CAL_SAMPLES)) {
    sub AR_CAL_SAMPLES () {	64;}
}
unless(defined(&AR_MAX_LOG_CAL)) {
    sub AR_MAX_LOG_CAL () {	2;}
}
unless(defined(&AR_TXC0_FRAME_LEN_M)) {
    sub AR_TXC0_FRAME_LEN_M () {	0xfff;}
}
unless(defined(&AR_TXC0_FRAME_LEN_S)) {
    sub AR_TXC0_FRAME_LEN_S () {	0;}
}
unless(defined(&AR_TXC0_VIRT_MORE_FRAG)) {
    sub AR_TXC0_VIRT_MORE_FRAG () {	0x1000;}
}
unless(defined(&AR_TXC0_XMIT_POWER_M)) {
    sub AR_TXC0_XMIT_POWER_M () {	0x3f0000;}
}
unless(defined(&AR_TXC0_XMIT_POWER_S)) {
    sub AR_TXC0_XMIT_POWER_S () {	16;}
}
unless(defined(&AR_TXC0_RTS_ENABLE)) {
    sub AR_TXC0_RTS_ENABLE () {	0x400000;}
}
unless(defined(&AR_TXC0_VEOL)) {
    sub AR_TXC0_VEOL () {	0x800000;}
}
unless(defined(&AR_TXC0_CLR_DEST_MASK)) {
    sub AR_TXC0_CLR_DEST_MASK () {	0x1000000;}
}
unless(defined(&AR_TXC0_INTR_REQ)) {
    sub AR_TXC0_INTR_REQ () {	0x20000000;}
}
unless(defined(&AR_TXC0_DEST_IDX_VALID)) {
    sub AR_TXC0_DEST_IDX_VALID () {	0x40000000;}
}
unless(defined(&AR_TXC0_CTS_ENABLE)) {
    sub AR_TXC0_CTS_ENABLE () {	0x80000000;}
}
unless(defined(&AR_TXC1_BUF_LEN_M)) {
    sub AR_TXC1_BUF_LEN_M () {	0xfff;}
}
unless(defined(&AR_TXC1_BUF_LEN_S)) {
    sub AR_TXC1_BUF_LEN_S () {	0;}
}
unless(defined(&AR_TXC1_MORE)) {
    sub AR_TXC1_MORE () {	0x1000;}
}
unless(defined(&AR_TXC1_DEST_IDX_M)) {
    sub AR_TXC1_DEST_IDX_M () {	0xfe000;}
}
unless(defined(&AR_TXC1_DEST_IDX_S)) {
    sub AR_TXC1_DEST_IDX_S () {	13;}
}
unless(defined(&AR_TXC1_FRAME_TYPE_M)) {
    sub AR_TXC1_FRAME_TYPE_M () {	0xf00000;}
}
unless(defined(&AR_TXC1_FRAME_TYPE_S)) {
    sub AR_TXC1_FRAME_TYPE_S () {	20;}
}
unless(defined(&AR_FRAME_TYPE_NORMAL)) {
    sub AR_FRAME_TYPE_NORMAL () {	0;}
}
unless(defined(&AR_FRAME_TYPE_ATIM)) {
    sub AR_FRAME_TYPE_ATIM () {	1;}
}
unless(defined(&AR_FRAME_TYPE_PSPOLL)) {
    sub AR_FRAME_TYPE_PSPOLL () {	2;}
}
unless(defined(&AR_FRAME_TYPE_BEACON)) {
    sub AR_FRAME_TYPE_BEACON () {	3;}
}
unless(defined(&AR_FRAME_TYPE_PROBE_RESP)) {
    sub AR_FRAME_TYPE_PROBE_RESP () {	4;}
}
unless(defined(&AR_TXC1_NO_ACK)) {
    sub AR_TXC1_NO_ACK () {	0x1000000;}
}
unless(defined(&AR_TXC1_INSERT_TS)) {
    sub AR_TXC1_INSERT_TS () {	0x2000000;}
}
unless(defined(&AR_TXC1_EXT_ONLY)) {
    sub AR_TXC1_EXT_ONLY () {	0x8000000;}
}
unless(defined(&AR_TXC1_EXT_AND_CTL)) {
    sub AR_TXC1_EXT_AND_CTL () {	0x10000000;}
}
unless(defined(&AR_TXC1_MORE_AGGR)) {
    sub AR_TXC1_MORE_AGGR () {	0x20000000;}
}
unless(defined(&AR_TXC1_IS_AGGR)) {
    sub AR_TXC1_IS_AGGR () {	0x40000000;}
}
unless(defined(&AR_TXC2_BURST_DUR_M)) {
    sub AR_TXC2_BURST_DUR_M () {	0x7fff;}
}
unless(defined(&AR_TXC2_BURST_DUR_S)) {
    sub AR_TXC2_BURST_DUR_S () {	0;}
}
unless(defined(&AR_TXC2_DUR_UPDATE_ENA)) {
    sub AR_TXC2_DUR_UPDATE_ENA () {	0x8000;}
}
unless(defined(&AR_TXC2_XMIT_DATA_TRIES0_M)) {
    sub AR_TXC2_XMIT_DATA_TRIES0_M () {	0xf0000;}
}
unless(defined(&AR_TXC2_XMIT_DATA_TRIES0_S)) {
    sub AR_TXC2_XMIT_DATA_TRIES0_S () {	16;}
}
unless(defined(&AR_TXC2_XMIT_DATA_TRIES1_M)) {
    sub AR_TXC2_XMIT_DATA_TRIES1_M () {	0xf00000;}
}
unless(defined(&AR_TXC2_XMIT_DATA_TRIES1_S)) {
    sub AR_TXC2_XMIT_DATA_TRIES1_S () {	20;}
}
unless(defined(&AR_TXC2_XMIT_DATA_TRIES2_M)) {
    sub AR_TXC2_XMIT_DATA_TRIES2_M () {	0xf000000;}
}
unless(defined(&AR_TXC2_XMIT_DATA_TRIES2_S)) {
    sub AR_TXC2_XMIT_DATA_TRIES2_S () {	24;}
}
unless(defined(&AR_TXC2_XMIT_DATA_TRIES3_M)) {
    sub AR_TXC2_XMIT_DATA_TRIES3_M () {	0xf0000000;}
}
unless(defined(&AR_TXC2_XMIT_DATA_TRIES3_S)) {
    sub AR_TXC2_XMIT_DATA_TRIES3_S () {	28;}
}
unless(defined(&AR_TXC3_XMIT_RATE0_M)) {
    sub AR_TXC3_XMIT_RATE0_M () {	0xff;}
}
unless(defined(&AR_TXC3_XMIT_RATE0_S)) {
    sub AR_TXC3_XMIT_RATE0_S () {	0;}
}
unless(defined(&AR_TXC3_XMIT_RATE1_M)) {
    sub AR_TXC3_XMIT_RATE1_M () {	0xff00;}
}
unless(defined(&AR_TXC3_XMIT_RATE1_S)) {
    sub AR_TXC3_XMIT_RATE1_S () {	8;}
}
unless(defined(&AR_TXC3_XMIT_RATE2_M)) {
    sub AR_TXC3_XMIT_RATE2_M () {	0xff0000;}
}
unless(defined(&AR_TXC3_XMIT_RATE2_S)) {
    sub AR_TXC3_XMIT_RATE2_S () {	16;}
}
unless(defined(&AR_TXC3_XMIT_RATE3_M)) {
    sub AR_TXC3_XMIT_RATE3_M () {	0xff000000;}
}
unless(defined(&AR_TXC3_XMIT_RATE3_S)) {
    sub AR_TXC3_XMIT_RATE3_S () {	24;}
}
unless(defined(&AR_TXC4_PACKET_DUR0_M)) {
    sub AR_TXC4_PACKET_DUR0_M () {	0x7fff;}
}
unless(defined(&AR_TXC4_PACKET_DUR0_S)) {
    sub AR_TXC4_PACKET_DUR0_S () {	0;}
}
unless(defined(&AR_TXC4_RTSCTS_QUAL0)) {
    sub AR_TXC4_RTSCTS_QUAL0 () {	0x8000;}
}
unless(defined(&AR_TXC4_PACKET_DUR1_M)) {
    sub AR_TXC4_PACKET_DUR1_M () {	0x7fff0000;}
}
unless(defined(&AR_TXC4_PACKET_DUR1_S)) {
    sub AR_TXC4_PACKET_DUR1_S () {	16;}
}
unless(defined(&AR_TXC4_RTSCTS_QUAL1)) {
    sub AR_TXC4_RTSCTS_QUAL1 () {	0x80000000;}
}
unless(defined(&AR_TXC4_RTSCTS_QUAL01)) {
    sub AR_TXC4_RTSCTS_QUAL01 () {	( &AR_TXC4_RTSCTS_QUAL0 |  &AR_TXC4_RTSCTS_QUAL1);}
}
unless(defined(&AR_TXC5_PACKET_DUR2_M)) {
    sub AR_TXC5_PACKET_DUR2_M () {	0x7fff;}
}
unless(defined(&AR_TXC5_PACKET_DUR2_S)) {
    sub AR_TXC5_PACKET_DUR2_S () {	0;}
}
unless(defined(&AR_TXC5_RTSCTS_QUAL2)) {
    sub AR_TXC5_RTSCTS_QUAL2 () {	0x8000;}
}
unless(defined(&AR_TXC5_PACKET_DUR3_M)) {
    sub AR_TXC5_PACKET_DUR3_M () {	0x7fff0000;}
}
unless(defined(&AR_TXC5_PACKET_DUR3_S)) {
    sub AR_TXC5_PACKET_DUR3_S () {	16;}
}
unless(defined(&AR_TXC5_RTSCTS_QUAL3)) {
    sub AR_TXC5_RTSCTS_QUAL3 () {	0x80000000;}
}
unless(defined(&AR_TXC5_RTSCTS_QUAL23)) {
    sub AR_TXC5_RTSCTS_QUAL23 () {	( &AR_TXC5_RTSCTS_QUAL2 |  &AR_TXC5_RTSCTS_QUAL3);}
}
unless(defined(&AR_TXC6_AGGR_LEN_M)) {
    sub AR_TXC6_AGGR_LEN_M () {	0xffff;}
}
unless(defined(&AR_TXC6_AGGR_LEN_S)) {
    sub AR_TXC6_AGGR_LEN_S () {	0;}
}
unless(defined(&AR_TXC6_PAD_DELIM_M)) {
    sub AR_TXC6_PAD_DELIM_M () {	0x3fc0000;}
}
unless(defined(&AR_TXC6_PAD_DELIM_S)) {
    sub AR_TXC6_PAD_DELIM_S () {	18;}
}
unless(defined(&AR_TXC6_ENCR_TYPE_M)) {
    sub AR_TXC6_ENCR_TYPE_M () {	0xc000000;}
}
unless(defined(&AR_TXC6_ENCR_TYPE_S)) {
    sub AR_TXC6_ENCR_TYPE_S () {	26;}
}
unless(defined(&AR_ENCR_TYPE_CLEAR)) {
    sub AR_ENCR_TYPE_CLEAR () {	0;}
}
unless(defined(&AR_ENCR_TYPE_WEP)) {
    sub AR_ENCR_TYPE_WEP () {	1;}
}
unless(defined(&AR_ENCR_TYPE_AES)) {
    sub AR_ENCR_TYPE_AES () {	2;}
}
unless(defined(&AR_ENCR_TYPE_TKIP)) {
    sub AR_ENCR_TYPE_TKIP () {	3;}
}
unless(defined(&AR_TXC7_2040_0)) {
    sub AR_TXC7_2040_0 () {	0x1;}
}
unless(defined(&AR_TXC7_GI0)) {
    sub AR_TXC7_GI0 () {	0x2;}
}
unless(defined(&AR_TXC7_CHAIN_SEL0_M)) {
    sub AR_TXC7_CHAIN_SEL0_M () {	0x1c;}
}
unless(defined(&AR_TXC7_CHAIN_SEL0_S)) {
    sub AR_TXC7_CHAIN_SEL0_S () {	2;}
}
unless(defined(&AR_TXC7_2040_1)) {
    sub AR_TXC7_2040_1 () {	0x20;}
}
unless(defined(&AR_TXC7_GI1)) {
    sub AR_TXC7_GI1 () {	0x40;}
}
unless(defined(&AR_TXC7_CHAIN_SEL1_M)) {
    sub AR_TXC7_CHAIN_SEL1_M () {	0x380;}
}
unless(defined(&AR_TXC7_CHAIN_SEL1_S)) {
    sub AR_TXC7_CHAIN_SEL1_S () {	7;}
}
unless(defined(&AR_TXC7_2040_2)) {
    sub AR_TXC7_2040_2 () {	0x400;}
}
unless(defined(&AR_TXC7_GI2)) {
    sub AR_TXC7_GI2 () {	0x800;}
}
unless(defined(&AR_TXC7_CHAIN_SEL2_M)) {
    sub AR_TXC7_CHAIN_SEL2_M () {	0x7000;}
}
unless(defined(&AR_TXC7_CHAIN_SEL2_S)) {
    sub AR_TXC7_CHAIN_SEL2_S () {	12;}
}
unless(defined(&AR_TXC7_2040_3)) {
    sub AR_TXC7_2040_3 () {	0x8000;}
}
unless(defined(&AR_TXC7_GI3)) {
    sub AR_TXC7_GI3 () {	0x10000;}
}
unless(defined(&AR_TXC7_CHAIN_SEL3_M)) {
    sub AR_TXC7_CHAIN_SEL3_M () {	0xe0000;}
}
unless(defined(&AR_TXC7_CHAIN_SEL3_S)) {
    sub AR_TXC7_CHAIN_SEL3_S () {	17;}
}
unless(defined(&AR_TXC7_RTSCTS_RATE_M)) {
    sub AR_TXC7_RTSCTS_RATE_M () {	0xff00000;}
}
unless(defined(&AR_TXC7_RTSCTS_RATE_S)) {
    sub AR_TXC7_RTSCTS_RATE_S () {	20;}
}
unless(defined(&AR_TXC7_2040_0123)) {
    sub AR_TXC7_2040_0123 () {	( &AR_TXC7_2040_0 |  &AR_TXC7_2040_1 |  &AR_TXC7_2040_2 |  &AR_TXC7_2040_3);}
}
unless(defined(&AR_TXC7_GI0123)) {
    sub AR_TXC7_GI0123 () {	( &AR_TXC7_GI0 |  &AR_TXC7_GI1 |  &AR_TXC7_GI2 |  &AR_TXC7_GI3);}
}
unless(defined(&AR_TXS0_RSSI_ANT0)) {
    sub AR_TXS0_RSSI_ANT0 {
	my($i) = @_;
	eval q(((( &x) >> (($i) * 8)) & 0xff));
    }
}
unless(defined(&AR_TXS0_BA_STATUS)) {
    sub AR_TXS0_BA_STATUS () {	0x40000000;}
}
unless(defined(&AR_TXS1_FRM_XMIT_OK)) {
    sub AR_TXS1_FRM_XMIT_OK () {	0x1;}
}
unless(defined(&AR_TXS1_EXCESSIVE_RETRIES)) {
    sub AR_TXS1_EXCESSIVE_RETRIES () {	0x2;}
}
unless(defined(&AR_TXS1_FIFO_UNDERRUN)) {
    sub AR_TXS1_FIFO_UNDERRUN () {	0x4;}
}
unless(defined(&AR_TXS1_FILTERED)) {
    sub AR_TXS1_FILTERED () {	0x8;}
}
unless(defined(&AR_TXS1_RTS_FAIL_CNT_M)) {
    sub AR_TXS1_RTS_FAIL_CNT_M () {	0xf0;}
}
unless(defined(&AR_TXS1_RTS_FAIL_CNT_S)) {
    sub AR_TXS1_RTS_FAIL_CNT_S () {	4;}
}
unless(defined(&AR_TXS1_DATA_FAIL_CNT_M)) {
    sub AR_TXS1_DATA_FAIL_CNT_M () {	0xf00;}
}
unless(defined(&AR_TXS1_DATA_FAIL_CNT_S)) {
    sub AR_TXS1_DATA_FAIL_CNT_S () {	8;}
}
unless(defined(&AR_TXS1_VIRT_RETRY_CNT_M)) {
    sub AR_TXS1_VIRT_RETRY_CNT_M () {	0xf000;}
}
unless(defined(&AR_TXS1_VIRT_RETRY_CNT_S)) {
    sub AR_TXS1_VIRT_RETRY_CNT_S () {	12;}
}
unless(defined(&AR_TXS1_TX_DELIM_UNDERRUN)) {
    sub AR_TXS1_TX_DELIM_UNDERRUN () {	0x10000;}
}
unless(defined(&AR_TXS1_TX_DATA_UNDERRUN)) {
    sub AR_TXS1_TX_DATA_UNDERRUN () {	0x20000;}
}
unless(defined(&AR_TXS1_DESC_CFG_ERR)) {
    sub AR_TXS1_DESC_CFG_ERR () {	0x40000;}
}
unless(defined(&AR_TXS1_TX_TIMER_EXPIRED)) {
    sub AR_TXS1_TX_TIMER_EXPIRED () {	0x80000;}
}
unless(defined(&AR_TXS1_UNDERRUN)) {
    sub AR_TXS1_UNDERRUN () {	( &AR_TXS1_FIFO_UNDERRUN |  &AR_TXS1_TX_DELIM_UNDERRUN |  &AR_TXS1_TX_DATA_UNDERRUN);}
}
unless(defined(&AR_TXS9_DONE)) {
    sub AR_TXS9_DONE () {	0x1;}
}
unless(defined(&AR_TXS9_SEQNUM_M)) {
    sub AR_TXS9_SEQNUM_M () {	0x1ffe;}
}
unless(defined(&AR_TXS9_SEQNUM_S)) {
    sub AR_TXS9_SEQNUM_S () {	1;}
}
unless(defined(&AR_TXS9_TXOP_EXCEEDED)) {
    sub AR_TXS9_TXOP_EXCEEDED () {	0x20000;}
}
unless(defined(&AR_TXS9_FINAL_IDX_M)) {
    sub AR_TXS9_FINAL_IDX_M () {	0x600000;}
}
unless(defined(&AR_TXS9_FINAL_IDX_S)) {
    sub AR_TXS9_FINAL_IDX_S () {	21;}
}
unless(defined(&AR_TXS9_POWER_MGMT)) {
    sub AR_TXS9_POWER_MGMT () {	0x2000000;}
}
unless(defined(&AR_RXC1_BUF_LEN_M)) {
    sub AR_RXC1_BUF_LEN_M () {	0xfff;}
}
unless(defined(&AR_RXC1_BUF_LEN_S)) {
    sub AR_RXC1_BUF_LEN_S () {	0;}
}
unless(defined(&AR_RXC1_INTR_REQ)) {
    sub AR_RXC1_INTR_REQ () {	0x2000;}
}
unless(defined(&AR_RXS0_RSSI_ANT00)) {
    sub AR_RXS0_RSSI_ANT00 {
	my($x) = @_;
	eval q(((($x) >> 0) & 0xff));
    }
}
unless(defined(&AR_RXS0_RSSI_ANT01)) {
    sub AR_RXS0_RSSI_ANT01 {
	my($x) = @_;
	eval q(((($x) >> 8) & 0xff));
    }
}
unless(defined(&AR_RXS0_RSSI_ANT02)) {
    sub AR_RXS0_RSSI_ANT02 {
	my($x) = @_;
	eval q(((($x) >> 16) & 0xff));
    }
}
unless(defined(&AR_RXS0_RATE_M)) {
    sub AR_RXS0_RATE_M () {	0xff000000;}
}
unless(defined(&AR_RXS0_RATE_S)) {
    sub AR_RXS0_RATE_S () {	24;}
}
unless(defined(&AR_RXS1_DATA_LEN_M)) {
    sub AR_RXS1_DATA_LEN_M () {	0xfff;}
}
unless(defined(&AR_RXS1_DATA_LEN_S)) {
    sub AR_RXS1_DATA_LEN_S () {	0;}
}
unless(defined(&AR_RXS1_MORE)) {
    sub AR_RXS1_MORE () {	0x1000;}
}
unless(defined(&AR_RXS3_GI)) {
    sub AR_RXS3_GI () {	0x1;}
}
unless(defined(&AR_RXS3_2040)) {
    sub AR_RXS3_2040 () {	0x2;}
}
unless(defined(&AR_RXS3_PARALLEL_40)) {
    sub AR_RXS3_PARALLEL_40 () {	0x4;}
}
unless(defined(&AR_RXS3_ANTENNA_M)) {
    sub AR_RXS3_ANTENNA_M () {	0xffffff00;}
}
unless(defined(&AR_RXS3_ANTENNA_S)) {
    sub AR_RXS3_ANTENNA_S () {	8;}
}
unless(defined(&AR_RXS3_RATE_M)) {
    sub AR_RXS3_RATE_M () {	0x3fc;}
}
unless(defined(&AR_RXS3_RATE_S)) {
    sub AR_RXS3_RATE_S () {	2;}
}
unless(defined(&AR_RXS4_RSSI_COMBINED_M)) {
    sub AR_RXS4_RSSI_COMBINED_M () {	0xff000000;}
}
unless(defined(&AR_RXS4_RSSI_COMBINED_S)) {
    sub AR_RXS4_RSSI_COMBINED_S () {	24;}
}
unless(defined(&AR_RXS8_DONE)) {
    sub AR_RXS8_DONE () {	0x1;}
}
unless(defined(&AR_RXS8_FRAME_OK)) {
    sub AR_RXS8_FRAME_OK () {	0x2;}
}
unless(defined(&AR_RXS8_CRC_ERR)) {
    sub AR_RXS8_CRC_ERR () {	0x4;}
}
unless(defined(&AR_RXS8_DECRYPT_CRC_ERR)) {
    sub AR_RXS8_DECRYPT_CRC_ERR () {	0x8;}
}
unless(defined(&AR_RXS8_PHY_ERR)) {
    sub AR_RXS8_PHY_ERR () {	0x10;}
}
unless(defined(&AR_RXS8_MICHAEL_ERR)) {
    sub AR_RXS8_MICHAEL_ERR () {	0x20;}
}
unless(defined(&AR_RXS8_PRE_DELIM_CRC_ERR)) {
    sub AR_RXS8_PRE_DELIM_CRC_ERR () {	0x40;}
}
unless(defined(&AR_RXS8_PHY_ERR_CODE_M)) {
    sub AR_RXS8_PHY_ERR_CODE_M () {	0xff00;}
}
unless(defined(&AR_RXS8_PHY_ERR_CODE_S)) {
    sub AR_RXS8_PHY_ERR_CODE_S () {	8;}
}
unless(defined(&AR_RXS8_KEY_IDX_VALID)) {
    sub AR_RXS8_KEY_IDX_VALID () {	0x100;}
}
unless(defined(&AR_RXS8_KEY_IDX_M)) {
    sub AR_RXS8_KEY_IDX_M () {	0xfe00;}
}
unless(defined(&AR_RXS8_KEY_IDX_S)) {
    sub AR_RXS8_KEY_IDX_S () {	9;}
}
unless(defined(&AR_RXS8_POST_DELIM_CRC_ERR)) {
    sub AR_RXS8_POST_DELIM_CRC_ERR () {	0x40000;}
}
unless(defined(&AR_RXS8_DECRYPT_BUSY_ERR)) {
    sub AR_RXS8_DECRYPT_BUSY_ERR () {	0x40000000;}
}
unless(defined(&AR_MAX_CHAINS)) {
    sub AR_MAX_CHAINS () {	3;}
}
unless(defined(&AR_KEYTABLE_SIZE)) {
    sub AR_KEYTABLE_SIZE () {	128;}
}
unless(defined(&AR_GPIO_WLANACTIVE_PIN)) {
    sub AR_GPIO_WLANACTIVE_PIN () {	5;}
}
unless(defined(&AR_GPIO_BTACTIVE_PIN)) {
    sub AR_GPIO_BTACTIVE_PIN () {	6;}
}
unless(defined(&AR_GPIO_BTPRIORITY_PIN)) {
    sub AR_GPIO_BTPRIORITY_PIN () {	7;}
}
unless(defined(&AR_SREV_5416)) {
    sub AR_SREV_5416 {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver ==  &AR_SREV_VERSION_5416_PCI || ($sc)-> &mac_ver ==  &AR_SREV_VERSION_5416_PCIE));
    }
}
unless(defined(&AR_SREV_5416_20_OR_LATER)) {
    sub AR_SREV_5416_20_OR_LATER {
	my($sc) = @_;
	eval q((( &AR_SREV_5416($sc)  && ($sc)-> &mac_rev >=  &AR_SREV_REVISION_5416_20) || ($sc)-> &mac_ver >=  &AR_SREV_VERSION_9100));
    }
}
unless(defined(&AR_SREV_5416_22_OR_LATER)) {
    sub AR_SREV_5416_22_OR_LATER {
	my($sc) = @_;
	eval q((( &AR_SREV_5416($sc)  && ($sc)-> &mac_rev >=  &AR_SREV_REVISION_5416_22) || ($sc)-> &mac_ver >=  &AR_SREV_VERSION_9100));
    }
}
unless(defined(&AR_SREV_9160)) {
    sub AR_SREV_9160 {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver ==  &AR_SREV_VERSION_9160));
    }
}
unless(defined(&AR_SREV_9160_10_OR_LATER)) {
    sub AR_SREV_9160_10_OR_LATER {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver >=  &AR_SREV_VERSION_9160));
    }
}
unless(defined(&AR_SREV_9160_11)) {
    sub AR_SREV_9160_11 {
	my($sc) = @_;
	eval q(( &AR_SREV_9160($sc)  && ($sc)-> &mac_rev ==  &AR_SREV_REVISION_9160_11));
    }
}
unless(defined(&AR_SREV_9280)) {
    sub AR_SREV_9280 {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver ==  &AR_SREV_VERSION_9280));
    }
}
unless(defined(&AR_SREV_9280_10_OR_LATER)) {
    sub AR_SREV_9280_10_OR_LATER {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver >=  &AR_SREV_VERSION_9280));
    }
}
unless(defined(&AR_SREV_9280_10)) {
    sub AR_SREV_9280_10 {
	my($sc) = @_;
	eval q(( &AR_SREV_9280($sc)  && ($sc)-> &mac_rev ==  &AR_SREV_REVISION_9280_10));
    }
}
unless(defined(&AR_SREV_9280_20)) {
    sub AR_SREV_9280_20 {
	my($sc) = @_;
	eval q(( &AR_SREV_9280($sc)  && ($sc)-> &mac_rev >=  &AR_SREV_REVISION_9280_20));
    }
}
unless(defined(&AR_SREV_9280_20_OR_LATER)) {
    sub AR_SREV_9280_20_OR_LATER {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver >  &AR_SREV_VERSION_9280 || ( &AR_SREV_9280($sc)  && ($sc)-> &mac_rev >=  &AR_SREV_REVISION_9280_20)));
    }
}
unless(defined(&AR_SREV_9285)) {
    sub AR_SREV_9285 {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver ==  &AR_SREV_VERSION_9285));
    }
}
unless(defined(&AR_SREV_9285_10_OR_LATER)) {
    sub AR_SREV_9285_10_OR_LATER {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver >=  &AR_SREV_VERSION_9285));
    }
}
unless(defined(&AR_SREV_9285_11)) {
    sub AR_SREV_9285_11 {
	my($sc) = @_;
	eval q(( &AR_SREV_9285($sc)  && ($sc)-> &mac_rev ==  &AR_SREV_REVISION_9285_11));
    }
}
unless(defined(&AR_SREV_9285_11_OR_LATER)) {
    sub AR_SREV_9285_11_OR_LATER {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver >  &AR_SREV_VERSION_9285 || ( &AR_SREV_9285($sc)  && ($sc)-> &mac_rev >=  &AR_SREV_REVISION_9285_11)));
    }
}
unless(defined(&AR_SREV_9285_12)) {
    sub AR_SREV_9285_12 {
	my($sc) = @_;
	eval q(( &AR_SREV_9285($sc)  && (($sc)-> &mac_rev ==  &AR_SREV_REVISION_9285_12)));
    }
}
unless(defined(&AR_SREV_9285_12_OR_LATER)) {
    sub AR_SREV_9285_12_OR_LATER {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver >  &AR_SREV_VERSION_9285 || ( &AR_SREV_9285($sc)  && ($sc)-> &mac_rev >=  &AR_SREV_REVISION_9285_12)));
    }
}
unless(defined(&AR_SREV_9287)) {
    sub AR_SREV_9287 {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver ==  &AR_SREV_VERSION_9287));
    }
}
unless(defined(&AR_SREV_9287_10_OR_LATER)) {
    sub AR_SREV_9287_10_OR_LATER {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver >=  &AR_SREV_VERSION_9287));
    }
}
unless(defined(&AR_SREV_9287_10)) {
    sub AR_SREV_9287_10 {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver ==  &AR_SREV_VERSION_9287  && ($sc)-> &mac_rev ==  &AR_SREV_REVISION_9287_10));
    }
}
unless(defined(&AR_SREV_9287_11)) {
    sub AR_SREV_9287_11 {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver ==  &AR_SREV_VERSION_9287  && ($sc)-> &mac_rev ==  &AR_SREV_REVISION_9287_11));
    }
}
unless(defined(&AR_SREV_9287_11_OR_LATER)) {
    sub AR_SREV_9287_11_OR_LATER {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver >  &AR_SREV_VERSION_9287 || ( &AR_SREV_9287($sc)  && ($sc)-> &mac_rev >=  &AR_SREV_REVISION_9287_11)));
    }
}
unless(defined(&AR_SREV_9287_12)) {
    sub AR_SREV_9287_12 {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver ==  &AR_SREV_VERSION_9287  && ($sc)-> &mac_rev ==  &AR_SREV_REVISION_9287_12));
    }
}
unless(defined(&AR_SREV_9287_12_OR_LATER)) {
    sub AR_SREV_9287_12_OR_LATER {
	my($sc) = @_;
	eval q((($sc)-> &mac_ver >  &AR_SREV_VERSION_9287 || ( &AR_SREV_9287($sc)  && ($sc)-> &mac_rev >=  &AR_SREV_REVISION_9287_12)));
    }
}
unless(defined(&AR_SINGLE_CHIP)) {
    sub AR_SINGLE_CHIP {
	my($sc) = @_;
	eval q( &AR_SREV_9280_10_OR_LATER($sc));
    }
}
unless(defined(&AR_RADIO_SREV_MAJOR)) {
    sub AR_RADIO_SREV_MAJOR () {	0xf0;}
}
unless(defined(&AR_RAD5133_SREV_MAJOR)) {
    sub AR_RAD5133_SREV_MAJOR () {	0xc0;}
}
unless(defined(&AR_RAD2133_SREV_MAJOR)) {
    sub AR_RAD2133_SREV_MAJOR () {	0xd0;}
}
unless(defined(&AR_RAD5122_SREV_MAJOR)) {
    sub AR_RAD5122_SREV_MAJOR () {	0xe0;}
}
unless(defined(&AR_RAD2122_SREV_MAJOR)) {
    sub AR_RAD2122_SREV_MAJOR () {	0xf0;}
}
unless(defined(&AR_EEPROM_MAGIC_OFFSET)) {
    sub AR_EEPROM_MAGIC_OFFSET () {	0x;}
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
    eval 'sub AR_EEPROM_MAGIC () {0x5aa5;}' unless defined(&AR_EEPROM_MAGIC);
} else {
    eval 'sub AR_EEPROM_MAGIC () {0xa55a;}' unless defined(&AR_EEPROM_MAGIC);
}
unless(defined(&AR_BCHAN_UNUSED)) {
    sub AR_BCHAN_UNUSED () {	0xff;}
}
unless(defined(&AR_NO_SPUR)) {
    sub AR_NO_SPUR () {	0x8000;}
}
unless(defined(&AR_NUM_PDADC_VALUES)) {
    sub AR_NUM_PDADC_VALUES () {	128;}
}
unless(defined(&AR_PD_GAINS_IN_MASK)) {
    sub AR_PD_GAINS_IN_MASK () {	4;}
}
unless(defined(&AR_MAX_PWR_RANGE_IN_HALF_DB)) {
    sub AR_MAX_PWR_RANGE_IN_HALF_DB () {	64;}
}
unless(defined(&AR_MAX_RATE_POWER)) {
    sub AR_MAX_RATE_POWER () {	63;}
}
unless(defined(&AR_HT40_POWER_INC_FOR_PDADC)) {
    sub AR_HT40_POWER_INC_FOR_PDADC () {	2;}
}
unless(defined(&AR_EEPROM_MODAL_SPURS)) {
    sub AR_EEPROM_MODAL_SPURS () {	5;}
}
unless(defined(&AR_BASE_FREQ_2GHZ)) {
    sub AR_BASE_FREQ_2GHZ () {	2300;}
}
unless(defined(&AR_BASE_FREQ_5GHZ)) {
    sub AR_BASE_FREQ_5GHZ () {	4900;}
}
unless(defined(&AR_PWR_TABLE_OFFSET_DB)) {
    sub AR_PWR_TABLE_OFFSET_DB () {	(-5);}
}
unless(defined(&AR9285_PD_GAIN_BOUNDARY_DEFAULT)) {
    sub AR9285_PD_GAIN_BOUNDARY_DEFAULT () {	58;}
}
unless(defined(&AR9280_TX_GAIN_TABLE_SIZE)) {
    sub AR9280_TX_GAIN_TABLE_SIZE () {	22;}
}
unless(defined(&AR_EEP_TXGAIN_ORIGINAL)) {
    sub AR_EEP_TXGAIN_ORIGINAL () {	0;}
}
unless(defined(&AR_EEP_TXGAIN_HIGH_POWER)) {
    sub AR_EEP_TXGAIN_HIGH_POWER () {	1;}
}
unless(defined(&AR_EEP_VER)) {
    sub AR_EEP_VER () {	0xe;}
}
unless(defined(&AR_EEP_VER_MINOR_MASK)) {
    sub AR_EEP_VER_MINOR_MASK () {	0xfff;}
}
unless(defined(&AR_EEP_MINOR_VER_2)) {
    sub AR_EEP_MINOR_VER_2 () {	2;}
}
unless(defined(&AR_EEP_MINOR_VER_3)) {
    sub AR_EEP_MINOR_VER_3 () {	3;}
}
unless(defined(&AR_EEP_MINOR_VER_7)) {
    sub AR_EEP_MINOR_VER_7 () {	7;}
}
unless(defined(&AR_EEP_MINOR_VER_9)) {
    sub AR_EEP_MINOR_VER_9 () {	9;}
}
unless(defined(&AR_EEP_MINOR_VER_10)) {
    sub AR_EEP_MINOR_VER_10 () {	10;}
}
unless(defined(&AR_EEP_MINOR_VER_16)) {
    sub AR_EEP_MINOR_VER_16 () {	16;}
}
unless(defined(&AR_EEP_MINOR_VER_17)) {
    sub AR_EEP_MINOR_VER_17 () {	17;}
}
unless(defined(&AR_EEP_MINOR_VER_19)) {
    sub AR_EEP_MINOR_VER_19 () {	19;}
}
unless(defined(&AR_EEP_MINOR_VER_20)) {
    sub AR_EEP_MINOR_VER_20 () {	20;}
}
unless(defined(&AR_EEP_MINOR_VER_21)) {
    sub AR_EEP_MINOR_VER_21 () {	21;}
}
unless(defined(&AR_EEP_MINOR_VER_22)) {
    sub AR_EEP_MINOR_VER_22 () {	22;}
}
unless(defined(&AR_OPFLAGS_11A)) {
    sub AR_OPFLAGS_11A () {	0x1;}
}
unless(defined(&AR_OPFLAGS_11G)) {
    sub AR_OPFLAGS_11G () {	0x2;}
}
unless(defined(&AR_OPFLAGS_11N_5G40)) {
    sub AR_OPFLAGS_11N_5G40 () {	0x4;}
}
unless(defined(&AR_OPFLAGS_11N_2G40)) {
    sub AR_OPFLAGS_11N_2G40 () {	0x8;}
}
unless(defined(&AR_OPFLAGS_11N_5G20)) {
    sub AR_OPFLAGS_11N_5G20 () {	0x10;}
}
unless(defined(&AR_OPFLAGS_11N_2G20)) {
    sub AR_OPFLAGS_11N_2G20 () {	0x20;}
}
unless(defined(&AR_OPFLAGS_11N)) {
    sub AR_OPFLAGS_11N () {	0x3c;}
}
unless(defined(&AR_EEP_RFSILENT_ENABLED)) {
    sub AR_EEP_RFSILENT_ENABLED () {	0x1;}
}
unless(defined(&AR_EEP_RFSILENT_GPIO_SEL_M)) {
    sub AR_EEP_RFSILENT_GPIO_SEL_M () {	0x1c;}
}
unless(defined(&AR_EEP_RFSILENT_GPIO_SEL_S)) {
    sub AR_EEP_RFSILENT_GPIO_SEL_S () {	2;}
}
unless(defined(&AR_EEP_RFSILENT_POLARITY)) {
    sub AR_EEP_RFSILENT_POLARITY () {	0x2;}
}
unless(defined(&AR_EEP_DEVCAP_COMPRESS_DIS)) {
    sub AR_EEP_DEVCAP_COMPRESS_DIS () {	0x1;}
}
unless(defined(&AR_EEP_DEVCAP_AES_DIS)) {
    sub AR_EEP_DEVCAP_AES_DIS () {	0x2;}
}
unless(defined(&AR_EEP_DEVCAP_FASTFRAME_DIS)) {
    sub AR_EEP_DEVCAP_FASTFRAME_DIS () {	0x4;}
}
unless(defined(&AR_EEP_DEVCAP_BURST_DIS)) {
    sub AR_EEP_DEVCAP_BURST_DIS () {	0x8;}
}
unless(defined(&AR_EEP_DEVCAP_MAXQCU_M)) {
    sub AR_EEP_DEVCAP_MAXQCU_M () {	0x1f0;}
}
unless(defined(&AR_EEP_DEVCAP_MAXQCU_S)) {
    sub AR_EEP_DEVCAP_MAXQCU_S () {	4;}
}
unless(defined(&AR_EEP_DEVCAP_HEAVY_CLIP_EN)) {
    sub AR_EEP_DEVCAP_HEAVY_CLIP_EN () {	0x200;}
}
unless(defined(&AR_EEP_DEVCAP_KC_ENTRIES_M)) {
    sub AR_EEP_DEVCAP_KC_ENTRIES_M () {	0xf000;}
}
unless(defined(&AR_EEP_DEVCAP_KC_ENTRIES_S)) {
    sub AR_EEP_DEVCAP_KC_ENTRIES_S () {	12;}
}
unless(defined(&AR_CAL_CTL_EDGES_POWER_M)) {
    sub AR_CAL_CTL_EDGES_POWER_M () {	0x3f;}
}
unless(defined(&AR_CAL_CTL_EDGES_POWER_S)) {
    sub AR_CAL_CTL_EDGES_POWER_S () {	0;}
}
unless(defined(&AR_CAL_CTL_EDGES_FLAG_M)) {
    sub AR_CAL_CTL_EDGES_FLAG_M () {	0xc0;}
}
unless(defined(&AR_CAL_CTL_EDGES_FLAG_S)) {
    sub AR_CAL_CTL_EDGES_FLAG_S () {	6;}
}
unless(defined(&AR_SD_NO_CTL)) {
    sub AR_SD_NO_CTL () {	0xe0;}
}
unless(defined(&AR_NO_CTL)) {
    sub AR_NO_CTL () {	0xff;}
}
unless(defined(&AR_CTL_MODE_M)) {
    sub AR_CTL_MODE_M () {	0x7;}
}
unless(defined(&AR_CTL_MODE_S)) {
    sub AR_CTL_MODE_S () {	0;}
}
unless(defined(&AR_CTL_11A)) {
    sub AR_CTL_11A () {	0;}
}
unless(defined(&AR_CTL_11B)) {
    sub AR_CTL_11B () {	1;}
}
unless(defined(&AR_CTL_11G)) {
    sub AR_CTL_11G () {	2;}
}
unless(defined(&AR_CTL_2GHT20)) {
    sub AR_CTL_2GHT20 () {	5;}
}
unless(defined(&AR_CTL_5GHT20)) {
    sub AR_CTL_5GHT20 () {	6;}
}
unless(defined(&AR_CTL_2GHT40)) {
    sub AR_CTL_2GHT40 () {	7;}
}
unless(defined(&AR_CTL_5GHT40)) {
    sub AR_CTL_5GHT40 () {	8;}
}
unless(defined(&AR_READ)) {
    sub AR_READ {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&AR_WRITE)) {
    sub AR_WRITE {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&AR_SETBITS)) {
    sub AR_SETBITS {
	my($sc, $reg, $mask) = @_;
	eval q( &AR_WRITE($sc, $reg,  &AR_READ($sc, $reg) | ($mask)));
    }
}
unless(defined(&AR_CLRBITS)) {
    sub AR_CLRBITS {
	my($sc, $reg, $mask) = @_;
	eval q( &AR_WRITE($sc, $reg,  &AR_READ($sc, $reg) & ~($mask)));
    }
}
unless(defined(&MS)) {
    sub MS {
	my($val, $field) = @_;
	eval q(((($val) & $field &_M) >> $field &_S));
    }
}
unless(defined(&SM)) {
    sub SM {
	my($field, $val) = @_;
	eval q(((($val) << $field &_S) & $field &_M));
    }
}
unless(defined(&RW)) {
    sub RW {
	my($var, $field, $val) = @_;
	eval q(((($var) & ~$field &_M) |  &SM($field, $val)));
    }
}
1;
