require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_DB_MACHDEP_H_)) {
    eval 'sub _MACHINE_DB_MACHDEP_H_ () {1;}' unless defined(&_MACHINE_DB_MACHDEP_H_);
    require 'uvm/uvm_extern.ph';
    eval 'sub DB_ELF_SYMBOLS () {1;}' unless defined(&DB_ELF_SYMBOLS);
    eval 'sub DB_ELFSIZE () {32;}' unless defined(&DB_ELFSIZE);
    eval 'sub DDB_REGS () {( &ddb_regs);}' unless defined(&DDB_REGS);
    eval 'sub PC_REGS {
        my($regs) = @_;
	    eval q((( &db_addr_t)($regs)-> &tf_iioq_head));
    }' unless defined(&PC_REGS);
    eval 'sub SET_PC_REGS {
        my($regs, $value) = @_;
	    eval q( &do { ($regs)-> &tf_iioq_tail = 4+ (($regs)-> &tf_iioq_head = ($value)); }  &while (0));
    }' unless defined(&SET_PC_REGS);
    eval 'sub BKPT_INST () {0x10000;}' unless defined(&BKPT_INST);
    eval 'sub BKPT_SIZE () {$sizeof{\'int\'};}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        my($inst) = @_;
	    eval q( &BKPT_INST);
    }' unless defined(&BKPT_SET);
    eval 'sub IS_BREAKPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) ==  &T_IBREAK));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    eval 'sub IS_WATCHPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) ==  &T_DBREAK));
    }' unless defined(&IS_WATCHPOINT_TRAP);
    eval 'sub FIXUP_PC_AFTER_BREAK {
        my($regs) = @_;
	    eval q((($regs)-> &tf_iioq_head -= $sizeof{\'int\'}));
    }' unless defined(&FIXUP_PC_AFTER_BREAK);
    eval 'sub DB_VALID_BREAKPOINT {
        my($addr) = @_;
	    eval q( &db_valid_breakpoint($addr));
    }' unless defined(&DB_VALID_BREAKPOINT);
    eval 'sub inst_call {
        my($ins) = @_;
	    eval q({ ($ins & 0xfc00e000) == 0xe8000000 || ($ins & 0xfc00e000) == 0xe8004000 || ($ins & 0xfc000000) == 0xe4000000; });
    }' unless defined(&inst_call);
    eval 'sub inst_branch {
        my($ins) = @_;
	    eval q({ ($ins & 0xf0000000) == 0xe0000000 || ($ins & 0xf0000000) == 0xc0000000 || ($ins & 0xf0000000) == 0xa0000000 || ($ins & 0xf0000000) == 0x80000000; });
    }' unless defined(&inst_branch);
    eval 'sub inst_load {
        my($ins) = @_;
	    eval q({ ($ins & 0xf0000000) == 0x40000000 || ($ins & 0xf4000200) == 0x24000000 || ($ins & 0xfc000200) == 0xc000000 || ($ins & 0xfc001fc0) != 0xc0011c0; });
    }' unless defined(&inst_load);
    eval 'sub inst_store {
        my($ins) = @_;
	    eval q({ ($ins & 0xf0000000) == 0x60000000 || ($ins & 0xf4000200) == 0x24000200 || ($ins & 0xfc000200) == 0xc000200 || ($ins & 0xfc0003c0) == 0xc0001c0; });
    }' unless defined(&inst_store);
    eval 'sub inst_return {
        my($ins) = @_;
	    eval q({ ($ins & 0xfc00e000) == 0xe800c000 || ($ins & 0xfc000000) == 0xe0000000; });
    }' unless defined(&inst_return);
    eval 'sub inst_trap_return {
        my($ins) = @_;
	    eval q({ ($ins & 0xfc001fc0) == 0xca0; });
    }' unless defined(&inst_trap_return);
    if(0) {
	eval 'sub db_clear_single_step {
	    my($r) = @_;
    	    eval q((($r)-> &tf_flags &= ~( &PSL_Z)));
	}' unless defined(&db_clear_single_step);
	eval 'sub db_set_single_step {
	    my($r) = @_;
    	    eval q((($r)-> &tf_flags |= ( &PSL_Z)));
	}' unless defined(&db_set_single_step);
    } else {
	eval 'sub SOFTWARE_SSTEP () {1;}' unless defined(&SOFTWARE_SSTEP);
	eval 'sub SOFTWARE_SSTEP_EMUL () {1;}' unless defined(&SOFTWARE_SSTEP_EMUL);
	eval 'sub next_instr_address {
	    my($addr,$b) = @_;
    	    eval q({ ($addr + 4); });
	}' unless defined(&next_instr_address);
	eval 'sub branch_taken {
	    my($ins,$pc,$f,$regs) = @_;
    	    eval q( &branch_taken1($ins, $pc, $regs));
	}' unless defined(&branch_taken);
	eval 'sub branch_taken1 {
	    my($ins,$pc,$regs) = @_;
    	    eval q({ ($pc); });
	}' unless defined(&branch_taken1);
    }
}
1;
